/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.PasswordPanel;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.ftp.FtpConfiguration;
import org.netbeans.modules.php.project.connections.ftp.WindowsJdk7WarningPanel;
import org.netbeans.modules.php.project.connections.spi.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class FtpClient
implements RemoteClient {
    static final Logger LOGGER = Logger.getLogger(FtpClient.class.getName());
    private static final RequestProcessor KEEP_ALIVE_RP = new RequestProcessor("PHP FTP client keep-alive thread", 1);
    private static final Map<Integer, String> PASSWORDS = new HashMap<Integer, String>();
    private static final int[] PERMISSIONS_ACCESSES = new int[]{0, 1, 2};
    private final FtpConfiguration configuration;
    private final InputOutput io;
    private final FTPClient ftpClient;
    private final ProtocolCommandListener protocolCommandListener;
    private final int keepAliveInterval;
    private final RequestProcessor.Task keepAliveTask;
    private final AtomicInteger keepAliveCounter = new AtomicInteger();
    private Long timestampDiff = null;

    public FtpClient(FtpConfiguration configuration, InputOutput io) {
        assert (configuration != null);
        this.configuration = configuration;
        this.io = io;
        LOGGER.log(Level.FINE, "FTP client creating");
        this.ftpClient = this.createFtpClient(configuration);
        if (io != null) {
            this.protocolCommandListener = new PrintCommandListener(io);
            this.addProtocolCommandListener();
            LOGGER.log(Level.FINE, "Protocol command listener added");
        } else {
            this.protocolCommandListener = null;
        }
        this.keepAliveInterval = configuration.getKeepAliveInterval() * 1000;
        this.keepAliveTask = this.keepAliveInterval <= 0 ? null : KEEP_ALIVE_RP.create(new Runnable(){

            @Override
            public void run() {
                FtpClient.this.keepAlive();
            }
        });
    }

    private FTPClient createFtpClient(FtpConfiguration configuration) {
        FtpConfiguration.Security security = configuration.getSecurity();
        if (!security.isPresent()) {
            LOGGER.log(Level.FINE, "No encryption used");
            RemoteUtils.HttpProxyInfo proxyInfo = RemoteUtils.getHttpProxy();
            if (proxyInfo != null) {
                LOGGER.log(Level.FINE, "HTTP proxy will be used");
                return new FTPHTTPClient(proxyInfo.getHost(), proxyInfo.getPort(), proxyInfo.getUsername(), proxyInfo.getPassword());
            }
            return new FTPClient();
        }
        FtpConfiguration.Encryption encryption = security.getEncryption();
        LOGGER.log(Level.FINE, "Used encryption {0}", encryption.name());
        return new FTPSClient(encryption.getProtocol(), encryption.isImplicit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProtocolCommandListener() {
        if (this.protocolCommandListener == null) {
            return;
        }
        FtpClient ftpClient = this;
        synchronized (ftpClient) {
            this.ftpClient.addProtocolCommandListener(this.protocolCommandListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProtocolCommandListener() {
        if (this.protocolCommandListener == null) {
            return;
        }
        FtpClient ftpClient = this;
        synchronized (ftpClient) {
            this.ftpClient.removeProtocolCommandListener(this.protocolCommandListener);
        }
    }

    @Override
    public synchronized void connect() throws RemoteException {
        try {
            String password = this.getPassword();
            int timeout = this.configuration.getTimeout() * 1000;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Connecting to {0} [timeout: {1} ms]", new Object[]{this.configuration.getHost(), timeout});
            }
            this.ftpClient.setDefaultTimeout(timeout);
            this.ftpClient.setControlKeepAliveReplyTimeout(this.keepAliveInterval);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Keep-alive interval is {0} ms", this.keepAliveInterval);
            }
            this.ftpClient.connect(this.configuration.getHost(), this.configuration.getPort());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Reply is {0}", this.getReplyString());
            }
            if (!FTPReply.isPositiveCompletion((int)this.ftpClient.getReplyCode())) {
                LOGGER.fine("Disconnecting because of negative reply");
                this.ftpClient.disconnect();
                throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpRefusedConnection", (Object)this.configuration.getHost()), this.getReplyString());
            }
            LOGGER.log(Level.FINE, "Login as {0}", this.configuration.getUserName());
            if (!this.ftpClient.login(this.configuration.getUserName(), password)) {
                LOGGER.fine("Login unusuccessful -> logout");
                this.ftpClient.logout();
                PASSWORDS.remove(this.configuration.hashCode());
                throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpLoginFailed"), this.getReplyString());
            }
            LOGGER.fine("Login successful");
            if (this.configuration.getSecurity().isPresent()) {
                FTPSClient ftpsClient = (FTPSClient)this.ftpClient;
                ftpsClient.execPBSZ(0L);
                if (!this.configuration.getSecurity().isOnlyLoginEncrypted()) {
                    ftpsClient.execPROT("P");
                }
            }
            if (this.configuration.isPassiveMode()) {
                LOGGER.fine("Setting passive mode");
                this.ftpClient.enterLocalPassiveMode();
            }
            LOGGER.fine("Setting file type to BINARY");
            this.ftpClient.setFileType(2);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Remote system is {0}", this.ftpClient.getSystemType());
            }
            LOGGER.fine("Setting data timeout");
            this.ftpClient.setDataTimeout(timeout);
            this.ftpClient.setListHiddenFiles(true);
            this.scheduleKeepAlive();
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            if (this.ftpClient.isConnected()) {
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Exception while disconnecting", e);
                }
            }
            LOGGER.log(Level.INFO, "Exception while connecting", ex);
            if (ex instanceof UnknownHostException) {
                ex = new IOException("Unknown host " + ex.getMessage());
            }
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotConnect", (Object)this.configuration.getHost()), ex, this.getReplyString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void disconnect() throws RemoteException {
        block14: {
            LOGGER.log(Level.FINE, "Remote client trying to disconnect");
            if (this.keepAliveTask != null) {
                this.keepAliveTask.cancel();
            }
            if (this.ftpClient.isConnected()) {
                LOGGER.log(Level.FINE, "Remote client connected -> disconnecting");
                try {
                    this.ftpClient.logout();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "Error while logout", ex);
                    if (this.configuration.getIgnoreDisconnectErrors()) {
                        LOGGER.log(Level.FINE, "Error while logout ignored by configuration");
                        break block14;
                    }
                    throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotLogout", (Object)this.configuration.getHost()), ex, this.getReplyString());
                }
                finally {
                    try {
                        this.ftpClient.disconnect();
                        LOGGER.log(Level.FINE, "Remote client disconnected");
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.FINE, "Remote client disconnected with exception", ex);
                    }
                }
            }
        }
    }

    private String getPassword() {
        String password = this.configuration.getPassword();
        assert (password != null);
        if (password.length() > 0) {
            return password;
        }
        password = PASSWORDS.get(this.configuration.hashCode());
        if (password != null) {
            return password;
        }
        PasswordPanel passwordPanel = PasswordPanel.forUser(this.configuration.getDisplayName(), this.configuration.getUserName());
        if (passwordPanel.open()) {
            password = passwordPanel.getPassword();
            PASSWORDS.put(this.configuration.hashCode(), password);
            return password;
        }
        return "";
    }

    @Override
    public synchronized String getReplyString() {
        String reply = this.ftpClient.getReplyString();
        if (reply == null) {
            return null;
        }
        return reply.trim();
    }

    @Override
    public synchronized String getNegativeReplyString() {
        int replyCode = this.ftpClient.getReplyCode();
        if (FTPReply.isNegativePermanent((int)replyCode) || FTPReply.isNegativeTransient((int)replyCode)) {
            return this.getReplyString();
        }
        return null;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.ftpClient.isConnected();
    }

    @Override
    public synchronized String printWorkingDirectory() throws RemoteException {
        try {
            return this.ftpClient.printWorkingDirectory();
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while pwd", ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotPwd", (Object)this.configuration.getHost()), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized boolean storeFile(String remote, InputStream local) throws RemoteException {
        try {
            boolean fileStored = this.ftpClient.storeFile(remote, local);
            this.scheduleKeepAlive();
            return fileStored;
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while storing file " + remote, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotStoreFile", (Object)remote), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized boolean deleteFile(String pathname) throws RemoteException {
        try {
            boolean fileDeleted = this.ftpClient.deleteFile(pathname);
            this.scheduleKeepAlive();
            return fileDeleted;
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while deleting file " + pathname, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotDeleteFile", (Object)pathname), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized boolean deleteDirectory(String pathname) throws RemoteException {
        try {
            boolean directoryDeleted = this.ftpClient.removeDirectory(pathname);
            this.scheduleKeepAlive();
            return directoryDeleted;
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while deleting file " + pathname, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotDeleteFile", (Object)pathname), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized boolean rename(String from, String to) throws RemoteException {
        try {
            boolean fileRenamed = this.ftpClient.rename(from, to);
            this.scheduleKeepAlive();
            return fileRenamed;
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, String.format("Error while renaming file %s -> %s", from, to), ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotRenameFile", (Object)from, (Object)to), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized List<RemoteFile> listFiles() throws RemoteException {
        ArrayList<RemoteFile> result = null;
        String pwd = null;
        try {
            pwd = this.ftpClient.printWorkingDirectory();
            FTPFile[] files = this.ftpClient.listFiles(pwd);
            result = new ArrayList<RemoteFile>(files.length);
            for (FTPFile f : files) {
                if (f == null) {
                    LOGGER.log(Level.FINE, "NULL returned for listing of {0}", pwd);
                    continue;
                }
                result.add(new RemoteFileImpl(f, pwd));
            }
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while listing files for " + pwd, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotListFiles", (Object)pwd), ex, this.getReplyString());
        }
        this.scheduleKeepAlive();
        return result;
    }

    @Override
    public synchronized RemoteFile listFile(String absolutePath) throws RemoteException {
        assert (absolutePath.startsWith("/")) : "Not absolute path give but: " + absolutePath;
        RemoteFileImpl result = null;
        try {
            FTPFile file;
            String name;
            FTPFile[] files;
            String parentPath = RemoteUtils.getParentPath(absolutePath);
            assert (parentPath != null) : "Parent path should exist for " + absolutePath;
            if (this.ftpClient.changeWorkingDirectory(parentPath) && (files = this.ftpClient.listFiles(name = RemoteUtils.getName(absolutePath))).length == 1 && ((file = files[0]).isFile() || file.isSymbolicLink()) && file.getName().equals(name)) {
                result = new RemoteFileImpl(file, parentPath);
            }
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while listing file for " + absolutePath, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotListFile", (Object)absolutePath), ex, this.getReplyString());
        }
        this.scheduleKeepAlive();
        return result;
    }

    @Override
    public synchronized boolean retrieveFile(String remote, OutputStream local) throws RemoteException {
        try {
            boolean fileRetrieved = this.ftpClient.retrieveFile(remote, local);
            this.scheduleKeepAlive();
            return fileRetrieved;
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while retrieving file " + remote, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotStoreFile", (Object)remote), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized boolean changeWorkingDirectory(String pathname) throws RemoteException {
        try {
            return this.ftpClient.changeWorkingDirectory(pathname);
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while changing directory " + pathname, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotChangeDirectory", (Object)pathname), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized boolean makeDirectory(String pathname) throws RemoteException {
        try {
            boolean directoryMade = this.ftpClient.makeDirectory(pathname);
            this.scheduleKeepAlive();
            return directoryMade;
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while creating directory " + pathname, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotCreateDirectory", (Object)pathname), ex, this.getReplyString());
        }
    }

    @Override
    @SuppressWarnings(value={"UG_SYNC_SET_UNSYNC_GET"})
    public int getPermissions(String path) throws RemoteException {
        try {
            return this.getPermissions(this.getFile(path));
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while getting permissions for " + path, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotGetPermissions", (Object)path), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized boolean setPermissions(int permissions, String path) throws RemoteException {
        try {
            return this.ftpClient.sendSiteCommand("chmod " + permissions + " " + path);
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            LOGGER.log(Level.FINE, "Error while setting permissions for " + path, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotSetPermissions", (Object)path), ex, this.getReplyString());
        }
    }

    @Override
    public synchronized boolean exists(String parent, String name) throws RemoteException {
        try {
            boolean found = false;
            this.ftpClient.changeWorkingDirectory(parent);
            for (RemoteFile file : this.listFiles()) {
                if (!file.getName().equals(name)) continue;
                found = true;
                break;
            }
            this.scheduleKeepAlive();
            return found;
        }
        catch (IOException ex) {
            WindowsJdk7WarningPanel.warn();
            String fullPath = parent + "/" + name;
            LOGGER.log(Level.FINE, "Error while checking existence of " + fullPath, ex);
            throw new RemoteException(NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotCheckFileExistence", (Object)fullPath), ex, this.getReplyString());
        }
    }

    private synchronized FTPFile getFile(String path) throws IOException {
        assert (path != null && path.trim().length() > 0);
        FTPFile[] files = this.ftpClient.listFiles(path);
        LOGGER.fine(String.format("Exactly 1 file should be found for %s; found %d", path, files.length));
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    private int getPermissions(FTPFile file) {
        if (file == null) {
            return -1;
        }
        StringBuilder sb = new StringBuilder(3);
        for (int access : PERMISSIONS_ACCESSES) {
            int rights = 0;
            if (file.hasPermission(access, 0)) {
                rights += 4;
            }
            if (file.hasPermission(access, 1)) {
                rights += 2;
            }
            if (file.hasPermission(access, 2)) {
                ++rights;
            }
            sb.append(rights);
        }
        assert (sb.length() == 3) : "Buffer lenght is incorrect: " + sb.length();
        int rights = Integer.valueOf(sb.toString());
        return rights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long getTimestampDiff() {
        if (this.timestampDiff != null) {
            return this.timestampDiff;
        }
        this.timestampDiff = 0L;
        this.removeProtocolCommandListener();
        try {
            File tmpFile = File.createTempFile("netbeans-timestampdiff-", ".txt");
            long now = tmpFile.lastModified();
            String remotePath = this.configuration.getInitialDirectory() + "/" + tmpFile.getName();
            FileInputStream is = new FileInputStream(tmpFile);
            try {
                if (this.storeFile(remotePath, is)) {
                    FTPFile remoteFile = this.getFile(remotePath);
                    if (remoteFile != null) {
                        this.timestampDiff = (now - remoteFile.getTimestamp().getTime().getTime()) / 1000L;
                    }
                    this.deleteFile(remotePath);
                }
            }
            finally {
                ((InputStream)is).close();
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Unable to calculate time difference", ex);
        }
        finally {
            this.addProtocolCommandListener();
        }
        return this.timestampDiff;
    }

    synchronized void keepAlive() {
        block3: {
            if (!this.ftpClient.isConnected()) {
                LOGGER.log(Level.FINE, "Ending keep-alive (NOOP) for {0}, not connected", this.configuration.getHost());
                this.keepAliveTask.cancel();
                return;
            }
            try {
                LOGGER.log(Level.FINE, "Keep-alive (NOOP) for {0}", this.configuration.getHost());
                this.ftpClient.noop();
                this.ftpClient.getReplyString();
                this.preventNoOperationTimeout();
                this.scheduleKeepAlive();
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Keep-alive (NOOP/PWD) error for " + this.configuration.getHost(), ex);
                this.keepAliveTask.cancel();
                this.silentDisconnect();
                WindowsJdk7WarningPanel.warn();
                if (this.io == null) break block3;
                String reason = this.getReplyString();
                String message = StringUtils.hasText((String)reason) ? NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotKeepAlive", (Object)this.configuration.getHost(), (Object)reason) : NbBundle.getMessage(FtpClient.class, (String)"MSG_FtpCannotKeepAliveNoReason", (Object)this.configuration.getHost());
                this.io.getErr().println(message);
            }
        }
    }

    private void silentDisconnect() {
        try {
            this.disconnect();
        }
        catch (RemoteException ex) {
            LOGGER.log(Level.FINE, "Error while silently disconnecting", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preventNoOperationTimeout() throws IOException {
        int counter = this.keepAliveCounter.incrementAndGet();
        if (counter == 10) {
            this.keepAliveCounter.set(0);
            LOGGER.log(Level.FINE, "Keep-alive (PWD) for {0}", this.configuration.getHost());
            this.removeProtocolCommandListener();
            try {
                this.ftpClient.pwd();
                this.ftpClient.getReplyString();
            }
            finally {
                this.addProtocolCommandListener();
            }
        }
    }

    private void scheduleKeepAlive() {
        if (this.keepAliveTask != null) {
            this.keepAliveTask.schedule(this.keepAliveInterval);
        }
    }

    private final class RemoteFileImpl
    implements RemoteFile {
        private final FTPFile ftpFile;
        private final String parentDirectory;

        public RemoteFileImpl(FTPFile ftpFile, String parentDirectory) {
            assert (ftpFile != null);
            assert (parentDirectory != null);
            this.ftpFile = ftpFile;
            this.parentDirectory = parentDirectory;
        }

        @Override
        public String getName() {
            return this.ftpFile.getName();
        }

        @Override
        public String getParentDirectory() {
            return this.parentDirectory;
        }

        @Override
        public boolean isDirectory() {
            return this.ftpFile.isDirectory();
        }

        @Override
        public boolean isFile() {
            return this.ftpFile.isFile();
        }

        @Override
        public boolean isLink() {
            return this.ftpFile.isSymbolicLink();
        }

        @Override
        public long getSize() {
            return this.ftpFile.getSize();
        }

        @Override
        public long getTimestamp() {
            return TimeUnit.SECONDS.convert(this.ftpFile.getTimestamp().getTime().getTime(), TimeUnit.MILLISECONDS) + FtpClient.this.getTimestampDiff();
        }

        public String toString() {
            return "FtpFile[name: " + this.getName() + ", parent directory: " + this.getParentDirectory() + "]";
        }
    }

    private static final class PrintCommandListener
    implements ProtocolCommandListener {
        private final InputOutput io;

        public PrintCommandListener(InputOutput io) {
            assert (io != null);
            this.io = io;
        }

        public void protocolCommandSent(ProtocolCommandEvent event) {
            this.processEvent(event);
        }

        public void protocolReplyReceived(ProtocolCommandEvent event) {
            this.processEvent(event);
        }

        private void processEvent(ProtocolCommandEvent event) {
            String message = event.getMessage();
            if (message.startsWith("PASS ")) {
                message = "PASS ******";
            }
            OutputWriter writer = null;
            writer = event.isReply() && (FTPReply.isNegativeTransient((int)event.getReplyCode()) || FTPReply.isNegativePermanent((int)event.getReplyCode())) ? this.io.getErr() : this.io.getOut();
            writer.println(message.trim());
            writer.flush();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Command listener: {0}", message.trim());
            }
        }
    }
}

