/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.Bundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NetworkSettings;

public final class RemoteUtils {
    private static final Logger LOGGER = Logger.getLogger(RemoteUtils.class.getName());
    private static final URI URI_FOR_HTTP_PROXY = URI.create("http://oracle.com");

    private RemoteUtils() {
    }

    public static void processRemoteException(RemoteException remoteException) {
        String title = Bundle.LBL_RemoteError();
        StringBuilder message = new StringBuilder(remoteException.getMessage());
        String remoteServerAnswer = remoteException.getRemoteServerAnswer();
        Throwable cause = remoteException.getCause();
        if (remoteServerAnswer != null && remoteServerAnswer.length() > 0) {
            message.append(Bundle.MSG_RemoteErrorReason(remoteServerAnswer));
        } else if (cause != null) {
            message.append(Bundle.MSG_RemoteErrorReason(cause.getMessage()));
        }
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)message.toString(), title, 2, 0, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(notifyDescriptor);
    }

    public static String sanitizeDirectoryPath(String directoryPath) {
        while (!directoryPath.equals("/") && directoryPath.endsWith("/")) {
            LOGGER.log(Level.FINE, "Removing ending slash from directory {0}", directoryPath);
            directoryPath = directoryPath.substring(0, directoryPath.length() - "/".length());
        }
        return directoryPath;
    }

    public static String sanitizeUploadDirectory(String uploadDirectory, boolean allowEmpty) {
        if (StringUtils.hasText((String)uploadDirectory)) {
            while (uploadDirectory.length() > 1 && uploadDirectory.endsWith("/")) {
                uploadDirectory = uploadDirectory.substring(0, uploadDirectory.length() - 1);
            }
        } else if (!allowEmpty) {
            uploadDirectory = "/";
        }
        if (allowEmpty && (uploadDirectory == null || "/".equals(uploadDirectory))) {
            uploadDirectory = "";
        }
        return uploadDirectory;
    }

    public static String getParentPath(String path) {
        ArrayList parts;
        if (path.equals("/")) {
            return null;
        }
        boolean absolute = path.startsWith("/");
        if (absolute) {
            path = path.substring(1);
        }
        if ((parts = new ArrayList(StringUtils.explode((String)path, (String)"/"))).size() <= 1) {
            return absolute ? "/" : null;
        }
        parts.remove(parts.size() - 1);
        String parent = StringUtils.implode(parts, (String)"/");
        if (absolute) {
            return "/" + parent;
        }
        return parent;
    }

    public static String getName(String path) {
        if (path.equals("/")) {
            return "/";
        }
        ArrayList parts = new ArrayList(StringUtils.explode((String)path, (String)"/"));
        return (String)parts.get(parts.size() - 1);
    }

    public static boolean hasHttpProxy() {
        return NetworkSettings.getProxyHost((URI)URI_FOR_HTTP_PROXY) != null;
    }

    @CheckForNull
    public static HttpProxyInfo getHttpProxy() {
        String proxyHost = NetworkSettings.getProxyHost((URI)URI_FOR_HTTP_PROXY);
        if (proxyHost == null) {
            return null;
        }
        return new HttpProxyInfo(proxyHost, Integer.parseInt(NetworkSettings.getProxyPort((URI)URI_FOR_HTTP_PROXY)), NetworkSettings.getAuthenticationUsername((URI)URI_FOR_HTTP_PROXY), NetworkSettings.getKeyForAuthenticationPassword((URI)URI_FOR_HTTP_PROXY));
    }

    public static final class HttpProxyInfo {
        private final String host;
        private final int port;
        private final String username;
        private final String passwordKey;

        public HttpProxyInfo(String host, int port, String username, String passwordKey) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.passwordKey = passwordKey;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            if (this.passwordKey == null) {
                return null;
            }
            char[] chars = Keyring.read((String)this.passwordKey);
            if (chars == null) {
                return null;
            }
            return new String(chars);
        }
    }
}

