/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.php.project.classpath.CommonPhpSourcePath;
import org.netbeans.modules.php.project.classpath.PhpSourcePathImplementation;
import org.netbeans.modules.php.project.classpath.SourcePathImplementation;
import org.netbeans.modules.php.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PhpSourcePathImplementation,
PropertyChangeListener {
    private final PhpProject project;
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sources;
    private final SourceRoots tests;
    private final SourceRoots selenium;
    private final ConcurrentMap<String, List<FileObject>> dirCache = new ConcurrentHashMap<String, List<FileObject>>();
    private final Map<ClassPathCache, ClassPath> cache = new EnumMap<ClassPathCache, ClassPath>(ClassPathCache.class);

    public ClassPathProviderImpl(PhpProject project, SourceRoots sources, SourceRoots tests, SourceRoots selenium) {
        assert (project != null);
        assert (sources != null);
        assert (tests != null);
        assert (selenium != null);
        this.project = project;
        this.helper = project.getHelper();
        this.projectDirectory = FileUtil.toFile((FileObject)this.helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = ProjectPropertiesSupport.getPropertyEvaluator(project);
        this.sources = sources;
        this.tests = tests;
        this.selenium = selenium;
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.evaluator));
    }

    private List<FileObject> getDirs(String propname) {
        ArrayList<FileObject> dirs = (ArrayList<FileObject>)this.dirCache.get(propname);
        if (!this.checkDirs((List<FileObject>)dirs)) {
            String prop = this.evaluator.getProperty(propname);
            if (prop == null) {
                return Collections.emptyList();
            }
            String[] paths = PropertyUtils.tokenizePath((String)prop);
            dirs = new ArrayList<FileObject>(paths.length);
            for (String path : paths) {
                FileObject resolvedFile = this.helper.resolveFileObject(path);
                if (resolvedFile == null) continue;
                dirs.add(resolvedFile);
            }
            this.dirCache.put(propname, dirs);
        }
        return dirs;
    }

    private boolean checkDirs(List<FileObject> dirs) {
        if (dirs == null) {
            return false;
        }
        for (FileObject fo : dirs) {
            if (fo.isValid()) continue;
            return false;
        }
        return true;
    }

    private List<FileObject> getPlatformPath() {
        return this.getDirs("include.path");
    }

    @Override
    public PhpSourcePath.FileType getFileType(FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        for (FileObject root : this.tests.getRoots()) {
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return PhpSourcePath.FileType.TEST;
        }
        for (FileObject root : this.selenium.getRoots()) {
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return PhpSourcePath.FileType.TEST;
        }
        for (FileObject root : this.sources.getRoots()) {
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return PhpSourcePath.FileType.SOURCE;
        }
        for (FileObject dir : this.getPlatformPath()) {
            if (!dir.equals(file) && !FileUtil.isParentOf((FileObject)dir, (FileObject)file)) continue;
            return PhpSourcePath.FileType.INCLUDE;
        }
        for (FileObject dir : CommonPhpSourcePath.getInternalPath()) {
            if (dir == null || !dir.equals(file) && !FileUtil.isParentOf((FileObject)dir, (FileObject)file)) continue;
            return PhpSourcePath.FileType.INTERNAL;
        }
        return PhpSourcePath.FileType.UNKNOWN;
    }

    @Override
    public List<FileObject> getIncludePath() {
        return new ArrayList<FileObject>(this.getPlatformPath());
    }

    @Override
    public FileObject resolveFile(FileObject directory, String fileName) {
        FileObject resolved = directory.getFileObject(fileName);
        if (resolved != null) {
            return resolved;
        }
        for (FileObject dir : this.getPlatformPath()) {
            resolved = dir.getFileObject(fileName);
            if (resolved == null) continue;
            return resolved;
        }
        return null;
    }

    private ClassPath getSourcePath(FileObject file) {
        return this.getSourcePath(this.getFileType(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getSourcePath(PhpSourcePath.FileType type) {
        ClassPath cp = null;
        switch (type) {
            case SOURCE: {
                Map<ClassPathCache, ClassPath> map = this.cache;
                synchronized (map) {
                    cp = this.cache.get((Object)ClassPathCache.SOURCE);
                    if (cp == null) {
                        cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.project, this.sources, this.tests, this.selenium));
                        this.cache.put(ClassPathCache.SOURCE, cp);
                    }
                    break;
                }
            }
            case TEST: {
                Map<ClassPathCache, ClassPath> map = this.cache;
                synchronized (map) {
                    cp = this.cache.get((Object)ClassPathCache.TEST);
                    if (cp == null) {
                        ClassPath testsCp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.project, this.tests));
                        ClassPath seleniumCp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.project, this.selenium));
                        ClassPath sourcesCp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.project, this.sources, this.tests, this.selenium));
                        cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{testsCp, seleniumCp, sourcesCp});
                        this.cache.put(ClassPathCache.TEST, cp);
                    }
                    break;
                }
            }
        }
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getBootClassPath() {
        ClassPath cp;
        Map<ClassPathCache, ClassPath> map = this.cache;
        synchronized (map) {
            cp = this.cache.get((Object)ClassPathCache.PLATFORM);
            if (cp == null) {
                List<FileObject> internalFolders = CommonPhpSourcePath.getInternalPath();
                ClassPath internalClassPath = ClassPathSupport.createClassPath((FileObject[])internalFolders.toArray(new FileObject[internalFolders.size()]));
                ClassPath includePath = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation(this.projectDirectory, this.evaluator, new String[]{"include.path"}));
                cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{internalClassPath, includePath});
                this.cache.put(ClassPathCache.PLATFORM, cp);
            }
        }
        return cp;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/php-boot")) {
            return this.getBootClassPath();
        }
        if (type.equals("classpath/php-source")) {
            return this.getSourcePath(file);
        }
        if (type.equals("js/library")) {
            return this.getSourcePath(PhpSourcePath.FileType.SOURCE);
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/php-boot".equals(type)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/php-source".equals(type)) {
            return new ClassPath[]{this.getSourcePath(PhpSourcePath.FileType.SOURCE), this.getSourcePath(PhpSourcePath.FileType.TEST)};
        }
        assert (false) : "Unknown classpath type requested: " + type;
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("include.path".equals(propertyName)) {
            this.dirCache.remove(propertyName);
        }
    }

    private static enum ClassPathCache {
        PLATFORM,
        SOURCE,
        TEST;

    }
}

