/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.classpath.CommonPhpSourcePath;
import org.netbeans.modules.php.project.classpath.IncludePathClassPathProvider;
import org.netbeans.modules.php.project.classpath.PhpSourcePathImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Parameters;

public final class PhpSourcePath {
    public static final String BOOT_CP = "classpath/php-boot";
    public static final String SOURCE_CP = "classpath/php-source";
    private static final DefaultPhpSourcePath DEFAULT_PHP_SOURCE_PATH = new DefaultPhpSourcePath();
    private static FileObject phpStubsFolder = null;

    private PhpSourcePath() {
    }

    public static FileType getFileType(FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        if (PhpSourcePath.isInternalFile(file)) {
            return FileType.INTERNAL;
        }
        PhpSourcePathImplementation phpSourcePath = PhpSourcePath.getPhpSourcePathForProjectFile(file);
        if (phpSourcePath != null) {
            return phpSourcePath.getFileType(file);
        }
        FileType fileType = PhpSourcePath.getFileTypeFromIncludeClassPath(file);
        if (fileType != null) {
            return fileType;
        }
        return DEFAULT_PHP_SOURCE_PATH.getFileType(file);
    }

    public static synchronized List<FileObject> getPreindexedFolders() {
        if (phpStubsFolder == null) {
            File clusterFile = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-php-project.jar", "org.netbeans.modules.php.project", false);
            if (clusterFile != null) {
                File phpStubs = new File(clusterFile.getParentFile().getParentFile().getAbsoluteFile(), "phpstubs/phpruntime");
                assert (phpStubs.exists() && phpStubs.isDirectory()) : "No stubs found";
                phpStubsFolder = FileUtil.toFileObject((File)phpStubs);
            } else {
                String phpDir = System.getProperty("xtest.php.home");
                if (phpDir == null) {
                    throw new RuntimeException("xtest.php.home property has to be set when running within binary distribution");
                }
                File phpStubs = new File(phpDir + File.separator + "phpstubs/phpruntime");
                if (phpStubs.exists()) {
                    phpStubsFolder = FileUtil.toFileObject((File)phpStubs);
                } else {
                    phpStubsFolder = FileUtil.toFileObject((File)new File(phpDir));
                    assert (phpStubsFolder != null);
                }
            }
        }
        return Collections.singletonList(phpStubsFolder);
    }

    public static List<FileObject> getIncludePath(FileObject file) {
        if (file == null) {
            return DEFAULT_PHP_SOURCE_PATH.getIncludePath();
        }
        PhpSourcePathImplementation phpSourcePath = PhpSourcePath.getPhpSourcePathForProjectFile(file);
        if (phpSourcePath != null) {
            return phpSourcePath.getIncludePath();
        }
        return DEFAULT_PHP_SOURCE_PATH.getIncludePath();
    }

    public static FileObject resolveFile(FileObject directory, String fileName) {
        Parameters.notNull((CharSequence)"directory", (Object)directory);
        Parameters.notNull((CharSequence)"fileName", (Object)fileName);
        if (!directory.isFolder()) {
            throw new IllegalArgumentException("valid directory needed");
        }
        PhpSourcePathImplementation phpSourcePath = PhpSourcePath.getPhpSourcePathForProjectFile(directory);
        if (phpSourcePath != null) {
            return phpSourcePath.resolveFile(directory, fileName);
        }
        return DEFAULT_PHP_SOURCE_PATH.resolveFile(directory, fileName);
    }

    private static PhpSourcePathImplementation getPhpSourcePathForProjectFile(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        PhpSourcePathImplementation phpSourcePath = (PhpSourcePathImplementation)project.getLookup().lookup(PhpSourcePathImplementation.class);
        return phpSourcePath;
    }

    private static FileType getFileTypeFromIncludeClassPath(FileObject file) {
        ClassPath classPath = IncludePathClassPathProvider.findProjectIncludePath(file);
        if (classPath != null && classPath.contains(file)) {
            if (PhpSourcePath.isInternalFile(file)) {
                return FileType.INTERNAL;
            }
            return FileType.INCLUDE;
        }
        return null;
    }

    private static boolean isInternalFile(FileObject file) {
        for (FileObject dir : CommonPhpSourcePath.getInternalPath()) {
            if (!dir.equals(file) && !FileUtil.isParentOf((FileObject)dir, (FileObject)file)) continue;
            return true;
        }
        return false;
    }

    private static class DefaultPhpSourcePath
    implements PhpSourcePathImplementation {
        private DefaultPhpSourcePath() {
        }

        @Override
        public FileType getFileType(FileObject file) {
            for (FileObject dir : CommonPhpSourcePath.getInternalPath()) {
                if (!dir.equals(file) && !FileUtil.isParentOf((FileObject)dir, (FileObject)file)) continue;
                return FileType.INTERNAL;
            }
            for (FileObject dir : this.getPlatformPath()) {
                if (!dir.equals(file) && !FileUtil.isParentOf((FileObject)dir, (FileObject)file)) continue;
                return FileType.INCLUDE;
            }
            return FileType.UNKNOWN;
        }

        @Override
        public List<FileObject> getIncludePath() {
            return new ArrayList<FileObject>(this.getPlatformPath());
        }

        @Override
        public FileObject resolveFile(FileObject directory, String fileName) {
            FileObject resolved = directory.getFileObject(fileName);
            if (resolved != null) {
                return resolved;
            }
            for (FileObject dir : this.getPlatformPath()) {
                resolved = dir.getFileObject(fileName);
                if (resolved == null) continue;
                return resolved;
            }
            return null;
        }

        private List<FileObject> getPlatformPath() {
            String[] paths = PhpOptions.getInstance().getPhpGlobalIncludePathAsArray();
            List<FileObject> internalPath = CommonPhpSourcePath.getInternalPath();
            ArrayList<FileObject> dirs = new ArrayList<FileObject>(paths.length + internalPath.size());
            dirs.addAll(internalPath);
            for (String path : paths) {
                FileObject resolvedFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(path)));
                if (resolvedFile == null) continue;
                dirs.add(resolvedFile);
            }
            return dirs;
        }
    }

    public static enum FileType {
        INTERNAL,
        INCLUDE,
        SOURCE,
        TEST,
        UNKNOWN;

    }
}

