/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.php.project.PhpLanguagePropertiesAccessor;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PhpLanguageProperties {
    public static final boolean SHORT_TAGS_ENABLED = true;
    public static final boolean ASP_TAGS_ENABLED = Boolean.getBoolean("netbeans.php.aspTags.enabled");
    public static final String PROP_SHORT_TAGS = PhpLanguageProperties.class.getName() + ".shortTags";
    public static final String PROP_ASP_TAGS = PhpLanguageProperties.class.getName() + ".aspTags";
    public static final String PROP_PHP_VERSION = PhpLanguageProperties.class.getName() + ".phpVersion";
    private static final PhpLanguageProperties INSTANCE = new PhpLanguageProperties();
    private final PhpLanguageOptionsImpl impl;

    PhpLanguageProperties(PhpProject project) {
        this.impl = ProjectOptions.forProject(project);
    }

    private PhpLanguageProperties() {
        this.impl = new DefaultOptions();
    }

    public static PhpLanguageProperties getDefault() {
        return INSTANCE;
    }

    public static PhpLanguageProperties forFileObject(FileObject fileObject) {
        PhpProject phpProject;
        if (fileObject != null && (phpProject = PhpProjectUtils.getPhpProject(fileObject)) != null) {
            return (PhpLanguageProperties)phpProject.getLookup().lookup(PhpLanguageProperties.class);
        }
        return INSTANCE;
    }

    public boolean areShortTagsEnabled() {
        return this.impl.areShortTagsEnabled();
    }

    public boolean areAspTagsEnabled() {
        return this.impl.areAspTagsEnabled();
    }

    public PhpVersion getPhpVersion() {
        return this.impl.getPhpVersion();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.impl.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.impl.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.getClass().getName());
        sb.append(" [shorTagsEnabled: ");
        sb.append(this.impl.areShortTagsEnabled());
        sb.append(", aspTagsEnabled: ");
        sb.append(this.impl.areAspTagsEnabled());
        sb.append(", PHP version: ");
        sb.append((Object)this.impl.getPhpVersion());
        sb.append("]");
        return sb.toString();
    }

    static {
        PhpLanguagePropertiesAccessor.setDefault(new PhpLanguagePropertiesAccessor(){

            @Override
            public PhpLanguageProperties createForProject(PhpProject project) {
                return new PhpLanguageProperties(project);
            }
        });
    }

    private static final class ProjectOptions
    implements PhpLanguageOptionsImpl,
    PropertyChangeListener {
        private final PhpProject project;
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
        volatile Boolean shortTagsEnabled;
        volatile Boolean aspTagsEnabled;
        volatile PhpVersion phpVersion;

        private ProjectOptions(PhpProject project) {
            this.project = project;
        }

        public static ProjectOptions forProject(PhpProject project) {
            ProjectOptions projectOptions = new ProjectOptions(project);
            ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(project, projectOptions);
            return projectOptions;
        }

        @Override
        public boolean areShortTagsEnabled() {
            if (this.shortTagsEnabled == null) {
                this.shortTagsEnabled = ProjectPropertiesSupport.areShortTagsEnabled(this.project);
            }
            return this.shortTagsEnabled;
        }

        @Override
        public boolean areAspTagsEnabled() {
            if (this.aspTagsEnabled == null) {
                this.aspTagsEnabled = ProjectPropertiesSupport.areAspTagsEnabled(this.project);
            }
            return this.aspTagsEnabled;
        }

        @Override
        public PhpVersion getPhpVersion() {
            if (this.phpVersion == null) {
                this.phpVersion = ProjectPropertiesSupport.getPhpVersion(this.project);
            }
            return this.phpVersion;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("tags.short".equals(propertyName)) {
                this.shortTagsEnabled = null;
                this.firePropertyChange(PROP_SHORT_TAGS, evt.getOldValue(), evt.getNewValue());
            } else if ("tags.asp".equals(propertyName)) {
                this.aspTagsEnabled = null;
                this.firePropertyChange(PROP_ASP_TAGS, evt.getOldValue(), evt.getNewValue());
            } else if ("php.version".equals(propertyName)) {
                this.phpVersion = null;
                this.firePropertyChange(PROP_PHP_VERSION, evt.getOldValue(), evt.getNewValue());
            }
        }
    }

    private static final class DefaultOptions
    implements PhpLanguageOptionsImpl {
        private DefaultOptions() {
        }

        @Override
        public boolean areShortTagsEnabled() {
            return true;
        }

        @Override
        public boolean areAspTagsEnabled() {
            return ASP_TAGS_ENABLED;
        }

        @Override
        public PhpVersion getPhpVersion() {
            return PhpVersion.getDefault();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private static interface PhpLanguageOptionsImpl {
        public boolean areShortTagsEnabled();

        public boolean areAspTagsEnabled();

        public PhpVersion getPhpVersion();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    public static final class PhpVersion
    extends Enum<PhpVersion> {
        public static final /* enum */ PhpVersion PHP_5 = new PhpVersion(NbBundle.getMessage(PhpLanguageProperties.class, (String)"PHP_5"));
        public static final /* enum */ PhpVersion PHP_53 = new PhpVersion(NbBundle.getMessage(PhpLanguageProperties.class, (String)"PHP_53"));
        public static final /* enum */ PhpVersion PHP_54 = new PhpVersion(NbBundle.getMessage(PhpLanguageProperties.class, (String)"PHP_54"));
        private final String displayName;
        private static final /* synthetic */ PhpVersion[] $VALUES;

        public static PhpVersion[] values() {
            return (PhpVersion[])$VALUES.clone();
        }

        public static PhpVersion valueOf(String name) {
            return Enum.valueOf(PhpVersion.class, name);
        }

        private PhpVersion(String displayName) {
            assert (displayName != null);
            this.displayName = displayName;
        }

        public static PhpVersion getDefault() {
            PhpVersion[] phpVersions = PhpVersion.values();
            return phpVersions[phpVersions.length - 1];
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        static {
            $VALUES = new PhpVersion[]{PHP_5, PHP_53, PHP_54};
        }
    }
}

