/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.php.api.framework.PhpFrameworks;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpConfigurationProvider;
import org.netbeans.modules.php.project.PhpEditorExtender;
import org.netbeans.modules.php.project.PhpLanguagePropertiesAccessor;
import org.netbeans.modules.php.project.PhpModuleImpl;
import org.netbeans.modules.php.project.PhpProjectEncodingQueryImpl;
import org.netbeans.modules.php.project.PhpProjectOperations;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.PhpSharabilityQuery;
import org.netbeans.modules.php.project.PhpSources;
import org.netbeans.modules.php.project.PhpTemplates;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.modules.php.project.TemplateAttributesProviderImpl;
import org.netbeans.modules.php.project.UpdateHelper;
import org.netbeans.modules.php.project.UpdateImplementation;
import org.netbeans.modules.php.project.api.PhpSeleniumProvider;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.netbeans.modules.php.project.classpath.BasePathSupport;
import org.netbeans.modules.php.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.php.project.classpath.IncludePathClassPathProvider;
import org.netbeans.modules.php.project.copysupport.CopySupport;
import org.netbeans.modules.php.project.internalserver.InternalWebServer;
import org.netbeans.modules.php.project.problems.ProjectPropertiesProblemProvider;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.codecoverage.PhpCoverageProvider;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.IgnorePathSupport;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleIgnoredFilesExtender;
import org.netbeans.modules.web.common.spi.ProjectWebRootProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.netbeans.spi.search.SubTreeSearchOptions;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class PhpProject
implements Project {
    static final Logger LOGGER = Logger.getLogger(PhpProject.class.getName());
    public static final String PROJECT_ICON = "org/netbeans/modules/php/project/ui/resources/phpProject.png";
    final AntProjectHelper helper;
    final UpdateHelper updateHelper;
    private final ReferenceHelper refHelper;
    private final PropertyEvaluator eval;
    private final Lookup lookup;
    private final SourceRoots sourceRoots;
    private final SourceRoots testRoots;
    private final SourceRoots seleniumRoots;
    private final SearchFilterDefinition searchFilterDef = new PhpSearchFilterDef();
    volatile FileObject webRootDirectory;
    volatile String name;
    private final AntProjectListener phpAntProjectListener = new PhpAntProjectListener();
    private final PropertyChangeListener projectPropertiesListener = new ProjectPropertiesListener();
    Set<BasePathSupport.Item> ignoredFolders;
    final Object ignoredFoldersLock = new Object();
    final ChangeSupport ignoredFoldersChangeSupport = new ChangeSupport((Object)this);
    private volatile boolean frameworksDirty = true;
    final List<PhpFrameworkProvider> frameworks = new CopyOnWriteArrayList<PhpFrameworkProvider>();
    volatile FileChangeListener sourceDirectoryFileChangeListener = null;
    private final LookupListener frameworksListener = new FrameworksListener();
    public static final String PROP_FRAMEWORKS = "frameworks";
    public static final String PROP_WEB_ROOT = "webRoot";
    final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final Set<PropertyChangeListener> propertyChangeListeners = new WeakSet();

    public PhpProject(AntProjectHelper helper) {
        assert (helper != null);
        this.helper = helper;
        this.updateHelper = new UpdateHelper(UpdateImplementation.NULL, helper);
        AuxiliaryConfiguration configuration = helper.createAuxiliaryConfiguration();
        this.eval = this.createEvaluator();
        this.refHelper = new ReferenceHelper(helper, configuration, this.getEvaluator());
        this.sourceRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.SOURCES);
        this.testRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.TESTS);
        this.seleniumRoots = SourceRoots.create(this.updateHelper, this.eval, this.refHelper, SourceRoots.Type.SELENIUM);
        this.lookup = this.createLookup(configuration);
        this.addWeakPropertyEvaluatorListener(this.projectPropertiesListener);
        helper.addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.phpAntProjectListener, (Object)helper));
        this.sourceRoots.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PhpProject.this.sourceDirectoryFileChangeListener = null;
            }
        });
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    PropertyEvaluator getEvaluator() {
        return this.eval;
    }

    void addWeakPropertyEvaluatorListener(PropertyChangeListener listener) {
        this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)this.eval));
    }

    void addWeakIgnoredFilesListener(ChangeListener listener) {
        this.ignoredFoldersChangeSupport.addChangeListener(WeakListeners.change((ChangeListener)listener, (Object)this.ignoredFoldersChangeSupport));
        VisibilityQuery visibilityQuery = VisibilityQuery.getDefault();
        visibilityQuery.addChangeListener(WeakListeners.change((ChangeListener)listener, (Object)visibilityQuery));
    }

    boolean addWeakPropertyChangeListener(PropertyChangeListener listener) {
        if (!this.propertyChangeListeners.add(listener)) {
            return false;
        }
        this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)this.propertyChangeSupport));
        return true;
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public SearchFilterDefinition getSearchFilterDefinition() {
        return this.searchFilterDef;
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator baseEval1 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties")});
        PropertyEvaluator baseEval2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/private.properties")});
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)this.helper.getStockPropertyPreprovider(), (PropertyProvider[])new PropertyProvider[]{this.helper.getPropertyProvider("nbproject/private/config.properties"), new ConfigPropertyProvider(baseEval1, "nbproject/private/configs", this.helper), this.helper.getPropertyProvider("nbproject/private/private.properties"), this.helper.getProjectLibrariesPropertyProvider(), PropertyUtils.userPropertiesProvider((PropertyEvaluator)baseEval2, (String)"user.properties.file", (File)FileUtil.toFile((FileObject)this.getProjectDirectory())), new ConfigPropertyProvider(baseEval1, "nbproject/configs", this.helper), this.helper.getPropertyProvider("nbproject/project.properties")});
    }

    public FileObject getProjectDirectory() {
        return this.getHelper().getProjectDirectory();
    }

    public SourceRoots getSourceRoots() {
        return this.sourceRoots;
    }

    public SourceRoots getTestRoots() {
        return this.testRoots;
    }

    public SourceRoots getSeleniumRoots() {
        return this.seleniumRoots;
    }

    FileObject getSourcesDirectory() {
        int i$ = 0;
        FileObject[] arr$ = this.sourceRoots.getRoots();
        int len$ = arr$.length;
        if (i$ < len$) {
            FileObject root = arr$[i$];
            if (this.sourceDirectoryFileChangeListener == null) {
                this.sourceDirectoryFileChangeListener = new SourceDirectoryFileChangeListener();
                root.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.sourceDirectoryFileChangeListener, (Object)root));
            }
            return root;
        }
        return null;
    }

    FileObject getTestsDirectory() {
        int i$ = 0;
        FileObject[] arr$ = this.testRoots.getRoots();
        int len$ = arr$.length;
        if (i$ < len$) {
            FileObject root = arr$[i$];
            return root;
        }
        return null;
    }

    FileObject getSeleniumDirectory() {
        int i$ = 0;
        FileObject[] arr$ = this.seleniumRoots.getRoots();
        int len$ = arr$.length;
        if (i$ < len$) {
            FileObject root = arr$[i$];
            return root;
        }
        return null;
    }

    FileObject getWebRootDirectory() {
        if (this.webRootDirectory == null) {
            this.webRootDirectory = this.resolveWebRootDirectory();
        }
        return this.webRootDirectory;
    }

    private FileObject resolveWebRootDirectory() {
        if (PhpProjectValidator.isFatallyBroken(this)) {
            return null;
        }
        FileObject sources = this.getSourcesDirectory();
        String webRootProperty = this.eval.getProperty("web.root");
        if (webRootProperty == null) {
            return sources;
        }
        FileObject webRootDir = sources.getFileObject(webRootProperty);
        if (webRootDir != null) {
            return webRootDir;
        }
        LOGGER.log(Level.INFO, "Web root directory {0} not found for project {1}", new Object[]{webRootProperty, this.getName()});
        return sources;
    }

    public PhpModule getPhpModule() {
        PhpModule phpModule = (PhpModule)this.getLookup().lookup(PhpModule.class);
        assert (phpModule != null);
        return phpModule;
    }

    boolean isVisible(File file) {
        if (this.getIgnoredFiles().contains(file)) {
            return false;
        }
        return VisibilityQuery.getDefault().isVisible(file);
    }

    boolean isVisible(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            if (this.getIgnoredFileObjects().contains(fileObject)) {
                return false;
            }
            return VisibilityQuery.getDefault().isVisible(fileObject);
        }
        return this.isVisible(file);
    }

    public Set<File> getIgnoredFiles() {
        HashSet<File> ignored = new HashSet<File>();
        this.addIgnoredProjectFiles(ignored);
        this.addIgnoredFrameworkFiles(ignored);
        return ignored;
    }

    public Set<FileObject> getIgnoredFileObjects() {
        HashSet<FileObject> ignoredFileObjects = new HashSet<FileObject>();
        for (File file : this.getIgnoredFiles()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            ignoredFileObjects.add(fo);
        }
        return ignoredFileObjects;
    }

    private void addIgnoredProjectFiles(final Set<File> ignored) {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                Object object = PhpProject.this.ignoredFoldersLock;
                synchronized (object) {
                    if (PhpProject.this.ignoredFolders == null) {
                        PhpProject.this.ignoredFolders = PhpProject.this.resolveIgnoredFolders();
                    }
                    assert (PhpProject.this.ignoredFolders != null) : "Ignored folders cannot be null";
                    for (BasePathSupport.Item item : PhpProject.this.ignoredFolders) {
                        if (item.isBroken()) continue;
                        ignored.add(new File(item.getAbsoluteFilePath(PhpProject.this.helper.getProjectDirectory())));
                    }
                }
                return null;
            }
        });
    }

    private void resetIgnoredFolders() {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                Object object = PhpProject.this.ignoredFoldersLock;
                synchronized (object) {
                    PhpProject.this.ignoredFolders = null;
                }
                return null;
            }
        });
    }

    private void addIgnoredFrameworkFiles(Set<File> ignored) {
        PhpModule phpModule = this.getPhpModule();
        for (PhpFrameworkProvider provider : this.getFrameworks()) {
            PhpModuleIgnoredFilesExtender ignoredFilesExtender = provider.getIgnoredFilesExtender(phpModule);
            if (ignoredFilesExtender == null) continue;
            for (File file : ignoredFilesExtender.getIgnoredFiles()) {
                assert (file != null) : "Ignored file = null found in " + provider.getIdentifier();
                assert (file.isAbsolute()) : "Not absolute file found in " + provider.getIdentifier();
                ignored.add(file);
            }
        }
    }

    private Set<BasePathSupport.Item> resolveIgnoredFolders() {
        IgnorePathSupport ignorePathSupport = new IgnorePathSupport(this.eval, this.refHelper, this.helper);
        HashSet<BasePathSupport.Item> ignored = new HashSet<BasePathSupport.Item>();
        EditableProperties properties = this.helper.getProperties("nbproject/project.properties");
        Iterator<BasePathSupport.Item> itemsIterator = ignorePathSupport.itemsIterator(properties.getProperty("ignore.path"));
        while (itemsIterator.hasNext()) {
            ignored.add(itemsIterator.next());
        }
        return ignored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhpFrameworkProvider> getFrameworks() {
        if (PhpProjectValidator.isFatallyBroken(this)) {
            return Collections.emptyList();
        }
        if (this.frameworksDirty) {
            List<PhpFrameworkProvider> list = this.frameworks;
            synchronized (list) {
                if (this.frameworksDirty) {
                    this.frameworksDirty = false;
                    LinkedList<PhpFrameworkProvider> newFrameworks = new LinkedList<PhpFrameworkProvider>();
                    PhpModule phpModule = this.getPhpModule();
                    for (PhpFrameworkProvider frameworkProvider : PhpFrameworks.getFrameworks()) {
                        if (!frameworkProvider.isInPhpModule(phpModule)) continue;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("Adding framework %s for project %s", frameworkProvider.getIdentifier(), this.getName()));
                        }
                        newFrameworks.add(frameworkProvider);
                    }
                    this.frameworks.clear();
                    this.frameworks.addAll(newFrameworks);
                }
            }
        }
        return new ArrayList<PhpFrameworkProvider>(this.frameworks);
    }

    public boolean hasConfigFiles() {
        PhpModule phpModule = this.getPhpModule();
        for (PhpFrameworkProvider frameworkProvider : this.getFrameworks()) {
            if (frameworkProvider.getConfigurationFiles(phpModule).length <= 0) continue;
            return true;
        }
        return false;
    }

    public void resetFrameworks() {
        List<PhpFrameworkProvider> oldFrameworkProviders = this.getFrameworks();
        this.frameworksDirty = true;
        List<PhpFrameworkProvider> newFrameworkProviders = this.getFrameworks();
        if (!((Object)oldFrameworkProviders).equals(newFrameworkProviders)) {
            this.propertyChangeSupport.firePropertyChange(PROP_FRAMEWORKS, null, null);
            this.fireIgnoredFilesChange();
        }
    }

    public String getName() {
        if (this.name == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Element data = PhpProject.this.getHelper().getPrimaryConfigurationData(true);
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name");
                    if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                        PhpProject.this.name = ((Text)nl.item(0)).getNodeValue();
                    }
                    if (PhpProject.this.name == null) {
                        PhpProject.this.name = "???";
                    }
                    return null;
                }
            });
        }
        assert (this.name != null);
        return this.name;
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Element nameEl;
                Element data = PhpProject.this.getHelper().getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/php-project/1", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/php-project/1", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                PhpProject.this.getHelper().putPrimaryConfigurationData(data, true);
            }
        });
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(this.getClass().getName());
        buffer.append(" [ project directory: ");
        buffer.append(this.getProjectDirectory());
        buffer.append(" ]");
        return buffer.toString();
    }

    public AntProjectHelper getHelper() {
        return this.helper;
    }

    public CopySupport getCopySupport() {
        return (CopySupport)this.getLookup().lookup(CopySupport.class);
    }

    private Lookup createLookup(AuxiliaryConfiguration configuration) {
        PhpProjectEncodingQueryImpl phpProjectEncodingQueryImpl = new PhpProjectEncodingQueryImpl(this.getEvaluator());
        return Lookups.fixed((Object[])new Object[]{this, CopySupport.getInstance(this), new SeleniumProvider(), new PhpCoverageProvider(this), new Info(), configuration, new PhpOpenedHook(), new PhpProjectXmlSavedHook(), new PhpActionProvider(this), new PhpConfigurationProvider(this), new PhpModuleImpl(this), PhpLanguagePropertiesAccessor.getDefault().createForProject(this), new PhpEditorExtender(this), this.helper.createCacheDirectoryProvider(), this.helper.createAuxiliaryProperties(), new ClassPathProviderImpl(this, this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpLogicalViewProvider(this), new CustomizerProviderImpl(this), PhpSharabilityQuery.create(this.helper, this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), new PhpProjectOperations(this), phpProjectEncodingQueryImpl, new TemplateAttributesProviderImpl(this.getHelper(), phpProjectEncodingQueryImpl), new PhpTemplates(), new PhpSources(this, this.getHelper(), this.getEvaluator(), this.getSourceRoots(), this.getTestRoots(), this.getSeleniumRoots()), this.getHelper(), this.getEvaluator(), PhpSearchInfo.create(this), new PhpSubTreeSearchOptions(), InternalWebServer.createForProject(this), ProjectPropertiesProblemProvider.createForProject(this), UILookupMergerSupport.createProjectProblemsProviderMerger(), new ProjectWebRootProviderImpl()});
    }

    public ReferenceHelper getRefHelper() {
        return this.refHelper;
    }

    public void fireIgnoredFilesChange() {
        this.resetIgnoredFolders();
        this.ignoredFoldersChangeSupport.fireChange();
    }

    private final class PhpSubTreeSearchOptions
    extends SubTreeSearchOptions {
        private List<SearchFilterDefinition> filterList = this.createList();

        public List<SearchFilterDefinition> getFilters() {
            return this.filterList;
        }

        private List<SearchFilterDefinition> createList() {
            ArrayList<SearchFilterDefinition> list = new ArrayList<SearchFilterDefinition>(2);
            list.add(PhpProject.this.getSearchFilterDefinition());
            list.add(SearchInfoDefinitionFactory.SHARABILITY_FILTER);
            return Collections.unmodifiableList(list);
        }
    }

    private final class PhpSearchFilterDef
    extends SearchFilterDefinition {
        private PhpSearchFilterDef() {
        }

        public boolean searchFile(FileObject file) {
            if (!file.isData()) {
                throw new IllegalArgumentException("File expected");
            }
            return PhpVisibilityQuery.forProject(PhpProject.this).isVisible(file);
        }

        public SearchFilterDefinition.FolderResult traverseFolder(FileObject folder) {
            if (!folder.isFolder()) {
                throw new IllegalArgumentException("Folder expected");
            }
            if (PhpVisibilityQuery.forProject(PhpProject.this).isVisible(folder)) {
                return SearchFilterDefinition.FolderResult.TRAVERSE;
            }
            return SearchFilterDefinition.FolderResult.DO_NOT_TRAVERSE;
        }
    }

    private static final class PhpSearchInfo
    extends SearchInfoDefinition
    implements PropertyChangeListener {
        private static final Logger LOGGER = Logger.getLogger(PhpSearchInfo.class.getName());
        private final PhpProject project;
        private SearchInfo delegate = null;

        private PhpSearchInfo(PhpProject project) {
            this.project = project;
        }

        public static SearchInfoDefinition create(PhpProject project) {
            PhpSearchInfo phpSearchInfo = new PhpSearchInfo(project);
            project.getSourceRoots().addPropertyChangeListener(phpSearchInfo);
            project.getTestRoots().addPropertyChangeListener(phpSearchInfo);
            project.getSeleniumRoots().addPropertyChangeListener(phpSearchInfo);
            return phpSearchInfo;
        }

        private SearchInfo createDelegate() {
            SearchInfo searchInfo = SearchInfoUtils.createSearchInfoForRoots((FileObject[])this.getRoots(), (boolean)false, (SearchFilterDefinition[])new SearchFilterDefinition[]{this.project.getSearchFilterDefinition(), SearchInfoDefinitionFactory.SHARABILITY_FILTER});
            return searchInfo;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<FileObject> filesToSearch(SearchScopeOptions searchScopeOptions, SearchListener listener, AtomicBoolean terminated) {
            return this.getDelegate().getFilesToSearch(searchScopeOptions, listener, terminated).iterator();
        }

        public List<SearchRoot> getSearchRoots() {
            return this.getDelegate().getSearchRoots();
        }

        private FileObject[] getRoots() {
            LinkedList<FileObject> roots = new LinkedList<FileObject>();
            this.addRoots(roots, this.project.getSourceRoots());
            this.addRoots(roots, this.project.getTestRoots());
            this.addRoots(roots, this.project.getSeleniumRoots());
            this.addIncludePath(roots, PhpSourcePath.getIncludePath(this.project.getSourcesDirectory()));
            return roots.toArray(new FileObject[roots.size()]);
        }

        private void addRoots(List<FileObject> roots, SourceRoots sourceRoots) {
            for (FileObject root : sourceRoots.getRoots()) {
                if (!root.isFolder()) {
                    LOGGER.log(Level.WARNING, "Not folder {0} for source roots {1}", new Object[]{root, Arrays.toString(sourceRoots.getRootNames())});
                    continue;
                }
                roots.add(root);
            }
        }

        private void addIncludePath(List<FileObject> roots, List<FileObject> includePath) {
            for (FileObject folder : includePath) {
                if (!folder.isFolder()) {
                    LOGGER.log(Level.WARNING, "Not folder {0} for Include path {1}", new Object[]{folder, includePath});
                    continue;
                }
                roots.add(folder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
                PhpSearchInfo phpSearchInfo = this;
                synchronized (phpSearchInfo) {
                    this.delegate = this.createDelegate();
                }
            }
        }

        private synchronized SearchInfo getDelegate() {
            if (this.delegate == null) {
                this.delegate = this.createDelegate();
            }
            return this.delegate;
        }
    }

    private final class ProjectWebRootProviderImpl
    implements ProjectWebRootProvider {
        private ProjectWebRootProviderImpl() {
        }

        public FileObject getWebRoot(FileObject file) {
            return ProjectPropertiesSupport.getWebRootDirectory(PhpProject.this);
        }
    }

    private final class PhpAntProjectListener
    implements AntProjectListener {
        private PhpAntProjectListener() {
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            PhpProject.this.name = null;
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }

    private final class FrameworksListener
    implements LookupListener {
        private FrameworksListener() {
        }

        public void resultChanged(LookupEvent ev) {
            LOGGER.fine("frameworks change, frameworks back to null");
            PhpProject.this.resetFrameworks();
        }
    }

    private final class SourceDirectoryFileChangeListener
    implements FileChangeListener {
        private SourceDirectoryFileChangeListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            this.processFileChange();
        }

        public void fileDataCreated(FileEvent fe) {
            this.processFileChange();
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            this.processFileChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.processFileChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        void processFileChange() {
            LOGGER.fine("file change, frameworks back to null");
            PhpProject.this.resetFrameworks();
        }
    }

    private final class ProjectPropertiesListener
    implements PropertyChangeListener {
        private ProjectPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("ignore.path".equals(propertyName)) {
                PhpProject.this.fireIgnoredFilesChange();
            } else if ("web.root".equals(propertyName)) {
                FileObject oldWebRoot = PhpProject.this.webRootDirectory;
                PhpProject.this.webRootDirectory = null;
                PhpProject.this.propertyChangeSupport.firePropertyChange(PhpProject.PROP_WEB_ROOT, oldWebRoot, PhpProject.this.getWebRootDirectory());
            }
        }
    }

    private final class SeleniumProvider
    implements PhpSeleniumProvider {
        private SeleniumProvider() {
        }

        @Override
        public FileObject getTestDirectory(boolean showCustomizer) {
            return ProjectPropertiesSupport.getSeleniumDirectory(PhpProject.this, showCustomizer);
        }

        @Override
        public void runAllTests() {
            ConfigAction.get(ConfigAction.Type.SELENIUM, PhpProject.this).runProject();
        }
    }

    public final class PhpProjectXmlSavedHook
    extends ProjectXmlSavedHook {
        protected void projectXmlSaved() throws IOException {
            Info info = (Info)PhpProject.this.getLookup().lookup(Info.class);
            assert (info != null);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    private static final class ConfigPropertyProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator baseEval;
        private final String prefix;
        private final AntProjectHelper helper;

        public ConfigPropertyProvider(PropertyEvaluator baseEval, String prefix, AntProjectHelper helper) {
            super(ConfigPropertyProvider.computeDelegate(baseEval, prefix, helper));
            this.baseEval = baseEval;
            this.prefix = prefix;
            this.helper = helper;
            baseEval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if ("config".equals(ev.getPropertyName())) {
                this.setDelegate(ConfigPropertyProvider.computeDelegate(this.baseEval, this.prefix, this.helper));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator baseEval, String prefix, AntProjectHelper helper) {
            String config = baseEval.getProperty("config");
            if (config != null) {
                return helper.getPropertyProvider(prefix + "/" + config + ".properties");
            }
            return PropertyUtils.fixedPropertyProvider(Collections.emptyMap());
        }
    }

    private final class PhpOpenedHook
    extends ProjectOpenedHook {
        private PhpOpenedHook() {
        }

        protected void projectOpened() {
            this.reinitFolders();
            PhpProject.this.resetFrameworks();
            LOGGER.log(Level.FINE, "Adding frameworks listener for {0}", PhpProject.this.getName());
            PhpFrameworks.addFrameworksListener((LookupListener)PhpProject.this.frameworksListener);
            List<PhpFrameworkProvider> frameworkProviders = PhpProject.this.getFrameworks();
            PhpProject.this.getName();
            PhpOptions.getInstance().ensurePhpGlobalIncludePath();
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
            ClassPath[] bootClassPaths = cpProvider.getProjectClassPaths("classpath/php-boot");
            GlobalPathRegistry.getDefault().register("classpath/php-boot", bootClassPaths);
            GlobalPathRegistry.getDefault().register("classpath/php-source", cpProvider.getProjectClassPaths("classpath/php-source"));
            for (ClassPath classPath : bootClassPaths) {
                IncludePathClassPathProvider.addProjectIncludePath(classPath);
            }
            PhpCoverageProvider coverageProvider = (PhpCoverageProvider)PhpProject.this.getLookup().lookup(PhpCoverageProvider.class);
            if (coverageProvider.isEnabled()) {
                PhpCoverageProvider.notifyProjectOpened(PhpProject.this);
            }
            PhpModule phpModule = PhpProject.this.getPhpModule();
            assert (phpModule != null);
            for (PhpFrameworkProvider frameworkProvider : frameworkProviders) {
                frameworkProvider.phpModuleOpened(phpModule);
            }
            PhpProject.this.getCopySupport().projectOpened();
            PhpProjectUtils.logUsage(PhpProject.class, "USG_PROJECT_OPEN_PHP", Arrays.asList(PhpProjectUtils.getFrameworksForUsage(frameworkProviders)));
            LOGGER.finest("PROJECT_OPENED_FINISHED");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void projectClosed() {
            try {
                LOGGER.log(Level.FINE, "Removing frameworks listener for {0}", PhpProject.this.getName());
                PhpFrameworks.removeFrameworksListener((LookupListener)PhpProject.this.frameworksListener);
                ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)PhpProject.this.lookup.lookup(ClassPathProviderImpl.class);
                ClassPath[] bootClassPaths = cpProvider.getProjectClassPaths("classpath/php-boot");
                GlobalPathRegistry.getDefault().unregister("classpath/php-boot", bootClassPaths);
                GlobalPathRegistry.getDefault().unregister("classpath/php-source", cpProvider.getProjectClassPaths("classpath/php-source"));
                for (ClassPath classPath : bootClassPaths) {
                    IncludePathClassPathProvider.removeProjectIncludePath(classPath);
                }
                PhpModule phpModule = PhpProject.this.getPhpModule();
                assert (phpModule != null);
                for (PhpFrameworkProvider frameworkProvider : PhpProject.this.getFrameworks()) {
                    frameworkProvider.phpModuleClosed(phpModule);
                }
                ((InternalWebServer)PhpProject.this.lookup.lookup(InternalWebServer.class)).stop();
            }
            finally {
                PhpProject.this.getCopySupport().projectClosed();
                LOGGER.finest("PROJECT_CLOSED_FINISHED");
            }
        }

        private void reinitFolders() {
            PhpProject.this.webRootDirectory = null;
            PhpProject.this.resetIgnoredFolders();
            PhpProject.this.getIgnoredFiles();
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        private Info() {
        }

        public String getDisplayName() {
            return PhpProject.this.getName();
        }

        public Icon getIcon() {
            return ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)PhpProject.PROJECT_ICON));
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this.getDisplayName());
        }

        public Project getProject() {
            return PhpProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        void firePropertyChange(String prop) {
            this.propertyChangeSupport.firePropertyChange(prop, null, null);
        }
    }
}

