/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PhpModuleImpl
extends PhpModule {
    private final PhpProject phpProject;

    public PhpModuleImpl(PhpProject phpProject) {
        assert (phpProject != null);
        this.phpProject = phpProject;
    }

    public PhpProject getPhpProject() {
        return this.phpProject;
    }

    public String getName() {
        return ((ProjectInformation)this.phpProject.getLookup().lookup(ProjectInformation.class)).getName();
    }

    public String getDisplayName() {
        return ((ProjectInformation)this.phpProject.getLookup().lookup(ProjectInformation.class)).getDisplayName();
    }

    public FileObject getProjectDirectory() {
        return ProjectPropertiesSupport.getProjectDirectory(this.phpProject);
    }

    public FileObject getSourceDirectory() {
        return ProjectPropertiesSupport.getSourcesDirectory(this.phpProject);
    }

    public FileObject getTestDirectory() {
        return ProjectPropertiesSupport.getTestDirectory(this.phpProject, false);
    }

    public boolean isBroken() {
        return PhpProjectValidator.isFatallyBroken(this.phpProject);
    }

    public PhpModuleProperties getProperties() {
        PhpModuleProperties properties = new PhpModuleProperties();
        properties = this.setEncoding(properties);
        properties = this.setWebRoot(properties);
        properties = this.setTests(properties);
        properties = this.setUrl(properties);
        properties = this.setIndexFile(properties);
        properties = this.setIncludePath(properties);
        return properties;
    }

    private PhpModuleProperties setEncoding(PhpModuleProperties properties) {
        return properties.setEncoding(ProjectPropertiesSupport.getEncoding(this.phpProject));
    }

    private PhpModuleProperties setWebRoot(PhpModuleProperties properties) {
        return properties.setWebRoot(ProjectPropertiesSupport.getWebRootDirectory(this.phpProject));
    }

    private PhpModuleProperties setTests(PhpModuleProperties properties) {
        FileObject tests = ProjectPropertiesSupport.getTestDirectory(this.phpProject, false);
        if (tests != null) {
            properties = properties.setTests(tests);
        }
        return properties;
    }

    private PhpModuleProperties setUrl(PhpModuleProperties properties) {
        String url = ProjectPropertiesSupport.getUrl(this.phpProject);
        if (url != null) {
            properties = properties.setUrl(url);
        }
        return properties;
    }

    private PhpModuleProperties setIndexFile(PhpModuleProperties properties) {
        FileObject index;
        String indexFile = ProjectPropertiesSupport.getIndexFile(this.phpProject);
        FileObject sourceDirectory = this.getSourceDirectory();
        if (indexFile != null && sourceDirectory != null && (index = sourceDirectory.getFileObject(indexFile)) != null && index.isData() && index.isValid()) {
            properties = properties.setIndexFile(index);
        }
        return properties;
    }

    private PhpModuleProperties setIncludePath(PhpModuleProperties properties) {
        String includePath = ProjectPropertiesSupport.getPropertyEvaluator(this.phpProject).getProperty("include.path");
        List<Object> paths = includePath == null ? Collections.emptyList() : Arrays.asList(PropertyUtils.tokenizePath((String)includePath));
        properties = properties.setIncludePath(paths);
        return properties;
    }

    public String toString() {
        return this.getDisplayName() + " (" + FileUtil.getFileDisplayName((FileObject)this.getSourceDirectory()) + ")";
    }

    public Preferences getPreferences(Class<?> clazz, boolean shared) {
        return ProjectUtils.getPreferences((Project)this.phpProject, clazz, (boolean)shared);
    }

    public void propertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if ("PROPERTY_FRAMEWORKS".equals(propertyChangeEvent.getPropertyName())) {
            this.phpProject.resetFrameworks();
        }
    }
}

