/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.actions.CopyCommand;
import org.netbeans.modules.php.project.ui.actions.DebugFileCommand;
import org.netbeans.modules.php.project.ui.actions.DebugProjectCommand;
import org.netbeans.modules.php.project.ui.actions.DeleteCommand;
import org.netbeans.modules.php.project.ui.actions.DownloadCommand;
import org.netbeans.modules.php.project.ui.actions.MoveCommand;
import org.netbeans.modules.php.project.ui.actions.RenameCommand;
import org.netbeans.modules.php.project.ui.actions.RunFileCommand;
import org.netbeans.modules.php.project.ui.actions.RunProjectCommand;
import org.netbeans.modules.php.project.ui.actions.RunTestCommand;
import org.netbeans.modules.php.project.ui.actions.RunTestsCommand;
import org.netbeans.modules.php.project.ui.actions.SyncCommand;
import org.netbeans.modules.php.project.ui.actions.TestProjectCommand;
import org.netbeans.modules.php.project.ui.actions.UploadCommand;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.LifecycleManager;
import org.openide.util.Lookup;

public class PhpActionProvider
implements ActionProvider {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();

    PhpActionProvider(PhpProject project) {
        Command[] commandArray;
        for (Command command : commandArray = new Command[]{new RunProjectCommand(project), new DebugProjectCommand(project), new TestProjectCommand(project), new RunFileCommand(project), new DebugFileCommand(project), new RunTestCommand(project), new RunTestsCommand(project), new DeleteCommand(project), new CopyCommand(project), new MoveCommand(project), new RenameCommand(project), new DownloadCommand(project), new UploadCommand(project), new SyncCommand(project)}) {
            this.commands.put(command.getCommandId(), command);
        }
    }

    public String[] getSupportedActions() {
        Set<String> commandIds = this.commands.keySet();
        return commandIds.toArray(new String[commandIds.size()]);
    }

    public void invokeAction(String commandId, final Lookup lookup) {
        final Command command = this.getCommand(commandId);
        if (!command.getProject().getCopySupport().waitFinished()) {
            return;
        }
        if (command.saveRequired()) {
            LifecycleManager.getDefault().saveAll();
        }
        if (!command.asyncCallRequired()) {
            command.invokeAction(lookup);
        } else {
            PhpActionProvider.submitTask(new Runnable(){

                @Override
                public void run() {
                    command.invokeAction(lookup);
                }
            });
        }
    }

    public static void submitTask(Runnable runnable) {
        assert (runnable != null);
        EXECUTOR.submit(runnable);
    }

    public boolean isActionEnabled(String commandId, Lookup lookup) {
        return this.getCommand(commandId).isActionEnabled(lookup);
    }

    public Command getCommand(String commandId) {
        Command retval = this.commands.get(commandId);
        assert (retval != null) : commandId;
        return retval;
    }

    public Action getAction(String commandId) {
        Command command = this.getCommand(commandId);
        assert (command != null) : commandId;
        assert (command instanceof Displayable);
        if (command.isFileSensitive()) {
            return FileSensitiveActions.fileCommandAction((String)command.getCommandId(), (String)((Displayable)((Object)command)).getDisplayName(), null);
        }
        return ProjectSensitiveActions.projectCommandAction((String)command.getCommandId(), (String)((Displayable)((Object)command)).getDisplayName(), null);
    }
}

