/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.network;

import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.LiveHTML;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;

public class Network {
    private TransportHelper transport;
    private boolean enabled;
    private Callback callback;
    private WebKitDebugging webKit;
    private int numberOfClients = 0;
    private boolean inLiveHTMLMode = false;

    public Network(TransportHelper transport, WebKitDebugging webKit) {
        this.transport = transport;
        this.callback = new Callback();
        this.transport.addListener(this.callback);
        this.webKit = webKit;
    }

    public void enable() {
        ++this.numberOfClients;
        if (!this.enabled) {
            this.enabled = true;
            this.transport.sendBlockingCommand(new Command("Network.enable"));
        }
        this.inLiveHTMLMode = this.webKit.getDebugger().isInLiveHTMLMode();
    }

    public void disable() {
        assert (this.numberOfClients > 0);
        --this.numberOfClients;
        if (this.numberOfClients == 0) {
            this.transport.sendCommand(new Command("Network.disable"));
            this.enabled = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private String getReponseBody(String requestId) {
        JSONObject params = new JSONObject();
        params.put((Object)"requestId", (Object)requestId);
        Response res = this.transport.sendBlockingCommand(new Command("Network.getResponseBody", params));
        String data = (String)res.getResult().get((Object)"body");
        return data;
    }

    private void recordDataEvent(long timeStamp, String id, String request, String mime) {
        assert (this.inLiveHTMLMode);
        String response = this.getReponseBody(id);
        LiveHTML.getDefault().storeDataEvent(this.transport.getConnectionURL(), timeStamp, response, request, mime);
    }

    private class Callback
    implements ResponseCallback {
        private Callback() {
        }

        @Override
        public void handleResponse(Response response) {
            if ("Network.responseReceived".equals(response.getMethod()) && Network.this.inLiveHTMLMode && "XHR".equals(response.getParams().get((Object)"type"))) {
                final long timeStamp = System.currentTimeMillis();
                final String id = (String)response.getParams().get((Object)"requestId");
                final String request = (String)((JSONObject)response.getParams().get((Object)"response")).get((Object)"url");
                final String mime = (String)((JSONObject)response.getParams().get((Object)"response")).get((Object)"mimeType");
                Network.this.transport.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        Network.this.recordDataEvent(timeStamp, id, request, mime);
                    }
                });
            }
        }
    }
}

