/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.debugger;

import java.util.Collections;
import java.util.List;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.AbstractObject;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.debugger.PropertyDescriptor;

public class RemoteObject
extends AbstractObject {
    private static final String PROP_TYPE = "type";
    private static final String PROP_VALUE = "value";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_CLASS_NAME = "className";
    private static final String PROP_OBJECT_ID = "objectId";
    private JSONObject property;
    private List<PropertyDescriptor> properties;

    public RemoteObject(JSONObject remoteObject, WebKitDebugging webkit) {
        this(remoteObject, webkit, null);
    }

    RemoteObject(JSONObject remoteObject, WebKitDebugging webkit, JSONObject property) {
        super(remoteObject, webkit);
        this.property = property;
    }

    public Type getType() {
        String t = (String)this.getObject().get((Object)PROP_TYPE);
        if ("object".equals(t)) {
            return Type.OBJECT;
        }
        if ("function".equals(t)) {
            return Type.FUNCTION;
        }
        if ("undefined".equals(t)) {
            return Type.UNDEFINED;
        }
        if ("string".equals(t)) {
            return Type.STRING;
        }
        if ("number".equals(t)) {
            return Type.NUMBER;
        }
        if ("boolean".equals(t)) {
            return Type.BOOLEAN;
        }
        assert (false) : "what type is this?? '" + t + "'";
        return Type.OBJECT;
    }

    public JSONObject getOwningProperty() {
        return this.property;
    }

    public String getClassName() {
        return (String)this.getObject().get((Object)PROP_CLASS_NAME);
    }

    public String getDescription() {
        return (String)this.getObject().get((Object)PROP_DESCRIPTION);
    }

    public boolean isMutable() {
        return this.getType() == Type.STRING || this.getType() == Type.NUMBER || this.getType() == Type.BOOLEAN;
    }

    private Object getValue() {
        return this.getObject().get((Object)PROP_VALUE);
    }

    public String getValueAsString() {
        switch (this.getType()) {
            case STRING: {
                return (String)this.getValue();
            }
            case NUMBER: {
                Number n = (Number)this.getValue();
                if (n == null) {
                    return "";
                }
                return n.toString();
            }
            case BOOLEAN: {
                Boolean b = (Boolean)this.getValue();
                if (b == null) {
                    return "";
                }
                return b.toString();
            }
        }
        return "";
    }

    public String getObjectID() {
        String remoteObjectId = (String)this.getObject().get((Object)PROP_OBJECT_ID);
        if (remoteObjectId == null) {
            return null;
        }
        if (remoteObjectId.trim().length() == 0) {
            return null;
        }
        return remoteObjectId;
    }

    public boolean hasFetchedProperties() {
        assert (this.getType() == Type.OBJECT);
        return this.properties != null || this.getObjectID() == null;
    }

    public List<PropertyDescriptor> getProperties() {
        assert (this.getType() == Type.OBJECT);
        if (this.properties != null) {
            return this.properties;
        }
        String remoteObjectId = this.getObjectID();
        if (remoteObjectId == null) {
            return Collections.emptyList();
        }
        this.properties = this.getWebkit().getRuntime().getRemoteObjectProperties(this, true);
        return this.properties;
    }

    public void release() {
        this.getWebkit().getRuntime().releaseObject(this);
    }

    public static enum Type {
        OBJECT(Bundle.TYPE_OBJECT()),
        FUNCTION(Bundle.TYPE_FUNCTION()),
        UNDEFINED(Bundle.TYPE_UNDEFINED()),
        STRING(Bundle.TYPE_STRING()),
        NUMBER(Bundle.TYPE_NUMBER()),
        BOOLEAN(Bundle.TYPE_BOOLEAN());

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

