/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.console;

import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class ConsoleMessage {
    private final JSONObject msg;
    private List<StackFrame> stackTrace;
    private boolean stackTraceLoaded;

    ConsoleMessage(JSONObject msg) {
        this.msg = msg;
    }

    public String getSource() {
        return (String)this.msg.get((Object)"source");
    }

    public String getLevel() {
        return (String)this.msg.get((Object)"level");
    }

    public String getType() {
        return (String)this.msg.get((Object)"type");
    }

    public String getText() {
        return (String)this.msg.get((Object)"text");
    }

    public String getURLString() {
        return (String)this.msg.get((Object)"url");
    }

    public int getLine() {
        Number n = (Number)this.msg.get((Object)"line");
        if (n != null) {
            return n.intValue();
        }
        return -1;
    }

    public List<StackFrame> getStackTrace() {
        if (!this.stackTraceLoaded) {
            JSONArray stack = (JSONArray)this.msg.get((Object)"stackTrace");
            if (stack != null && stack.size() > 0) {
                this.stackTrace = new ArrayList<StackFrame>();
                for (Object o : stack) {
                    JSONObject json = (JSONObject)o;
                    this.stackTrace.add(new StackFrame(json));
                }
            }
            this.stackTraceLoaded = true;
        }
        return this.stackTrace;
    }

    public static final class StackFrame {
        private JSONObject stack;

        StackFrame(JSONObject stack) {
            this.stack = stack;
        }

        public String getFunctionName() {
            return (String)this.stack.get((Object)"functionName");
        }

        public String getURLString() {
            return (String)this.stack.get((Object)"url");
        }

        public int getLine() {
            Number n = (Number)this.stack.get((Object)"lineNumber");
            if (n != null) {
                return n.intValue();
            }
            return -1;
        }

        public int getColumn() {
            Number n = (Number)this.stack.get((Object)"columnNumber");
            if (n != null) {
                return n.intValue();
            }
            return -1;
        }
    }
}

