/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api;

import org.netbeans.modules.web.webkit.debugging.APIFactory;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.Runtime;
import org.netbeans.modules.web.webkit.debugging.api.console.Console;
import org.netbeans.modules.web.webkit.debugging.api.css.CSS;
import org.netbeans.modules.web.webkit.debugging.api.dom.DOM;
import org.netbeans.modules.web.webkit.debugging.api.network.Network;
import org.netbeans.modules.web.webkit.debugging.api.page.Page;

public class WebKitDebugging {
    private TransportHelper transport;
    private Debugger debugger;
    private Runtime runtime;
    private DOM dom;
    private CSS css;
    private Page page;
    private Network network;
    private Console console;

    private WebKitDebugging(TransportHelper transport) {
        this.transport = transport;
    }

    public String getConnectionName() {
        return this.transport.getConnectionName();
    }

    public synchronized Debugger getDebugger() {
        if (this.debugger == null) {
            this.debugger = new Debugger(this.transport, this);
        }
        return this.debugger;
    }

    public synchronized Runtime getRuntime() {
        if (this.runtime == null) {
            this.runtime = new Runtime(this.transport, this);
        }
        return this.runtime;
    }

    public synchronized DOM getDOM() {
        if (this.dom == null) {
            this.dom = new DOM(this.transport, this);
        }
        return this.dom;
    }

    public synchronized CSS getCSS() {
        if (this.css == null) {
            this.css = new CSS(this.transport);
        }
        return this.css;
    }

    public synchronized Page getPage() {
        if (this.page == null) {
            this.page = new Page(this.transport, this);
        }
        return this.page;
    }

    public synchronized Network getNetwork() {
        if (this.network == null) {
            this.network = new Network(this.transport, this);
        }
        return this.network;
    }

    public synchronized Console getConsole() {
        if (this.console == null) {
            this.console = new Console(this.transport, this);
        }
        return this.console;
    }

    public synchronized void reset() {
        if (this.dom != null) {
            this.dom.reset();
        }
        if (this.console != null) {
            this.console.reset();
        }
    }

    static {
        APIFactory.Accessor.DEFAULT = new APIFactory.Accessor(){

            @Override
            public WebKitDebugging createWebKitDebugging(TransportHelper transport) {
                return new WebKitDebugging(transport);
            }
        };
    }
}

