/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.APIFactory;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.PropertyDescriptor;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;

public class Runtime {
    private TransportHelper transport;
    private WebKitDebugging webkit;
    private static final Logger LOG = Logger.getLogger(Runtime.class.getCanonicalName());

    Runtime(TransportHelper transport, WebKitDebugging webkit) {
        this.transport = transport;
        this.webkit = webkit;
    }

    public List<PropertyDescriptor> getRemoteObjectProperties(RemoteObject remoteObject, boolean ownProperties) {
        ArrayList<PropertyDescriptor> res = new ArrayList<PropertyDescriptor>();
        JSONObject params = new JSONObject();
        params.put((Object)"ownProperties", (Object)ownProperties);
        params.put((Object)"objectId", (Object)remoteObject.getObjectID());
        Response properties = this.transport.sendBlockingCommand(new Command("Runtime.getProperties", params));
        if (properties == null) {
            LOG.log(Level.WARNING, "no response from command: Runtime.getProperties " + params.toJSONString() + ", remote object was: " + remoteObject.toString() + " and owning property :" + remoteObject.getOwningProperty());
            return Collections.emptyList();
        }
        if (properties.getException() != null) {
            LOG.log(Level.WARNING, "transport exception from command: Runtime.getProperties " + params.toJSONString() + ", remote object was: " + remoteObject.toString() + " and owning property :" + remoteObject.getOwningProperty());
            return Collections.emptyList();
        }
        JSONObject response = properties.getResponse();
        JSONObject result = (JSONObject)response.get((Object)"result");
        if (result == null) {
            LOG.log(Level.WARNING, "no result in response: " + response.toJSONString() + ". the command was: " + "Runtime.getProperties " + params.toJSONString() + " and remote object was: " + remoteObject.toString() + " and owning property :" + remoteObject.getOwningProperty());
            return Collections.emptyList();
        }
        JSONArray array = (JSONArray)result.get((Object)"result");
        for (Object o : array) {
            res.add(APIFactory.createPropertyDescriptor((JSONObject)o, this.webkit));
        }
        return res;
    }

    public RemoteObject evaluate(String expression) {
        JSONObject result;
        RemoteObject remoteObject = null;
        JSONObject params = new JSONObject();
        params.put((Object)"expression", (Object)expression);
        Response response = this.transport.sendBlockingCommand(new Command("Runtime.evaluate", params));
        if (response != null && (result = response.getResult()) != null) {
            JSONObject expressionResult = (JSONObject)result.get((Object)"result");
            remoteObject = new RemoteObject(expressionResult, this.webkit);
        }
        return remoteObject;
    }

    public RemoteObject callFunctionOn(RemoteObject object, String functionDeclaration) {
        JSONObject result;
        RemoteObject remoteObject = null;
        JSONObject params = new JSONObject();
        params.put((Object)"objectId", (Object)object.getObjectID());
        params.put((Object)"functionDeclaration", (Object)functionDeclaration);
        Response response = this.transport.sendBlockingCommand(new Command("Runtime.callFunctionOn", params));
        if (response != null && (result = response.getResult()) != null) {
            JSONObject expressionResult = (JSONObject)result.get((Object)"result");
            remoteObject = new RemoteObject(expressionResult, this.webkit);
        }
        return remoteObject;
    }

    public void releaseObject(RemoteObject object) {
        String objectId = object.getObjectID();
        if (objectId != null) {
            JSONObject params = new JSONObject();
            params.put((Object)"objectId", (Object)objectId);
            this.transport.sendCommand(new Command("Runtime.releaseObject", params));
        }
    }

    void releaseNetBeansObjectGroup() {
        JSONObject params = new JSONObject();
        params.put((Object)"objectGroup", (Object)"netbeans-debugger-objects");
        this.transport.sendCommand(new Command("Runtime.releaseObjectGroup", params));
    }
}

