/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.APIFactory;
import org.netbeans.modules.web.webkit.debugging.LiveHTML;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Breakpoint;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.Script;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;
import org.openide.util.RequestProcessor;

public final class Debugger {
    public static final String PROP_CURRENT_FRAME = "currentFrame";
    public static final String PROP_BREAKPOINTS_ACTIVE = "breakpointsActive";
    private static final String COMMAND_ENABLE = "Debugger.enable";
    private static final String COMMAND_DISABLE = "Debugger.disable";
    private static final String COMMAND_STEP_OVER = "Debugger.stepOver";
    private static final String COMMAND_STEP_INTO = "Debugger.stepInto";
    private static final String COMMAND_STEP_OUT = "Debugger.stepOut";
    private static final String COMMAND_PAUSE = "Debugger.pause";
    private static final String COMMAND_RESUME = "Debugger.resume";
    private static final String COMMAND_SET_BRKP_BY_URL = "Debugger.setBreakpointByUrl";
    private static final String COMMAND_SET_BRKP_DOM = "DOMDebugger.setDOMBreakpoint";
    private static final String COMMAND_SET_BRKP_XHR = "DOMDebugger.setXHRBreakpoint";
    private static final String COMMAND_SET_BRKP_EVENT = "DOMDebugger.setEventListenerBreakpoint";
    private static final String COMMAND_REMOVE_BRKP = "Debugger.removeBreakpoint";
    private static final String COMMAND_REMOVE_BRKP_DOM = "DOMDebugger.removeDOMBreakpoint";
    private static final String COMMAND_REMOVE_BRKP_XHR = "DOMDebugger.removeXHRBreakpoint";
    private static final String COMMAND_REMOVE_BRKP_EVENT = "DOMDebugger.removeEventListenerBreakpoint";
    private static final String COMMAND_SET_BRKPS_ACTIVE = "Debugger.setBreakpointsActive";
    private static final String RESPONSE_BRKP_RESOLVED = "Debugger.breakpointResolved";
    private static final String RESPONSE_GLOB_OBJECT_CLEARED = "Debugger.globalObjectCleared";
    private static final String RESPONSE_PAUSED = "Debugger.paused";
    private static final String RESPONSE_RESUMED = "Debugger.resumed";
    private static final String RESPONSE_SCRIPT_PARSED = "Debugger.scriptParsed";
    private static final Logger LOG = Logger.getLogger(Debugger.class.getName());
    private static boolean lastBreakpointsActive = true;
    private TransportHelper transport;
    private boolean enabled = false;
    private boolean suspended = false;
    private Callback callback;
    private boolean initDOMLister = true;
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private PropertyChangeSupport pchs = new PropertyChangeSupport(this);
    private Map<String, Script> scripts = new HashMap<String, Script>();
    private WebKitDebugging webkit;
    private List<CallFrame> currentCallStack = new ArrayList<CallFrame>();
    private CallFrame currentCallFrame = null;
    private boolean breakpointsActive = lastBreakpointsActive;
    private final Object breakpointsActiveLock = new Object();
    private final Map<String, Breakpoint> breakpointsById = Collections.synchronizedMap(new HashMap());
    private boolean inLiveHTMLMode = false;
    private RequestProcessor.Task latestSnapshotTask;
    public static final String DOM_BREAKPOINT_SUBTREE = "subtree-modified";
    public static final String DOM_BREAKPOINT_ATTRIBUTE = "attribute-modified";
    public static final String DOM_BREAKPOINT_NODE = "node-removed";

    Debugger(TransportHelper transport, WebKitDebugging webkit) {
        this.transport = transport;
        this.webkit = webkit;
        this.callback = new Callback();
        this.transport.addListener(this.callback);
    }

    public boolean enable() {
        this.transport.sendBlockingCommand(new Command(COMMAND_ENABLE));
        this.webkit.getPage().enable();
        this.webkit.getNetwork().enable();
        this.webkit.getConsole().enable();
        this.webkit.getCSS().enable();
        this.enabled = true;
        return true;
    }

    public void enableDebuggerInLiveHTMLMode() {
        this.inLiveHTMLMode = true;
        this.enable();
        this.latestSnapshotTask = this.transport.getRequestProcessor().create(new Runnable(){

            @Override
            public void run() {
                Debugger.this.recordDocumentChange(System.currentTimeMillis(), null, false, false);
            }
        });
        this.initDOMLister = true;
        this.addEventBreakpoint("DOMContentLoaded");
        this.addEventBreakpoint("load");
    }

    public boolean isInLiveHTMLMode() {
        return this.inLiveHTMLMode;
    }

    public void disable() {
        assert (this.enabled);
        this.webkit.getPage().disable();
        this.webkit.getNetwork().disable();
        this.webkit.getConsole().disable();
        this.webkit.getCSS().disable();
        this.transport.sendCommand(new Command(COMMAND_DISABLE));
        this.enabled = false;
        this.suspended = false;
        this.currentCallStack.clear();
        this.currentCallFrame = null;
        this.initDOMLister = true;
    }

    public void stepOver() {
        this.doCommand(COMMAND_STEP_OVER);
    }

    public void stepInto() {
        this.doCommand(COMMAND_STEP_INTO);
    }

    public void stepOut() {
        this.doCommand(COMMAND_STEP_OUT);
    }

    public void resume() {
        this.doCommand(COMMAND_RESUME);
    }

    public void pause() {
        this.doCommand(COMMAND_PAUSE);
    }

    private void doCommand(String name) {
        this.transport.sendCommand(new Command(name));
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pchs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pchs.removePropertyChangeListener(l);
    }

    private void notifyResumed() {
        this.suspended = false;
        this.setCurrentCallFrame(null);
        for (Listener l : this.listeners) {
            l.resumed();
        }
    }

    public URL getConnectionURL() {
        return this.transport.getConnectionURL();
    }

    private List<CallFrame> createCallStack(JSONArray callFrames) {
        ArrayList<CallFrame> callStack = new ArrayList<CallFrame>();
        for (Object cf : callFrames) {
            callStack.add(APIFactory.createCallFrame((JSONObject)cf, this.webkit, this.transport));
        }
        return callStack;
    }

    private void notifyPaused(JSONArray callFrames, String reason, JSONObject data) {
        this.suspended = true;
        List<CallFrame> callStack = this.createCallStack(callFrames);
        this.setCurrentCallStack(callStack);
        if (!callStack.isEmpty()) {
            this.setCurrentCallFrame(callStack.get(0));
        } else {
            this.setCurrentCallFrame(null);
        }
        for (Listener l : this.listeners) {
            l.paused(callStack, reason);
        }
    }

    private void notifyReset() {
        for (Listener l : this.listeners) {
            l.reset();
        }
    }

    private JSONArray normalizeStackTrace(JSONArray callStack) {
        JSONArray res = new JSONArray();
        for (Object o : callStack) {
            JSONObject cf = (JSONObject)o;
            JSONObject ncf = new JSONObject();
            ncf.put((Object)"lineNumber", ((JSONObject)cf.get((Object)"location")).get((Object)"lineNumber"));
            ncf.put((Object)"columnNumber", ((JSONObject)cf.get((Object)"location")).get((Object)"columnNumber"));
            ncf.put((Object)"function", cf.get((Object)"functionName"));
            Script sc = this.getScript((String)((JSONObject)cf.get((Object)"location")).get((Object)"scriptId"));
            if (sc == null) continue;
            ncf.put((Object)"script", (Object)sc.getURL());
            res.add((Object)ncf);
        }
        return res;
    }

    private synchronized void addScript(JSONObject data) {
        Script script = APIFactory.createScript(data, this.webkit);
        this.scripts.put(script.getID(), script);
    }

    public synchronized Script getScript(String scriptID) {
        return this.scripts.get(scriptID);
    }

    public synchronized List<CallFrame> getCurrentCallStack() {
        assert (this.isSuspended());
        return this.currentCallStack;
    }

    private synchronized void setCurrentCallStack(List<CallFrame> callstack) {
        this.currentCallStack = callstack;
    }

    public synchronized CallFrame getCurrentCallFrame() {
        return this.currentCallFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentCallFrame(CallFrame frame) {
        CallFrame lastFrame;
        Debugger debugger = this;
        synchronized (debugger) {
            if (frame != null) {
                assert (this.isSuspended());
                if (!this.currentCallStack.contains(frame)) {
                    throw new IllegalArgumentException("Unknown frame: " + frame);
                }
            }
            lastFrame = this.currentCallFrame;
            this.currentCallFrame = frame;
        }
        this.pchs.firePropertyChange(PROP_CURRENT_FRAME, lastFrame, frame);
    }

    public Breakpoint addLineBreakpoint(String url, int lineNumber, int columnNumber) {
        if (this.inLiveHTMLMode) {
            return null;
        }
        JSONObject params = new JSONObject();
        params.put((Object)"lineNumber", (Object)lineNumber);
        params.put((Object)"url", (Object)url.replaceAll("/", "\\/"));
        params.put((Object)"columnNumber", (Object)columnNumber);
        Response resp = this.transport.sendBlockingCommand(new Command(COMMAND_SET_BRKP_BY_URL, params));
        if (resp != null) {
            if (resp.getException() != null) {
                return null;
            }
            JSONObject result = (JSONObject)resp.getResponse().get((Object)"result");
            if (result != null) {
                Breakpoint b = APIFactory.createBreakpoint(result, this.webkit);
                this.breakpointsById.put(b.getBreakpointID(), b);
                return b;
            }
            LOG.log(Level.WARNING, "No result in setBreakpointByUrl response: {0}", resp);
        }
        return null;
    }

    public void removeLineBreakpoint(Breakpoint b) {
        JSONObject params = new JSONObject();
        String id = b.getBreakpointID();
        params.put((Object)"breakpointId", (Object)id);
        this.transport.sendBlockingCommand(new Command(COMMAND_REMOVE_BRKP, params));
        this.breakpointsById.remove(id);
    }

    public Breakpoint addDOMBreakpoint(Node node, String type) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"type", (Object)type);
        Response resp = this.transport.sendBlockingCommand(new Command(COMMAND_SET_BRKP_DOM, params));
        if (resp != null) {
            if (resp.getException() != null) {
                return null;
            }
            JSONObject result = (JSONObject)resp.getResponse().get((Object)"result");
            if (result != null) {
                Breakpoint b = APIFactory.createBreakpoint(result, this.webkit);
                return b;
            }
            LOG.log(Level.WARNING, "No result in setDOMBreakpoint response: {0}", resp);
        }
        return null;
    }

    public void removeDOMBreakpoint(Node node, String type) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        params.put((Object)"type", (Object)type);
        this.transport.sendBlockingCommand(new Command(COMMAND_REMOVE_BRKP_DOM, params));
    }

    public Breakpoint addXHRBreakpoint(String urlSubstring) {
        JSONObject params = new JSONObject();
        params.put((Object)"url", (Object)urlSubstring);
        Response resp = this.transport.sendBlockingCommand(new Command(COMMAND_SET_BRKP_XHR, params));
        if (resp != null) {
            if (resp.getException() != null) {
                return null;
            }
            JSONObject result = (JSONObject)resp.getResponse().get((Object)"result");
            if (result != null) {
                Breakpoint b = APIFactory.createBreakpoint(result, this.webkit);
                return b;
            }
            LOG.log(Level.WARNING, "No result in setXHRBreakpoint response: {0}", resp);
        }
        return null;
    }

    public void removeXHRBreakpoint(String urlSubstring) {
        JSONObject params = new JSONObject();
        params.put((Object)"url", (Object)urlSubstring);
        this.transport.sendBlockingCommand(new Command(COMMAND_REMOVE_BRKP_XHR, params));
    }

    public Breakpoint addEventBreakpoint(String event) {
        JSONObject params = new JSONObject();
        params.put((Object)"eventName", (Object)event);
        Response resp = this.transport.sendBlockingCommand(new Command(COMMAND_SET_BRKP_EVENT, params));
        if (resp != null) {
            if (resp.getException() != null) {
                return null;
            }
            JSONObject result = (JSONObject)resp.getResponse().get((Object)"result");
            if (result != null) {
                Breakpoint b = APIFactory.createBreakpoint(result, this.webkit);
                return b;
            }
            LOG.log(Level.WARNING, "No result in setEventListenerBreakpoint response: {0}", resp);
        }
        return null;
    }

    public void removeEventBreakpoint(String event) {
        JSONObject params = new JSONObject();
        params.put((Object)"eventName", (Object)event);
        this.transport.sendBlockingCommand(new Command(COMMAND_REMOVE_BRKP_EVENT, params));
    }

    public boolean areBreakpointsActive() {
        return this.breakpointsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreakpointsActive(boolean active) {
        boolean oldActive;
        Object object = this.breakpointsActiveLock;
        synchronized (object) {
            oldActive = this.breakpointsActive;
            if (oldActive != active) {
                JSONObject params = new JSONObject();
                params.put((Object)"active", (Object)active);
                this.transport.sendBlockingCommand(new Command(COMMAND_SET_BRKPS_ACTIVE, params));
                this.breakpointsActive = active;
                lastBreakpointsActive = active;
            }
        }
        if (oldActive != active) {
            this.pchs.firePropertyChange(PROP_BREAKPOINTS_ACTIVE, oldActive, active);
        }
    }

    private void recordDocumentChange(long timeStamp, JSONArray callStack, boolean attachDOMListeners, boolean realChange) {
        JSONArray callStack2;
        assert (this.inLiveHTMLMode);
        Node n = this.webkit.getDOM().getDocument();
        if (attachDOMListeners) {
            this.addDOMBreakpoint(n, DOM_BREAKPOINT_SUBTREE);
            this.removeEventBreakpoint("DOMContentLoaded");
            this.removeEventBreakpoint("load");
        }
        String content = this.webkit.getDOM().getOuterHTML(n);
        JSONArray jSONArray = callStack2 = callStack != null ? this.normalizeStackTrace(callStack) : null;
        if (realChange) {
            LiveHTML.getDefault().storeDocumentVersionBeforeChange(this.transport.getConnectionURL(), timeStamp, content, callStack2 != null ? callStack2.toJSONString() : null);
            this.resume();
            this.latestSnapshotTask.schedule(345);
        } else {
            LiveHTML.getDefault().storeDocumentVersionAfterChange(this.transport.getConnectionURL(), timeStamp, content);
        }
    }

    public static interface Listener
    extends EventListener {
        public void paused(List<CallFrame> var1, String var2);

        public void resumed();

        public void reset();
    }

    private class Callback
    implements ResponseCallback {
        private Callback() {
        }

        @Override
        public void handleResponse(Response response) {
            String method = response.getMethod();
            if (Debugger.RESPONSE_RESUMED.equals(method)) {
                Debugger.this.notifyResumed();
                Debugger.this.webkit.getRuntime().releaseNetBeansObjectGroup();
            } else if (Debugger.RESPONSE_PAUSED.equals(method)) {
                JSONObject params = response.getParams();
                if (Debugger.this.inLiveHTMLMode) {
                    final long timestamp = System.currentTimeMillis();
                    JSONObject data = (JSONObject)params.get((Object)"data");
                    boolean internalSuspend = false;
                    boolean attachDOMListeners = false;
                    if ("DOM".equals(params.get((Object)"reason"))) {
                        internalSuspend = true;
                    }
                    if ("EventListener".equals(params.get((Object)"reason")) && data != null && ("listener:DOMContentLoaded".equals(data.get((Object)"eventName")) || "listener:load".equals(data.get((Object)"eventName")))) {
                        internalSuspend = true;
                        if (Debugger.this.initDOMLister) {
                            attachDOMListeners = true;
                        }
                        Debugger.this.initDOMLister = false;
                    }
                    if (internalSuspend) {
                        final JSONArray callStack = (JSONArray)params.get((Object)"callFrames");
                        final boolean finalAttachDOMListeners = attachDOMListeners;
                        Debugger.this.transport.getRequestProcessor().post(new Runnable(){

                            @Override
                            public void run() {
                                Debugger.this.recordDocumentChange(timestamp, callStack, finalAttachDOMListeners, true);
                            }
                        });
                    }
                } else {
                    JSONArray frames = (JSONArray)params.get((Object)"callFrames");
                    if (frames == null) {
                        frames = (JSONArray)((JSONObject)params.get((Object)"details")).get((Object)"callFrames");
                    }
                    Debugger.this.notifyPaused(frames, (String)params.get((Object)"reason"), (JSONObject)params.get((Object)"data"));
                }
            } else if (Debugger.RESPONSE_GLOB_OBJECT_CLEARED.equals(method)) {
                Debugger.this.notifyReset();
            } else if (Debugger.RESPONSE_SCRIPT_PARSED.equals(method)) {
                Debugger.this.addScript(response.getParams());
            } else if (Debugger.RESPONSE_BRKP_RESOLVED.equals(method)) {
                JSONObject params = response.getParams();
                Object id = params.get((Object)"breakpointId");
                Breakpoint bp = (Breakpoint)Debugger.this.breakpointsById.get(id);
                if (bp != null) {
                    APIFactory.breakpointResolved(bp, (JSONObject)params.get((Object)"location"));
                }
            }
        }
    }
}

