/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.refactoring.spi.impl.UndoableWrapper;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

abstract class BackupFacility2 {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.refactoring.Undo");
    private static BackupFacility2 defaultInstance;

    private BackupFacility2() {
    }

    public abstract Handle backup(FileObject ... var1) throws IOException;

    public abstract Handle backup(File ... var1) throws IOException;

    public final Handle backup(Collection<? extends FileObject> fileObjects) throws IOException {
        return this.backup(fileObjects.toArray(new FileObject[fileObjects.size()]));
    }

    public abstract void clear();

    public static BackupFacility2 getDefault() {
        BackupFacility2 instance = (BackupFacility2)Lookup.getDefault().lookup(BackupFacility2.class);
        return instance != null ? instance : BackupFacility2.getDefaultInstance();
    }

    private static synchronized BackupFacility2 getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultImpl();
        }
        return defaultInstance;
    }

    private static class DefaultImpl
    extends BackupFacility2 {
        private long currentId = 0L;
        private Map<Long, BackupEntry> map = new HashMap<Long, BackupEntry>();
        private static Field undoRedo;

        private String MD5toString(byte[] digest) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                b.append(Integer.toHexString(0xFF & digest[i]));
            }
            return b.toString();
        }

        private void storeChecksum(long l) throws IOException {
            CloneableEditorSupport ces;
            BaseDocument doc;
            BackupEntry backup = this.map.get(l);
            File f = new File(backup.path);
            FileObject fo = FileUtil.toFileObject((File)f);
            if (fo == null) {
                BackupEntry.access$402(backup, new byte[16]);
                Arrays.fill(backup.checkSum, (byte)0);
                return;
            }
            DataObject dob = DataObject.find((FileObject)fo);
            if (dob != null && (doc = (BaseDocument)(ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class)).getDocument()) != null && doc.isAtomicLock()) {
                return;
            }
            LOG.fine("Storing MD5 for " + backup.path);
            BackupEntry.access$402(backup, this.getMD5(this.getInputStream(backup.path)));
            LOG.fine("MD5 is: " + this.MD5toString(backup.checkSum));
        }

        private String checkChecksum(long l, boolean undo) {
            try {
                BackupEntry backup = this.map.get(l);
                File f = new File(backup.path);
                FileObject fo = FileUtil.toFileObject((File)f);
                if (fo == null) {
                    return null;
                }
                DataObject dob = DataObject.find((FileObject)fo);
                if (dob != null) {
                    CloneableEditorSupport ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class);
                    BaseDocument doc = (BaseDocument)ces.getDocument();
                    if (doc != null && doc.isAtomicLock()) {
                        return null;
                    }
                    EditorCookie editor = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                    if (editor != null && doc != null && editor.isModified()) {
                        UndoableWrapper.UndoableEditDelegate edit;
                        UndoableWrapper.UndoableEditDelegate undoableEditDelegate = edit = undo ? (UndoableWrapper.UndoableEditDelegate)NbDocument.getEditToBeUndoneOfType((EditorCookie)editor, UndoableWrapper.UndoableEditDelegate.class) : (UndoableWrapper.UndoableEditDelegate)NbDocument.getEditToBeRedoneOfType((EditorCookie)editor, UndoableWrapper.UndoableEditDelegate.class);
                        if (edit == null) {
                            try {
                                LOG.fine("Editor Undo Different");
                                return backup.path.toURL().getPath();
                            }
                            catch (MalformedURLException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
                try {
                    LOG.fine("Checking MD5 for " + backup.path);
                    byte[] ts = this.getMD5(this.getInputStream(backup.path));
                    if (!Arrays.equals(backup.checkSum, ts)) {
                        LOG.fine("MD5 check failed");
                        return backup.path.toURL().getPath();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }

        private InputStream getInputStream(URI path) throws IOException {
            File f = new File(path);
            FileObject fo = FileUtil.toFileObject((File)f);
            DataObject dob = DataObject.find((FileObject)fo);
            CloneableEditorSupport ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class);
            if (ces != null && ces.isModified()) {
                LOG.fine("Editor Input Stream");
                return ces.getInputStream();
            }
            LOG.fine("File Input Stream");
            return fo.getInputStream();
        }

        private DefaultImpl() {
        }

        @Override
        public Handle backup(FileObject ... file) throws IOException {
            ArrayList<Long> list = new ArrayList<Long>();
            for (FileObject f : file) {
                list.add(this.backup(f));
            }
            return new DefaultHandle(this, list);
        }

        @Override
        public Handle backup(File ... files) throws IOException {
            ArrayList<Long> list = new ArrayList<Long>();
            for (File f : files) {
                list.add(this.backup(f));
            }
            return new DefaultHandle(this, list);
        }

        public long backup(FileObject file) throws IOException {
            try {
                BackupEntry entry = new BackupEntry();
                entry.file = File.createTempFile("nbbackup", null);
                this.copy(file, entry.file);
                entry.path = file.getURL().toURI();
                this.map.put(this.currentId, entry);
                entry.file.deleteOnExit();
                return this.currentId++;
            }
            catch (URISyntaxException ex) {
                throw (IOException)new IOException(file.toString()).initCause(ex);
            }
        }

        public long backup(File file) throws IOException {
            BackupEntry entry = new BackupEntry();
            entry.file = File.createTempFile("nbbackup", null);
            entry.path = file.toURI();
            entry.exists = file.exists();
            this.map.put(this.currentId, entry);
            entry.file.deleteOnExit();
            if (entry.exists) {
                this.copy(file, entry.file);
            }
            return this.currentId++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getMD5(InputStream is) throws IOException {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                try {
                    is = new DigestInputStream(is, md);
                    DefaultImpl.readFully(is, -1, true);
                }
                finally {
                    is.close();
                }
                return md.digest();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IOException(ex);
            }
        }

        private static byte[] readFully(InputStream is, int length, boolean readAll) throws IOException {
            int cc;
            byte[] output = new byte[]{};
            if (length == -1) {
                length = Integer.MAX_VALUE;
            }
            for (int pos = 0; pos < length; pos += cc) {
                int bytesToRead;
                if (pos >= output.length) {
                    bytesToRead = Math.min(length - pos, output.length + 1024);
                    if (output.length < pos + bytesToRead) {
                        output = Arrays.copyOf(output, pos + bytesToRead);
                    }
                } else {
                    bytesToRead = output.length - pos;
                }
                if ((cc = is.read(output, pos, bytesToRead)) >= 0) continue;
                if (readAll && length != Integer.MAX_VALUE) {
                    throw new EOFException("Detect premature EOF");
                }
                if (output.length == pos) break;
                output = Arrays.copyOf(output, pos);
                break;
            }
            return output;
        }

        void restore(long id) throws IOException {
            BackupEntry entry = this.map.get(id);
            if (entry == null) {
                throw new IllegalArgumentException("Backup with id " + id + "does not exist");
            }
            File backup = File.createTempFile("nbbackup", null);
            backup.deleteOnExit();
            File f = new File(entry.path);
            boolean exists = this.createNewFile(f);
            if (exists) {
                backup.createNewFile();
                this.copy(f, backup);
            }
            FileObject fileObj = FileUtil.toFileObject((File)f);
            if (entry.exists) {
                if (!this.tryUndoOrRedo(fileObj, entry)) {
                    this.copy(entry.file, fileObj);
                }
            } else {
                fileObj.delete();
            }
            entry.exists = exists;
            entry.file.delete();
            if (backup.exists()) {
                entry.file = backup;
            } else {
                this.map.remove(id);
            }
        }

        private boolean tryUndoOrRedo(FileObject fileObj, final BackupEntry entry) throws DataObjectNotFoundException {
            DataObject dob = DataObject.find((FileObject)fileObj);
            if (dob != null) {
                CloneableEditorSupport ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class);
                try {
                    final UndoRedo.Manager manager = (UndoRedo.Manager)undoRedo.get(ces);
                    BaseDocument doc = (BaseDocument)ces.getDocument();
                    if (doc == null) {
                        return false;
                    }
                    if (doc.isAtomicLock() || fileObj.isLocked()) {
                        if (entry.isUndo()) {
                            entry.setUndo(false);
                        } else {
                            entry.setUndo(true);
                        }
                    } else if (entry.isUndo() && manager.canUndo() || !entry.isUndo() && manager.canRedo()) {
                        doc.runAtomic(new Runnable(){

                            @Override
                            public void run() {
                                if (entry.isUndo()) {
                                    manager.undo();
                                    entry.setUndo(false);
                                } else {
                                    manager.redo();
                                    entry.setUndo(true);
                                }
                            }
                        });
                    } else {
                        return false;
                    }
                    return true;
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }

        private boolean createNewFile(File f) throws IOException {
            if (f.exists()) {
                return true;
            }
            File parent = f.getParentFile();
            if (parent != null) {
                this.createNewFolder(parent);
            }
            FileUtil.createData((File)f);
            return false;
        }

        private void createNewFolder(File f) throws IOException {
            if (!f.exists()) {
                File parent = f.getParentFile();
                if (parent != null) {
                    this.createNewFolder(parent);
                }
                FileUtil.createFolder((File)f);
            }
        }

        private void copy(FileObject a, File b) throws IOException {
            InputStream fs = a.getInputStream();
            FileOutputStream fo = new FileOutputStream(b);
            this.copy(fs, fo);
        }

        private void copy(File a, File b) throws IOException {
            FileInputStream fs = new FileInputStream(a);
            FileOutputStream fo = new FileOutputStream(b);
            this.copy(fs, fo);
        }

        private void copy(File a, FileObject b) throws IOException {
            FileInputStream fs = new FileInputStream(a);
            OutputStream fo = b.getOutputStream();
            this.copy(fs, fo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(InputStream is, OutputStream os) throws IOException {
            try {
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                is.close();
                os.close();
            }
        }

        @Override
        public void clear() {
            for (BackupEntry entry : this.map.values()) {
                entry.file.delete();
            }
            this.map.clear();
        }

        static {
            try {
                undoRedo = CloneableEditorSupport.class.getDeclaredField("undoRedo");
                undoRedo.setAccessible(true);
            }
            catch (NoSuchFieldException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private class BackupEntry {
            private File file;
            private URI path;
            private byte[] checkSum;
            private boolean undo = true;
            private boolean exists = true;

            public boolean isUndo() {
                return this.undo;
            }

            public void setUndo(boolean undo) {
                this.undo = undo;
            }

            static /* synthetic */ byte[] access$402(BackupEntry x0, byte[] x1) {
                x0.checkSum = x1;
                return x1;
            }
        }
    }

    private static class DefaultHandle
    implements Handle {
        private List<Long> handle;
        private DefaultImpl instance;

        private DefaultHandle(DefaultImpl instance, List<Long> handles) {
            this.handle = handles;
            this.instance = instance;
        }

        @Override
        public void restore() throws IOException {
            for (long l : this.handle) {
                this.instance.restore(l);
            }
        }

        @Override
        public void storeChecksum() throws IOException {
            for (long l : this.handle) {
                this.instance.storeChecksum(l);
            }
        }

        @Override
        public Collection<String> checkChecksum(boolean undo) throws IOException {
            LinkedList<String> result = new LinkedList<String>();
            for (long l : this.handle) {
                String checkChecksum = this.instance.checkChecksum(l, undo);
                if (checkChecksum == null) continue;
                result.add(checkChecksum);
            }
            return result;
        }
    }

    public static interface Handle {
        public void restore() throws IOException;

        public void storeChecksum() throws IOException;

        public Collection<String> checkChecksum(boolean var1) throws IOException;
    }
}

