/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.util.Utils;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.modules.versioning.ui.options.Bundle;
import org.netbeans.modules.versioning.ui.options.GeneralOptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class GeneralOptionsPanel
extends JPanel
implements ActionListener {
    private final GeneralOptionsPanelController controller;
    private String[] keywords;
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBox cmbVersioningSystems;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JList lstDisconnectedFolders;

    GeneralOptionsPanel(GeneralOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.cmbVersioningSystems.setRenderer(new Renderer());
        this.cmbVersioningSystems.addActionListener(this);
        this.btnRemove.addActionListener(this);
        this.btnAdd.addActionListener(this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    Collection<String> getKeywords() {
        if (this.keywords == null) {
            this.keywords = new String[]{Bundle.GeneralOptionsPanel_kw1().toUpperCase(), Bundle.GeneralOptionsPanel_kw2().toUpperCase(), Bundle.GeneralOptionsPanel_kw3().toUpperCase()};
        }
        return Collections.unmodifiableList(Arrays.asList(this.keywords));
    }

    private void fillDisconnectedFolders() {
        if (this.cmbVersioningSystems.getSelectedItem() instanceof VCSSystemProvider.VersioningSystem) {
            String[] disconnected = Utils.getDisconnectedRoots((VCSSystemProvider.VersioningSystem)((VCSSystemProvider.VersioningSystem)this.cmbVersioningSystems.getSelectedItem()));
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (String f : disconnected) {
                model.addElement(f);
            }
            this.lstDisconnectedFolders.setModel(model);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cmbVersioningSystems = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstDisconnectedFolders = new JList();
        this.btnRemove = new JButton();
        this.btnAdd = new JButton();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel1.setLabelFor(this.cmbVersioningSystems);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.lstDisconnectedFolders);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.jLabel2.text"));
        this.jScrollPane1.setViewportView(this.lstDisconnectedFolders);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.btnRemove.TTtext"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.btnAdd.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_OptionsPanel.disconnectedFolders.title"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbVersioningSystems, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.btnRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAdd)).addComponent(this.jScrollPane1))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jSeparator1, -2, 4, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cmbVersioningSystems, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnRemove).addComponent(this.btnAdd)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    void load() {
        this.fillVersioningSystems();
    }

    void store() {
    }

    boolean valid() {
        return true;
    }

    private void fillVersioningSystems() {
        LinkedList<VCSSystemProvider.VersioningSystem> systems = new LinkedList<VCSSystemProvider.VersioningSystem>();
        for (VCSSystemProvider.VersioningSystem system : Lookup.getDefault().lookupAll(VCSSystemProvider.VersioningSystem.class)) {
            systems.add(system);
        }
        this.cmbVersioningSystems.setModel(new DefaultComboBoxModel<VCSSystemProvider.VersioningSystem>(systems.toArray(new VCSSystemProvider.VersioningSystem[systems.size()])));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmbVersioningSystems) {
            this.fillDisconnectedFolders();
        } else if (e.getSource() == this.btnRemove) {
            if (this.cmbVersioningSystems.getSelectedItem() instanceof VCSSystemProvider.VersioningSystem && this.lstDisconnectedFolders.getSelectedValue() != null) {
                String f = (String)this.lstDisconnectedFolders.getSelectedValue();
                Utils.connectRepository((VCSSystemProvider.VersioningSystem)((VCSSystemProvider.VersioningSystem)this.cmbVersioningSystems.getSelectedItem()), (String)f);
                this.fillDisconnectedFolders();
                this.refreshSystems();
            }
        } else if (e.getSource() == this.btnAdd && this.cmbVersioningSystems.getSelectedItem() instanceof VCSSystemProvider.VersioningSystem) {
            VCSSystemProvider.VersioningSystem vcs = (VCSSystemProvider.VersioningSystem)this.cmbVersioningSystems.getSelectedItem();
            File f = new FileChooserBuilder("VersioningOptions.disconnected").setTitle(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_DisconnectingFolder.title")).setDirectoriesOnly(true).setFileHiding(true).showOpenDialog();
            if (f != null && vcs.getTopmostManagedAncestor(VCSFileProxy.createFileProxy((File)f)) != null) {
                Utils.disconnectRepository((VCSSystemProvider.VersioningSystem)vcs, (String)f.getAbsolutePath());
                this.fillDisconnectedFolders();
                this.refreshSystems();
            }
        }
    }

    private void refreshSystems() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Utils.versionedRootsChanged();
            }
        }).schedule(100);
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof VCSSystemProvider.VersioningSystem) {
                value = ((VCSSystemProvider.VersioningSystem)value).getDisplayName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

