/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.Action;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.ui.history.History;
import org.netbeans.modules.versioning.ui.history.HistoryEntry;
import org.netbeans.modules.versioning.ui.history.TableEntry;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class RevisionNode
extends AbstractNode
implements Comparable {
    static final String PROPERTY_NAME_LABEL = "label";
    static final String PROPERTY_NAME_USER = "user";
    static final String PROPERTY_NAME_VERSION = "version";
    private HistoryEntry entry;
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private static DateFormat timeFormat = DateFormat.getTimeInstance();

    private RevisionNode(HistoryEntry entry, Lookup l) {
        super(RevisionNode.createChildren(entry), l);
        this.entry = entry;
        this.initProperties();
    }

    static RevisionNode create(HistoryEntry entry) {
        VCSFileProxy[] proxies;
        LinkedList<Object> lookup = new LinkedList<Object>();
        for (VCSFileProxy proxy : proxies = entry.getFiles()) {
            lookup.add(proxy);
            File f = proxy.toFile();
            if (f == null) continue;
            lookup.add(f);
        }
        lookup.addAll(Arrays.asList(entry.getLookupObjects()));
        lookup.add(entry);
        return new RevisionNode(entry, Lookups.fixed((Object[])lookup.toArray(new Object[lookup.size()])));
    }

    private static Children createChildren(HistoryEntry entry) {
        if (entry.getFiles().length == 1) {
            return Children.LEAF;
        }
        FileNode[] nodes = new FileNode[entry.getFiles().length];
        int i = 0;
        for (VCSFileProxy file : entry.getFiles()) {
            nodes[i++] = new FileNode(entry, file);
        }
        Children.SortedArray children = new Children.SortedArray();
        children.add((Node[])nodes);
        return children;
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new RevisionProperty());
        ps.put((Node.Property)new UserProperty());
        ps.put((Node.Property)(this.entry.canEdit() ? new EditableMessageProperty() : new MessageProperty()));
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return RevisionNode.getFormatedDate(this.entry);
    }

    static String getFormatedDate(HistoryEntry se) {
        int day = RevisionNode.getDay(se.getDateTime().getTime());
        switch (day) {
            case 0: {
                return NbBundle.getMessage(RevisionNode.class, (String)"LBL_Today", (Object[])new Object[]{timeFormat.format(se.getDateTime())});
            }
            case 1: {
                return NbBundle.getMessage(RevisionNode.class, (String)"LBL_Yesterday", (Object[])new Object[]{timeFormat.format(se.getDateTime())});
            }
        }
        return dateFormat.format(se.getDateTime());
    }

    private static int getDay(long ts) {
        Date date = new Date(ts);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int todayMillis = c.get(11) * 60 * 60 * 1000 + c.get(12) * 60 * 1000 + c.get(13) * 1000 + c.get(14);
        c.add(14, -1 * todayMillis);
        if (c.getTime().compareTo(date) < 0) {
            return 0;
        }
        return (int)((c.getTimeInMillis() - ts) / 86400000L) + 1;
    }

    public Action[] getActions(boolean context) {
        return this.entry.getActions();
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof RevisionNode) || obj == null) {
            return -1;
        }
        RevisionNode node = (RevisionNode)obj;
        return node.entry.getDateTime().compareTo(this.entry.getDateTime());
    }

    static class FileNode
    extends AbstractNode
    implements Comparable {
        private final HistoryEntry entry;
        private final VCSFileProxy file;

        FileNode(HistoryEntry entry, VCSFileProxy file) {
            super(Children.LEAF, FileNode.createLookup(file, entry));
            this.entry = entry;
            this.file = file;
        }

        private static Lookup createLookup(VCSFileProxy proxy, HistoryEntry entry) {
            LinkedList<Object> lookup = new LinkedList<Object>();
            lookup.add(proxy);
            File f = proxy.toFile();
            if (f != null) {
                lookup.add(f);
            }
            lookup.add(entry);
            lookup.addAll(Arrays.asList(entry.getLookupObjects()));
            return Lookups.fixed((Object[])lookup.toArray(new Object[lookup.size()]));
        }

        public Action[] getActions(boolean context) {
            return this.entry.getActions();
        }

        public String getName() {
            return this.file.getName();
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof FileNode) || obj == null) {
                return -1;
            }
            FileNode node = (FileNode)obj;
            return this.getName().compareTo(node.getName());
        }
    }

    class RevisionProperty
    extends PropertySupport.ReadOnly<TableEntry> {
        private TableEntry te;

        public RevisionProperty() {
            super(RevisionNode.PROPERTY_NAME_VERSION, TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_VersionProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_VersionProperty_Desc"));
            this.te = new TableEntry(){

                @Override
                public String getDisplayValue() {
                    return RevisionNode.this.entry.getRevisionShort();
                }

                @Override
                public String getTooltip() {
                    return RevisionNode.this.entry.getRevision();
                }

                @Override
                public int compareTo(TableEntry e) {
                    if (e == null) {
                        return 1;
                    }
                    try {
                        Integer i1 = Integer.parseInt(this.getDisplayValue());
                        Integer i2 = Integer.parseInt(e.getDisplayValue());
                        return i1.compareTo(i2);
                    }
                    catch (NumberFormatException ex) {
                        return super.compareTo(e);
                    }
                }
            };
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }

        public String toString() {
            return RevisionNode.this.entry.getRevision();
        }
    }

    class UserProperty
    extends PropertySupport.ReadOnly<TableEntry> {
        private TableEntry te;

        public UserProperty() {
            super(RevisionNode.PROPERTY_NAME_USER, TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_UserProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_UserProperty_Desc"));
            this.te = new TableEntry(){

                @Override
                public String getDisplayValue() {
                    return RevisionNode.this.entry.getUsernameShort();
                }

                @Override
                public String getTooltip() {
                    return RevisionNode.this.entry.getUsername();
                }
            };
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }

        public String toString() {
            return RevisionNode.this.entry.getUsername();
        }
    }

    class EditableMessageProperty
    extends PropertySupport.ReadWrite<TableEntry> {
        private TableEntry te;

        public EditableMessageProperty() {
            super(RevisionNode.PROPERTY_NAME_LABEL, TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Desc"));
            this.te = new TableEntry(){

                @Override
                public String getDisplayValue() {
                    return RevisionNode.this.entry.getMessage();
                }

                @Override
                public String getTooltip() {
                    String tooltip = RevisionNode.this.entry.getMessage();
                    if (tooltip == null || "".equals(tooltip.trim())) {
                        tooltip = NbBundle.getMessage(RevisionNode.class, (String)"LBL_SetTooltip");
                    }
                    return tooltip;
                }
            };
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }

        public void setValue(TableEntry te) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.te = te;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport(){

                @Override
                public void setAsText(String text) throws IllegalArgumentException {
                    if (text instanceof String) {
                        try {
                            RevisionNode.this.entry.setMessage(!text.equals("") ? text : null);
                        }
                        catch (IOException ex) {
                            History.LOG.log(Level.WARNING, null, ex);
                        }
                        return;
                    }
                    throw new IllegalArgumentException(text);
                }

                @Override
                public String getAsText() {
                    return EditableMessageProperty.this.te.getDisplayValue();
                }
            };
        }

        public String toString() {
            return RevisionNode.this.entry.getMessage();
        }
    }

    class MessageProperty
    extends PropertySupport.ReadOnly<TableEntry> {
        private TableEntry te;

        public MessageProperty() {
            super(RevisionNode.PROPERTY_NAME_LABEL, TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Desc"));
            this.te = new TableEntry(){

                @Override
                public String getDisplayValue() {
                    return RevisionNode.this.entry.getMessage();
                }

                @Override
                public String getTooltip() {
                    return RevisionNode.this.entry.getMessage();
                }
            };
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }

        public String toString() {
            return RevisionNode.this.entry.getMessage();
        }
    }
}

