/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.util.Utils;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class History {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.versioning.ui.history");
    private static History instance;
    private Lookup.Result<? extends VCSHyperlinkProvider> hpResult;
    private RequestProcessor rp;

    private History() {
    }

    public static synchronized History getInstance() {
        if (instance == null) {
            instance = new History();
        }
        return instance;
    }

    public RequestProcessor getRequestProcessor() {
        if (this.rp == null) {
            this.rp = new RequestProcessor("History.ParallelTasks", 5, true);
        }
        return this.rp;
    }

    public List<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.emptyList();
        }
        Collection providersCol = this.hpResult.allInstances();
        ArrayList providersList = new ArrayList(providersCol.size());
        providersList.addAll(providersCol);
        return Collections.unmodifiableList(providersList);
    }

    VCSSystemProvider.VersioningSystem getLocalHistory(FileObject fo) {
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            LOG.log(Level.FINE, "local history available only for local files {0}", fo);
            return null;
        }
        VCSSystemProvider.VersioningSystem vs = Utils.getLocalHistory((File)file);
        if (vs == null) {
            LOG.fine("local history not available");
        }
        return vs;
    }

    static VCSHistoryProvider getHistoryProvider(VCSSystemProvider.VersioningSystem versioningSystem) {
        if (versioningSystem == null) {
            return null;
        }
        return versioningSystem.getVCSHistoryProvider();
    }

    static VCSFileProxy[] toProxies(FileObject[] files) {
        if (files == null) {
            return new VCSFileProxy[0];
        }
        ArrayList<VCSFileProxy> l = new ArrayList<VCSFileProxy>(files.length);
        for (FileObject f : files) {
            VCSFileProxy proxy = VCSFileProxy.createFileProxy((FileObject)f);
            if (proxy == null) continue;
            l.add(proxy);
        }
        return l.toArray(new VCSFileProxy[l.size()]);
    }
}

