/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.diff;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DiffFileEncodingQueryImpl
extends FileEncodingQueryImplementation {
    private Map<File, Charset> fileToCharset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset getEncoding(FileObject fo) {
        try {
            if (this.fileToCharset == null || this.fileToCharset.isEmpty() || fo == null || fo.isFolder()) {
                return null;
            }
            File file = FileUtil.toFile((FileObject)fo);
            if (file == null) {
                return null;
            }
            Map<File, Charset> map = this.fileToCharset;
            synchronized (map) {
                return this.fileToCharset.get(file);
            }
        }
        catch (Throwable t) {
            ErrorManager.getDefault().notify(1, t);
            return null;
        }
    }

    void associateEncoding(FileObject referenceFile, Collection<File> files) {
        if (referenceFile.isFolder()) {
            return;
        }
        this.associateEncoding(FileEncodingQuery.getEncoding((FileObject)referenceFile), files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associateEncoding(Charset charset, Collection<File> files) {
        if (charset == null) {
            return;
        }
        if (this.fileToCharset == null) {
            this.fileToCharset = new WeakHashMap<File, Charset>();
        }
        Map<File, Charset> map = this.fileToCharset;
        synchronized (map) {
            for (File file : files) {
                this.fileToCharset.put(file, charset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetEncodingForFiles(Collection<File> files) {
        if (this.fileToCharset == null || files == null || files.isEmpty()) {
            return;
        }
        Map<File, Charset> map = this.fileToCharset;
        synchronized (map) {
            for (File file : files) {
                this.fileToCharset.remove(file);
            }
        }
    }
}

