/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.j2meunit;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.mobility.j2meunit.TestUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class TestCreator {
    private Map<CommonPlugin.CreateTestParam, Object> parameters;
    private FileObject testSourceRoot;
    private Project mProject;
    private AntProjectHelper aph;
    private static final String J2MEUNIT_SUPER_CLASS_NAME = "TestCase";
    private static final String J2MEUNIT_FRAMEWORK_PACKAGE_NAME = "jmunit.framework.cldc10";
    private static final String METHOD_NAME_SETUP = "setUp";
    private static final String METHOD_NAME_TEARDOWN = "tearDown";
    private static final String CLASS_COMMENT_LINE1 = "TestCreator.javaClass.addTestsHereComment.l1";
    private static final String CLASS_COMMENT_LINE2 = "TestCreator.javaClass.addTestsHereComment.l2";
    private static final String INSTANCE_VAR_NAME = "instance";
    private static final String RESULT_VAR_NAME = "result";
    private static final String EXP_RESULT_VAR_NAME = "expResult";
    private static final String ARTIFICAL_VAR_NAME_BASE = "arg";
    private static final EnumSet<Modifier> ACCESS_MODIFIERS = EnumSet.of(Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
    private static final EnumSet<Modifier> NO_MODIFIERS = EnumSet.noneOf(Modifier.class);
    private boolean skipPkgPrivateClasses = false;
    private boolean skipAbstractClasses = false;
    private boolean skipExceptionClasses = false;
    private Set<Modifier> methodAccessModifiers = TestUtils.createModifierSet(Modifier.PUBLIC, Modifier.PROTECTED);
    private boolean testPkgPrivateMethods = true;
    private boolean generateDefMethodBody = true;
    private boolean generateMethodJavadoc = true;
    private boolean generateSourceCodeHints = true;
    private boolean generateSetUp = true;
    private boolean generateTearDown = true;

    public TestCreator(Map<CommonPlugin.CreateTestParam, Object> params, FileObject testTargetRoot, Project p, AntProjectHelper aph) {
        this.parameters = params;
        this.testSourceRoot = testTargetRoot;
        this.aph = aph;
        this.mProject = p;
        this.skipPkgPrivateClasses = !Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS));
        this.skipAbstractClasses = !Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_ABSTRACT_CLASS));
        this.skipExceptionClasses = !Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_EXCEPTION_CLASS));
        this.methodAccessModifiers.clear();
        if (Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_PUBLIC))) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        }
        if (Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_PROTECTED))) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        }
        this.testPkgPrivateMethods = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_PKG_PRIVATE));
        this.generateDefMethodBody = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_METHOD_BODIES));
        this.generateMethodJavadoc = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_JAVADOC));
        this.generateSourceCodeHints = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_CODE_HINT));
        this.generateSetUp = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_SETUP));
        this.generateTearDown = Boolean.TRUE.equals(params.get(CommonPlugin.CreateTestParam.INC_TEAR_DOWN));
    }

    public void setSkipPackagePrivateClasses(boolean skip) {
        this.skipPkgPrivateClasses = skip;
    }

    public void setSkipAbstractClasses(boolean skip) {
        this.skipAbstractClasses = skip;
    }

    public void setSkipExceptionClasses(boolean skip) {
        this.skipExceptionClasses = skip;
    }

    public void setTestPublicMethods(boolean test) {
        if (test) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        } else {
            this.methodAccessModifiers.remove((Object)Modifier.PUBLIC);
        }
    }

    public void setTestProtectedMethods(boolean test) {
        if (test) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        } else {
            this.methodAccessModifiers.remove((Object)Modifier.PROTECTED);
        }
    }

    public void setTestPackagePrivateMethods(boolean test) {
        this.testPkgPrivateMethods = test;
    }

    public void setGenerateDefMethodBody(boolean generate) {
        this.generateDefMethodBody = generate;
    }

    public void setGenerateMethodJavadoc(boolean generate) {
        this.generateMethodJavadoc = generate;
    }

    public void setGenerateMethodBodyComment(boolean generate) {
        this.generateSourceCodeHints = generate;
    }

    public void setGenerateSetUp(boolean generate) {
        this.generateSetUp = generate;
    }

    public void setGenerateTearDown(boolean generate) {
        this.generateTearDown = generate;
    }

    public FileObject[] generateTests(FileObject[] files2test) {
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        Enumeration<FileObject> dataFiles = Collections.enumeration(Arrays.asList(files2test));
        while (dataFiles.hasMoreElements()) {
            FileObject dataFile = dataFiles.nextElement();
            if (dataFile.isFolder()) {
                Enumeration testableFiles = dataFile.getData(true);
                while (testableFiles.hasMoreElements()) {
                    FileObject testableFile = (FileObject)testableFiles.nextElement();
                    if (!TestUtils.isTestable(testableFile)) continue;
                    result.addAll(this.generateFromSingleSource(testableFile));
                }
                continue;
            }
            if (!TestUtils.isTestable(dataFile)) continue;
            result.addAll(this.generateFromSingleSource(dataFile));
        }
        return result.toArray(new FileObject[result.size()]);
    }

    private List<FileObject> generateFromFolder(FileObject folder2test) {
        assert (folder2test.isFolder());
        LinkedList result = new LinkedList();
        Enumeration dataFiles = folder2test.getData(true);
        return null;
    }

    private List<FileObject> generateFromSingleSource(FileObject file2test) {
        ClassPath testClassPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.testSourceRoot});
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        HashMap<ElementHandle<TypeElement>, List<ExecutableElement>> testable = null;
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)file2test);
            TestUtils.TestableTypeFinder finder = new TestUtils.TestableTypeFinder();
            javaSource.runUserActionTask((Task)finder, true);
            if (!finder.isTestable()) {
                return Collections.EMPTY_LIST;
            }
            testable = TestUtils.findTopClasses(javaSource, this.methodAccessModifiers, this.testPkgPrivateMethods, this.skipAbstractClasses, this.skipPkgPrivateClasses, this.skipExceptionClasses);
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return Collections.EMPTY_LIST;
        }
        if (testable != null && !testable.isEmpty()) {
            String packageName = TestUtils.getPackageName(ClassPath.getClassPath((FileObject)file2test, (String)"classpath/source").getResourceName(file2test, '.', false));
            try {
                for (ElementHandle<TypeElement> clsToTest : testable.keySet()) {
                    SaveCookie sc;
                    boolean isNew;
                    String srcClassNameShort = TestUtils.getSimpleName(clsToTest.getQualifiedName().toString());
                    String testClassResourceName = TestUtils.getTestClassFullName(srcClassNameShort, packageName);
                    DataObject testDataObj = null;
                    FileObject testFileObj = testClassPath.findResource(testClassResourceName + ".java");
                    boolean bl = isNew = testFileObj == null;
                    if (testFileObj == null) {
                        testDataObj = this.createTestClassDataObj(testClassResourceName, this.loadTestTemplate("PROP_emptyTestClassTemplate"));
                        testFileObj = testDataObj.getPrimaryFile();
                    }
                    JavaSource testSource = JavaSource.forFileObject((FileObject)testFileObj);
                    SingleTestCreator testCreator = new SingleTestCreator(clsToTest, testable.get(clsToTest), isNew);
                    ModificationResult mResult = testSource.runModificationTask((Task)testCreator);
                    mResult.commit();
                    if (testDataObj == null) {
                        testDataObj = DataObject.find((FileObject)testFileObj);
                    }
                    if ((sc = (SaveCookie)testDataObj.getCookie(SaveCookie.class)) != null) {
                        sc.save();
                    }
                    result.add(testFileObj);
                    TestUtils.addTestClassProperty(this.mProject, this.aph, packageName != null && packageName.trim().length() != 0 ? packageName + "." + TestUtils.getTestClassName(srcClassNameShort) : TestUtils.getTestClassName(srcClassNameShort));
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        return result;
    }

    private DataObject createTestClassDataObj(String testClassName, DataObject templateDataObj) throws DataObjectNotFoundException, IOException {
        int index = testClassName.lastIndexOf(47);
        String className = index > -1 ? testClassName.substring(index + 1) : testClassName;
        FileObject packageFO = index > -1 ? this.testSourceRoot.getFileObject(testClassName.substring(0, index)) : this.testSourceRoot;
        return templateDataObj.createFromTemplate(DataFolder.findFolder((FileObject)packageFO), className);
    }

    private DataObject loadTestTemplate(String templateID) {
        String path = NbBundle.getMessage(TestCreator.class, (String)templateID);
        try {
            FileObject fo = FileUtil.getConfigFile((String)path);
            if (fo == null) {
                System.out.println("Cannot find template.");
                return null;
            }
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    final class SingleTestCreator
    implements CancellableTask<WorkingCopy> {
        private final ElementHandle classElem;
        private final List<ExecutableElement> srcMethods;
        private final boolean isNewTestClass;
        private List<String> processedClassNames;
        private volatile boolean cancelled = false;
        private TypeElement testCaseTypeElem;

        private SingleTestCreator() {
            this.srcMethods = null;
            this.classElem = null;
            this.isNewTestClass = true;
        }

        private SingleTestCreator(ElementHandle clsToTest, List<ExecutableElement> srcMethods, boolean isNewTestClass) {
            this.classElem = clsToTest;
            this.srcMethods = srcMethods;
            this.isNewTestClass = isNewTestClass;
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            String className = workingCopy.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).getResourceName(workingCopy.getFileObject(), '.', false);
            workingCopy.toPhase(JavaSource.Phase.UP_TO_DATE);
            CompilationUnitTree compUnit = workingCopy.getCompilationUnit();
            List<ClassTree> tstTopClasses = TestUtils.findTopClasses(compUnit, workingCopy.getTreeUtilities());
            TypeElement srcTopClassElem = (TypeElement)this.classElem.resolve((CompilationInfo)workingCopy);
            TreePath compUnitPath = new TreePath(compUnit);
            if (srcTopClassElem != null) {
                String srcClassName = srcTopClassElem.getSimpleName().toString();
                String tstClassName = TestUtils.getTestClassName(srcClassName);
                boolean srcHasTestableMethods = !this.srcMethods.isEmpty();
                ClassTree tstTopClass = null;
                for (ClassTree tstClass : tstTopClasses) {
                    if (!tstClass.getSimpleName().contentEquals(tstClassName)) continue;
                    tstTopClass = tstClass;
                    break;
                }
                if (tstTopClass != null) {
                    TreePath tstTopClassTreePath = new TreePath(compUnitPath, tstTopClass);
                    ClassTree origTstTopClass = tstTopClass;
                    if (srcHasTestableMethods) {
                        tstTopClass = this.generateMissingTestMethods(workingCopy, tstTopClass, tstTopClassTreePath, srcTopClassElem, this.srcMethods, this.isNewTestClass);
                    } else if (this.isNewTestClass) {
                        tstTopClass = this.generateMissingInitMembers(tstTopClass, tstTopClassTreePath, workingCopy);
                    }
                    if (tstTopClass != origTstTopClass) {
                        workingCopy.rewrite((Tree)origTstTopClass, (Tree)tstTopClass);
                    }
                }
            }
        }

        private ClassTree generateMissingInitMembers(ClassTree tstClass, TreePath tstClassTreePath, WorkingCopy workingCopy) {
            if (!TestCreator.this.generateSetUp && !TestCreator.this.generateTearDown) {
                return tstClass;
            }
            if (!(TestCreator.this.generateSetUp && !TestUtils.hasSetUp(tstClass) || TestCreator.this.generateTearDown && !TestUtils.hasTearDown(tstClass))) {
                return tstClass;
            }
            TreeMaker maker = workingCopy.getTreeMaker();
            List<? extends Tree> tstMembersOrig = tstClass.getMembers();
            ArrayList<? extends Tree> tstMembers = new ArrayList<Tree>(tstMembersOrig.size() + 2);
            tstMembers.addAll(tstMembersOrig);
            TypeElement element = (TypeElement)workingCopy.getTrees().getElement(tstClassTreePath);
            TypeMirror mirror = element.getSuperclass();
            TypeElement parent = workingCopy.getElements().getTypeElement(((Object)mirror).toString());
            List<? extends Element> elList = parent.getEnclosedElements();
            for (Element element2 : elList) {
                if (element2.toString().equals("tearDown()") && TestCreator.this.generateTearDown && !TestUtils.hasTearDown(tstClass)) {
                    tstMembers.add(GeneratorUtilities.get((WorkingCopy)workingCopy).createOverridingMethod(element, (ExecutableElement)element2));
                }
                if (!element2.toString().equals("setUp()") || !TestCreator.this.generateSetUp || TestUtils.hasSetUp(tstClass)) continue;
                tstMembers.add(GeneratorUtilities.get((WorkingCopy)workingCopy).createOverridingMethod(element, (ExecutableElement)element2));
            }
            ClassTree newClass = maker.Class(tstClass.getModifiers(), (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstMembers);
            return newClass;
        }

        private ClassTree generateMissingTestMethods(WorkingCopy workingCopy, ClassTree tstClass, TreePath tstClassTreePath, TypeElement srcClass, List<ExecutableElement> srcMethods, boolean generateMissingInitMembers) {
            if (srcMethods.isEmpty()) {
                return tstClass;
            }
            List<? extends Tree> tstMembersOrig = tstClass.getMembers();
            ArrayList<? extends Tree> tstMembers = new ArrayList<Tree>(tstMembersOrig.size() + 4);
            tstMembers.addAll(tstMembersOrig);
            MethodTree tMethod = this.getTestMethod(tstClass);
            tstMembers.remove(tMethod);
            if (generateMissingInitMembers) {
                tstClass = this.generateMissingInitMembers(tstClass, tstClassTreePath, workingCopy);
            }
            Boolean useNoArgConstrutor = null;
            HashMap<String, ArrayList<ExecutableElement>> mMap = new HashMap<String, ArrayList<ExecutableElement>>();
            if (useNoArgConstrutor == null) {
                useNoArgConstrutor = this.hasAccessibleNoArgConstructor(srcClass);
            }
            for (ExecutableElement srcMethod : srcMethods) {
                String string = TestUtils.createTestMethodName(srcMethod.getSimpleName().toString());
                if (TestUtils.testMethodExists(tstClass, string)) continue;
                ArrayList<ExecutableElement> mList = (ArrayList<ExecutableElement>)mMap.get(string);
                if (mList == null) {
                    mList = new ArrayList<ExecutableElement>();
                    mMap.put(string, mList);
                }
                mList.add(srcMethod);
            }
            for (String name : mMap.keySet()) {
                MethodTree methodTree = this.generateTestMethod(workingCopy, srcClass, name, (List)mMap.get(name), useNoArgConstrutor);
                tstMembers.add(methodTree);
            }
            if (tstMembersOrig.containsAll(tstMembers)) {
                return tstClass;
            }
            LinkedList<MethodTree> testMethods = new LinkedList<MethodTree>();
            for (Tree tree : tstMembers) {
                MethodTree testMethod;
                if (tree.getKind() != Tree.Kind.METHOD || !TestUtils.isTestMethod(testMethod = (MethodTree)tree)) continue;
                testMethods.add(testMethod);
            }
            tstMembers.add(1, this.generateOverrideTestMethod(workingCopy, testMethods));
            ClassTree newClass = workingCopy.getTreeMaker().Class(tstClass.getModifiers(), (CharSequence)tstClass.getSimpleName(), tstClass.getTypeParameters(), tstClass.getExtendsClause(), tstClass.getImplementsClause(), tstMembers);
            return newClass;
        }

        private MethodTree getTestMethod(ClassTree clsTree) {
            MethodTree mMethod = null;
            for (Tree tree : clsTree.getMembers()) {
                if (tree.getKind() != Tree.Kind.METHOD) continue;
                mMethod = (MethodTree)tree;
                if (mMethod.getName().toString().equals(NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_override_test_method"))) break;
                mMethod = null;
            }
            return mMethod;
        }

        private List<MethodTree> generateTestMethods(WorkingCopy workingCopy, TypeElement srcClass, List<ExecutableElement> srcMethods) {
            if (srcMethods.isEmpty()) {
                return Collections.emptyList();
            }
            boolean useNoArgConstrutor = this.hasAccessibleNoArgConstructor(srcClass);
            ArrayList<MethodTree> testMethods = new ArrayList<MethodTree>(srcMethods.size());
            for (ExecutableElement srcMethod : srcMethods) {
                ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>(1);
                methods.add(srcMethod);
                testMethods.add(this.generateTestMethod(workingCopy, srcClass, TestUtils.createTestMethodName(srcMethod.getSimpleName().toString()), methods, useNoArgConstrutor));
            }
            return testMethods;
        }

        private MethodTree generateOverrideTestMethod(WorkingCopy workingCopy, List<MethodTree> testMethods) {
            TreeMaker maker = workingCopy.getTreeMaker();
            ClassTree clsTree = (ClassTree)workingCopy.getCompilationUnit().getTypeDecls().get(0);
            StringBuffer methodBody = new StringBuffer("{\nswitch(" + NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_override_test_method_param") + ") {\n");
            int i = 0;
            for (MethodTree testMethod : testMethods) {
                methodBody.append("case " + i + ":" + testMethod.getName().toString() + "();break;\n");
                ++i;
            }
            methodBody.append("default: break;\n}\n}\n");
            List<IdentifierTree> throwsList = Collections.singletonList(maker.Identifier((CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_throwable")));
            ModifiersTree parameterModifiers = maker.Modifiers(Collections.emptySet(), Collections.emptyList());
            VariableTree parameter = maker.Variable(parameterModifiers, (CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_override_test_method_param"), (Tree)maker.PrimitiveType(TypeKind.INT), null);
            MethodTree m1 = maker.Method(maker.Modifiers(TestUtils.createModifierSet(Modifier.PUBLIC)), (CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_override_test_method"), (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(parameter), throwsList, methodBody.toString(), null);
            this.updateTestClassConctructor(workingCopy, i);
            return m1;
        }

        private void updateTestClassConctructor(WorkingCopy workingCopy, int nTests) {
            ClassTree clsTree = (ClassTree)workingCopy.getCompilationUnit().getTypeDecls().get(0);
            TreeMaker maker = workingCopy.getTreeMaker();
            MethodTree consMethod = null;
            for (Tree tree : clsTree.getMembers()) {
                if (tree.getKind() == Tree.Kind.METHOD && (consMethod = (MethodTree)tree).getName().toString().equals("<init>")) break;
            }
            String consBody = "{\nsuper(" + nTests + ",\"" + clsTree.getSimpleName() + "\");\n}\n";
            BlockTree blockTree = consMethod.getBody();
            TreeUtilities treeUtils = workingCopy.getTreeUtilities();
            StatementTree newBlock = treeUtils.parseStatement(consBody, new SourcePositions[1]);
            assert (Tree.Kind.BLOCK == newBlock.getKind());
            workingCopy.rewrite((Tree)blockTree, (Tree)newBlock);
        }

        private MethodTree generateTestMethod(WorkingCopy workingCopy, TypeElement srcClass, String testMethodName, List<ExecutableElement> srcMethods, boolean useNoArgConstructor) {
            TreeMaker maker = workingCopy.getTreeMaker();
            ModifiersTree modifiers = maker.Modifiers(TestUtils.createModifierSet(Modifier.PUBLIC));
            LinkedList<IdentifierTree> throwsList = new LinkedList<IdentifierTree>();
            throwsList.add(maker.Identifier((CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_test_method_exception")));
            for (ExecutableElement srcMethod : srcMethods) {
                if (!this.throwsNonRuntimeExceptions((CompilationInfo)workingCopy, srcMethod)) continue;
                throwsList.add(maker.Identifier((CharSequence)NbBundle.getMessage(TestCreator.class, (String)"PROP_generator_nonrte")));
            }
            MethodTree method = maker.Method(modifiers, (CharSequence)testMethodName, (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), throwsList, this.generateTestMethodBody(workingCopy, srcClass, srcMethods, useNoArgConstructor), null);
            if (TestCreator.this.generateMethodJavadoc) {
                Comment javadoc = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)NbBundle.getMessage(TestCreator.class, (String)"PROP_src_code_javadoc", (Object)testMethodName, (Object)srcClass.getSimpleName().toString()));
                maker.addComment((Tree)method, javadoc, true);
            }
            return method;
        }

        private MethodTree generateSuiteMethod(String suiteName, List<String> members, WorkingCopy workingCopy) {
            Types types = workingCopy.getTypes();
            Elements elements = workingCopy.getElements();
            TreeMaker maker = workingCopy.getTreeMaker();
            ArrayList bodyContent = new ArrayList(members.size() + 2);
            return maker.Method(maker.Modifiers(TestUtils.createModifierSet(Modifier.PUBLIC)), (CharSequence)"test", (Tree)maker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), maker.Block(bodyContent, false), null);
        }

        private BlockTree generateTestMethodBody(WorkingCopy workingCopy, TypeElement srcClass, List<ExecutableElement> srcMethods, boolean useNoArgConstructor) {
            TreeMaker maker = workingCopy.getTreeMaker();
            ArrayList<StatementTree> statements = new ArrayList<StatementTree>(8);
            boolean allStatic = true;
            int i = 0;
            for (ExecutableElement srcAMethod : srcMethods) {
                boolean isStatic = srcAMethod.getModifiers().contains((Object)Modifier.STATIC);
                allStatic &= isStatic;
                ++i;
                if (!TestCreator.this.generateDefMethodBody) continue;
                List<VariableTree> paramVariables = this.generateParamVariables(maker, srcAMethod, i);
                if (i == 1) {
                    StatementTree sout = this.generateSystemOutPrintln(maker, srcAMethod.getSimpleName().toString());
                    statements.add(sout);
                }
                statements.addAll(paramVariables);
                MethodInvocationTree methodCall = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect(isStatic ? maker.QualIdent((Element)srcClass) : maker.Identifier((CharSequence)TestCreator.INSTANCE_VAR_NAME), (CharSequence)srcAMethod.getSimpleName()), this.createIdentifiers(maker, paramVariables));
                TypeMirror retType = srcAMethod.getReturnType();
                TypeKind retTypeKind = retType.getKind();
                if (retTypeKind == TypeKind.VOID) {
                    ExpressionStatementTree methodCallStmt = maker.ExpressionStatement((ExpressionTree)methodCall);
                    statements.add(methodCallStmt);
                } else {
                    MethodInvocationTree comparison;
                    Tree retTypeTree = maker.Type(retType);
                    VariableTree expectedValue = maker.Variable(maker.Modifiers((Set)NO_MODIFIERS), (CharSequence)("expResult_" + i), retTypeTree, this.getDefaultValue(maker, retType));
                    VariableTree actualValue = maker.Variable(maker.Modifiers((Set)NO_MODIFIERS), (CharSequence)("result_" + i), retTypeTree, (ExpressionTree)methodCall);
                    ArrayList<ExpressionTree> comparisonArgs = new ArrayList<ExpressionTree>(2);
                    if (retTypeKind == TypeKind.FLOAT || retTypeKind == TypeKind.DOUBLE) {
                        comparisonArgs.add(maker.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)maker.Identifier((CharSequence)expectedValue.getName().toString()), (ExpressionTree)maker.Identifier((CharSequence)actualValue.getName().toString())));
                        comparison = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.Identifier((CharSequence)"assertTrue"), comparisonArgs);
                    } else {
                        comparisonArgs.add(maker.Identifier((CharSequence)expectedValue.getName().toString()));
                        comparisonArgs.add(maker.Identifier((CharSequence)actualValue.getName().toString()));
                        comparison = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.Identifier((CharSequence)"assertEquals"), comparisonArgs);
                    }
                    ExpressionStatementTree comparisonStmt = maker.ExpressionStatement((ExpressionTree)comparison);
                    statements.add(expectedValue);
                    statements.add(actualValue);
                    statements.add(comparisonStmt);
                }
                String failMsg = NbBundle.getMessage(TestCreator.class, (String)"PROP_src_code_sample_msg");
                MethodInvocationTree failMethodCall = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.Identifier((CharSequence)"fail"), Collections.singletonList(maker.Literal((Object)failMsg)));
                statements.add(maker.ExpressionStatement((ExpressionTree)failMethodCall));
            }
            if (!allStatic && TestCreator.this.generateDefMethodBody) {
                VariableTree instanceVarInit = maker.Variable(maker.Modifiers(Collections.emptySet()), (CharSequence)TestCreator.INSTANCE_VAR_NAME, (Tree)maker.QualIdent((Element)srcClass), useNoArgConstructor ? this.generateNoArgConstructorCall(maker, srcClass) : maker.Literal(null));
                statements.add(1, instanceVarInit);
            }
            return maker.Block(statements, false);
        }

        private StatementTree generateSystemOutPrintln(TreeMaker maker, String arg) {
            MethodInvocationTree methodInvocation = maker.MethodInvocation(Collections.emptyList(), (ExpressionTree)maker.MemberSelect((ExpressionTree)maker.MemberSelect((ExpressionTree)maker.Identifier((CharSequence)"System"), (CharSequence)"out"), (CharSequence)"println"), Collections.singletonList(maker.Literal((Object)arg)));
            return maker.ExpressionStatement((ExpressionTree)methodInvocation);
        }

        private List<VariableTree> generateParamVariables(TreeMaker maker, ExecutableElement srcMethod, int i) {
            List<? extends VariableElement> params = srcMethod.getParameters();
            if (params == null || params.isEmpty()) {
                return Collections.emptyList();
            }
            Set noModifiers = Collections.emptySet();
            ArrayList<VariableTree> paramVariables = new ArrayList<VariableTree>(params.size());
            String[] varNames = this.getTestSkeletonVarNames(params);
            int index = 0;
            for (VariableElement variableElement : params) {
                TypeMirror paramType = variableElement.asType();
                paramVariables.add(maker.Variable(maker.Modifiers(noModifiers), (CharSequence)(varNames[index++] + '_' + i), maker.Type(paramType), this.getDefaultValue(maker, paramType)));
            }
            return paramVariables;
        }

        private List<IdentifierTree> createIdentifiers(TreeMaker maker, List<VariableTree> variables) {
            List<IdentifierTree> identifiers;
            if (variables.isEmpty()) {
                identifiers = Collections.emptyList();
            } else {
                identifiers = new ArrayList<IdentifierTree>(variables.size());
                for (VariableTree var : variables) {
                    identifiers.add(maker.Identifier((CharSequence)var.getName().toString()));
                }
            }
            return identifiers;
        }

        private String[] getTestSkeletonVarNames(List<? extends VariableElement> sourceMethodParams) {
            String paramName;
            int i;
            if (sourceMethodParams.isEmpty()) {
                return new String[0];
            }
            int count = sourceMethodParams.size();
            String[] varNames = new String[count];
            boolean[] conflicts = new boolean[count];
            boolean issueFound = false;
            HashSet<String> varNamesSet = new HashSet<String>((int)((double)(count + 2) * 1.4));
            varNamesSet.add(TestCreator.INSTANCE_VAR_NAME);
            varNamesSet.add(TestCreator.RESULT_VAR_NAME);
            varNamesSet.add(TestCreator.EXP_RESULT_VAR_NAME);
            Iterator<? extends VariableElement> it = sourceMethodParams.iterator();
            for (i = 0; i < count; ++i) {
                varNames[i] = paramName = it.next().getSimpleName().toString();
                if (paramName == null) {
                    issueFound = true;
                    continue;
                }
                if (!varNamesSet.add(paramName)) {
                    conflicts[i] = true;
                    issueFound = true;
                    continue;
                }
                conflicts[i] = false;
            }
            if (issueFound) {
                for (i = 0; i < count; ++i) {
                    if (varNames[i] == null) {
                        paramName = TestCreator.ARTIFICAL_VAR_NAME_BASE + i;
                        if (varNamesSet.add(paramName)) {
                            varNames[i] = paramName;
                            continue;
                        }
                        conflicts[i] = true;
                    }
                    if (!conflicts[i]) continue;
                    String paramNamePrefix = varNames[i] + '_';
                    int index = 2;
                    while (!varNamesSet.add(paramName = paramNamePrefix + index++)) {
                    }
                    varNames[i] = paramName;
                }
            }
            return varNames;
        }

        private ExpressionTree getDefaultValue(TreeMaker maker, TypeMirror type) {
            LiteralTree defValue;
            TypeKind typeKind = type.getKind();
            if (typeKind.isPrimitive()) {
                switch (typeKind) {
                    case BOOLEAN: {
                        defValue = maker.Literal((Object)Boolean.FALSE);
                        break;
                    }
                    case CHAR: {
                        defValue = maker.Literal((Object)new Character(' '));
                        break;
                    }
                    case BYTE: {
                        defValue = maker.Literal((Object)new Byte(0));
                        break;
                    }
                    case SHORT: {
                        defValue = maker.Literal((Object)new Short(0));
                        break;
                    }
                    case INT: {
                        defValue = maker.Literal((Object)new Integer(0));
                        break;
                    }
                    case FLOAT: {
                        defValue = maker.Literal((Object)new Float(0.0f));
                        break;
                    }
                    case LONG: {
                        defValue = maker.Literal((Object)new Long(0L));
                        break;
                    }
                    case DOUBLE: {
                        defValue = maker.Literal((Object)new Double(0.0));
                        break;
                    }
                    default: {
                        assert (false) : "unknown primitive type";
                        defValue = maker.Literal((Object)new Integer(0));
                        break;
                    }
                }
            } else {
                defValue = typeKind == TypeKind.DECLARED && ((Object)type).toString().equals("java.lang.String") ? maker.Literal((Object)"") : maker.Literal(null);
            }
            return defValue;
        }

        private ExpressionTree generateNoArgConstructorCall(TreeMaker maker, TypeElement cls) {
            return maker.NewClass(null, Collections.emptyList(), maker.QualIdent((Element)cls), Collections.emptyList(), null);
        }

        private boolean hasAccessibleNoArgConstructor(TypeElement srcClass) {
            boolean answer;
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(srcClass.getEnclosedElements());
            if (constructors.isEmpty()) {
                answer = true;
            } else {
                answer = false;
                for (ExecutableElement constructor : constructors) {
                    if (!constructor.getParameters().isEmpty()) continue;
                    answer = !constructor.getModifiers().contains((Object)Modifier.PRIVATE);
                    break;
                }
            }
            return answer;
        }

        private boolean throwsNonRuntimeExceptions(CompilationInfo compInfo, ExecutableElement method) {
            List<? extends TypeMirror> thrownTypes = method.getThrownTypes();
            if (thrownTypes.isEmpty()) {
                return false;
            }
            String runtimeExcName = "java.lang.RuntimeException";
            TypeElement runtimeExcElement = compInfo.getElements().getTypeElement(runtimeExcName);
            if (runtimeExcElement == null) {
                return true;
            }
            Types types = compInfo.getTypes();
            TypeMirror runtimeExcType = runtimeExcElement.asType();
            for (TypeMirror typeMirror : thrownTypes) {
                if (types.isSubtype(typeMirror, runtimeExcType)) continue;
                return true;
            }
            return false;
        }

        private TypeElement getTestCaseTypeElem(Elements elements) {
            if (this.testCaseTypeElem == null) {
                this.testCaseTypeElem = this.getElemForClassName(TestCreator.J2MEUNIT_FRAMEWORK_PACKAGE_NAME, elements);
            }
            return this.testCaseTypeElem;
        }

        private TypeElement getElemForClassName(String className, Elements elements) {
            TypeElement elem = elements.getTypeElement(className);
            if (elem == null) {
                ErrorManager.getDefault().log(65536, "Could not find TypeElement for " + className);
            }
            return elem;
        }

        public void cancel() {
            this.cancelled = true;
        }

        private void classProcessed(ClassTree cls) {
            if (this.processedClassNames == null) {
                this.processedClassNames = new ArrayList<String>(4);
            }
            this.processedClassNames.add(cls.getSimpleName().toString());
        }

        List<String> getProcessedClassNames() {
            return this.processedClassNames != null ? this.processedClassNames : Collections.emptyList();
        }
    }
}

