/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.j2meunit;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.mobility.j2meunit.TestCreator;
import org.netbeans.modules.mobility.j2meunit.TestUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class J2MEUnitPlugin
extends JUnitPlugin {
    private Project p;
    private AntProjectHelper aph;

    public J2MEUnitPlugin(Project p, AntProjectHelper aph) {
        this.p = p;
        this.aph = aph;
    }

    protected CommonPlugin.Location getTestLocation(CommonPlugin.Location sourceLocation) {
        ClassPath srcCp;
        FileObject fileObj = sourceLocation.getFileObject();
        if (fileObj.isFolder() || (srcCp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source")) == null) {
            return null;
        }
        String baseResName = srcCp.getResourceName(fileObj, '/', false);
        String testResName = J2MEUnitPlugin.getTestResName(baseResName, fileObj.getExt());
        assert (testResName != null);
        return J2MEUnitPlugin.getOppositeLocation(sourceLocation, srcCp, testResName, true);
    }

    protected CommonPlugin.Location getTestedLocation(CommonPlugin.Location testLocation) {
        ClassPath srcCp;
        FileObject fileObj = testLocation.getFileObject();
        if (fileObj.isFolder() || (srcCp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source")) == null) {
            return null;
        }
        String baseResName = srcCp.getResourceName(fileObj, '/', false);
        String srcResName = J2MEUnitPlugin.getSrcResName(baseResName, fileObj.getExt());
        if (srcResName == null) {
            return null;
        }
        return J2MEUnitPlugin.getOppositeLocation(testLocation, srcCp, srcResName, false);
    }

    private static String getTestResName(String baseResName, String ext) {
        StringBuilder buf = new StringBuilder(baseResName.length() + ext.length() + 10);
        buf.append(baseResName).append("Test");
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static String getSrcResName(String testResName, String ext) {
        if (!testResName.endsWith("Test")) {
            return null;
        }
        StringBuilder buf = new StringBuilder(testResName.length() + ext.length());
        buf.append(testResName.substring(0, testResName.length() - 4));
        if (ext.length() != 0) {
            buf.append('.').append(ext);
        }
        return buf.toString();
    }

    private static CommonPlugin.Location getOppositeLocation(CommonPlugin.Location sourceLocation, ClassPath fileObjCp, String oppoResourceName, boolean sourceToTest) {
        URL[] oppoRootsURLs;
        FileObject fileObj = sourceLocation.getFileObject();
        FileObject fileObjRoot = fileObjCp.findOwnerRoot(fileObj);
        if (fileObjRoot == null) {
            return null;
        }
        URL[] uRLArray = oppoRootsURLs = sourceToTest ? UnitTestForSourceQuery.findUnitTests((FileObject)fileObjRoot) : UnitTestForSourceQuery.findSources((FileObject)fileObjRoot);
        if (oppoRootsURLs == null || oppoRootsURLs.length == 0) {
            return null;
        }
        ClassPath oppoRootsClassPath = ClassPathSupport.createClassPath((URL[])oppoRootsURLs);
        List oppoFiles = oppoRootsClassPath.findAllResources(oppoResourceName);
        if (oppoFiles.isEmpty()) {
            return null;
        }
        return new CommonPlugin.Location((FileObject)oppoFiles.get(0));
    }

    public boolean canCreateTests(FileObject ... filesToTest) {
        TestUtils.TestableTypeFinder finder = new TestUtils.TestableTypeFinder();
        for (FileObject fo : filesToTest) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
            if (javaSource == null) continue;
            try {
                javaSource.runUserActionTask((Task)finder, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            if (finder.isTestable()) continue;
            return false;
        }
        return true;
    }

    protected FileObject[] createTests(FileObject[] filesToTest, FileObject targetRoot, Map<CommonPlugin.CreateTestParam, Object> params) {
        ProjectClassPathExtender pcpe = (ProjectClassPathExtender)this.p.getLookup().lookup(ProjectClassPathExtender.class);
        if (pcpe != null) {
            Library lib = LibraryManager.getDefault().getLibrary("JMUnit4CLDC10");
            try {
                pcpe.addLibrary(lib);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
        AntProjectHelper aph = (AntProjectHelper)this.p.getLookup().lookup(AntProjectHelper.class);
        try {
            TestUtils.addTestRunnerMIDletProperty(this.p, aph);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        TestCreator generator = new TestCreator(params, targetRoot, this.p, this.aph);
        FileObject[] result = generator.generateTests(filesToTest);
        return result;
    }

    public static void main(String[] args) {
        try {
            TestCreator testGenerator = new TestCreator(Collections.EMPTY_MAP, FileUtil.createData((File)new File("./")), null, null);
            if (args.length > 0) {
                FileObject[] files2test = new FileObject[args.length];
                for (int i = 0; i < args.length; ++i) {
                    files2test[i] = FileUtil.createData((File)new File(args[i]));
                }
                FileObject[] fileObjectArray = testGenerator.generateTests(files2test);
            } else {
                System.out.println("Usage: J2MEUnitPlugin FILES...");
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
        }
    }
}

