/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.JavaFXProjectWizardIterator;
import org.netbeans.modules.javafx2.project.PanelConfigureProject;
import org.netbeans.modules.javafx2.project.SettingsPanel;
import org.netbeans.modules.javafx2.project.api.JavaFXProjectUtils;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class PanelOptionsVisual
extends SettingsPanel
implements TaskListener,
PropertyChangeListener,
DocumentListener {
    private static final Logger LOGGER = Logger.getLogger("javafx");
    private static boolean lastMainClassCheck = true;
    private volatile RequestProcessor.Task task = null;
    private DetectPlatformTask detectPlatformTask;
    boolean detectPlatformTaskPerformed = false;
    private ProgressHandle progressHandle;
    private final JavaFXProjectWizardIterator.WizardType type;
    private PanelConfigureProject panel;
    private ComboBoxModel platformsModel;
    private ListCellRenderer platformsCellRenderer;
    private JavaPlatformChangeListener jpcl;
    private String currentLibrariesLocation;
    private String projectLocation;
    private boolean isMainClassValid;
    private boolean isPreloaderNameValid;
    private boolean isFXMLNameValid;
    private JButton btnLibFolder;
    private JButton btnManagePlatforms;
    private JCheckBox cbSharable;
    private JCheckBox createMainCheckBox;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JLabel fxmlLabel;
    private JTextField fxmlTextField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator2;
    private JLabel lblHint;
    private JLabel lblLibFolder;
    private JLabel lblPlatform;
    private JLabel lblPreloaderProject;
    private JTextField mainClassTextField;
    private JComboBox platformComboBox;
    private JCheckBox preloaderCheckBox;
    private JLabel progressLabel;
    private JPanel progressPanel;
    private JTextField txtLibFolder;
    private JTextField txtPreloaderProject;

    PanelOptionsVisual(PanelConfigureProject panel, JavaFXProjectWizardIterator.WizardType type) {
        this.panel = panel;
        this.type = type;
        this.detectPlatformTask = new DetectPlatformTask();
        this.preInitComponents();
        this.initComponents();
        this.postInitComponents();
    }

    private void preInitComponents() {
        this.platformsModel = JavaFXProjectUtils.createPlatformComboBoxModel();
        this.platformsCellRenderer = JavaFXProjectUtils.createPlatformListCellRenderer();
    }

    private void postInitComponents() {
        if (!UIManager.getLookAndFeel().getClass().getName().toUpperCase().contains("AQUA")) {
            this.platformComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        }
        this.jpcl = new JavaPlatformChangeListener();
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.jpcl, (Object)JavaPlatformManager.getDefault()));
        this.selectJavaFXEnabledPlatform();
        this.currentLibrariesLocation = "." + File.separatorChar + "lib";
        this.txtLibFolder.setText(this.currentLibrariesLocation);
        this.cbSharableActionPerformed(null);
        switch (this.type) {
            case LIBRARY: {
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                this.preloaderCheckBox.setVisible(false);
                this.lblPreloaderProject.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
                this.fxmlLabel.setVisible(false);
                this.fxmlTextField.setVisible(false);
                break;
            }
            case APPLICATION: {
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                this.fxmlLabel.setVisible(false);
                this.fxmlTextField.setVisible(false);
                break;
            }
            case PRELOADER: {
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_createPreloaderCheckBox"));
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                this.preloaderCheckBox.setVisible(false);
                this.lblPreloaderProject.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
                this.fxmlLabel.setVisible(false);
                this.fxmlTextField.setVisible(false);
                break;
            }
            case FXML: {
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                this.preloaderCheckBox.setVisible(false);
                this.lblPreloaderProject.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
                break;
            }
            case SWING: {
                this.createMainCheckBox.setSelected(lastMainClassCheck);
                Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_createMainSwingCheckBox"));
                this.mainClassTextField.setEnabled(lastMainClassCheck);
                this.preloaderCheckBox.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
                this.lblPreloaderProject.setVisible(false);
                this.fxmlLabel.setVisible(false);
                this.fxmlTextField.setVisible(false);
                break;
            }
            case EXTISTING: {
                this.createMainCheckBox.setVisible(false);
                this.mainClassTextField.setVisible(false);
                this.preloaderCheckBox.setVisible(false);
                this.lblPreloaderProject.setVisible(false);
                this.txtPreloaderProject.setVisible(false);
                this.fxmlLabel.setVisible(false);
                this.fxmlTextField.setVisible(false);
            }
        }
        this.mainClassTextField.getDocument().addDocumentListener(this);
        this.txtLibFolder.getDocument().addDocumentListener(this);
        this.txtPreloaderProject.getDocument().addDocumentListener(this);
        this.fxmlTextField.getDocument().addDocumentListener(this);
        this.progressLabel.setVisible(false);
        this.progressPanel.setVisible(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propName = event.getPropertyName();
        if ("projectName".equals(propName)) {
            String projectName = (String)event.getNewValue();
            this.mainClassTextField.setText(PanelOptionsVisual.createMainClassName(projectName, this.type));
            this.txtPreloaderProject.setText(PanelOptionsVisual.createPreloaderProjectName(projectName));
        } else if ("projectLocation".equals(propName)) {
            this.projectLocation = (String)event.getNewValue();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged(e.getDocument());
    }

    private void documentChanged(Document doc) {
        if (this.txtLibFolder.getDocument().equals(doc)) {
            this.librariesLocationChanged();
        } else if (this.mainClassTextField.getDocument().equals(doc)) {
            this.mainClassChanged();
        } else if (this.txtPreloaderProject.getDocument().equals(doc)) {
            this.preloaderNameChanged();
        } else if (this.fxmlTextField.getDocument().equals(doc)) {
            this.fxmlNameChanged();
        }
    }

    private static String createPreloaderProjectName(String projectName) {
        return projectName + "-" + NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_FileNamePreloaderPostfix");
    }

    private static String createMainClassName(String projectName, JavaFXProjectWizardIterator.WizardType type) {
        String part;
        StringBuilder pkg = new StringBuilder();
        StringBuilder main = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        boolean needsEscape = false;
        for (int i = 0; i < projectName.length(); ++i) {
            char c = projectName.charAt(i);
            if (first) {
                if (!Character.isJavaIdentifierStart(c)) {
                    if (!Character.isJavaIdentifierPart(c)) continue;
                    needsEscape = true;
                    sb.append(c);
                    first = false;
                    continue;
                }
                sb.append(c);
                first = false;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (sb.length() <= 0) continue;
            part = sb.toString();
            if (pkg.length() > 0) {
                pkg.append('.');
            }
            if (needsEscape || !Utilities.isJavaIdentifier((String)part.toLowerCase())) {
                pkg.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNamePrefix"));
            }
            pkg.append(part.toLowerCase());
            if (!needsEscape || main.length() > 0) {
                main.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
            sb = new StringBuilder();
            first = true;
            needsEscape = false;
        }
        if (sb.length() > 0) {
            part = sb.toString();
            if (pkg.length() > 0) {
                pkg.append('.');
            }
            if (needsEscape || !Utilities.isJavaIdentifier((String)part.toLowerCase())) {
                pkg.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNamePrefix"));
            }
            pkg.append(part.toLowerCase());
            if (!needsEscape || main.length() > 0) {
                main.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1));
            }
        }
        if (main.length() == 0) {
            main.append(NbBundle.getMessage(PanelOptionsVisual.class, (String)(type == JavaFXProjectWizardIterator.WizardType.PRELOADER ? "TXT_ClassNamePreloader" : "TXT_ClassName")));
        }
        return pkg.length() == 0 ? main.toString() : String.format("%s.%s", pkg.toString(), main.toString());
    }

    private JavaPlatform getSelectedPlatform() {
        Object selectedItem = this.platformComboBox.getSelectedItem();
        JavaPlatform platform = selectedItem == null ? null : PlatformUiSupport.getPlatform((Object)selectedItem);
        return platform;
    }

    private void selectJavaFXEnabledPlatform() {
        for (int i = 0; i < this.platformsModel.getSize(); ++i) {
            JavaPlatform platform = PlatformUiSupport.getPlatform(this.platformsModel.getElementAt(i));
            if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)platform)) continue;
            this.platformComboBox.setSelectedIndex(i);
            break;
        }
    }

    private void initComponents() {
        this.cbSharable = new JCheckBox();
        this.lblLibFolder = new JLabel();
        this.createMainCheckBox = new JCheckBox();
        this.mainClassTextField = new JTextField();
        this.lblPlatform = new JLabel();
        this.platformComboBox = new JComboBox();
        this.btnManagePlatforms = new JButton();
        this.preloaderCheckBox = new JCheckBox();
        this.lblPreloaderProject = new JLabel();
        this.txtPreloaderProject = new JTextField();
        this.fxmlLabel = new JLabel();
        this.fxmlTextField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.btnLibFolder = new JButton();
        this.lblHint = new JLabel();
        this.txtLibFolder = new JTextField();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel2 = new JPanel();
        this.progressLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.cbSharable.setSelected(SharableLibrariesUtils.isLastProjectSharable());
        Mnemonics.setLocalizedText((AbstractButton)this.cbSharable, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_SharableProject_Checkbox"));
        this.cbSharable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.cbSharableActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.cbSharable, gridBagConstraints);
        this.cbSharable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_sharableProject"));
        this.cbSharable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_sharableProject"));
        this.lblLibFolder.setLabelFor(this.txtLibFolder);
        Mnemonics.setLocalizedText((JLabel)this.lblLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        this.add((Component)this.lblLibFolder, gridBagConstraints);
        this.lblLibFolder.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_labelLibrariesFolder"));
        this.lblLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_labelLibrariesFolder"));
        this.createMainCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createMainCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_createMainCheckBox"));
        this.createMainCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.createMainCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(25, 0, 0, 10);
        this.add((Component)this.createMainCheckBox, gridBagConstraints);
        this.createMainCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_createMainCheckBox"));
        this.createMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSD_createMainCheckBox"));
        this.mainClassTextField.setText("com.myapp.Main");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        this.add((Component)this.mainClassTextField, gridBagConstraints);
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        this.lblPlatform.setLabelFor(this.platformComboBox);
        Mnemonics.setLocalizedText((JLabel)this.lblPlatform, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Platform_ComboBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.lblPlatform, gridBagConstraints);
        this.lblPlatform.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_labelPlatform"));
        this.lblPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_labelPlatform"));
        this.platformComboBox.setModel(this.platformsModel);
        this.platformComboBox.setRenderer(this.platformsCellRenderer);
        this.platformComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.platformComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.platformComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnManagePlatforms, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Manage_Button"));
        this.btnManagePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnManagePlatformsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.btnManagePlatforms, gridBagConstraints);
        this.btnManagePlatforms.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_buttonManagePlatforms"));
        this.btnManagePlatforms.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_buttonManagePlatforms"));
        Mnemonics.setLocalizedText((AbstractButton)this.preloaderCheckBox, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Preloader_Checkbox"));
        this.preloaderCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PanelOptionsVisual.this.preloaderCheckBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.preloaderCheckBox, gridBagConstraints);
        this.preloaderCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_preloaderCheckBox"));
        this.preloaderCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_preloaderCheckBox"));
        this.lblPreloaderProject.setLabelFor(this.txtPreloaderProject);
        Mnemonics.setLocalizedText((JLabel)this.lblPreloaderProject, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_PreloaderName_TextBox"));
        this.lblPreloaderProject.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.add((Component)this.lblPreloaderProject, gridBagConstraints);
        this.lblPreloaderProject.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_labelPreloaderProject"));
        this.lblPreloaderProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_labelPreloaderProject"));
        this.txtPreloaderProject.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PanelOptions_Preloader_Project_Name"));
        this.txtPreloaderProject.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.txtPreloaderProject, gridBagConstraints);
        this.fxmlLabel.setLabelFor(this.fxmlTextField);
        Mnemonics.setLocalizedText((JLabel)this.fxmlLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_FXML_lbl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.fxmlLabel, gridBagConstraints);
        this.fxmlLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_fxmlLabel"));
        this.fxmlLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_fxmlLabel"));
        this.fxmlTextField.setText("Sample");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.fxmlTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 13, 0);
        this.add((Component)this.jSeparator2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnLibFolder, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Browse_Button"));
        this.btnLibFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.btnLibFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 768;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.jPanel1.add((Component)this.btnLibFolder, gridBagConstraints);
        this.btnLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_browseLibraries"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"HINT_LibrariesFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel1.add((Component)this.lblHint, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.2;
        this.jPanel1.add((Component)this.txtLibFolder, gridBagConstraints);
        this.txtLibFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_LibrariesLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.add((Component)this.filler1, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_PanelOptions_Progress_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.progressLabel, gridBagConstraints);
        this.progressLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_progressLabel"));
        this.progressLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_progressLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.progressPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void cbSharableActionPerformed(ActionEvent evt) {
        this.txtLibFolder.setEnabled(this.cbSharable.isSelected());
        this.btnLibFolder.setEnabled(this.cbSharable.isSelected());
        this.lblHint.setEnabled(this.cbSharable.isSelected());
        this.lblLibFolder.setEnabled(this.cbSharable.isSelected());
        if (this.cbSharable.isSelected()) {
            this.txtLibFolder.setText(this.currentLibrariesLocation);
        } else {
            this.txtLibFolder.setText("");
        }
    }

    private void btnLibFolderActionPerformed(ActionEvent evt) {
        File f = FileUtil.normalizeFile((File)new File(this.projectLocation + File.separatorChar + "project_folder"));
        String curr = SharableLibrariesUtils.browseForLibraryLocation((String)this.txtLibFolder.getText().trim(), (Component)this, (File)f);
        if (curr != null) {
            this.currentLibrariesLocation = curr;
            if (this.cbSharable.isSelected()) {
                this.txtLibFolder.setText(this.currentLibrariesLocation);
            }
        }
    }

    private void btnManagePlatformsActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)this.getSelectedPlatform());
    }

    private void platformComboBoxItemStateChanged(ItemEvent evt) {
        this.panel.fireChangeEvent();
    }

    private void preloaderCheckBoxItemStateChanged(ItemEvent evt) {
        this.txtPreloaderProject.setEnabled(this.preloaderCheckBox.isSelected());
    }

    private void createMainCheckBoxItemStateChanged(ItemEvent evt) {
        lastMainClassCheck = this.createMainCheckBox.isSelected();
        this.mainClassTextField.setEnabled(lastMainClassCheck);
        this.panel.fireChangeEvent();
    }

    private void setBottomPanelAreaVisible(boolean visible) {
        this.cbSharable.setVisible(visible);
        this.lblLibFolder.setVisible(visible);
        this.jPanel1.setVisible(visible);
        this.txtLibFolder.setVisible(visible);
        this.btnLibFolder.setVisible(visible);
        this.lblHint.setVisible(visible);
        this.createMainCheckBox.setVisible(visible);
        this.mainClassTextField.setVisible(visible);
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        if (this.task != null) {
            this.setBottomPanelAreaVisible(false);
            return false;
        }
        if (this.task == null && this.detectPlatformTaskPerformed && !JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)this.getSelectedPlatform())) {
            this.setBottomPanelAreaVisible(false);
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.notFXPlatform"));
            return false;
        }
        this.setBottomPanelAreaVisible(true);
        if (this.cbSharable.isSelected()) {
            String location = this.txtLibFolder.getText();
            if (this.projectLocation != null) {
                if (new File(location).isAbsolute()) {
                    settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.absolutePath"));
                } else {
                    File projectLoc = FileUtil.normalizeFile((File)new File(this.projectLocation));
                    File libLoc = PropertyUtils.resolveFile((File)projectLoc, (String)location);
                    if (!CollocationQuery.areCollocated((URI)projectLoc.toURI(), (URI)libLoc.toURI())) {
                        settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WARN_PanelOptionsVisual.relativePath"));
                    }
                }
            }
        }
        if (this.mainClassTextField.isVisible() && this.mainClassTextField.isEnabled()) {
            if (!this.isMainClassValid) {
                settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalMainClassName"));
            }
            return this.isMainClassValid;
        }
        if (this.txtPreloaderProject.isVisible() && this.txtPreloaderProject.isEnabled()) {
            if (!this.isPreloaderNameValid) {
                settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalPreloaderProjectName"));
            }
            return this.isPreloaderNameValid;
        }
        if (this.fxmlTextField.isVisible()) {
            if (!this.isFXMLNameValid) {
                settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"ERROR_IllegalFXMLName"));
            }
            return this.isFXMLNameValid;
        }
        return true;
    }

    @Override
    synchronized void read(WizardDescriptor d) {
        if (this.task == null) {
            this.checkPlatforms();
        }
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty("mainClass", this.createMainCheckBox.isSelected() && this.createMainCheckBox.isVisible() ? this.mainClassTextField.getText() : null);
        d.putProperty("sharedLibraries", this.cbSharable.isSelected() ? this.txtLibFolder.getText() : null);
        String platformName = (String)this.getSelectedPlatform().getProperties().get("platform.ant.name");
        d.putProperty("java.platform.name", (Object)platformName);
        if (this.preloaderCheckBox.isSelected()) {
            d.putProperty("preloaderName", (Object)this.txtPreloaderProject.getText());
        }
        if (this.fxmlTextField.isVisible()) {
            d.putProperty("fxmlName", (Object)this.fxmlTextField.getText());
        }
    }

    private void mainClassChanged() {
        String mainClassName = this.mainClassTextField.getText();
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        boolean isValid = true;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && Utilities.isJavaIdentifier((String)token)) continue;
            isValid = false;
            break;
        }
        this.isMainClassValid = isValid;
        this.panel.fireChangeEvent();
    }

    private void fxmlNameChanged() {
        String fxmlName = this.fxmlTextField.getText();
        this.isFXMLNameValid = !fxmlName.isEmpty() && Utilities.isJavaIdentifier((String)fxmlName);
        this.panel.fireChangeEvent();
    }

    private void librariesLocationChanged() {
        this.panel.fireChangeEvent();
    }

    private void preloaderNameChanged() {
        String name = this.txtPreloaderProject.getText();
        this.isPreloaderNameValid = !JavaFXProjectWizardIterator.isIllegalProjectName(name);
        this.panel.fireChangeEvent();
    }

    private void checkPlatforms() {
        if (!JavaFXPlatformUtils.isThereAnyJavaFXPlatform()) {
            this.task = RequestProcessor.getDefault().create((Runnable)this.detectPlatformTask);
            this.task.addTaskListener((TaskListener)this);
            this.progressPanel.setVisible(true);
            this.progressLabel.setVisible(true);
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_SetupFXPlatformProgress"));
            this.progressPanel.removeAll();
            this.progressPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = -1;
            c.gridx = -1;
            c.gridwidth = 0;
            c.gridheight = 0;
            c.fill = 2;
            c.weightx = 1.0;
            JComponent pc = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
            ((GridBagLayout)this.progressPanel.getLayout()).setConstraints(pc, c);
            this.progressPanel.add(pc);
            this.progressHandle.start();
            this.task.schedule(0);
        }
    }

    public synchronized void taskFinished(Task task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                assert (PanelOptionsVisual.this.progressHandle != null);
                PanelOptionsVisual.this.progressHandle.finish();
                PanelOptionsVisual.this.progressPanel.setVisible(false);
                PanelOptionsVisual.this.progressLabel.setVisible(false);
                JavaPlatform platform = PanelOptionsVisual.this.detectPlatformTask.getPlatform();
                if (platform != null) {
                    PanelOptionsVisual.this.platformComboBox.setModel(PanelOptionsVisual.this.platformsModel);
                    PanelOptionsVisual.this.selectJavaFXEnabledPlatform();
                }
                PanelOptionsVisual.this.detectPlatformTaskPerformed = true;
                PanelOptionsVisual.this.panel.fireChangeEvent();
            }
        });
        this.task.removeTaskListener((TaskListener)this);
        this.task = null;
    }

    private class DetectPlatformTask
    implements Runnable {
        private JavaPlatform platform = null;

        private DetectPlatformTask() {
        }

        public JavaPlatform getPlatform() {
            return this.platform;
        }

        @Override
        public void run() {
            try {
                this.platform = JavaFXPlatformUtils.createDefaultJavaFXPlatform();
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Can't create Java Platform instance: {0}", ex);
            }
        }
    }

    private class JavaPlatformChangeListener
    implements PropertyChangeListener {
        private JavaPlatformChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PanelOptionsVisual.this.panel.fireChangeEvent();
        }
    }
}

