/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.JFXProjectConfigurations;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.ui.CustomizerJarComponent;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class JFXProjectProperties {
    private static final Logger LOG = Logger.getLogger(JFXProjectProperties.class.getName());
    public static final String JAVAFX_ENABLED = "javafx.enabled";
    public static final String JAVAFX_PRELOADER = "javafx.preloader";
    public static final String JAVAFX_SWING = "javafx.swing";
    public static final String JAVAFX_DISABLE_AUTOUPDATE = "javafx.disable.autoupdate";
    public static final String JAVAFX_DISABLE_AUTOUPDATE_NOTIFICATION = "javafx.disable.autoupdate.notification";
    public static final String JAVAFX_DISABLE_CONCURRENT_RUNS = "javafx.disable.concurrent.runs";
    public static final String JAVAFX_ENABLE_CONCURRENT_EXTERNAL_RUNS = "javafx.enable.concurrent.external.runs";
    public static final String JAVAFX_ENDORSED_ANT_CLASSPATH = "endorsed.javafx.ant.classpath";
    public static final String FXML_EXTENSION = "fxml";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_ADDITIONALPARAM = "javadoc.additionalparam";
    public static final String BUILD_SCRIPT = "buildfile";
    public static final String DIST_JAR = "dist.jar";
    public static final String JAVAFX_BINARY_ENCODE_CSS = "javafx.binarycss";
    public static final String JAVAFX_DEPLOY_INCLUDEDT = "javafx.deploy.includeDT";
    public static final String JAVAFX_DEPLOY_EMBEDJNLP = "javafx.deploy.embedJNLP";
    public static final String JAVAFX_REBASE_LIBS = "javafx.rebase.libs";
    public static final String MAIN_CLASS = "javafx.main.class";
    public static final String APPLICATION_ARGS = "application.args";
    public static final String APP_PARAM_PREFIX = "javafx.param.";
    public static final String[] APP_PARAM_SUFFIXES = JFXProjectConfigurations.APP_PARAM_SUFFIXES;
    public static final String RUN_JVM_ARGS = "run.jvmargs";
    public static final String FALLBACK_CLASS = "javafx.fallback.class";
    public static final String SIGNED_JAR = "dist.signed.jar";
    public static final String PRELOADER_ENABLED = "javafx.preloader.enabled";
    public static final String PRELOADER_TYPE = "javafx.preloader.type";
    public static final String PRELOADER_PROJECT = "javafx.preloader.project.path";
    public static final String PRELOADER_CLASS = "javafx.preloader.class";
    public static final String PRELOADER_JAR_FILENAME = "javafx.preloader.jar.filename";
    public static final String PRELOADER_JAR_PATH = "javafx.preloader.jar.path";
    public static final String RUN_WORK_DIR = "work.dir";
    public static final String RUN_APP_WIDTH = "javafx.run.width";
    public static final String RUN_APP_HEIGHT = "javafx.run.height";
    public static final String RUN_IN_HTMLTEMPLATE = "javafx.run.htmltemplate";
    public static final String RUN_IN_HTMLTEMPLATE_PROCESSED = "javafx.run.htmltemplate.processed";
    public static final String RUN_IN_BROWSER = "javafx.run.inbrowser";
    public static final String RUN_IN_BROWSER_PATH = "javafx.run.inbrowser.path";
    public static final String RUN_IN_BROWSER_ARGUMENTS = "javafx.run.inbrowser.arguments";
    public static final String RUN_IN_BROWSER_UNDEFINED = "undefined";
    public static final String RUN_AS = "javafx.run.as";
    public static final String DEFAULT_APP_WIDTH = "800";
    public static final String DEFAULT_APP_HEIGHT = "600";
    public static final String UPDATE_MODE_BACKGROUND = "javafx.deploy.backgroundupdate";
    public static final String ALLOW_OFFLINE = "javafx.deploy.allowoffline";
    public static final String INSTALL_PERMANENTLY = "javafx.deploy.installpermanently";
    public static final String ADD_DESKTOP_SHORTCUT = "javafx.deploy.adddesktopshortcut";
    public static final String ADD_STARTMENU_SHORTCUT = "javafx.deploy.addstartmenushortcut";
    public static final String ICON_FILE = "javafx.deploy.icon";
    public static final String PERMISSIONS_ELEVATED = "javafx.deploy.permissionselevated";
    public static final String JAVAFX_SIGNING_ENABLED = "javafx.signing.enabled";
    public static final String JAVAFX_SIGNING_TYPE = "javafx.signing.type";
    public static final String JAVAFX_SIGNING_KEYSTORE = "javafx.signing.keystore";
    public static final String JAVAFX_SIGNING_KEYSTORE_PASSWORD = "javafx.signing.keystore.password";
    public static final String JAVAFX_SIGNING_KEY = "javafx.signing.keyalias";
    public static final String JAVAFX_SIGNING_KEY_PASSWORD = "javafx.signing.keyalias.password";
    public static final String JAVAFX_NATIVE_BUNDLING_ENABLED = "javafx.native.bundling.enabled";
    public static final String JAVAFX_NATIVE_BUNDLING_TYPE = "javafx.native.bundling.type";
    public static final String RUN_CP = "run.classpath";
    public static final String BUILD_CLASSES = "build.classes.dir";
    public static final String DOWNLOAD_MODE_LAZY_JARS = "download.mode.lazy.jars";
    private static final String DOWNLOAD_MODE_LAZY_JAR = "download.mode.lazy.jar.";
    private static final String DOWNLOAD_MODE_LAZY_FORMAT = "download.mode.lazy.jar.%s";
    public static final String JAVASCRIPT_CALLBACK_PREFIX = "javafx.jscallback.";
    public static final String PROJECT_CONFIGS_DIR = "nbproject/configs";
    public static final String PROJECT_PRIVATE_CONFIGS_DIR = "nbproject/private/configs";
    public static final String PROPERTIES_FILE_EXT = "properties";
    public static final String CONFIG_PROPERTIES_FILE = "nbproject/private/config.properties";
    public static final String DEFAULT_CONFIG = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.default.label");
    public static final String DEFAULT_CONFIG_STANDALONE = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.standalone.label");
    public static final String DEFAULT_CONFIG_WEBSTART = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.webstart.label");
    public static final String DEFAULT_CONFIG_BROWSER = NbBundle.getBundle((String)"org.netbeans.modules.javafx2.project.ui.Bundle").getString("JFXConfigurationProvider.browser.label");
    private StoreGroup fxPropGroup = new StoreGroup();
    JToggleButton.ToggleButtonModel binaryEncodeCSS;
    private CustomizerJarComponent jarComponent = null;
    private JFXConfigs CONFIGS = null;
    private Map<String, String> browserPaths = null;
    PreloaderClassComboBoxModel preloaderClassModel;
    JToggleButton.ToggleButtonModel runStandalone;
    JToggleButton.ToggleButtonModel runAsWebStart;
    JToggleButton.ToggleButtonModel runInBrowser;
    JToggleButton.ToggleButtonModel allowOfflineModel;
    JToggleButton.ToggleButtonModel backgroundUpdateCheck;
    JToggleButton.ToggleButtonModel installPermanently;
    JToggleButton.ToggleButtonModel addDesktopShortcut;
    JToggleButton.ToggleButtonModel addStartMenuShortcut;
    Document iconDocument;
    boolean signingEnabled;
    SigningType signingType;
    String signingKeyStore;
    String signingKeyAlias;
    boolean permissionsElevated;
    char[] signingKeyStorePassword;
    char[] signingKeyPassword;
    boolean nativeBundlingEnabled;
    BundlingType nativeBundlingType;
    List<? extends File> runtimeCP;
    List<? extends File> lazyJars;
    boolean lazyJarsChanged;
    Map<String, String> jsCallbacks;
    boolean jsCallbacksChanged;
    private J2SEPropertyEvaluator j2sePropEval;
    private PropertyEvaluator evaluator;
    private Project project;
    private static Map<String, JFXProjectProperties> propInstance = new HashMap<String, JFXProjectProperties>();
    private Set<String> instanceMarkers = new TreeSet<String>();
    private static Map<String, Set<PreloaderArtifact>> prelArtifacts = new HashMap<String, Set<PreloaderArtifact>>();

    public JToggleButton.ToggleButtonModel getBinaryEncodeCSSModel() {
        return this.binaryEncodeCSS;
    }

    public CustomizerJarComponent getCustomizerJarComponent() {
        if (this.jarComponent == null) {
            this.jarComponent = new CustomizerJarComponent(this);
        }
        return this.jarComponent;
    }

    public JFXConfigs getConfigs() {
        return this.CONFIGS;
    }

    public Map<String, String> getBrowserPaths() {
        return this.browserPaths;
    }

    public void resetBrowserPaths() {
        this.browserPaths = new HashMap<String, String>();
    }

    public void setBrowserPaths(Map<String, String> browserPaths) {
        this.browserPaths = browserPaths;
    }

    public PreloaderClassComboBoxModel getPreloaderClassModel() {
        return this.preloaderClassModel;
    }

    public JToggleButton.ToggleButtonModel getAllowOfflineModel() {
        return this.allowOfflineModel;
    }

    public JToggleButton.ToggleButtonModel getBackgroundUpdateCheckModel() {
        return this.backgroundUpdateCheck;
    }

    public JToggleButton.ToggleButtonModel getInstallPermanentlyModel() {
        return this.installPermanently;
    }

    public JToggleButton.ToggleButtonModel getAddDesktopShortcutModel() {
        return this.addDesktopShortcut;
    }

    public JToggleButton.ToggleButtonModel getAddStartMenuShortcutModel() {
        return this.addStartMenuShortcut;
    }

    public Document getIconDocumentModel() {
        return this.iconDocument;
    }

    public boolean getSigningEnabled() {
        return this.signingEnabled;
    }

    public void setSigningEnabled(boolean enabled) {
        this.signingEnabled = enabled;
    }

    public boolean getPermissionsElevated() {
        return this.permissionsElevated;
    }

    public void setPermissionsElevated(boolean enabled) {
        this.permissionsElevated = enabled;
    }

    public SigningType getSigningType() {
        return this.signingType;
    }

    public void setSigningType(SigningType type) {
        this.signingType = type;
    }

    public String getSigningKeyStore() {
        return this.signingKeyStore;
    }

    public String getSigningKeyAlias() {
        return this.signingKeyAlias;
    }

    public char[] getSigningKeyStorePassword() {
        return this.signingKeyStorePassword;
    }

    public char[] getSigningKeyPassword() {
        return this.signingKeyPassword;
    }

    public void setSigningKeyAlias(String signingKeyAlias) {
        this.signingKeyAlias = signingKeyAlias;
    }

    public void setSigningKeyPassword(char[] signingKeyPassword) {
        this.signingKeyPassword = signingKeyPassword;
    }

    public void setSigningKeyStore(String signingKeyStore) {
        this.signingKeyStore = signingKeyStore;
    }

    public void setSigningKeyStorePassword(char[] signingKeyStorePassword) {
        this.signingKeyStorePassword = signingKeyStorePassword;
    }

    public boolean getNativeBundlingEnabled() {
        return this.nativeBundlingEnabled;
    }

    public void setNativeBundlingEnabled(boolean enabled) {
        this.nativeBundlingEnabled = enabled;
    }

    public BundlingType getNativeBundlingType() {
        return this.nativeBundlingType;
    }

    public void setNativeBundlingType(BundlingType type) {
        this.nativeBundlingType = type;
    }

    public boolean setNativeBundlingType(String type) {
        for (BundlingType bundleType : BundlingType.values()) {
            if (!bundleType.getString().equalsIgnoreCase(type)) continue;
            this.nativeBundlingType = bundleType;
            return true;
        }
        return false;
    }

    public List<? extends File> getRuntimeCP() {
        return this.runtimeCP;
    }

    public List<? extends File> getLazyJars() {
        return this.lazyJars;
    }

    public void setLazyJars(List<? extends File> newLazyJars) {
        this.lazyJars = newLazyJars;
    }

    public boolean getLazyJarsChanged() {
        return this.lazyJarsChanged;
    }

    public void setLazyJarsChanged(boolean changed) {
        this.lazyJarsChanged = changed;
    }

    public Map<String, String> getJSCallbacks() {
        return this.jsCallbacks;
    }

    public void setJSCallbacks(Map<String, String> newCallbacks) {
        this.jsCallbacks = newCallbacks;
    }

    public boolean getJSCallbacksChanged() {
        return this.jsCallbacksChanged;
    }

    public void setJSCallbacksChanged(boolean changed) {
        this.jsCallbacksChanged = changed;
    }

    public Project getProject() {
        return this.project;
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void markInstance(@NonNull String marker) {
        this.instanceMarkers.add(marker);
    }

    public boolean isInstanceMarked(@NonNull String marker) {
        return this.instanceMarkers.contains(marker);
    }

    public static JFXProjectProperties getInstance(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop == null) {
            prop = new JFXProjectProperties(context);
            propInstance.put(projDir, prop);
        }
        return prop;
    }

    @Deprecated
    public static JFXProjectProperties getInstancePerSession(Lookup context, String category) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop != null) {
            if (prop.isInstanceMarked(category)) {
                prop = null;
            } else {
                prop.markInstance(category);
            }
        }
        if (prop == null) {
            prop = new JFXProjectProperties(context);
            propInstance.put(projDir, prop);
            prop.markInstance(category);
        }
        return prop;
    }

    public static JFXProjectProperties getInstanceIfExists(Project proj) {
        assert (proj != null);
        String projDir = proj.getProjectDirectory().getPath();
        JFXProjectProperties prop = propInstance.get(projDir);
        if (prop != null) {
            return prop;
        }
        return null;
    }

    public static JFXProjectProperties getInstanceIfExists(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        return JFXProjectProperties.getInstanceIfExists(proj);
    }

    public static void cleanup(Lookup context) {
        Project proj = (Project)context.lookup(Project.class);
        String projDir = proj.getProjectDirectory().getPath();
        propInstance.remove(projDir);
    }

    private static Set<PreloaderArtifact> getPreloaderArtifacts(@NonNull Project proj) {
        String projDir = proj.getProjectDirectory().getPath();
        Set<PreloaderArtifact> prels = prelArtifacts.get(projDir);
        if (prels == null) {
            prels = new HashSet<PreloaderArtifact>();
            prelArtifacts.put(projDir, prels);
        }
        return prels;
    }

    private JFXProjectProperties(Lookup context) {
        this.project = (Project)context.lookup(Project.class);
        if (this.project != null) {
            this.j2sePropEval = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class);
            this.evaluator = this.j2sePropEval.evaluator();
            this.binaryEncodeCSS = this.fxPropGroup.createToggleButtonModel(this.evaluator, JAVAFX_BINARY_ENCODE_CSS);
            this.allowOfflineModel = this.fxPropGroup.createToggleButtonModel(this.evaluator, ALLOW_OFFLINE);
            this.backgroundUpdateCheck = this.fxPropGroup.createToggleButtonModel(this.evaluator, UPDATE_MODE_BACKGROUND);
            this.installPermanently = this.fxPropGroup.createToggleButtonModel(this.evaluator, INSTALL_PERMANENTLY);
            this.addDesktopShortcut = this.fxPropGroup.createToggleButtonModel(this.evaluator, ADD_DESKTOP_SHORTCUT);
            this.addStartMenuShortcut = this.fxPropGroup.createToggleButtonModel(this.evaluator, ADD_STARTMENU_SHORTCUT);
            this.iconDocument = this.fxPropGroup.createStringDocument(this.evaluator, ICON_FILE);
            this.CONFIGS = new JFXConfigs();
            this.CONFIGS.read();
            this.initPreloaderArtifacts(this.project, this.CONFIGS);
            this.CONFIGS.setActive(this.evaluator.getProperty("config"));
            this.preloaderClassModel = new PreloaderClassComboBoxModel();
            this.initSigning(this.evaluator);
            this.initNativeBundling(this.evaluator);
            this.initResources(this.evaluator, this.project, this.CONFIGS);
            this.initJSCallbacks(this.evaluator);
        }
    }

    public static boolean isTrue(String value) {
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public static boolean isNonEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean isEqual(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2);
    }

    public static boolean isEqualIgnoreCase(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    public static boolean isEqualText(String s1, String s2) {
        return (s1 == null || s1.isEmpty()) && (s2 == null || s2.isEmpty()) || s1 != null && s2 != null && s1.equals(s2);
    }

    private FileObject getSrcRoot(@NonNull Project project) {
        FileObject srcRoot = null;
        for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            if (JFXProjectProperties.isTest(sg.getRootFolder(), project)) continue;
            srcRoot = sg.getRootFolder();
            break;
        }
        return srcRoot;
    }

    private void initPreloaderArtifacts(@NonNull Project project, @NonNull JFXConfigs configs) {
        Set<PreloaderArtifact> prels = JFXProjectProperties.getPreloaderArtifacts(project);
        prels.clear();
        try {
            prels.addAll(this.getPreloaderArtifactsFromConfigs(configs));
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public boolean hasPreloaderInAnyConfig() {
        return this.hasPreloaderInAnyConfig(this.CONFIGS);
    }

    private boolean hasPreloaderInAnyConfig(@NonNull JFXConfigs configs) {
        if (configs != null) {
            for (String config : configs.getConfigNames()) {
                if (!JFXProjectProperties.isTrue(configs.getProperty(config, PRELOADER_ENABLED))) continue;
                return true;
            }
        }
        return false;
    }

    private PreloaderArtifact getPreloaderArtifactFromConfig(@NonNull JFXConfigs configs, @NonNull String config, boolean transparent) throws IOException {
        if (configs.hasConfig(config)) {
            String prelProjDir;
            PreloaderArtifact preloader = null;
            if (!JFXProjectProperties.isTrue(transparent ? configs.getPropertyTransparent(config, PRELOADER_ENABLED) : configs.getProperty(config, PRELOADER_ENABLED))) {
                return null;
            }
            String prelTypeString = transparent ? configs.getPropertyTransparent(config, PRELOADER_TYPE) : configs.getProperty(config, PRELOADER_TYPE);
            String string = prelProjDir = transparent ? configs.getPropertyTransparent(config, PRELOADER_PROJECT) : configs.getProperty(config, PRELOADER_PROJECT);
            if (prelProjDir != null && JFXProjectProperties.isEqualIgnoreCase(prelTypeString, PreloaderSourceType.PROJECT.getString())) {
                FileObject srcRoot;
                FileObject thisProjDir = this.project.getProjectDirectory();
                FileObject fo = JFXProjectUtils.getFileObject(thisProjDir, prelProjDir);
                File prelProjDirF = fo == null ? null : FileUtil.toFile((FileObject)fo);
                if (JFXProjectProperties.isTrue(transparent ? configs.getPropertyTransparent(config, PRELOADER_ENABLED) : configs.getProperty(config, PRELOADER_ENABLED)) && prelProjDirF != null && prelProjDirF.exists() && (srcRoot = this.getSrcRoot(this.getProject())) != null) {
                    prelProjDirF = FileUtil.normalizeFile((File)prelProjDirF);
                    FileObject prelProjFO = FileUtil.toFileObject((File)prelProjDirF);
                    Project proj = ProjectManager.getDefault().findProject(prelProjFO);
                    AntArtifact[] artifacts = AntArtifactQuery.findArtifactsByType((Project)proj, (String)"jar");
                    ArrayList<URI> allURI = new ArrayList<URI>();
                    for (AntArtifact artifact : artifacts) {
                        allURI.addAll(Arrays.asList(artifact.getArtifactLocations()));
                    }
                    if (!allURI.isEmpty()) {
                        URI[] arrayURI = allURI.toArray(new URI[0]);
                        preloader = new PreloaderProjectArtifact(artifacts, arrayURI, srcRoot, "classpath/compile", prelProjDirF.getAbsolutePath());
                    }
                }
            }
            if (preloader == null) {
                String prelJar;
                String string2 = prelJar = transparent ? configs.getPropertyTransparent(config, PRELOADER_JAR_PATH) : configs.getProperty(config, PRELOADER_JAR_PATH);
                if (prelJar != null && JFXProjectProperties.isEqualIgnoreCase(prelTypeString, PreloaderSourceType.JAR.getString())) {
                    FileObject srcRoot;
                    File prelJarF;
                    FileObject thisProjDir = this.project.getProjectDirectory();
                    FileObject fo = JFXProjectUtils.getFileObject(thisProjDir, prelJar);
                    File file = prelJarF = fo == null ? null : FileUtil.toFile((FileObject)fo);
                    if (prelJarF != null && prelJarF.exists() && (srcRoot = this.getSrcRoot(this.getProject())) != null) {
                        URL[] urls = new URL[]{FileUtil.urlForArchiveOrDir((File)prelJarF)};
                        FileObject[] fos = new FileObject[]{FileUtil.toFileObject((File)prelJarF)};
                        preloader = new PreloaderJarArtifact(urls, fos, srcRoot, "classpath/compile", urls[0].toString());
                    }
                }
            }
            return preloader;
        }
        return null;
    }

    private Set<PreloaderArtifact> getPreloaderArtifactsFromConfigs(@NonNull JFXConfigs configs) throws IOException {
        HashSet<PreloaderArtifact> preloaderArtifacts = new HashSet<PreloaderArtifact>();
        for (String config : configs.getConfigNames()) {
            PreloaderArtifact preloader = this.getPreloaderArtifactFromConfig(configs, config, false);
            if (preloader == null) continue;
            preloaderArtifacts.add(preloader);
        }
        return preloaderArtifacts;
    }

    public void updatePreloaderDependencies() {
        try {
            this.updatePreloaderDependencies(this.CONFIGS);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updatePreloaderDependencies(@NonNull JFXConfigs configs) throws IOException {
        Set<PreloaderArtifact> preloaderArtifacts = JFXProjectProperties.getPreloaderArtifacts(this.getProject());
        for (PreloaderArtifact artifact : preloaderArtifacts) {
            artifact.setValid(false);
        }
        final PreloaderArtifact preloaderActive = this.getPreloaderArtifactFromConfig(configs, configs.getActive(), true);
        for (String config : configs.getConfigNames()) {
            PreloaderArtifact preloader = this.getPreloaderArtifactFromConfig(configs, config, false);
            if (preloader == null) continue;
            boolean updated = false;
            for (PreloaderArtifact a : preloaderArtifacts) {
                if (!a.equals(preloader)) continue;
                a.setValid(true);
                updated = true;
            }
            if (updated) continue;
            preloader.setValid(true);
            preloaderArtifacts.add(preloader);
        }
        HashSet<PreloaderArtifact> toRemove = new HashSet<PreloaderArtifact>();
        for (PreloaderArtifact artifact : preloaderArtifacts) {
            if (preloaderActive != null && preloaderActive.equals(artifact)) continue;
            toRemove.add(artifact);
        }
        if (preloaderActive != null || !toRemove.isEmpty()) {
            final Set toRemoveFinal = Collections.unmodifiableSet(toRemove);
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    if (preloaderActive != null) {
                        try {
                            preloaderActive.addDependency();
                        }
                        catch (IOException e) {
                            LOG.log(Level.SEVERE, "Preloader dependency addition failed.");
                        }
                    }
                    try {
                        for (PreloaderArtifact artifact : toRemoveFinal) {
                            artifact.removeDependency();
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.SEVERE, "Preloader dependency removal failed.");
                    }
                }
            });
        }
        toRemove.clear();
        for (PreloaderArtifact artifact : preloaderArtifacts) {
            if (artifact.isValid()) continue;
            toRemove.add(artifact);
        }
        for (PreloaderArtifact artifact : toRemove) {
            preloaderArtifacts.remove(artifact);
        }
    }

    private static boolean isTest(@NonNull FileObject root, @NonNull Project project) {
        assert (root != null);
        assert (project != null);
        ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject[] srcRoots;
            for (FileObject srcRoot : srcRoots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots()) {
                if (!project.equals(FileOwnerQuery.getOwner((FileObject)srcRoot))) continue;
                return true;
            }
        }
        return false;
    }

    private void storeRest(@NonNull EditableProperties editableProps, @NonNull EditableProperties privProps) {
        editableProps.setProperty(JAVAFX_SIGNING_ENABLED, this.signingEnabled ? "true" : "false");
        editableProps.setProperty(JAVAFX_SIGNING_TYPE, this.signingType.getString());
        this.setOrRemove(editableProps, JAVAFX_SIGNING_KEY, this.signingKeyAlias);
        this.setOrRemove(editableProps, JAVAFX_SIGNING_KEYSTORE, this.signingKeyStore);
        editableProps.setProperty(PERMISSIONS_ELEVATED, this.permissionsElevated ? "true" : "false");
        this.setOrRemove(privProps, JAVAFX_SIGNING_KEYSTORE_PASSWORD, this.signingKeyStorePassword);
        this.setOrRemove(privProps, JAVAFX_SIGNING_KEY_PASSWORD, this.signingKeyPassword);
        editableProps.setProperty(JAVAFX_NATIVE_BUNDLING_ENABLED, this.nativeBundlingEnabled ? "true" : "false");
        editableProps.setProperty(JAVAFX_NATIVE_BUNDLING_TYPE, this.nativeBundlingType.getString().toLowerCase());
        this.storeResources(editableProps);
        this.storeJSCallbacks(editableProps);
        this.storePlatform(editableProps);
    }

    private void setOrRemove(EditableProperties props, String name, char[] value) {
        this.setOrRemove(props, name, value != null ? new String(value) : null);
    }

    private void setOrRemove(@NonNull EditableProperties props, @NonNull String name, String value) {
        if (value != null) {
            props.setProperty(name, value);
        } else {
            props.remove((Object)name);
        }
    }

    public void store() throws IOException {
        this.updatePreloaderDependencies(this.CONFIGS);
        this.CONFIGS.storeActive();
        final EditableProperties ep = new EditableProperties(true);
        final FileObject projPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final EditableProperties pep = new EditableProperties(true);
        final FileObject privPropsFO = this.project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        try {
            final InputStream is = projPropsFO.getInputStream();
            final InputStream pis = privPropsFO.getInputStream();
            ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    try {
                        ep.load(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    try {
                        pep.load(pis);
                    }
                    finally {
                        if (pis != null) {
                            pis.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
        this.fxPropGroup.store(ep);
        this.storeRest(ep, pep);
        this.CONFIGS.store(ep, pep);
        this.updatePreloaderComment(ep);
        JFXProjectProperties.logProps(ep);
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = projPropsFO.lock();
                        os = projPropsFO.getOutputStream(lock);
                        ep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    try {
                        lock = privPropsFO.lock();
                        os = privPropsFO.getOutputStream(lock);
                        pep.store(os);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    private void updatePreloaderComment(EditableProperties ep) {
        if (JFXProjectProperties.isTrue(ep.get((Object)PRELOADER_ENABLED))) {
            ep.setComment(PRELOADER_ENABLED, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_use_preloader")}, false);
        } else {
            ep.setComment(PRELOADER_ENABLED, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_dontuse_preloader")}, false);
        }
    }

    private void initSigning(PropertyEvaluator eval) {
        String enabled = eval.getProperty(JAVAFX_SIGNING_ENABLED);
        String signedProp = eval.getProperty(JAVAFX_SIGNING_TYPE);
        this.signingEnabled = JFXProjectProperties.isTrue(enabled);
        this.signingType = signedProp == null ? SigningType.NOSIGN : (signedProp.equalsIgnoreCase(SigningType.SELF.getString()) ? SigningType.SELF : (signedProp.equalsIgnoreCase(SigningType.KEY.getString()) ? SigningType.KEY : SigningType.NOSIGN));
        this.signingKeyStore = eval.getProperty(JAVAFX_SIGNING_KEYSTORE);
        this.signingKeyAlias = eval.getProperty(JAVAFX_SIGNING_KEY);
        if (eval.getProperty(JAVAFX_SIGNING_KEYSTORE_PASSWORD) != null) {
            this.signingKeyStorePassword = eval.getProperty(JAVAFX_SIGNING_KEYSTORE_PASSWORD).toCharArray();
        }
        if (eval.getProperty(JAVAFX_SIGNING_KEY_PASSWORD) != null) {
            this.signingKeyPassword = eval.getProperty(JAVAFX_SIGNING_KEY_PASSWORD).toCharArray();
        }
        this.permissionsElevated = JFXProjectProperties.isTrue(eval.getProperty(PERMISSIONS_ELEVATED));
    }

    private void initNativeBundling(PropertyEvaluator eval) {
        String enabled = eval.getProperty(JAVAFX_NATIVE_BUNDLING_ENABLED);
        String bundleProp = eval.getProperty(JAVAFX_NATIVE_BUNDLING_TYPE);
        this.nativeBundlingEnabled = JFXProjectProperties.isTrue(enabled);
        this.nativeBundlingType = bundleProp == null ? BundlingType.NONE : (bundleProp.equalsIgnoreCase(BundlingType.ALL.getString()) ? BundlingType.ALL : (bundleProp.equalsIgnoreCase(BundlingType.IMAGE.getString()) ? BundlingType.IMAGE : (bundleProp.equalsIgnoreCase(BundlingType.INSTALLER.getString()) ? BundlingType.INSTALLER : BundlingType.NONE)));
    }

    private void initResources(PropertyEvaluator eval, Project prj, JFXConfigs configs) {
        String[] paths;
        String lz = eval.getProperty(DOWNLOAD_MODE_LAZY_JARS);
        String rcp = eval.getProperty(RUN_CP);
        String bc = eval.getProperty(BUILD_CLASSES);
        File prjDir = FileUtil.toFile((FileObject)prj.getProjectDirectory());
        File bcDir = bc == null ? null : PropertyUtils.resolveFile((File)prjDir, (String)bc);
        ArrayList<? extends File> lazyFileList = new ArrayList<File>();
        if (lz != null) {
            for (String p : paths = PropertyUtils.tokenizePath((String)lz)) {
                lazyFileList.add(PropertyUtils.resolveFile((File)prjDir, (String)p));
            }
        }
        paths = PropertyUtils.tokenizePath((String)rcp);
        String mainJar = eval.getProperty(DIST_JAR);
        File mainFile = PropertyUtils.resolveFile((File)prjDir, (String)mainJar);
        ArrayList<FileObject> preloaders = new ArrayList<FileObject>();
        try {
            for (PreloaderArtifact pa : this.getPreloaderArtifactsFromConfigs(configs)) {
                preloaders.addAll(Arrays.asList(pa.getFileObjects()));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        ArrayList<? extends File> resFileList = new ArrayList<File>(paths.length);
        for (String p : paths) {
            File f;
            if (p.startsWith("${") && p.endsWith("}") || (f = PropertyUtils.resolveFile((File)prjDir, (String)p)).equals(mainFile)) continue;
            boolean isPrel = false;
            for (FileObject prelfo : preloaders) {
                File prelf = FileUtil.toFile((FileObject)prelfo);
                if (prelf == null || !prelf.equals(f)) continue;
                isPrel = true;
            }
            if (isPrel || bc != null && bcDir.equals(f)) continue;
            resFileList.add(f);
            if (!JFXProjectProperties.isTrue(eval.getProperty(String.format(DOWNLOAD_MODE_LAZY_FORMAT, f.getName())))) continue;
            lazyFileList.add(f);
        }
        this.lazyJars = lazyFileList;
        this.runtimeCP = resFileList;
        this.lazyJarsChanged = false;
    }

    private void storeResources(EditableProperties props) {
        if (this.lazyJarsChanged) {
            props.remove((Object)DOWNLOAD_MODE_LAZY_JARS);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                if (!((String)((Map.Entry)it.next()).getKey()).startsWith(DOWNLOAD_MODE_LAZY_JAR)) continue;
                it.remove();
            }
            for (File file : this.lazyJars) {
                props.setProperty(String.format(DOWNLOAD_MODE_LAZY_FORMAT, file.getName()), "true");
            }
        }
    }

    private void initJSCallbacks(PropertyEvaluator eval) {
        String platformName = eval.getProperty("platform.active");
        Map<String, List<String>> callbacks = JFXProjectUtils.getJSCallbacks(platformName);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : callbacks.entrySet()) {
            String v = eval.getProperty(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey());
            if (v == null || v.isEmpty()) continue;
            result.put(entry.getKey(), v);
        }
        this.jsCallbacks = result;
        this.jsCallbacksChanged = false;
    }

    private void storeJSCallbacks(EditableProperties props) {
        if (this.jsCallbacksChanged && this.jsCallbacks != null) {
            for (Map.Entry<String, String> entry : this.jsCallbacks.entrySet()) {
                if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                    props.setProperty(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey(), entry.getValue());
                    continue;
                }
                props.remove((Object)(JAVASCRIPT_CALLBACK_PREFIX + entry.getKey()));
            }
        }
    }

    private void storePlatform(EditableProperties editableProps) {
        JavaPlatform[] installedPlatforms;
        String activePlatform = editableProps.getProperty("platform.active");
        for (JavaPlatform javaPlatform : installedPlatforms = JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String platformName = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (!JFXProjectProperties.isEqual(platformName, activePlatform) || !JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)javaPlatform)) continue;
            editableProps.setProperty("javafx.sdk", JavaFXPlatformUtils.getJavaFXSDKPathReference((String)activePlatform));
            editableProps.setProperty("javafx.runtime", JavaFXPlatformUtils.getJavaFXRuntimePathReference((String)activePlatform));
        }
    }

    static void logProps(EditableProperties ep) {
        LOG.log(Level.INFO, "javafx.preloader.enabled = " + (ep.get((Object)PRELOADER_ENABLED) == null ? "null" : ep.get((Object)PRELOADER_ENABLED)));
        LOG.log(Level.INFO, "javafx.preloader.type = " + (ep.get((Object)PRELOADER_TYPE) == null ? "null" : ep.get((Object)PRELOADER_TYPE)));
        LOG.log(Level.INFO, "javafx.preloader.project.path = " + (ep.get((Object)PRELOADER_PROJECT) == null ? "null" : ep.get((Object)PRELOADER_PROJECT)));
        LOG.log(Level.INFO, "javafx.preloader.class = " + (ep.get((Object)PRELOADER_CLASS) == null ? "null" : ep.get((Object)PRELOADER_CLASS)));
        LOG.log(Level.INFO, "javafx.preloader.jar.filename = " + (ep.get((Object)PRELOADER_JAR_FILENAME) == null ? "null" : ep.get((Object)PRELOADER_JAR_FILENAME)));
        LOG.log(Level.INFO, "javafx.preloader.jar.path = " + (ep.get((Object)PRELOADER_JAR_PATH) == null ? "null" : ep.get((Object)PRELOADER_JAR_PATH)));
    }

    public class JFXConfigs
    extends JFXProjectConfigurations {
        private String PRELOADER_GROUP_NAME;
        private List<String> PRELOADER_PROPERTIES;
        private String BROWSER_GROUP_NAME;
        private List<String> BROWSER_PROPERTIES;

        public final List<String> getPreloaderProperties() {
            return Collections.unmodifiableList(this.PRELOADER_PROPERTIES);
        }

        public final List<String> getBrowserProperties() {
            return Collections.unmodifiableList(this.BROWSER_PROPERTIES);
        }

        JFXConfigs() {
            super(JFXProjectProperties.this.project.getProjectDirectory());
            this.PRELOADER_GROUP_NAME = "preloader";
            this.PRELOADER_PROPERTIES = Arrays.asList(JFXProjectProperties.PRELOADER_ENABLED, JFXProjectProperties.PRELOADER_TYPE, JFXProjectProperties.PRELOADER_PROJECT, JFXProjectProperties.PRELOADER_JAR_PATH, JFXProjectProperties.PRELOADER_JAR_FILENAME, JFXProjectProperties.PRELOADER_CLASS);
            this.BROWSER_GROUP_NAME = "browser";
            this.BROWSER_PROPERTIES = Arrays.asList(JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH);
            this.registerProjectProperties(new String[]{"main.class", JFXProjectProperties.MAIN_CLASS, JFXProjectProperties.RUN_JVM_ARGS, JFXProjectProperties.PRELOADER_ENABLED, JFXProjectProperties.PRELOADER_TYPE, JFXProjectProperties.PRELOADER_PROJECT, JFXProjectProperties.PRELOADER_JAR_PATH, JFXProjectProperties.PRELOADER_JAR_FILENAME, JFXProjectProperties.PRELOADER_CLASS, JFXProjectProperties.RUN_WORK_DIR, JFXProjectProperties.RUN_APP_WIDTH, JFXProjectProperties.RUN_APP_HEIGHT, JFXProjectProperties.RUN_IN_HTMLTEMPLATE, JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH, JFXProjectProperties.RUN_AS});
            this.registerPrivateProperties(new String[]{JFXProjectProperties.RUN_WORK_DIR, JFXProjectProperties.RUN_IN_HTMLTEMPLATE, JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH, JFXProjectProperties.RUN_AS});
            this.registerStaticProperties(new String[]{JFXProjectProperties.RUN_AS});
            HashMap<String, String> substituteMissing = new HashMap<String, String>();
            substituteMissing.put(JFXProjectProperties.RUN_APP_WIDTH, JFXProjectProperties.DEFAULT_APP_WIDTH);
            substituteMissing.put(JFXProjectProperties.RUN_APP_HEIGHT, JFXProjectProperties.DEFAULT_APP_HEIGHT);
            this.registerDefaultsIfMissing(substituteMissing);
            this.registerCleanEmptyProjectProperties(new String[]{JFXProjectProperties.MAIN_CLASS, JFXProjectProperties.RUN_JVM_ARGS, JFXProjectProperties.PRELOADER_ENABLED, JFXProjectProperties.PRELOADER_TYPE, JFXProjectProperties.PRELOADER_PROJECT, JFXProjectProperties.PRELOADER_JAR_PATH, JFXProjectProperties.PRELOADER_JAR_FILENAME, JFXProjectProperties.PRELOADER_CLASS, JFXProjectProperties.RUN_APP_WIDTH, JFXProjectProperties.RUN_APP_HEIGHT});
            this.registerCleanEmptyPrivateProperties(new String[]{JFXProjectProperties.RUN_WORK_DIR, JFXProjectProperties.RUN_IN_HTMLTEMPLATE, JFXProjectProperties.RUN_IN_BROWSER, JFXProjectProperties.RUN_IN_BROWSER_PATH});
            this.defineGroup(this.PRELOADER_GROUP_NAME, this.getPreloaderProperties());
            this.defineGroup(this.BROWSER_GROUP_NAME, this.getBrowserProperties());
        }
    }

    class PreloaderJarArtifact
    extends PreloaderArtifact {
        private final String ID;
        private final URL[] classPathRoots;
        private final FileObject[] fileObjects;
        private final FileObject projectArtifact;
        private final String classPathType;

        PreloaderJarArtifact(@NonNull URL[] classPathRoots, @NonNull FileObject[] fileObjects, @NonNull FileObject projectArtifact, @NonNull String classPathType, String ID) {
            this.classPathRoots = classPathRoots;
            this.fileObjects = fileObjects;
            this.projectArtifact = projectArtifact;
            this.classPathType = classPathType;
            this.ID = ID;
        }

        @Override
        public boolean addDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addRoots((URL[])this.classPathRoots, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        @Override
        public boolean removeDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.removeRoots((URL[])this.classPathRoots, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof PreloaderJarArtifact)) {
                return false;
            }
            PreloaderJarArtifact concrete = (PreloaderJarArtifact)that;
            return this.ID.equals(concrete.ID);
        }

        @Override
        final FileObject[] getFileObjects() {
            return this.fileObjects;
        }
    }

    class PreloaderProjectArtifact
    extends PreloaderArtifact {
        private final String ID;
        private final AntArtifact[] artifacts;
        private final URI[] artifactElements;
        private final FileObject projectArtifact;
        private final String classPathType;

        PreloaderProjectArtifact(@NonNull AntArtifact[] artifacts, @NonNull URI[] artifactElements, @NonNull FileObject projectArtifact, @NonNull String classPathType, String ID) {
            this.artifacts = artifacts;
            this.artifactElements = artifactElements;
            this.projectArtifact = projectArtifact;
            this.classPathType = classPathType;
            this.ID = ID;
        }

        @Override
        public boolean addDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addAntArtifacts((AntArtifact[])this.artifacts, (URI[])this.artifactElements, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        @Override
        public boolean removeDependency() throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.removeAntArtifacts((AntArtifact[])this.artifacts, (URI[])this.artifactElements, (FileObject)this.projectArtifact, (String)this.classPathType);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof PreloaderProjectArtifact)) {
                return false;
            }
            PreloaderProjectArtifact concrete = (PreloaderProjectArtifact)that;
            return this.ID.equals(concrete.ID);
        }

        @Override
        final FileObject[] getFileObjects() {
            ArrayList<FileObject> l = new ArrayList<FileObject>();
            for (AntArtifact a : this.artifacts) {
                l.addAll(Arrays.asList(a.getArtifactFiles()));
            }
            return l.toArray(new FileObject[l.size()]);
        }
    }

    abstract class PreloaderArtifact {
        private boolean valid;

        PreloaderArtifact() {
        }

        abstract boolean addDependency() throws IOException, UnsupportedOperationException;

        abstract boolean removeDependency() throws IOException, UnsupportedOperationException;

        abstract FileObject[] getFileObjects();

        void setValid(boolean valid) {
            this.valid = valid;
        }

        boolean isValid() {
            return this.valid;
        }
    }

    public class PreloaderClassComboBoxModel
    extends DefaultComboBoxModel {
        private boolean filling = false;
        private ChangeListener changeListener = null;

        public PreloaderClassComboBoxModel() {
            this.fillNoPreloaderAvailable();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeListener = l;
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeListener = null;
        }

        public final void fillNoPreloaderAvailable() {
            this.removeAllElements();
            this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
        }

        public void fillFromProject(final Project project, final String select, final JFXConfigs configs, final String activeConfig) {
            final Map<FileObject, List<ClassPath>> classpathMap = JFXProjectUtils.getClassPathMap(project);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!PreloaderClassComboBoxModel.this.filling) {
                        PreloaderClassComboBoxModel.this.filling = true;
                        PreloaderClassComboBoxModel.this.removeAllElements();
                        if (project == null) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                            return;
                        }
                        Set<String> appClassNames = JFXProjectUtils.getAppClassNames(classpathMap, "javafx.application.Preloader");
                        if (appClassNames.isEmpty()) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                        } else {
                            PreloaderClassComboBoxModel.this.addElements(appClassNames);
                            if (select != null) {
                                PreloaderClassComboBoxModel.this.setSelectedItem(select);
                            }
                            String verify = (String)PreloaderClassComboBoxModel.this.getSelectedItem();
                            if (!JFXProjectProperties.isEqual(configs.getPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS), verify)) {
                                configs.setPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS, verify);
                            }
                        }
                        if (PreloaderClassComboBoxModel.this.changeListener != null) {
                            PreloaderClassComboBoxModel.this.changeListener.stateChanged(appClassNames.isEmpty() ? null : new ChangeEvent(this));
                        }
                        PreloaderClassComboBoxModel.this.filling = false;
                    }
                }
            });
        }

        public void fillFromJAR(final FileObject jarFile, final String select, final JFXConfigs configs, final String activeConfig) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    if (!PreloaderClassComboBoxModel.this.filling) {
                        PreloaderClassComboBoxModel.this.filling = true;
                        PreloaderClassComboBoxModel.this.removeAllElements();
                        if (jarFile == null) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                            return;
                        }
                        Set<String> appClassNames = JFXProjectUtils.getAppClassNamesInJar(jarFile, "javafx.application.Preloader");
                        appClassNames.remove("com.javafx.main.Main");
                        appClassNames.remove("com.javafx.main.NoJavaFXFallback");
                        if (appClassNames.isEmpty()) {
                            PreloaderClassComboBoxModel.this.addElement(NbBundle.getMessage(JFXProjectProperties.class, (String)"MSG_ComboNoPreloaderClassAvailable"));
                        } else {
                            PreloaderClassComboBoxModel.this.addElements(appClassNames);
                            if (select != null) {
                                PreloaderClassComboBoxModel.this.setSelectedItem(select);
                            }
                            String verify = (String)PreloaderClassComboBoxModel.this.getSelectedItem();
                            if (!JFXProjectProperties.isEqual(configs.getPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS), verify)) {
                                configs.setPropertyTransparent(activeConfig, JFXProjectProperties.PRELOADER_CLASS, verify);
                            }
                        }
                        if (PreloaderClassComboBoxModel.this.changeListener != null) {
                            PreloaderClassComboBoxModel.this.changeListener.stateChanged(appClassNames.isEmpty() ? null : new ChangeEvent(this));
                        }
                        PreloaderClassComboBoxModel.this.filling = false;
                    }
                }
            });
        }

        private void addElements(Set<String> elems) {
            for (String elem : elems) {
                this.addElement(elem);
            }
        }
    }

    public static class PropertiesTableModel
    extends AbstractTableModel {
        private List<Map<String, String>> properties;
        private String[] propSuffixes;
        private String[] columnNames;

        public PropertiesTableModel(List<Map<String, String>> props, String[] sfxs, String[] clmns) {
            if (sfxs.length != clmns.length) {
                throw new IllegalArgumentException();
            }
            this.properties = props;
            this.propSuffixes = sfxs;
            this.columnNames = clmns;
        }

        @Override
        public int getRowCount() {
            return this.properties.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.properties.get(rowIndex).put(this.propSuffixes[columnIndex], (String)aValue);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.properties.get(rowIndex).get(this.propSuffixes[columnIndex]);
        }

        public void addRow() {
            HashMap<String, String> emptyMap = new HashMap<String, String>();
            for (String suffix : this.propSuffixes) {
                emptyMap.put(suffix, "");
            }
            this.properties.add(emptyMap);
        }

        public void removeRow(int index) {
            this.properties.remove(index);
        }
    }

    public static enum BundlingType {
        NONE("None"),
        ALL("All"),
        IMAGE("Image"),
        INSTALLER("Installer");

        private final String propertyValue;

        private BundlingType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }

    public static enum SigningType {
        NOSIGN("notsigned"),
        SELF("self"),
        KEY("key");

        private final String propertyValue;

        private SigningType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }

    public static enum RunAsType {
        STANDALONE("standalone", DEFAULT_CONFIG_STANDALONE),
        ASWEBSTART("webstart", DEFAULT_CONFIG_WEBSTART),
        INBROWSER("embedded", DEFAULT_CONFIG_BROWSER);

        private final String propertyValue;
        private final String defaultConfig;

        private RunAsType(String propertyValue, String defaultConfig) {
            this.propertyValue = propertyValue;
            this.defaultConfig = defaultConfig;
        }

        public String getString() {
            return this.propertyValue;
        }

        public String getDefaultConfig() {
            return this.defaultConfig;
        }
    }

    public static enum PreloaderSourceType {
        NONE("none"),
        PROJECT("project"),
        JAR("jar");

        private final String propertyValue;

        private PreloaderSourceType(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public String getString() {
            return this.propertyValue;
        }
    }
}

