/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JFXProjectConfigurations {
    private static final Logger LOG = Logger.getLogger(JFXProjectConfigurations.class.getName());
    public static final String APPLICATION_ARGS = "application.args";
    public static final String APP_PARAM_PREFIX = "javafx.param.";
    public static final String[] APP_PARAM_SUFFIXES = new String[]{"name", "value"};
    public static final String PROJECT_CONFIGS_DIR = "nbproject/configs";
    public static final String PROJECT_PRIVATE_CONFIGS_DIR = "nbproject/private/configs";
    public static final String PROPERTIES_FILE_EXT = "properties";
    public static final String CONFIG_PROPERTIES_FILE = "nbproject/private/config.properties";
    private Map<String, Map<String, String>> RUN_CONFIGS;
    private Set<String> ERASED_CONFIGS;
    private Map<String, List<Map<String, String>>> APP_PARAMS;
    private BoundedPropertyGroups groups = new BoundedPropertyGroups();
    private String active;
    private FileObject projectDir;
    private List<String> PROJECT_PROPERTIES = new ArrayList<String>();
    private List<String> PRIVATE_PROPERTIES = new ArrayList<String>();
    private List<String> STATIC_PROPERTIES = new ArrayList<String>();
    private Map<String, String> DEFAULT_IF_MISSING = new HashMap<String, String>();
    private List<String> CLEAN_EMPTY_PROJECT_PROPERTIES = new ArrayList<String>();
    private List<String> CLEAN_EMPTY_PRIVATE_PROPERTIES = new ArrayList<String>();

    public static String getSharedConfigFilePath(@NonNull String config) {
        return "nbproject/configs/" + config + "." + PROPERTIES_FILE_EXT;
    }

    public static String getPrivateConfigFilePath(@NonNull String config) {
        return "nbproject/private/configs/" + config + "." + PROPERTIES_FILE_EXT;
    }

    private Comparator<String> getComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            }
        };
    }

    JFXProjectConfigurations(@NonNull FileObject projectDirFO) {
        this.projectDir = projectDirFO;
        this.reset();
    }

    public void registerProjectProperties(String[] props) {
        if (props != null) {
            this.PROJECT_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void registerPrivateProperties(String[] props) {
        if (props != null) {
            this.PRIVATE_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void registerStaticProperties(String[] props) {
        if (props != null) {
            this.STATIC_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void registerDefaultsIfMissing(Map<String, String> defaults) {
        if (defaults != null) {
            this.DEFAULT_IF_MISSING.putAll(defaults);
        }
    }

    public void registerCleanEmptyProjectProperties(String[] props) {
        if (props != null) {
            this.CLEAN_EMPTY_PROJECT_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void registerCleanEmptyPrivateProperties(String[] props) {
        if (props != null) {
            this.CLEAN_EMPTY_PRIVATE_PROPERTIES.addAll(Arrays.asList(props));
        }
    }

    public void resetProjectProperties() {
        this.PROJECT_PROPERTIES.clear();
    }

    public void resetPrivateProperties() {
        this.PRIVATE_PROPERTIES.clear();
    }

    public void resetStaticProperties() {
        this.STATIC_PROPERTIES.clear();
    }

    public void resetDefaultsIfMissing() {
        this.DEFAULT_IF_MISSING.clear();
    }

    public void resetCleanEmptyProjectProperties() {
        this.CLEAN_EMPTY_PROJECT_PROPERTIES.clear();
    }

    public void resetCleanEmptyPrivateProperties() {
        this.CLEAN_EMPTY_PRIVATE_PROPERTIES.clear();
    }

    private void reset() {
        this.RUN_CONFIGS = new TreeMap<String, Map<String, String>>(this.getComparator());
        this.ERASED_CONFIGS = null;
        this.APP_PARAMS = new TreeMap<String, List<Map<String, String>>>(this.getComparator());
    }

    private boolean configNameWrong(String config) {
        return config != null && config.contains("default");
    }

    public final void defineGroup(String groupName, Collection<String> props) {
        this.groups.defineGroup(groupName, props);
    }

    public final void clearGroup(String groupName) {
        this.groups.clearGroup(groupName);
    }

    public final void clearAllGroups() {
        this.groups.clearAllGroups();
    }

    public boolean isBound(String prop) {
        return this.groups.isBound(prop);
    }

    public Collection<String> getBoundedProperties(String prop) {
        return this.groups.getBoundedProperties(prop);
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String config) {
        assert (!this.configNameWrong(config));
        this.active = config;
    }

    public boolean hasConfig(String config) {
        assert (!this.configNameWrong(config));
        return this.RUN_CONFIGS.containsKey(config);
    }

    public boolean isConfigEmpty(String config) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap != null) {
            return configMap.isEmpty();
        }
        return true;
    }

    public boolean isDefaultConfigEmpty() {
        return this.isConfigEmpty(null);
    }

    public boolean isActiveConfigEmpty() {
        return this.isConfigEmpty(this.getActive());
    }

    public Set<String> getConfigNames() {
        return Collections.unmodifiableSet(this.RUN_CONFIGS.keySet());
    }

    private Map<String, String> getConfigUnmodifyable(String config) {
        assert (!this.configNameWrong(config));
        return Collections.unmodifiableMap(this.RUN_CONFIGS.get(config));
    }

    private Map<String, String> getDefaultConfigUnmodifyable() {
        return this.getConfigUnmodifyable(null);
    }

    private Map<String, String> getActiveConfigUnmodifyable() {
        return this.getConfigUnmodifyable(this.getActive());
    }

    private Map<String, String> getConfig(String config) {
        assert (!this.configNameWrong(config));
        return this.RUN_CONFIGS.get(config);
    }

    private Map<String, String> getDefaultConfig() {
        return this.getConfig(null);
    }

    private Map<String, String> getActiveConfig() {
        return this.getConfig(this.getActive());
    }

    private Map<String, String> getConfigNonNull(String config) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap == null) {
            configMap = new TreeMap<String, String>(this.getComparator());
            this.RUN_CONFIGS.put(config, configMap);
        }
        return configMap;
    }

    private Map<String, String> getDefaultConfigNonNull() {
        return this.getConfigNonNull(null);
    }

    private Map<String, String> getActiveConfigNonNull() {
        return this.getConfigNonNull(this.getActive());
    }

    public void addToConfig(String config, Map<String, String> props) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap == null) {
            configMap = new TreeMap<String, String>(this.getComparator());
            this.RUN_CONFIGS.put(config, configMap);
        }
        configMap.putAll(props);
    }

    public void addToDefaultConfig(Map<String, String> props) {
        this.addToConfig(null, props);
    }

    public void addToActiveConfig(Map<String, String> props) {
        this.addToConfig(this.getActive(), props);
    }

    public void addToConfig(String config, EditableProperties props) {
        assert (!this.configNameWrong(config));
        this.addToConfig(config, new HashMap<String, String>((Map<String, String>)props));
    }

    public void addToDefaultConfig(EditableProperties props) {
        this.addToConfig(null, props);
    }

    public void addToActiveConfig(EditableProperties props) {
        this.addToConfig(this.getActive(), props);
    }

    public void eraseConfig(String config) {
        assert (!this.configNameWrong(config));
        assert (config != null);
        this.RUN_CONFIGS.remove(config);
        if (this.ERASED_CONFIGS == null) {
            this.ERASED_CONFIGS = new HashSet<String>();
        }
        this.ERASED_CONFIGS.add(config);
    }

    public boolean isPropertySet(String config, @NonNull String prop) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap != null) {
            return configMap.containsKey(prop);
        }
        return false;
    }

    public boolean isDefaultPropertySet(@NonNull String prop) {
        return this.isPropertySet(null, prop);
    }

    public boolean isActivePropertySet(@NonNull String prop) {
        return this.isPropertySet(this.getActive(), prop);
    }

    private boolean isBoundedToNonemptyProperty(String config, String prop) {
        assert (!this.configNameWrong(config));
        for (String name : this.groups.getBoundedProperties(prop)) {
            if (!this.isPropertySet(config, name)) continue;
            return true;
        }
        return false;
    }

    public String getProperty(String config, @NonNull String prop) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap != null) {
            return configMap.get(prop);
        }
        return null;
    }

    public String getDefaultProperty(@NonNull String prop) {
        return this.getProperty(null, prop);
    }

    public String getActiveProperty(@NonNull String prop) {
        return this.getProperty(this.getActive(), prop);
    }

    public String getPropertyTransparent(String config, @NonNull String prop) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        String value = null;
        if (configMap != null && (value = configMap.get(prop)) == null && config != null) {
            return this.getDefaultProperty(prop);
        }
        return value;
    }

    public String getActivePropertyTransparent(@NonNull String prop) {
        return this.getPropertyTransparent(this.getActive(), prop);
    }

    public void setProperty(String config, @NonNull String prop, String value) {
        this.setPropertyImpl(config, prop, value);
        this.solidifyBoundedGroups(config, prop);
        if (config == null) {
            for (String c : this.getConfigNames()) {
                if (c == null || !JFXProjectProperties.isEqual(this.getProperty(c, prop), value) || this.STATIC_PROPERTIES.contains(prop) || !this.isBoundedPropertiesEraseable(c, prop)) continue;
                this.eraseProperty(c, prop);
            }
        }
    }

    private void setPropertyImpl(String config, @NonNull String prop, String value) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfigNonNull(config);
        configMap.put(prop, value);
    }

    public void setDefaultProperty(@NonNull String prop, String value) {
        this.setProperty(null, prop, value);
    }

    public void setActiveProperty(@NonNull String prop, String value) {
        this.setProperty(this.getActive(), prop, value);
    }

    public void setPropertyTransparent(String config, @NonNull String prop, String value) {
        assert (!this.configNameWrong(config));
        if (config != null && JFXProjectProperties.isEqual(this.getDefaultProperty(prop), value) && (!this.STATIC_PROPERTIES.contains(prop) || !this.isPropertySet(config, prop)) && this.isBoundedPropertiesEraseable(config, prop)) {
            this.eraseProperty(config, prop);
        } else {
            this.setProperty(config, prop, value);
        }
    }

    public void setActivePropertyTransparent(@NonNull String prop, String value) {
        this.setPropertyTransparent(this.getActive(), prop, value);
    }

    public boolean solidifyProperty(String config, @NonNull String prop) {
        if (!this.isPropertySet(config, prop)) {
            if (config != null) {
                this.setPropertyImpl(config, prop, this.getDefaultProperty(prop));
            } else {
                this.setPropertyImpl(null, prop, "");
            }
            return true;
        }
        return false;
    }

    private boolean solidifyBoundedGroups(String config, @NonNull String prop) {
        boolean solidified = false;
        for (String name : this.groups.getBoundedProperties(prop)) {
            solidified |= this.solidifyProperty(config, name);
        }
        return solidified;
    }

    public void eraseProperty(String config, @NonNull String prop) {
        assert (!this.configNameWrong(config));
        Map<String, String> configMap = this.getConfig(config);
        if (configMap != null) {
            configMap.remove(prop);
            for (String name : this.groups.getBoundedProperties(prop)) {
                configMap.remove(name);
            }
        }
    }

    public void eraseDefaultProperty(@NonNull String prop) {
        this.eraseProperty(null, prop);
    }

    public void eraseActiveProperty(@NonNull String prop) {
        this.eraseProperty(this.getActive(), prop);
    }

    private boolean isBoundedPropertiesEraseable(String config, String prop) {
        assert (!this.configNameWrong(config));
        if (config == null) {
            return false;
        }
        boolean canErase = true;
        for (String name : this.groups.getBoundedProperties(prop)) {
            if ((!this.isPropertySet(config, name) || JFXProjectProperties.isEqual(this.getDefaultProperty(name), this.getProperty(config, name))) && !this.STATIC_PROPERTIES.contains(name)) continue;
            canErase = false;
            break;
        }
        return canErase;
    }

    public boolean hasParam(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        return this.getParam(config, name) != null;
    }

    public boolean hasDefaultParam(@NonNull String name) {
        return this.hasParam(null, name);
    }

    public boolean hasActiveParam(@NonNull String name) {
        return this.hasParam(this.getActive(), name);
    }

    public boolean hasParamTransparent(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        return this.getParamTransparent(config, name) != null;
    }

    public boolean hasActiveParamTransparent(@NonNull String name) {
        return this.hasParamTransparent(this.getActive(), name);
    }

    public boolean hasParam(String config, @NonNull String name, @NonNull String value) {
        assert (!this.configNameWrong(config));
        String v = this.getParamValue(config, name);
        return JFXProjectProperties.isEqual(v, value);
    }

    public boolean hasDefaultParam(@NonNull String name, @NonNull String value) {
        return this.hasParam(null, name, value);
    }

    public boolean hasActiveParam(@NonNull String name, @NonNull String value) {
        return this.hasParam(this.getActive(), name, value);
    }

    public boolean hasParamTransparent(String config, @NonNull String name, @NonNull String value) {
        assert (!this.configNameWrong(config));
        String v = this.getParamValueTransparent(config, name);
        return JFXProjectProperties.isEqual(v, value);
    }

    public boolean hasParamValue(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        Map<String, String> param = this.getParam(config, name);
        return param != null && param.containsKey(APP_PARAM_SUFFIXES[1]);
    }

    public boolean hasDefaultParamValue(@NonNull String name) {
        return this.hasParamValue(null, name);
    }

    public boolean hasActiveParamValue(@NonNull String name) {
        return this.hasParamValue(this.getActive(), name);
    }

    public boolean hasParamValueTransparent(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        return config != null && this.hasParamValue(config, name) || this.hasDefaultParamValue(name);
    }

    public boolean hasActiveParamValueTransparent(@NonNull String name) {
        return this.hasParamValueTransparent(this.getActive(), name);
    }

    public Map<String, String> getParam(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        return this.getParam(this.getParams(config), name);
    }

    public Map<String, String> getDefaultParam(@NonNull String name) {
        return this.getParam((String)null, name);
    }

    public Map<String, String> getActiveParam(@NonNull String name) {
        return this.getParam(this.getActive(), name);
    }

    public Map<String, String> getParamTransparent(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        Map<String, String> param = this.getParam(config, name);
        if (param == null) {
            param = this.getDefaultParam(name);
        }
        return param;
    }

    public Map<String, String> getActiveParamTransparent(@NonNull String name) {
        return this.getParamTransparent(this.getActive(), name);
    }

    public String getParamValue(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        Map<String, String> param = this.getParam(config, name);
        if (param != null) {
            return param.get(APP_PARAM_SUFFIXES[1]);
        }
        return null;
    }

    public String getDefaultParamValue(@NonNull String name) {
        return this.getParamValue(null, name);
    }

    public String getActiveParamValue(@NonNull String name) {
        return this.getParamValue(this.getActive(), name);
    }

    public String getParamValueTransparent(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        Map<String, String> param = this.getParam(config, name);
        if (param != null) {
            return param.get(APP_PARAM_SUFFIXES[1]);
        }
        return this.getDefaultParamValue(name);
    }

    public String getActiveParamValueTransparent(@NonNull String name) {
        return this.getParamValueTransparent(this.getActive(), name);
    }

    private List<Map<String, String>> getParams(String config) {
        assert (!this.configNameWrong(config));
        return this.APP_PARAMS.get(config);
    }

    private List<Map<String, String>> getDefaultParams() {
        return this.APP_PARAMS.get(null);
    }

    private List<Map<String, String>> getActiveParams() {
        return this.APP_PARAMS.get(this.getActive());
    }

    private List<Map<String, String>> getParamsTransparent(String config) {
        assert (!this.configNameWrong(config));
        List<Map<String, String>> union = JFXProjectUtils.copyList(this.getDefaultParams());
        if (config != null && this.getParams(config) != null) {
            for (Map<String, String> map : this.getParams(config)) {
                String name = map.get(APP_PARAM_SUFFIXES[0]);
                String value = map.get(APP_PARAM_SUFFIXES[1]);
                if (name == null || name.isEmpty()) continue;
                Map<String, String> old = this.getParam(union, name);
                if (old != null) {
                    old.put(APP_PARAM_SUFFIXES[0], name);
                    old.put(APP_PARAM_SUFFIXES[1], value);
                    continue;
                }
                union.add(map);
            }
        }
        return union;
    }

    public List<Map<String, String>> getActiveParamsTransparent() {
        return this.getParamsTransparent(this.getActive());
    }

    public String getParamsTransparentAsString(String config, boolean commandLine) {
        assert (!this.configNameWrong(config));
        return this.getParamsAsString(this.getParamsTransparent(config), commandLine);
    }

    public String getActiveParamsTransparentAsString(boolean commandLine) {
        return this.getParamsAsString(this.getActiveParamsTransparent(), commandLine);
    }

    public String getParamsAsString(String config, boolean commandLine) {
        return this.getParamsAsString(this.getParams(config), commandLine);
    }

    public String getActiveParamsAsString(boolean commandLine) {
        return this.getParamsAsString(this.getActiveParams(), commandLine);
    }

    public String getDefaultParamsAsString(boolean commandLine) {
        return this.getParamsAsString(this.getDefaultParams(), commandLine);
    }

    private String getParamsAsString(List<Map<String, String>> params, boolean commandLine) {
        StringBuilder sb = new StringBuilder();
        if (params != null) {
            int index = 0;
            for (Map<String, String> m : params) {
                String name = m.get(APP_PARAM_SUFFIXES[0]);
                String value = m.get(APP_PARAM_SUFFIXES[1]);
                if (name == null || name.length() <= 0) continue;
                if (sb.length() > 0) {
                    if (!commandLine) {
                        sb.append(",");
                    }
                    sb.append(" ");
                }
                if (value != null && value.length() > 0) {
                    if (commandLine) {
                        sb.append("--");
                    }
                    sb.append(name);
                    sb.append("=");
                    sb.append(value);
                } else {
                    sb.append(name);
                }
                ++index;
            }
        }
        return sb.toString();
    }

    private Map<String, String> createParam(@NonNull String name) {
        TreeMap<String, String> param = new TreeMap<String, String>(this.getComparator());
        param.put(APP_PARAM_SUFFIXES[0], name);
        return param;
    }

    private Map<String, String> createParam(@NonNull String name, String value) {
        TreeMap<String, String> param = new TreeMap<String, String>(this.getComparator());
        param.put(APP_PARAM_SUFFIXES[0], name);
        param.put(APP_PARAM_SUFFIXES[1], value);
        return param;
    }

    public void addParam(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        List<Map<String, String>> params = this.getParams(config);
        if (params == null) {
            params = new ArrayList<Map<String, String>>();
            this.APP_PARAMS.put(config, params);
        } else {
            this.eraseParam(params, name);
        }
        params.add(this.createParam(name));
    }

    public void addDefaultParam(@NonNull String name) {
        this.addParam(null, name);
    }

    public void addActiveParam(@NonNull String name) {
        this.addParam(this.getActive(), name);
    }

    public void addParamTransparent(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        if (config == null) {
            this.addDefaultParam(name);
        } else if (this.hasDefaultParam(name) && !this.hasDefaultParamValue(name)) {
            this.eraseParam(config, name);
        } else {
            this.addParam(config, name);
        }
    }

    public void addActiveParamTransparent(@NonNull String name) {
        this.addParamTransparent(this.getActive(), name);
    }

    public void addParam(String config, @NonNull String name, String value) {
        assert (!this.configNameWrong(config));
        List<Map<String, String>> params = this.getParams(config);
        if (params == null) {
            params = new ArrayList<Map<String, String>>();
            this.APP_PARAMS.put(config, params);
        } else {
            this.eraseParam(params, name);
        }
        params.add(this.createParam(name, value));
    }

    public void addDefaultParam(@NonNull String name, String value) {
        this.addParam(null, name, value);
    }

    public void addActiveParam(@NonNull String name, String value) {
        this.addParam(this.getActive(), name, value);
    }

    public void addParamTransparent(String config, @NonNull String name, String value) {
        assert (!this.configNameWrong(config));
        if (config == null) {
            this.addDefaultParam(name, value);
        } else if (this.hasDefaultParam(name, value)) {
            this.eraseParam(config, name);
        } else {
            this.addParam(config, name, value);
        }
    }

    public void addActiveParamTransparent(@NonNull String name, String value) {
        this.addParamTransparent(this.getActive(), name, value);
    }

    public void setParamsTransparent(String config, List<Map<String, String>> params) {
        assert (!this.configNameWrong(config));
        if (config == null) {
            this.APP_PARAMS.put(null, params);
        } else {
            ArrayList<Map<String, String>> reduct = new ArrayList<Map<String, String>>();
            List<Map<String, String>> def = JFXProjectUtils.copyList(this.getDefaultParams());
            if (params != null) {
                for (Map<String, String> map : params) {
                    String name = map.get(APP_PARAM_SUFFIXES[0]);
                    String value = map.get(APP_PARAM_SUFFIXES[1]);
                    Map<String, String> old = this.getDefaultParam(name);
                    if (old != null) {
                        String oldValue = old.get(APP_PARAM_SUFFIXES[1]);
                        if (!JFXProjectProperties.isEqual(value, oldValue)) {
                            reduct.add(JFXProjectUtils.copyMap(old));
                        }
                        def.remove(old);
                        continue;
                    }
                    reduct.add(JFXProjectUtils.copyMap(map));
                }
                for (Map<String, String> map : def) {
                    map.put(APP_PARAM_SUFFIXES[1], "");
                    reduct.add(JFXProjectUtils.copyMap(map));
                }
            }
            this.APP_PARAMS.put(config, reduct);
        }
    }

    public void setActiveParamsTransparent(List<Map<String, String>> params) {
        this.setParamsTransparent(this.getActive(), params);
    }

    public void eraseParam(String config, @NonNull String name) {
        assert (!this.configNameWrong(config));
        this.eraseParam(this.getParams(config), name);
    }

    public void eraseDefaultParam(@NonNull String name) {
        this.eraseParam((String)null, name);
    }

    public void eraseActiveParam(@NonNull String name) {
        this.eraseParam(this.getActive(), name);
    }

    public void eraseParams(String config) {
        assert (!this.configNameWrong(config));
        this.APP_PARAMS.remove(config);
    }

    public void eraseDefaultParams() {
        this.eraseParams(null);
    }

    public void eraseActiveParams() {
        this.eraseParams(this.getActive());
    }

    private Map<String, String> getParam(List<Map<String, String>> params, String paramName) {
        if (params != null) {
            for (Map<String, String> map : params) {
                String name = map.get(APP_PARAM_SUFFIXES[0]);
                if (name == null || !name.equals(paramName)) continue;
                return map;
            }
        }
        return null;
    }

    private void eraseParam(List<Map<String, String>> params, String paramName) {
        if (params != null) {
            Map<String, String> toErase = null;
            for (Map<String, String> map : params) {
                String name = map.get(APP_PARAM_SUFFIXES[0]);
                if (name == null || !name.equals(paramName)) continue;
                toErase = map;
                break;
            }
            if (toErase != null) {
                params.remove(toErase);
            }
        }
    }

    public void read() {
        this.reset();
        this.readDefaultConfig("nbproject/project.properties");
        this.readDefaultConfig("nbproject/private/private.properties");
        this.addDefaultsIfMissing();
        this.readNonDefaultConfigs(PROJECT_CONFIGS_DIR, true);
        this.readNonDefaultConfigs(PROJECT_PRIVATE_CONFIGS_DIR, false);
    }

    private void readDefaultConfig(String propsFile) {
        EditableProperties ep = null;
        try {
            ep = JFXProjectUtils.readFromFile(this.projectDir, propsFile);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (ep != null) {
            for (String prop : this.PROJECT_PROPERTIES) {
                String v = ep.getProperty(prop);
                if (v == null) continue;
                this.setDefaultProperty(prop, v);
            }
        }
        this.extractDefaultParams(ep);
    }

    private void addDefaultsIfMissing() {
        for (String prop : this.DEFAULT_IF_MISSING.keySet()) {
            if (this.isDefaultPropertySet(prop)) continue;
            this.setDefaultProperty(prop, this.DEFAULT_IF_MISSING.get(prop));
        }
    }

    private void readNonDefaultConfigs(String subDir, boolean createIfNotExists) {
        FileObject configsFO = this.projectDir.getFileObject(subDir);
        if (configsFO != null) {
            for (FileObject kid : configsFO.getChildren()) {
                Map<String, String> c;
                if (!kid.hasExt(PROPERTIES_FILE_EXT) || (c = this.getConfig(kid.getName())) == null && !createIfNotExists) continue;
                EditableProperties cep = null;
                try {
                    cep = JFXProjectUtils.readFromFile(kid);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.addToConfig(kid.getName(), cep);
                this.extractParams(cep, kid.getName());
            }
        }
    }

    private void extractParams(@NonNull EditableProperties ep, String config) {
        if (ep != null) {
            for (String prop : ep.keySet()) {
                String name;
                if (!prop.startsWith(APP_PARAM_PREFIX) || !prop.endsWith(APP_PARAM_SUFFIXES[0]) || (name = ep.getProperty(prop)) == null) continue;
                String propV = prop.replace(APP_PARAM_SUFFIXES[0], APP_PARAM_SUFFIXES[1]);
                String value = ep.getProperty(propV);
                if (value != null) {
                    this.addParam(config, name, value);
                    continue;
                }
                this.addParam(config, name);
            }
        }
    }

    private void extractDefaultParams(@NonNull EditableProperties ep) {
        this.extractParams(ep, null);
    }

    private void extractActiveParams(@NonNull EditableProperties ep) {
        this.extractParams(ep, this.getActive());
    }

    public void readActive() {
        try {
            this.setActive(JFXProjectUtils.readFromFile(this.projectDir, CONFIG_PROPERTIES_FILE).getProperty("config"));
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Failed to read active configuration from {0}.", CONFIG_PROPERTIES_FILE);
        }
    }

    public void storeActive() throws IOException {
        String configPath = CONFIG_PROPERTIES_FILE;
        if (this.active == null) {
            try {
                JFXProjectUtils.deleteFile(this.projectDir, configPath);
            }
            catch (IOException ex) {}
        } else {
            EditableProperties configProps = JFXProjectUtils.readFromFile(this.projectDir, configPath);
            configProps.setProperty("config", this.active);
            JFXProjectUtils.saveToFile(this.projectDir, configPath, configProps);
        }
    }

    public void store(EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        for (String name : this.PROJECT_PROPERTIES) {
            String string = this.getDefaultProperty(name);
            this.updateProperty(name, string, projectProperties, privateProperties, this.isBoundedToNonemptyProperty(null, name));
        }
        ArrayList<String> paramNamesUsed = new ArrayList<String>();
        this.updateDefaultParamProperties(projectProperties, privateProperties, paramNamesUsed);
        this.storeDefaultParamsAsCommandLine(privateProperties);
        for (Map.Entry<String, Map<String, String>> entry : this.RUN_CONFIGS.entrySet()) {
            String config = entry.getKey();
            if (config == null) continue;
            String sharedPath = JFXProjectConfigurations.getSharedConfigFilePath(config);
            String privatePath = JFXProjectConfigurations.getPrivateConfigFilePath(config);
            Map<String, String> configProps = entry.getValue();
            if (configProps == null) {
                try {
                    JFXProjectUtils.deleteFile(this.projectDir, sharedPath);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to delete file: {0}", sharedPath);
                }
                try {
                    JFXProjectUtils.deleteFile(this.projectDir, privatePath);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to delete file: {0}", privatePath);
                }
                continue;
            }
            EditableProperties sharedCfgProps = JFXProjectUtils.readFromFile(this.projectDir, sharedPath);
            EditableProperties privateCfgProps = JFXProjectUtils.readFromFile(this.projectDir, privatePath);
            boolean privatePropsChanged = false;
            for (Map.Entry<String, String> prop : configProps.entrySet()) {
                String name = prop.getKey();
                String value = prop.getValue();
                String defaultValue = this.getDefaultProperty(name);
                boolean storeIfEmpty = defaultValue != null && defaultValue.length() > 0 || this.isBoundedToNonemptyProperty(config, name);
                privatePropsChanged |= this.updateProperty(name, value, sharedCfgProps, privateCfgProps, storeIfEmpty);
            }
            this.cleanPropertiesIfEmpty(this.CLEAN_EMPTY_PROJECT_PROPERTIES.toArray(new String[0]), config, sharedCfgProps);
            privatePropsChanged |= this.cleanPropertiesIfEmpty(this.CLEAN_EMPTY_PRIVATE_PROPERTIES.toArray(new String[0]), config, privateCfgProps);
            privatePropsChanged |= this.updateParamProperties(config, sharedCfgProps, privateCfgProps, paramNamesUsed);
            JFXProjectUtils.saveToFile(this.projectDir, sharedPath, sharedCfgProps);
            if (!(privatePropsChanged |= this.storeParamsAsCommandLine(config, privateCfgProps))) continue;
            JFXProjectUtils.saveToFile(this.projectDir, privatePath, privateCfgProps);
        }
        if (this.ERASED_CONFIGS != null) {
            for (String string : this.ERASED_CONFIGS) {
                if (this.RUN_CONFIGS.containsKey(string)) continue;
                String sharedPath = JFXProjectConfigurations.getSharedConfigFilePath(string);
                String privatePath = JFXProjectConfigurations.getPrivateConfigFilePath(string);
                try {
                    JFXProjectUtils.deleteFile(this.projectDir, sharedPath);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to delete file: {0}", sharedPath);
                }
                try {
                    JFXProjectUtils.deleteFile(this.projectDir, privatePath);
                }
                catch (IOException ex) {
                    LOG.log(Level.WARNING, "Failed to delete file: {0}", privatePath);
                }
            }
        }
    }

    private boolean updateProperty(@NonNull String name, String value, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, boolean storeEmpty) {
        EditableProperties ep;
        boolean changePrivate = this.PRIVATE_PROPERTIES.contains(name) || privateProperties.containsKey((Object)name);
        EditableProperties editableProperties = ep = changePrivate ? privateProperties : projectProperties;
        if (changePrivate) {
            projectProperties.remove((Object)name);
        }
        if (!Utilities.compareObjects((Object)value, (Object)ep.getProperty(name))) {
            if (value != null && (value.length() > 0 || storeEmpty)) {
                ep.setProperty(name, value);
            } else {
                ep.remove((Object)name);
            }
            return changePrivate;
        }
        return false;
    }

    private boolean updateProperty(@NonNull String name, String value, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties) {
        return this.updateProperty(name, value, projectProperties, privateProperties, false);
    }

    private boolean cleanPropertyIfEmpty(@NonNull String name, String config, @NonNull EditableProperties ep) {
        if (!this.isPropertySet(config, name)) {
            ep.remove((Object)name);
            return true;
        }
        return false;
    }

    private boolean cleanPropertiesIfEmpty(@NonNull String[] names, String config, @NonNull EditableProperties ep) {
        boolean updated = false;
        for (String name : names) {
            updated |= this.cleanPropertyIfEmpty(name, config, ep);
        }
        return updated;
    }

    private boolean isParamNameProperty(@NonNull String prop) {
        return prop != null && prop.startsWith(APP_PARAM_PREFIX) && prop.endsWith(APP_PARAM_SUFFIXES[0]);
    }

    private boolean isParamValueProperty(@NonNull String prop) {
        return prop != null && prop.startsWith(APP_PARAM_PREFIX) && prop.endsWith(APP_PARAM_SUFFIXES[1]);
    }

    private String getParamValueProperty(String paramNameProperty) {
        if (paramNameProperty != null && this.isParamNameProperty(paramNameProperty)) {
            return paramNameProperty.replace(APP_PARAM_SUFFIXES[0], APP_PARAM_SUFFIXES[1]);
        }
        return null;
    }

    private String getParamNameProperty(int index) {
        return APP_PARAM_PREFIX + index + "." + APP_PARAM_SUFFIXES[0];
    }

    private String getParamValueProperty(int index) {
        return APP_PARAM_PREFIX + index + "." + APP_PARAM_SUFFIXES[1];
    }

    private boolean isFreeParamPropertyIndex(int index, @NonNull EditableProperties ep) {
        return !ep.containsKey((Object)this.getParamNameProperty(index));
    }

    private int getFreeParamPropertyIndex(int start, @NonNull EditableProperties ep, @NonNull EditableProperties pep, List<String> paramNamesUsed) {
        int index;
        int n = index = start >= 0 ? start : 0;
        while (index >= 0 && (!this.isFreeParamPropertyIndex(index, ep) || !this.isFreeParamPropertyIndex(index, pep) || paramNamesUsed != null && paramNamesUsed.contains(this.getParamNameProperty(index)))) {
            ++index;
        }
        return index >= 0 ? index : 0;
    }

    private boolean updateParamProperties(String config, @NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, @NonNull List<String> paramNamesUsed) {
        assert (!this.configNameWrong(config));
        boolean privateUpdated = false;
        List<Map<String, String>> reduce = JFXProjectUtils.copyList(this.getParams(config));
        for (String prop : paramNamesUsed) {
            if (prop == null || prop.length() <= 0) continue;
            projectProperties.remove((Object)prop);
            projectProperties.remove((Object)this.getParamValueProperty(prop));
            privateProperties.remove((Object)prop);
            privateProperties.remove((Object)this.getParamValueProperty(prop));
        }
        this.cleanParamPropertiesIfEmpty(config, privateProperties);
        for (String prop : privateProperties.keySet()) {
            if (!this.isParamNameProperty(prop)) continue;
            paramNamesUsed.add(prop);
        }
        LinkedList<Map<String, String>> toEraseList = new LinkedList<Map<String, String>>();
        for (Map<String, String> map : reduce) {
            String value;
            String name = map.get(APP_PARAM_SUFFIXES[0]);
            if (!this.updateParamPropertyIfExists(name, value = map.get(APP_PARAM_SUFFIXES[1]), privateProperties, true)) continue;
            toEraseList.add(map);
            privateUpdated = true;
        }
        for (Map<String, String> toErase : toEraseList) {
            reduce.remove(toErase);
        }
        this.cleanParamPropertiesNotListed(reduce, projectProperties);
        for (String prop : projectProperties.keySet()) {
            if (!this.isParamNameProperty(prop)) continue;
            paramNamesUsed.add(prop);
        }
        int index = 0;
        for (Map<String, String> map : reduce) {
            String name = map.get(APP_PARAM_SUFFIXES[0]);
            String value = map.get(APP_PARAM_SUFFIXES[1]);
            if (name == null || name.length() <= 0 || this.updateParamPropertyIfExists(name, value, projectProperties, false)) continue;
            index = this.getFreeParamPropertyIndex(index, projectProperties, privateProperties, paramNamesUsed);
            this.exportParamProperty(map, this.getParamNameProperty(index), this.getParamValueProperty(index), projectProperties);
            paramNamesUsed.add(this.getParamNameProperty(index));
        }
        return privateUpdated;
    }

    private boolean updateDefaultParamProperties(@NonNull EditableProperties projectProperties, @NonNull EditableProperties privateProperties, List<String> paramNamesUsed) {
        return this.updateParamProperties(null, projectProperties, privateProperties, paramNamesUsed);
    }

    private boolean updateParamPropertyIfExists(@NonNull String name, String value, EditableProperties ep, boolean storeEmpty) {
        if (name != null && !name.isEmpty()) {
            for (String prop : ep.keySet()) {
                if (!this.isParamNameProperty(prop) || !JFXProjectProperties.isEqual(name, ep.get((Object)prop))) continue;
                String propVal = this.getParamValueProperty(prop);
                if (value != null && (value.length() > 0 || storeEmpty)) {
                    ep.setProperty(propVal, value);
                } else {
                    ep.remove((Object)propVal);
                }
                return true;
            }
        }
        return false;
    }

    private void cleanParamPropertiesIfEmpty(String config, EditableProperties ep) {
        assert (!this.configNameWrong(config));
        LinkedList<String> toRemove = new LinkedList<String>();
        for (String prop : ep.keySet()) {
            String name;
            if (!this.isParamNameProperty(prop) || this.hasParam(config, name = ep.get((Object)prop))) continue;
            toRemove.add(prop);
        }
        for (String prop : toRemove) {
            ep.remove((Object)prop);
            ep.remove((Object)this.getParamValueProperty(prop));
        }
    }

    private void cleanParamPropertiesNotListed(List<Map<String, String>> props, EditableProperties ep) {
        LinkedList<String> toRemove = new LinkedList<String>();
        for (String name : ep.keySet()) {
            if (!this.isParamNameProperty(name)) continue;
            boolean inProps = false;
            for (Map<String, String> map : props) {
                String prop = map.get(APP_PARAM_SUFFIXES[0]);
                if (!JFXProjectProperties.isEqual(name, prop)) continue;
                inProps = true;
                break;
            }
            if (inProps) continue;
            toRemove.add(name);
        }
        for (String prop : toRemove) {
            ep.remove((Object)prop);
            ep.remove((Object)this.getParamValueProperty(prop));
        }
    }

    private void exportParamProperty(@NonNull Map<String, String> param, String newPropName, String newPropValue, @NonNull EditableProperties ep) {
        String name = param.get(APP_PARAM_SUFFIXES[0]);
        String value = param.get(APP_PARAM_SUFFIXES[1]);
        if (name != null) {
            ep.put(newPropName, name);
            if (value != null && value.length() > 0) {
                ep.put(newPropValue, value);
            }
        }
    }

    private boolean storeParamsAsCommandLine(String config, EditableProperties projectProperties) {
        assert (!this.configNameWrong(config));
        String params = this.getParamsTransparentAsString(config, true);
        if (config != null && JFXProjectProperties.isEqual(params, this.getDefaultParamsAsString(true))) {
            params = null;
        }
        if (!Utilities.compareObjects((Object)params, (Object)projectProperties.getProperty(APPLICATION_ARGS))) {
            if (params != null && params.length() > 0) {
                projectProperties.setProperty(APPLICATION_ARGS, params);
                projectProperties.setComment(APPLICATION_ARGS, new String[]{"# " + NbBundle.getMessage(JFXProjectProperties.class, (String)"COMMENT_app_args")}, false);
            } else {
                projectProperties.remove((Object)APPLICATION_ARGS);
            }
            return true;
        }
        return false;
    }

    private boolean storeDefaultParamsAsCommandLine(EditableProperties projectProperties) {
        return this.storeParamsAsCommandLine(null, projectProperties);
    }

    private class BoundedPropertyGroups {
        Map<String, Set<String>> groups = new HashMap<String, Set<String>>();

        private BoundedPropertyGroups() {
        }

        public void defineGroup(String groupName, Collection<String> props) {
            HashSet<String> group = new HashSet<String>();
            group.addAll(props);
            this.groups.put(groupName, group);
        }

        public void clearGroup(String groupName) {
            this.groups.remove(groupName);
        }

        public void clearAllGroups() {
            this.groups.clear();
        }

        public boolean isBound(String prop) {
            for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
                Set<String> group = entry.getValue();
                if (group == null || !group.contains(prop) || group.size() <= 1) continue;
                return true;
            }
            return false;
        }

        public Collection<String> getBoundedProperties(String prop) {
            HashSet<String> bounded = new HashSet<String>();
            for (Map.Entry<String, Set<String>> entry : this.groups.entrySet()) {
                Set<String> group = entry.getValue();
                if (group == null || !group.contains(prop)) continue;
                bounded.addAll(group);
            }
            bounded.remove(prop);
            return bounded;
        }
    }
}

