/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

public final class JFXGeneratedFilesHelper {
    public static void generateBuildScriptFromStylesheet(final AntProjectHelper h, final String path, final URL stylesheet) throws IOException {
        if (h == null) {
            throw new IllegalArgumentException("Null AntProjectHelper");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (stylesheet == null) {
            throw new IllegalArgumentException("Null stylesheet");
        }
        final FileObject dir = h.getProjectDirectory();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    dir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            byte[] resultData;
                            byte[] stylesheetData;
                            byte[] projectXmlData;
                            FileObject projectXml = dir.getFileObject("nbproject/project.xml");
                            if (projectXml == null) {
                                throw new IOException("Missing project metadata: " + h.resolveFile("nbproject/project.xml"));
                            }
                            InputStream is = projectXml.getInputStream();
                            try {
                                projectXmlData = JFXGeneratedFilesHelper.load(is);
                            }
                            finally {
                                is.close();
                            }
                            is = stylesheet.openStream();
                            try {
                                stylesheetData = JFXGeneratedFilesHelper.load(is);
                            }
                            finally {
                                is.close();
                            }
                            TransformerFactory tf = TransformerFactory.newInstance();
                            try {
                                StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(stylesheetData), stylesheet.toExternalForm());
                                Transformer t = tf.newTransformer(stylesheetSource);
                                File projectXmlF = FileUtil.toFile((FileObject)projectXml);
                                assert (projectXmlF != null);
                                StreamSource projectXmlSource = new StreamSource(new ByteArrayInputStream(projectXmlData), projectXmlF.toURI().toString());
                                ByteArrayOutputStream result = new ByteArrayOutputStream();
                                t.transform(projectXmlSource, new StreamResult(result));
                                resultData = result.toByteArray();
                            }
                            catch (TransformerException e) {
                                throw (IOException)new IOException(e.toString()).initCause(e);
                            }
                            FileSystem.AtomicAction body = new FileSystem.AtomicAction(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() throws IOException {
                                    FileObject buildScriptXml = FileUtil.createData((FileObject)dir, (String)path);
                                    assert (buildScriptXml.isValid());
                                    FileLock lock1 = buildScriptXml.lock();
                                    try {
                                        EolFilterOutputStream os1 = new EolFilterOutputStream(buildScriptXml.getOutputStream(lock1));
                                        try {
                                            ((OutputStream)os1).write(resultData);
                                        }
                                        finally {
                                            ((OutputStream)os1).close();
                                        }
                                    }
                                    finally {
                                        lock1.releaseLock();
                                    }
                                }
                            };
                            try {
                                body.run();
                            }
                            catch (UserQuestionException uqe) {
                                // empty catch block
                            }
                        }
                    });
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private static byte[] load(InputStream is) throws IOException {
        int read;
        int size = Math.max(1024, is.available());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
        byte[] buf = new byte[size];
        while ((read = is.read(buf)) != -1) {
            baos.write(buf, 0, read);
        }
        return baos.toByteArray();
    }

    private static class EolFilterOutputStream
    extends BufferedOutputStream {
        private boolean isActive = Utilities.isWindows();
        private int last = -1;

        public EolFilterOutputStream(OutputStream os) {
            super(os, 4096);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.isActive) {
                for (int i = off; i < off + len; ++i) {
                    this.write(b[i]);
                }
            } else {
                super.write(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.isActive) {
                if (b == 10 && this.last != 13) {
                    super.write(13);
                }
                this.last = b;
            }
            super.write(b);
        }
    }
}

