/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.project.Bundle;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class CreateNativePackageAction
extends AbstractAction
implements ContextAwareAction {
    private static final String METRICS_LOGGER = "org.netbeans.ui.metrics.projects";
    private static final String JFX_METRICS_LOGGER = "org.netbeans.ui.metrics.jfx";
    private static final String PROJECT_TYPE = "org.netbeans.modules.javafx2.project.JFXProject";
    private static final String BUILD_NATIVE = "USG_PROJECT_BUILD_NATIVE";
    private static final String BUILD_NATIVE_JFX = "USG_PROJECT_BUILD_NATIVE_JFX";

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        return new ContextAction(context);
    }

    private static final class ContextAction
    extends AbstractAction {
        private final Project prj;
        private final J2SEPropertyEvaluator ep;
        private boolean isJSAvailable = true;
        private boolean isJSAvailableChecked = false;

        public ContextAction(Lookup context) {
            this.prj = (Project)context.lookup(Project.class);
            this.ep = (J2SEPropertyEvaluator)this.prj.getLookup().lookup(J2SEPropertyEvaluator.class);
            if (!ContextAction.isFXProject(this.ep)) {
                this.setEnabled(false);
            } else {
                String nativeEnabled = this.ep.evaluator().getProperty("javafx.native.bundling.enabled");
                String nativeType = this.ep.evaluator().getProperty("javafx.native.bundling.type");
                this.setEnabled(nativeEnabled != null && nativeType != null && ContextAction.isTrue(nativeEnabled) && !nativeType.equalsIgnoreCase("none"));
            }
            this.putValue("hideWhenDisabled", true);
            this.putValue("Name", Bundle.CTL_CreateNativePackageAction());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContextAction.logUsage();
            FileObject buildFo = this.findBuildXml();
            assert (buildFo != null && buildFo.isValid());
            String noScript = this.isJavaScriptAvailable() ? "" : "-noscript";
            final ActionProgress listener = ActionProgress.start((Lookup)this.prj.getLookup());
            try {
                String target = "jfx-build-native".concat(noScript);
                Properties props = new Properties();
                assert (this.ep != null);
                String nativeType = this.ep.evaluator().getProperty("javafx.native.bundling.type");
                if (nativeType == null || nativeType.equalsIgnoreCase("none")) {
                    nativeType = "all";
                }
                props.setProperty("javafx.native.bundling.type", nativeType);
                ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{target}, (Properties)props).addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        listener.finished(((ExecutorTask)task).result() == 0);
                    }
                });
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                listener.finished(false);
            }
        }

        @NonNull
        private static String getBuildXmlName(@NonNull PropertyEvaluator evaluator) {
            String buildScriptPath = evaluator.getProperty("buildfile");
            if (buildScriptPath == null) {
                buildScriptPath = "build.xml";
            }
            return buildScriptPath;
        }

        @CheckForNull
        private FileObject findBuildXml() {
            assert (this.ep != null);
            return this.prj.getProjectDirectory().getFileObject(ContextAction.getBuildXmlName(this.ep.evaluator()));
        }

        private boolean isJavaScriptAvailable() {
            if (this.isJSAvailableChecked) {
                return this.isJSAvailable;
            }
            ScriptEngineManager mgr = new ScriptEngineManager();
            List<ScriptEngineFactory> factories = mgr.getEngineFactories();
            for (ScriptEngineFactory factory : factories) {
                List<String> engNames = factory.getNames();
                for (String name : engNames) {
                    if (!name.equalsIgnoreCase("js") && !name.equalsIgnoreCase("javascript")) continue;
                    this.isJSAvailableChecked = true;
                    this.isJSAvailable = true;
                    return this.isJSAvailable;
                }
            }
            this.isJSAvailableChecked = true;
            this.isJSAvailable = false;
            return this.isJSAvailable;
        }

        private static boolean isFXProject(@NonNull J2SEPropertyEvaluator ep) {
            if (ep == null) {
                return false;
            }
            return ContextAction.isTrue(ep.evaluator().getProperty("javafx.enabled"));
        }

        private static boolean isTrue(String value) {
            return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
        }

        static void logUsage() {
            Logger logger = Logger.getLogger(CreateNativePackageAction.METRICS_LOGGER);
            LogRecord logRecord = new LogRecord(Level.INFO, CreateNativePackageAction.BUILD_NATIVE);
            logRecord.setLoggerName(logger.getName());
            logRecord.setResourceBundle(NbBundle.getBundle(CreateNativePackageAction.class));
            logRecord.setResourceBundleName(CreateNativePackageAction.class.getPackage().getName() + ".Bundle");
            logRecord.setParameters(new Object[]{CreateNativePackageAction.PROJECT_TYPE});
            logger.log(logRecord);
            logger = Logger.getLogger(CreateNativePackageAction.JFX_METRICS_LOGGER);
            logRecord = new LogRecord(Level.INFO, CreateNativePackageAction.BUILD_NATIVE_JFX);
            logRecord.setLoggerName(logger.getName());
            logRecord.setResourceBundle(NbBundle.getBundle(CreateNativePackageAction.class));
            logRecord.setResourceBundleName(CreateNativePackageAction.class.getPackage().getName() + ".Bundle");
            logger.log(logRecord);
        }
    }
}

