/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javafx2.project.FXMLTemplateWizardIterator;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConfigureFXMLCSSPanelVisual
extends JPanel
implements DocumentListener {
    private Panel observer;
    private File[] srcRoots;
    private File rootFolder;
    private FileObject targetFolder;
    private String fxmlName;
    private ButtonGroup buttonGroup1;
    private JButton chooseButton;
    private JRadioButton createNewRadioButton;
    private JLabel createdNameLabel;
    private JTextField createdNameTextField;
    private JCheckBox cssCheckBox;
    private JLabel existingNameLabel;
    private JTextField existingNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private Box.Filler filler1;
    private JRadioButton useExistingRadioButton;

    ConfigureFXMLCSSPanelVisual(Panel observer) {
        this.observer = observer;
        this.setName(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"TXT_CSSNameAndLoc"));
        this.initComponents();
        this.initComponents2();
    }

    private void fireChange() {
        this.observer.fireChangeEvent();
    }

    private void initComponents2() {
        this.createdNameTextField.getDocument().addDocumentListener(this);
        this.existingNameTextField.getDocument().addDocumentListener(this);
    }

    public void initValues(FileObject template, FileObject targetFolder, String fxmlName, File[] srcRoots, File rootFolder) {
        String displayName;
        if (template == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_Template_Error"));
        }
        if (targetFolder == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_Target_Error"));
        }
        if (srcRoots == null || srcRoots.length < 1) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_SGs_Error"));
        }
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.targetFolder = targetFolder;
        this.fxmlName = fxmlName;
        this.srcRoots = srcRoots;
        this.rootFolder = rootFolder;
        this.updateText();
        this.updateResult();
    }

    boolean isCSSEnabled() {
        return this.cssCheckBox.isSelected();
    }

    String getNewCSSName() {
        String text = this.createdNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    String getExistingCSSName() {
        String text = this.existingNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    FileObject getTargetFolder() {
        return this.targetFolder;
    }

    FileObject getExistingCSS() {
        String rel;
        File f;
        String name = this.getExistingCSSName();
        if (name != null && (f = new File(rel = this.getPathForExistingCSS(name))).exists()) {
            return FileUtil.toFileObject((File)f);
        }
        return null;
    }

    String getExistingCSSRelative() {
        FileObject targetFO = this.getTargetFolder();
        FileObject existing = this.getExistingCSS();
        if (targetFO != null && existing != null) {
            return JFXProjectUtils.getRelativePath(targetFO, existing);
        }
        return this.getExistingCSSName();
    }

    private void radioButtonsStateChanged() {
        if (!this.cssCheckBox.isSelected()) {
            return;
        }
        this.createdNameLabel.setEnabled(this.createNewRadioButton.isSelected());
        this.createdNameTextField.setEnabled(this.createNewRadioButton.isSelected());
        this.existingNameLabel.setEnabled(!this.createNewRadioButton.isSelected());
        this.existingNameTextField.setEnabled(!this.createNewRadioButton.isSelected());
        this.chooseButton.setEnabled(!this.createNewRadioButton.isSelected());
        this.updateResult();
        this.fireChange();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.cssCheckBox = new JCheckBox();
        this.createdNameLabel = new JLabel();
        this.createdNameTextField = new JTextField();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.createNewRadioButton = new JRadioButton();
        this.useExistingRadioButton = new JRadioButton();
        this.existingNameLabel = new JLabel();
        this.existingNameTextField = new JTextField();
        this.chooseButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setPreferredSize(new Dimension(500, 340));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cssCheckBox, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.cssCheckBox.text"));
        this.cssCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLCSSPanelVisual.this.cssCheckBoxItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 1280;
        this.add((Component)this.cssCheckBox, gridBagConstraints);
        this.cssCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.cssCheckBox.AccessibleContext.accessibleDescription"));
        this.createdNameLabel.setLabelFor(this.createdNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdNameLabel, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createdNameLabel.text"));
        this.createdNameLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.createdNameLabel, gridBagConstraints);
        this.createdNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createdNameLabel.AccessibleContext.accessibleDescription"));
        this.createdNameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.createdNameTextField, gridBagConstraints);
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.fileLabel.text"));
        this.fileLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(25, 15, 0, 0);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.fileLabel.AccessibleContext.accessibleDescription"));
        this.fileTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.buttonGroup1.add(this.createNewRadioButton);
        this.createNewRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createNewRadioButton, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createNewRadioButton.text"));
        this.createNewRadioButton.setEnabled(false);
        this.createNewRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLCSSPanelVisual.this.createNewRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.add((Component)this.createNewRadioButton, gridBagConstraints);
        this.createNewRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.createNewRadioButton.AccessibleContext.accessibleDescription"));
        this.buttonGroup1.add(this.useExistingRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.useExistingRadioButton, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.useExistingRadioButton.text"));
        this.useExistingRadioButton.setEnabled(false);
        this.useExistingRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLCSSPanelVisual.this.useExistingRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.add((Component)this.useExistingRadioButton, gridBagConstraints);
        this.useExistingRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.useExistingRadioButton.AccessibleContext.accessibleDescription"));
        this.existingNameLabel.setLabelFor(this.existingNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.existingNameLabel, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.existingNameLabel.text"));
        this.existingNameLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.existingNameLabel, gridBagConstraints);
        this.existingNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.existingNameLabel.AccessibleContext.accessibleDescription"));
        this.existingNameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.existingNameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chooseButton, (String)NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.chooseButton.text"));
        this.chooseButton.setEnabled(false);
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureFXMLCSSPanelVisual.this.chooseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.chooseButton, gridBagConstraints);
        this.chooseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"ConfigureFXMLCSSPanelVisual.chooseButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void cssCheckBoxItemStateChanged(ItemEvent evt) {
        this.createNewRadioButton.setEnabled(this.cssCheckBox.isSelected());
        if (this.createNewRadioButton.isSelected()) {
            this.createdNameLabel.setEnabled(this.cssCheckBox.isSelected());
            this.createdNameTextField.setEnabled(this.cssCheckBox.isSelected());
        }
        this.useExistingRadioButton.setEnabled(this.cssCheckBox.isSelected());
        if (this.useExistingRadioButton.isSelected()) {
            this.existingNameLabel.setEnabled(this.cssCheckBox.isSelected());
            this.existingNameTextField.setEnabled(this.cssCheckBox.isSelected());
            this.chooseButton.setEnabled(this.cssCheckBox.isSelected());
        }
        this.fileLabel.setEnabled(this.cssCheckBox.isSelected());
        this.updateResult();
        this.fireChange();
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(new FXMLTemplateWizardIterator.SrcFileSystemView(this.srcRoots));
        chooser.setDialogTitle(NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"LBL_ConfigureFXMLPanel_FileChooser_Select_CSS"));
        chooser.setFileFilter(FXMLTemplateWizardIterator.FXMLTemplateFileFilter.createCSSFilter());
        String existingPath = this.existingNameTextField.getText();
        if (existingPath.length() > 0) {
            File f = new File(this.rootFolder.getPath() + File.pathSeparator + existingPath);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            } else {
                chooser.setCurrentDirectory(this.rootFolder);
            }
        } else {
            chooser.setCurrentDirectory(this.rootFolder);
        }
        if (0 == chooser.showOpenDialog(this)) {
            String cssFile = FileUtil.normalizeFile((File)chooser.getSelectedFile()).getPath();
            String srcPath = FileUtil.normalizeFile((File)this.srcRoots[0]).getPath();
            String relativePath = cssFile.substring(srcPath.length() + 1);
            this.existingNameTextField.setText(relativePath);
        }
    }

    private void createNewRadioButtonItemStateChanged(ItemEvent evt) {
        this.radioButtonsStateChanged();
    }

    private void useExistingRadioButtonItemStateChanged(ItemEvent evt) {
        this.radioButtonsStateChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateResult();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updateText() {
        String cssName = this.getNewCSSName();
        if (cssName == null) {
            cssName = this.fxmlName.toLowerCase() + ".css";
            this.createdNameTextField.setText(cssName);
        }
    }

    private void updateResult() {
        String cssName;
        String string = cssName = this.shouldCreateCSS() ? this.getNewCSSName() : this.getExistingCSSName();
        if (cssName == null) {
            this.fileTextField.setText(null);
            return;
        }
        if (this.shouldCreateCSS()) {
            String file = FileUtil.getFileDisplayName((FileObject)FileUtil.toFileObject((File)this.rootFolder)) + File.separator + cssName;
            this.fileTextField.setText(file);
        } else {
            this.fileTextField.setText(this.getPathForExistingCSS(cssName));
        }
    }

    private String getPathForExistingCSS(String controllerName) {
        assert (controllerName != null);
        return FileUtil.normalizeFile((File)this.srcRoots[0]).getPath() + File.separatorChar + controllerName;
    }

    String isCSSValid() {
        if (this.createNewRadioButton.isSelected()) {
            return FXMLTemplateWizardIterator.canUseFileName(this.rootFolder, this.getNewCSSName());
        }
        if (this.existingNameTextField.getText().isEmpty()) {
            return NbBundle.getMessage(ConfigureFXMLCSSPanelVisual.class, (String)"WARN_ConfigureFXMLPanel_Provide_CSS_Name");
        }
        return FXMLTemplateWizardIterator.fileExist(this.getPathForExistingCSS(this.getExistingCSSName()));
    }

    boolean shouldCreateCSS() {
        return this.cssCheckBox.isSelected() && this.createNewRadioButton.isSelected();
    }

    static class Panel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private ConfigureFXMLCSSPanelVisual component;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private WizardDescriptor settings;

        public Panel() {
            this.component = new ConfigureFXMLCSSPanelVisual(this);
        }

        public Component getComponent() {
            return this.component;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(WizardDescriptor settings) {
            this.settings = settings;
            String fxmlName = Templates.getTargetName((WizardDescriptor)settings);
            File[] srcRoots = (File[])settings.getProperty("srcRootFolder");
            File rootFolder = (File)settings.getProperty("rootFolder");
            this.component.initValues(Templates.getTemplate((WizardDescriptor)settings), Templates.getTargetFolder((WizardDescriptor)settings), fxmlName, srcRoots, rootFolder);
            Object substitute = this.component.getClientProperty("NewFileWizard_Title");
            if (substitute != null) {
                settings.putProperty("NewFileWizard_Title", substitute);
            }
        }

        public void storeSettings(WizardDescriptor settings) {
            Object value = settings.getValue();
            if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
                return;
            }
            if (this.isValid()) {
                settings.putProperty("cssCreate", (Object)this.component.shouldCreateCSS());
                settings.putProperty("CSS", (Object)(this.component.shouldCreateCSS() ? this.component.getNewCSSName() : this.component.getExistingCSSRelative()));
            }
            settings.putProperty("NewFileWizard_Title", null);
        }

        public boolean isValid() {
            if (this.component.isCSSEnabled()) {
                String errorMessage = this.component.isCSSValid();
                this.settings.getNotificationLineSupport().setErrorMessage(errorMessage);
                return errorMessage == null;
            }
            return true;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

