/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model;

import com.sun.istack.NotNull;
import com.sun.xml.ws.runtime.config.MetroConfig;
import com.sun.xml.ws.runtime.config.ObjectFactory;
import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.ws.runtime.config.TubelineDefinition;
import com.sun.xml.ws.runtime.config.TubelineMapping;
import com.sun.xml.ws.runtime.config.Tubelines;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.wsitconf.api.WSITConfigProvider;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class MetroConfigLoader {
    public static final String CFG_FILE_NAME = "metro.xml";
    public static final String DEFAULT_TUBELINE_NAME = "default";
    private JAXBContext jaxbContext = null;
    private ObjectFactory objFactory = null;

    public MetroConfigLoader() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)MetroConfig.class.getPackage().getName());
            this.objFactory = new ObjectFactory();
        }
        catch (JAXBException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isMetroConfigSupported(Project project) {
        if (project == null) {
            return false;
        }
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        if (wsitProvider == null || !wsitProvider.isWsitSupported()) {
            return false;
        }
        WSStackVersion version = WSITConfigProvider.getDefault().getHighestWSStackVersion(project);
        return version != null && version.compareTo(WSStackVersion.valueOf((int)2, (int)2, (int)0, (int)0)) >= 0;
    }

    public MetroConfig createFreshMetroConfig() {
        MetroConfig metroConfig = this.objFactory.createMetroConfig();
        metroConfig.setVersion("1.0");
        return metroConfig;
    }

    public TubelineDefinition createDefaultTubeline(MetroConfig cfg) {
        TubelineDefinition tDef = this.getDefaultTubeline(cfg);
        if (tDef == null) {
            Tubelines tubelines = cfg.getTubelines();
            if (tubelines == null) {
                tubelines = this.objFactory.createTubelines();
                cfg.setTubelines(tubelines);
            }
            tDef = this.objFactory.createTubelineDefinition();
            tDef.setName(DEFAULT_TUBELINE_NAME);
            tubelines.getTubelineDefinitions().add(tDef);
            tubelines.setDefault("#" + tDef.getName());
        }
        return tDef;
    }

    public TubelineDefinition createTubeline(MetroConfig cfg, String endpointRef, String tName) {
        TubelineDefinition tDef = this.getTubeline(cfg, endpointRef);
        if (tDef == null) {
            Tubelines tubelines = cfg.getTubelines();
            if (tubelines == null) {
                tubelines = this.objFactory.createTubelines();
                cfg.setTubelines(tubelines);
            }
            tDef = this.objFactory.createTubelineDefinition();
            tDef.setName(tName);
            tubelines.getTubelineDefinitions().add(tDef);
            List<TubelineMapping> mappings = tubelines.getTubelineMappings();
            TubelineMapping mapping = this.objFactory.createTubelineMapping();
            mapping.setEndpointRef(endpointRef);
            mapping.setTubelineRef("#" + tName);
            mappings.add(mapping);
        }
        return tDef;
    }

    public void removeTubelineReference(MetroConfig cfg, String endpointRef) {
        TubelineMapping mapping = MetroConfigLoader.getTubelineMapping(cfg, endpointRef);
        if (mapping != null) {
            String tRef = mapping.getTubelineRef();
            Tubelines tubelines = cfg.getTubelines();
            tubelines.getTubelineMappings().remove(mapping);
            if (!this.isTubelineReferenced(tubelines, tRef)) {
                this.removeTubeline(tubelines, tRef);
            }
        }
        this.clearTubelines(cfg);
    }

    public void removeDefaultTubeline(MetroConfig cfg) {
        Tubelines tubelines = cfg.getTubelines();
        TubelineDefinition tDef = this.getDefaultTubeline(cfg);
        if (tDef != null) {
            tubelines.getTubelineDefinitions().remove(tDef);
        }
        tubelines.setDefault(null);
        this.clearTubelines(cfg);
    }

    private void clearTubelines(MetroConfig cfg) {
        Tubelines tubelines = cfg.getTubelines();
        List<TubelineDefinition> tDefs = tubelines.getTubelineDefinitions();
        if (tDefs == null || tDefs.isEmpty()) {
            cfg.setTubelines(null);
        }
    }

    private void removeTubeline(Tubelines tubelines, String tubelineRef) {
        TubelineDefinition tDef = this.getTubeline(tubelines, tubelineRef);
        if (tDef != null) {
            tubelines.getTubelineDefinitions().remove(tDef);
        }
    }

    private boolean isTubelineReferenced(Tubelines tubelines, String tubelineRef) {
        List<TubelineMapping> mappings = tubelines.getTubelineMappings();
        for (TubelineMapping mapping : mappings) {
            if (!tubelineRef.equals(mapping.getTubelineRef())) continue;
            return true;
        }
        return false;
    }

    public MetroConfig loadDefaultMetroConfig(Project project) {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
        if (classPath == null) {
            return null;
        }
        FileObject defFO = classPath.findResource("META-INF/metro-default.xml");
        try {
            if (defFO != null) {
                return this.loadMetroConfig(defFO.getURL());
            }
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public MetroConfig loadMetroConfig(Project project) {
        FileObject cfgFolder = this.getConfigFolder(project, false);
        if (cfgFolder != null && cfgFolder.isValid()) {
            try {
                FileObject cfgFile = cfgFolder.getFileObject(CFG_FILE_NAME);
                return cfgFile != null ? this.loadMetroConfig(cfgFile.getURL()) : null;
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private MetroConfig loadMetroConfig(@NotNull URL resourceUrl) {
        MetroConfig result = null;
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            JAXBElement configElement = unmarshaller.unmarshal(XMLInputFactory.newInstance().createXMLStreamReader(resourceUrl.openStream()), MetroConfig.class);
            result = (MetroConfig)configElement.getValue();
        }
        catch (Exception e) {
            Logger.global.warning(String.format("Unable to unmarshall metro config file from location: '%s'", resourceUrl.toString()));
        }
        return result;
    }

    public void saveMetroConfig(@NotNull MetroConfig metroConfig, Project project) {
        FileObject cfgFolder = this.getConfigFolder(project, false);
        if (cfgFolder != null && cfgFolder.isValid()) {
            File outFile = null;
            FileObject cfgFile = cfgFolder.getFileObject(CFG_FILE_NAME);
            if (metroConfig == null) {
                if (cfgFile != null && cfgFile.isValid()) {
                    outFile = FileUtil.toFile((FileObject)cfgFile);
                    outFile.delete();
                }
                return;
            }
            outFile = cfgFile != null && cfgFile.isValid() ? FileUtil.toFile((FileObject)cfgFile) : new File(FileUtil.toFile((FileObject)cfgFolder), CFG_FILE_NAME);
            this.saveMetroConfig(metroConfig, outFile);
        }
    }

    private void saveMetroConfig(@NotNull MetroConfig metroConfig, @NotNull File cfgFile) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)metroConfig, cfgFile);
        }
        catch (Exception e) {
            Logger.global.warning(String.format("Unable to marshall metro config to file: '%s'", cfgFile.toString()));
        }
    }

    public List<TubeFactoryConfig> createTubeFactoryConfigList(List<String> classList) {
        ArrayList<TubeFactoryConfig> tubeFacList = new ArrayList<TubeFactoryConfig>();
        for (String clsName : classList) {
            TubeFactoryConfig cfg = this.objFactory.createTubeFactoryConfig();
            cfg.setClassName(clsName);
            tubeFacList.add(cfg);
        }
        return tubeFacList;
    }

    public TubelineDefinition getDefaultTubeline(MetroConfig cfg) {
        return this.getDefaultTubeline(cfg.getTubelines());
    }

    private TubelineDefinition getDefaultTubeline(Tubelines tubelines) {
        if (tubelines == null) {
            return null;
        }
        return this.getTubeline(tubelines, tubelines.getDefault());
    }

    private TubelineDefinition getTubeline(Tubelines tubelines, String tubeRef) {
        if (tubeRef == null) {
            return null;
        }
        List<TubelineDefinition> tubelineDefs = tubelines.getTubelineDefinitions();
        for (TubelineDefinition tubelineDef : tubelineDefs) {
            if (!tubeRef.equals("#" + tubelineDef.getName())) continue;
            return tubelineDef;
        }
        return null;
    }

    public TubelineDefinition getTubeline(MetroConfig cfg, String endpointRef) {
        Tubelines tubelines = cfg.getTubelines();
        TubelineMapping mapping = MetroConfigLoader.getTubelineMapping(cfg, endpointRef);
        if (mapping != null) {
            return this.getTubeline(tubelines, mapping.getTubelineRef());
        }
        return null;
    }

    public static TubelineMapping getTubelineMapping(MetroConfig cfg, String endpointRef) {
        Tubelines tubelines = cfg.getTubelines();
        if (tubelines != null) {
            List<TubelineMapping> mappings = tubelines.getTubelineMappings();
            for (TubelineMapping mapping : mappings) {
                if (!endpointRef.equals(mapping.getEndpointRef())) continue;
                return mapping;
            }
        }
        return null;
    }

    private FileObject getConfigFolder(Project project, boolean client) {
        WsitProvider wsitProvider = (WsitProvider)project.getLookup().lookup(WsitProvider.class);
        return wsitProvider != null ? wsitProvider.getConfigFilesFolder(client) : null;
    }
}

