/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectSelectorPanel
extends JPanel
implements HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "ProjectSelectorPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ProjectSelectorPanel.HelpCtx");
    private List<Lookup.Provider> pool = new ArrayList<Lookup.Provider>();
    private List<Lookup.Provider> selection = new ArrayList<Lookup.Provider>();
    private AbstractListModel selectionModel = new AbstractListModel(){

        @Override
        public int getSize() {
            return ProjectSelectorPanel.this.selection.size();
        }

        @Override
        public Object getElementAt(int index) {
            return ProjectSelectorPanel.this.selection.get(index);
        }
    };
    private AbstractListModel poolModel = new AbstractListModel(){

        @Override
        public int getSize() {
            return ProjectSelectorPanel.this.pool.size();
        }

        @Override
        public Object getElementAt(int index) {
            return ProjectSelectorPanel.this.pool.get(index);
        }
    };
    private final Action selectProjectAction = new AbstractAction("selectProject"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProjectSelectorPanel.this.projectList.getModel().getSize() == 0) {
                return;
            }
            Object[] vals = ProjectSelectorPanel.this.projectList.getSelectedValues();
            Lookup.Provider[] projs = new Lookup.Provider[vals.length];
            System.arraycopy(vals, 0, projs, 0, vals.length);
            ProjectSelectorPanel.this.selectProjects(projs);
        }
    };
    private final Action unselectProjectAction = new AbstractAction("unselectProject"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProjectSelectorPanel.this.selectionList.getModel().getSize() == 0) {
                return;
            }
            Object[] vals = ProjectSelectorPanel.this.selectionList.getSelectedValues();
            Lookup.Provider[] projs = new Lookup.Provider[vals.length];
            System.arraycopy(vals, 0, projs, 0, vals.length);
            ProjectSelectorPanel.this.unselectProjects(projs);
        }
    };
    private JButton addButton;
    private JLabel jLabel1;
    private JLabel lblAvailable;
    private JLabel lblSelected;
    private JList projectList;
    private JButton removeButton;
    private JScrollPane scroller;
    private JScrollPane scroller1;
    private JList selectionList;

    public ProjectSelectorPanel() {
        this.initComponents();
        this.postInit();
        this.loadPool();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    private void initComponents() {
        this.lblAvailable = new JLabel();
        this.scroller = new JScrollPane();
        this.projectList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.lblSelected = new JLabel();
        this.scroller1 = new JScrollPane();
        this.selectionList = new JList();
        this.jLabel1 = new JLabel();
        this.lblAvailable.setDisplayedMnemonic('A');
        this.lblAvailable.setLabelFor(this.scroller);
        this.lblAvailable.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.lblAvailable.text"));
        this.projectList.setModel(this.poolModel);
        this.projectList.setVisibleRowCount(13);
        this.projectList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectSelectorPanel.this.projectListMouseClicked(evt);
            }
        });
        this.scroller.setViewportView(this.projectList);
        this.addButton.setAction(this.selectProjectAction);
        this.addButton.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.addButton.text"));
        this.addButton.setToolTipText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.addButton.toolTipText"));
        this.addButton.setMargin(new Insets(2, 8, 2, 8));
        this.removeButton.setAction(this.unselectProjectAction);
        this.removeButton.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.removeButton.text"));
        this.removeButton.setToolTipText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.removeButton.toolTipText"));
        this.removeButton.setActionCommand(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.removeButton.actionCommand"));
        this.removeButton.setMargin(new Insets(2, 8, 2, 8));
        this.lblSelected.setDisplayedMnemonic('S');
        this.lblSelected.setLabelFor(this.scroller1);
        this.lblSelected.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.lblSelected.text"));
        this.selectionList.setModel(this.selectionModel);
        this.selectionList.setVisibleRowCount(13);
        this.selectionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProjectSelectorPanel.this.selectionListMouseClicked(evt);
            }
        });
        this.scroller1.setViewportView(this.selectionList);
        this.jLabel1.setForeground(UIManager.getDefaults().getColor("Button.shadow"));
        this.jLabel1.setText(NbBundle.getMessage(ProjectSelectorPanel.class, (String)"ProjectSelectorPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.scroller, -1, 190, Short.MAX_VALUE).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton).addComponent(this.removeButton)).addGap(6, 6, 6)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblAvailable).addGap(125, 125, 125))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblSelected).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.scroller1, -1, 190, Short.MAX_VALUE).addGap(13, 13, 13)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAvailable).addComponent(this.lblSelected)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE)).addComponent(this.scroller).addComponent(this.scroller1)).addGap(10, 10, 10).addComponent(this.jLabel1).addContainerGap()));
    }

    private void projectListMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.selectProjectAction.actionPerformed(new ActionEvent(evt.getSource(), 1001, "selectProject"));
        }
    }

    private void selectionListMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.unselectProjectAction.actionPerformed(new ActionEvent(evt.getSource(), 1001, "unselectProject"));
        }
    }

    private void loadPool() {
        Lookup.Provider[] projects = ProjectUtilities.getOpenedProjects();
        Lookup.Provider curProj = this.getCurrentProject();
        if (curProj != null && projects != null) {
            Lookup.Provider[] newProjs = new Lookup.Provider[projects.length - 1];
            int cntr = 0;
            for (int i = 0; i < projects.length; ++i) {
                if (projects[i].equals(curProj)) continue;
                newProjs[cntr++] = projects[i];
            }
            projects = newProjs;
        }
        this.pool.addAll(Arrays.asList(projects));
    }

    private void selectProjects(Lookup.Provider ... project) {
        this.addProjects(this.selectionModel, this.selection, project);
        this.removeProjects(this.poolModel, this.pool, project);
    }

    private void unselectProjects(Lookup.Provider ... project) {
        this.addProjects(this.poolModel, this.pool, project);
        this.removeProjects(this.selectionModel, this.selection, project);
    }

    private void addProjects(AbstractListModel model, List<Lookup.Provider> data, Lookup.Provider ... project) {
        data.addAll(Arrays.asList(project));
        ListDataListener[] listeners = model.getListDataListeners();
        if (listeners.length == 0) {
            return;
        }
        ListDataEvent e = new ListDataEvent(this, 1, data.size() - project.length, data.size());
        for (ListDataListener l : model.getListDataListeners()) {
            l.intervalAdded(e);
        }
    }

    private void removeProjects(AbstractListModel model, List<Lookup.Provider> data, Lookup.Provider ... project) {
        data.removeAll(Arrays.asList(project));
        ListDataListener[] listeners = model.getListDataListeners();
        if (listeners.length == 0) {
            return;
        }
        ListDataEvent e = new ListDataEvent(this, 2, data.size(), data.size() + project.length);
        for (ListDataListener l : listeners) {
            l.intervalRemoved(e);
        }
    }

    public void setSelection(List<Lookup.Provider> selection) {
        this.selection.clear();
        this.selection.addAll(selection);
        int oldI = this.pool.size();
        this.pool.removeAll(selection);
        for (ListDataListener l : this.selectionModel.getListDataListeners()) {
            l.contentsChanged(new ListDataEvent(this, 1, 0, this.selection.size()));
        }
        for (ListDataListener l : this.poolModel.getListDataListeners()) {
            l.contentsChanged(new ListDataEvent(this, 2, 0, oldI));
            l.contentsChanged(new ListDataEvent(this, 1, 0, this.pool.size()));
        }
    }

    public List<Lookup.Provider> getSelection() {
        return new ArrayList<Lookup.Provider>(this.selection);
    }

    protected Lookup.Provider getCurrentProject() {
        return null;
    }

    private void postInit() {
        final ListCellRenderer r = this.projectList.getCellRenderer();
        ListCellRenderer r1 = new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = r.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel) {
                    ((JLabel)c).setText(ProjectUtilities.getDisplayName((Lookup.Provider)((Lookup.Provider)value)));
                    ((JLabel)c).setIcon(ProjectUtilities.getIcon((Lookup.Provider)((Lookup.Provider)value)));
                }
                return c;
            }
        };
        this.projectList.setCellRenderer(r1);
        this.selectionList.setCellRenderer(r1);
        this.projectList.getActionMap().put("selectProject", this.selectProjectAction);
        this.selectionList.getActionMap().put("unselectProject", this.unselectProjectAction);
        this.projectList.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "selectProject");
        this.selectionList.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "unselectProject");
    }
}

