/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;

public final class RunCalibrationAction
extends AbstractAction {
    public RunCalibrationAction() {
        this.putValue("Name", Bundle.LBL_RunCalibrationAction());
        this.putValue("ShortDescription", Bundle.HINT_RunCalibrationAction());
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        boolean terminate = false;
        boolean detach = false;
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.MSG_CalibrationOnProfile(), (String)Bundle.CAPTION_Question())) {
                    return;
                }
                terminate = true;
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.MSG_CalibrationOnAttach(), (String)Bundle.CAPTION_Question())) {
                    return;
                }
                detach = true;
            }
        }
        final boolean doDetach = detach;
        final boolean doStop = terminate;
        JavaPlatform platform = JavaPlatformSelector.getDefault().selectPlatformForCalibration();
        if (platform == null) {
            return;
        }
        final JavaPlatform calibratePlatform = platform;
        ProfilerUtils.getProfilerRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (doDetach) {
                    Profiler.getDefault().detachFromApp();
                } else if (doStop) {
                    Profiler.getDefault().stopApp();
                }
                if (!Profiler.getDefault().runCalibration(false, calibratePlatform.getPlatformJavaFile(), calibratePlatform.getPlatformJDKVersion(), calibratePlatform.getPlatformArchitecture())) {
                    ProfilerDialogs.displayError((String)Bundle.MSG_CalibrationFailed());
                }
            }
        }, 0, 10);
    }
}

