/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.actions.Bundle;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class CompareSnapshotsAction
extends AbstractAction {
    private static final HelpCtx EXTERNAL_SNAPSHOT_HELP_CTX = new HelpCtx("SelectExternalSnapshotsPanel.HelpCtx");
    private static final HelpCtx SECOND_SNAPSHOT_HELP_CTX = new HelpCtx("SelectSecondSnapshotPanel.HelpCtx");
    private static final Icon cpuIcon = Icons.getIcon((String)"ProfilerIcons.Cpu");
    private static final Icon fragmentIcon = Icons.getIcon((String)"ProfilerIcons.Fragment");
    private static final Icon memoryIcon = Icons.getIcon((String)"ProfilerIcons.Memory");
    private static JFileChooser snapshotFileChooser;
    private LoadedSnapshot snapshot = null;
    private SelectExternalSnapshotsPanel externalSnapshotsSelector;
    private SelectSecondSnapshotPanel secondSnapshotSelector;

    public CompareSnapshotsAction() {
        this.putValue("Name", Bundle.CompareSnapshotsAction_ActionName());
        this.putValue("ShortDescription", Bundle.CompareSnapshotsAction_ActionDescr());
        this.putValue("SmallIcon", Icons.getIcon((String)"ProfilerIcons.SnapshotsCompare"));
    }

    public CompareSnapshotsAction(LoadedSnapshot snapshot) {
        this();
        this.snapshot = snapshot;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.snapshot != null) {
            this.compareDefinedSnapshot();
        } else {
            this.compareExternalSnapshots();
        }
    }

    public static boolean areComparableSnapshots(LoadedSnapshot s1, LoadedSnapshot s2) {
        if (s1.getType() != s2.getType()) {
            return false;
        }
        return s1.getType() != 4 && s1.getType() != 8 || s1.getSettings().getAllocTrackEvery() == s2.getSettings().getAllocTrackEvery();
    }

    public static boolean areComparableSnapshots(LoadedSnapshot s1, FileObject s2f) {
        LoadedSnapshot s2 = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)s2f));
        if (s2 != null) {
            return CompareSnapshotsAction.areComparableSnapshots(s1, s2);
        }
        if (s1.getType() != ResultsManager.getDefault().getSnapshotType(s2f)) {
            return false;
        }
        if (s1.getType() == 4 || s1.getType() == 8) {
            ProfilingSettings s2settings = ResultsManager.getDefault().getSnapshotSettings(s2f);
            if (s2settings == null) {
                return false;
            }
            if (s1.getSettings().getAllocTrackEvery() != s2settings.getAllocTrackEvery()) {
                return false;
            }
        }
        return true;
    }

    public static boolean areComparableSnapshots(FileObject s1f, FileObject s2f) {
        LoadedSnapshot s1 = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)s1f));
        LoadedSnapshot s2 = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)s2f));
        if (s1 != null) {
            if (s2 != null) {
                return CompareSnapshotsAction.areComparableSnapshots(s1, s2);
            }
            return CompareSnapshotsAction.areComparableSnapshots(s1, s2f);
        }
        int s1t = ResultsManager.getDefault().getSnapshotType(s1f);
        if (s1t != ResultsManager.getDefault().getSnapshotType(s2f)) {
            return false;
        }
        if (s1t == 4 || s1t == 8) {
            ProfilingSettings s1s = ResultsManager.getDefault().getSnapshotSettings(s1f);
            ProfilingSettings s2s = ResultsManager.getDefault().getSnapshotSettings(s2f);
            if (s1s == null || s2s == null) {
                return false;
            }
            if (s1s.getAllocTrackEvery() != s2s.getAllocTrackEvery()) {
                return false;
            }
        }
        return true;
    }

    private static JFileChooser getSnapshotFileChooser() {
        if (snapshotFileChooser == null) {
            snapshotFileChooser = new JFileChooser();
            snapshotFileChooser.setFileSelectionMode(0);
            snapshotFileChooser.setMultiSelectionEnabled(false);
            snapshotFileChooser.setDialogType(0);
            snapshotFileChooser.setDialogTitle(Bundle.CompareSnapshotsAction_OpenChooserCaption());
            snapshotFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".nps");
                }

                @Override
                public String getDescription() {
                    return Bundle.CompareSnapshotsAction_OpenChooserFilter("nps");
                }
            });
        }
        return snapshotFileChooser;
    }

    private SelectExternalSnapshotsPanel getExternalSnapshotsSelector() {
        if (this.externalSnapshotsSelector == null) {
            this.externalSnapshotsSelector = new SelectExternalSnapshotsPanel();
        }
        return this.externalSnapshotsSelector;
    }

    private SelectSecondSnapshotPanel getSecondSnapshotSelector() {
        if (this.secondSnapshotSelector == null) {
            this.secondSnapshotSelector = new SelectSecondSnapshotPanel();
        }
        return this.secondSnapshotSelector;
    }

    private void compareDefinedSnapshot() {
        this.getSecondSnapshotSelector().populateSnapshotsList();
        DialogDescriptor desc = new DialogDescriptor((Object)this.getSecondSnapshotSelector(), Bundle.CompareSnapshotsAction_SelectSnapshotDialogCaption(), true, new Object[]{this.getSecondSnapshotSelector().getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (res.equals(this.getSecondSnapshotSelector().getOKButton())) {
            Object selectedSnapshot = this.getSecondSnapshotSelector().getSnapshot();
            if (selectedSnapshot instanceof LoadedSnapshot) {
                ResultsManager.getDefault().compareSnapshots(this.snapshot, (LoadedSnapshot)selectedSnapshot);
            } else if (selectedSnapshot instanceof FileObject) {
                if (this.snapshot.getFile() == null) {
                    LoadedSnapshot snapshot2 = ResultsManager.getDefault().getSnapshotFromFileObject((FileObject)selectedSnapshot);
                    if (snapshot2 != null) {
                        ResultsManager.getDefault().compareSnapshots(this.snapshot, snapshot2);
                    }
                } else {
                    ResultsManager.getDefault().compareSnapshots(FileUtil.toFileObject((File)this.snapshot.getFile()), (FileObject)selectedSnapshot);
                }
            }
        }
    }

    private void compareExternalSnapshots() {
        DialogDescriptor desc = new DialogDescriptor((Object)this.getExternalSnapshotsSelector(), Bundle.CompareSnapshotsAction_SelectSnapshotsDialogCaption(), true, new Object[]{this.getExternalSnapshotsSelector().getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (res.equals(this.getExternalSnapshotsSelector().getOKButton())) {
            ResultsManager.getDefault().compareSnapshots(FileUtil.toFileObject((File)new File(this.getExternalSnapshotsSelector().getSnapshot1Filename())), FileUtil.toFileObject((File)new File(this.getExternalSnapshotsSelector().getSnapshot2Filename())));
        }
    }

    private class SelectSecondSnapshotPanel
    extends JPanel
    implements HelpCtx.Provider {
        private JButton externalFileButton;
        private JButton okButton;
        private JLabel externalFileHintLabel;
        private JLabel projectSnapshotsHintLabel;
        private JLabel selectSnapshotLabel;
        private JList projectSnapshotsList;
        private JRadioButton fromFileRadio;
        private JRadioButton fromProjectRadio;
        private JTextField externalFileField;

        public SelectSecondSnapshotPanel() {
            this.initComponents();
        }

        public HelpCtx getHelpCtx() {
            return SECOND_SNAPSHOT_HELP_CTX;
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public Object getSnapshot() {
            if (this.fromProjectRadio.isSelected()) {
                Object selectedItem = this.projectSnapshotsList.getSelectedValue();
                if (selectedItem == null || selectedItem instanceof String) {
                    return null;
                }
                return selectedItem;
            }
            if (this.fromFileRadio.isSelected()) {
                File s;
                String sf = this.externalFileField.getText();
                if (sf.length() > 0 && (s = new File(sf)).exists() && s.isFile()) {
                    return FileUtil.toFileObject((File)s);
                }
                return null;
            }
            return null;
        }

        public void populateSnapshotsList() {
            DefaultListModel listModel = (DefaultListModel)this.projectSnapshotsList.getModel();
            listModel.removeAllElements();
            LoadedSnapshot[] loadedSnapshots = ResultsManager.getDefault().getLoadedSnapshots();
            for (int i = 0; i < loadedSnapshots.length; ++i) {
                if (loadedSnapshots[i] == CompareSnapshotsAction.this.snapshot || loadedSnapshots[i].getFile() != null || !CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, loadedSnapshots[i])) continue;
                listModel.addElement(loadedSnapshots[i]);
            }
            final Lookup.Provider project = CompareSnapshotsAction.this.snapshot.getProject();
            File snapFile = CompareSnapshotsAction.this.snapshot.getFile();
            final File snapshotDir = snapFile != null ? snapFile.getParentFile() : null;
            FileObject[] snapshotsOnDisk = ResultsManager.getDefault().listSavedSnapshots(project, snapshotDir);
            FileObject snapshotFile = snapFile != null ? FileUtil.toFileObject((File)snapFile) : null;
            for (int i = 0; i < snapshotsOnDisk.length; ++i) {
                if (snapshotFile != null && snapshotsOnDisk[i].equals(snapshotFile) || !CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, snapshotsOnDisk[i])) continue;
                listModel.addElement(snapshotsOnDisk[i]);
            }
            if (listModel.getSize() == 0) {
                listModel.addElement(Bundle.CompareSnapshotsAction_NoComparableSnapshotsFoundMsg());
                this.fromFileRadio.setSelected(true);
                this.externalFileField.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.externalFileField.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.externalFileField.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            } else {
                this.projectSnapshotsList.setSelectedIndex(0);
                this.projectSnapshotsList.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.projectSnapshotsList.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.projectSnapshotsList.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (project != null) {
                        Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)Bundle.CompareSnapshotsAction_FromProjectRadioText());
                        SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(null);
                    } else {
                        Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)Bundle.CompareSnapshotsAction_FromCurrentLocationRadioText());
                        SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(snapshotDir != null ? snapshotDir.getAbsolutePath() : null);
                    }
                }
            });
        }

        private void initComponents() {
            this.okButton = new JButton(Bundle.CompareSnapshotsAction_OkButtonText());
            this.setLayout(new GridBagLayout());
            ButtonGroup group = new ButtonGroup();
            this.selectSnapshotLabel = new JLabel(Bundle.CompareSnapshotsAction_SelectSnapshotString());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(15, 10, 8, 10);
            this.add((Component)this.selectSnapshotLabel, c);
            this.fromProjectRadio = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.fromProjectRadio, (String)Bundle.CompareSnapshotsAction_FromProjectRadioText());
            group.add(this.fromProjectRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_SelectSnapshotString() + Bundle.CompareSnapshotsAction_FromProjectRadioText());
            this.fromProjectRadio.setSelected(true);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15, 0, 10);
            this.add((Component)this.fromProjectRadio, c);
            this.projectSnapshotsList = new JList(new DefaultListModel());
            this.projectSnapshotsList.getAccessibleContext().setAccessibleName(Bundle.CompareSnapshotsAction_SnapshotsListAccessDescr());
            this.projectSnapshotsList.setVisibleRowCount(5);
            this.projectSnapshotsList.setSelectionMode(0);
            JScrollPane projectSnapshotsListScroll = new JScrollPane(this.projectSnapshotsList, 20, 31);
            projectSnapshotsListScroll.setPreferredSize(new Dimension(1, projectSnapshotsListScroll.getPreferredSize().height));
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.weighty = 1.0;
            c.gridwidth = 0;
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)projectSnapshotsListScroll, c);
            this.projectSnapshotsHintLabel = new JLabel(Bundle.CompareSnapshotsAction_OnlyComparableListedString());
            this.projectSnapshotsHintLabel.setForeground(Color.darkGray);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.projectSnapshotsHintLabel, c);
            this.fromFileRadio = new JRadioButton(Bundle.CompareSnapshotsAction_FromFileRadioText());
            Mnemonics.setLocalizedText((AbstractButton)this.fromFileRadio, (String)Bundle.CompareSnapshotsAction_FromFileRadioText());
            group.add(this.fromFileRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_SelectSnapshotString() + Bundle.CompareSnapshotsAction_FromFileRadioText());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(5, 15, 0, 10);
            this.add((Component)this.fromFileRadio, c);
            this.externalFileField = new JTextField();
            this.externalFileField.setPreferredSize(new Dimension(250, this.externalFileField.getPreferredSize().height));
            this.externalFileField.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 5;
            c.weightx = 1.0;
            c.gridwidth = 2;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.externalFileField, c);
            this.externalFileButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.externalFileButton, (String)Bundle.CompareSnapshotsAction_BrowseButtonText());
            this.externalFileButton.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_BrowseButtonAccessDescr());
            this.externalFileButton.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 5;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.externalFileButton, c);
            this.externalFileHintLabel = new JLabel(" ");
            this.externalFileHintLabel.setForeground(Color.darkGray);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 6;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.externalFileHintLabel, c);
            this.projectSnapshotsList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    ResultsManager rm = ResultsManager.getDefault();
                    if (value instanceof LoadedSnapshot) {
                        LoadedSnapshot ls = (LoadedSnapshot)value;
                        c.setFont(c.getFont().deriveFont(1));
                        c.setText(rm.getSnapshotDisplayName(ls));
                        switch (ls.getType()) {
                            case 1: {
                                c.setIcon(cpuIcon);
                                break;
                            }
                            case 2: {
                                c.setIcon(fragmentIcon);
                                break;
                            }
                            case 4: 
                            case 8: 
                            case 16: {
                                c.setIcon(memoryIcon);
                            }
                        }
                    } else if (value instanceof FileObject) {
                        FileObject fo = (FileObject)value;
                        LoadedSnapshot ls = rm.findLoadedSnapshot(FileUtil.toFile((FileObject)fo));
                        if (ls != null) {
                            c.setFont(c.getFont().deriveFont(1));
                            c.setText(rm.getSnapshotDisplayName(ls));
                            switch (ls.getType()) {
                                case 1: {
                                    c.setIcon(cpuIcon);
                                    break;
                                }
                                case 2: {
                                    c.setIcon(fragmentIcon);
                                    break;
                                }
                                case 4: 
                                case 8: 
                                case 16: {
                                    c.setIcon(memoryIcon);
                                }
                            }
                        } else {
                            int type = rm.getSnapshotType(fo);
                            c.setText(rm.getSnapshotDisplayName(fo.getName(), type));
                            switch (type) {
                                case 1: {
                                    c.setIcon(cpuIcon);
                                    break;
                                }
                                case 2: {
                                    c.setIcon(fragmentIcon);
                                    break;
                                }
                                case 4: 
                                case 8: 
                                case 16: {
                                    c.setIcon(memoryIcon);
                                }
                            }
                        }
                    }
                    return c;
                }
            });
            this.projectSnapshotsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.projectSnapshotsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2 && SelectSecondSnapshotPanel.this.projectSnapshotsList.getSelectedValue() != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SelectSecondSnapshotPanel.this.okButton.doClick();
                            }
                        });
                    }
                }
            });
            this.fromProjectRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SelectSecondSnapshotPanel.this.projectSnapshotsList.setEnabled(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected());
                    SelectSecondSnapshotPanel.this.projectSnapshotsHintLabel.setText(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected() ? Bundle.CompareSnapshotsAction_OnlyComparableListedString() : " ");
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.fromFileRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SelectSecondSnapshotPanel.this.externalFileField.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    SelectSecondSnapshotPanel.this.externalFileButton.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    if (!SelectSecondSnapshotPanel.this.fromFileRadio.isSelected()) {
                        SelectSecondSnapshotPanel.this.externalFileHintLabel.setText(" ");
                    }
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            };
            this.externalFileField.getDocument().addDocumentListener(documentListener);
            this.externalFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    JFileChooser snapshotChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    snapshotChooser.setCurrentDirectory(new File(SelectSecondSnapshotPanel.this.externalFileField.getText()));
                    if (snapshotChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = snapshotChooser.getSelectedFile()) != null) {
                        SelectSecondSnapshotPanel.this.externalFileField.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.fromProjectRadio.isSelected()) {
                Object selectedItem = this.projectSnapshotsList.getSelectedValue();
                this.okButton.setEnabled(selectedItem != null && !(selectedItem instanceof String));
            } else if (this.fromFileRadio.isSelected()) {
                String sf = this.externalFileField.getText();
                if (sf.length() > 0) {
                    File s = new File(sf);
                    if (s.exists() && s.isFile()) {
                        if (s.equals(CompareSnapshotsAction.this.snapshot.getFile())) {
                            this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_ComparingSameSnapshotsMsg());
                            this.okButton.setEnabled(false);
                        } else {
                            FileObject snapshot2f = FileUtil.toFileObject((File)s);
                            if (CompareSnapshotsAction.this.snapshot.getType() != ResultsManager.getDefault().getSnapshotType(snapshot2f)) {
                                this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_DifferentSnapshotsTypeMsg());
                            } else if (CompareSnapshotsAction.this.snapshot.getSettings().getAllocTrackEvery() != ResultsManager.getDefault().getSnapshotSettings(snapshot2f).getAllocTrackEvery()) {
                                this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_DifferentObjectsCountsMsg());
                            } else {
                                this.externalFileHintLabel.setText(" ");
                            }
                            this.okButton.setEnabled(CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, snapshot2f));
                        }
                    } else {
                        this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_InvalidFileMsg());
                        this.okButton.setEnabled(false);
                    }
                } else {
                    this.externalFileHintLabel.setText(Bundle.CompareSnapshotsAction_EnterFileMsg());
                    this.okButton.setEnabled(false);
                }
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    private static class SelectExternalSnapshotsPanel
    extends JPanel
    implements HelpCtx.Provider {
        private JButton okButton;
        private JButton snapshot1Button;
        private JButton snapshot2Button;
        private JLabel hintLabel;
        private JLabel snapshot1Label;
        private JLabel snapshot2Label;
        private JTextField snapshot1Field;
        private JTextField snapshot2Field;

        public SelectExternalSnapshotsPanel() {
            this.initComponents();
        }

        public HelpCtx getHelpCtx() {
            return EXTERNAL_SNAPSHOT_HELP_CTX;
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public String getSnapshot1Filename() {
            return this.snapshot1Field.getText();
        }

        public String getSnapshot2Filename() {
            return this.snapshot2Field.getText();
        }

        private void initComponents() {
            this.okButton = new JButton(Bundle.CompareSnapshotsAction_OkButtonText());
            this.setLayout(new GridBagLayout());
            this.snapshot1Label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.snapshot1Label, (String)Bundle.CompareSnapshotsAction_Snapshot1String());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(15, 10, 5, 5);
            this.add((Component)this.snapshot1Label, c);
            this.snapshot1Field = new JTextField();
            this.snapshot1Field.setPreferredSize(new Dimension(250, this.snapshot1Field.getPreferredSize().height));
            this.snapshot1Label.setLabelFor(this.snapshot1Field);
            this.snapshot1Field.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_SnapshotAccessDescr());
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(15, 5, 5, 5);
            this.add((Component)this.snapshot1Field, c);
            this.snapshot1Button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.snapshot1Button, (String)Bundle.CompareSnapshotsAction_BrowseButtonText());
            this.snapshot1Button.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_BrowseButtonAccessDescr());
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(15, 5, 5, 10);
            this.add((Component)this.snapshot1Button, c);
            this.snapshot2Label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.snapshot2Label, (String)Bundle.CompareSnapshotsAction_Snapshot2String());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(5, 10, 5, 5);
            this.add((Component)this.snapshot2Label, c);
            this.snapshot2Field = new JTextField();
            this.snapshot2Field.setPreferredSize(new Dimension(250, this.snapshot2Field.getPreferredSize().height));
            this.snapshot2Label.setLabelFor(this.snapshot2Field);
            this.snapshot2Field.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_SnapshotAccessDescr());
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.snapshot2Field, c);
            this.snapshot2Button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.snapshot2Button, (String)Bundle.CompareSnapshotsAction_Browse2ButtonText());
            this.snapshot2Button.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsAction_BrowseButtonAccessDescr());
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.snapshot2Button, c);
            this.hintLabel = new JLabel(" ");
            this.hintLabel.setForeground(Color.darkGray);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 2;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.hintLabel, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 0;
            c.weighty = 1.0;
            c.anchor = 18;
            c.fill = 1;
            this.add((Component)new JPanel(new FlowLayout(0, 0, 3)), c);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }
            };
            this.snapshot1Field.getDocument().addDocumentListener(documentListener);
            this.snapshot2Field.getDocument().addDocumentListener(documentListener);
            this.snapshot1Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    JFileChooser snapshotChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    snapshotChooser.setCurrentDirectory(new File(SelectExternalSnapshotsPanel.this.getSnapshot1Filename()));
                    if (snapshotChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = snapshotChooser.getSelectedFile()) != null) {
                        SelectExternalSnapshotsPanel.this.snapshot1Field.setText(file.getAbsolutePath());
                    }
                }
            });
            this.snapshot2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    JFileChooser snapshotChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    snapshotChooser.setCurrentDirectory(new File(SelectExternalSnapshotsPanel.this.getSnapshot2Filename().length() == 0 ? SelectExternalSnapshotsPanel.this.getSnapshot1Filename() : SelectExternalSnapshotsPanel.this.getSnapshot2Filename()));
                    if (snapshotChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = snapshotChooser.getSelectedFile()) != null) {
                        SelectExternalSnapshotsPanel.this.snapshot2Field.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            String s1f = this.getSnapshot1Filename();
            String s2f = this.getSnapshot2Filename();
            if (s1f.length() > 0 && s2f.length() > 0) {
                final File s1 = new File(s1f);
                final File s2 = new File(s2f);
                if (s1.exists() && s1.isFile() && s2.exists() && s2.isFile()) {
                    if (s1.equals(s2)) {
                        this.hintLabel.setText(Bundle.CompareSnapshotsAction_ComparingSameSnapshotsMsg());
                        this.okButton.setEnabled(false);
                    } else {
                        new NBSwingWorker(true){
                            private String hintStr;
                            private boolean enabledOk;

                            protected void doInBackground() {
                                int s2t;
                                FileObject s1fo = FileUtil.toFileObject((File)s1);
                                FileObject s2fo = FileUtil.toFileObject((File)s2);
                                int s1t = ResultsManager.getDefault().getSnapshotType(s1fo);
                                if (s1t != (s2t = ResultsManager.getDefault().getSnapshotType(s2fo))) {
                                    this.hintStr = Bundle.CompareSnapshotsAction_DifferentSnapshotsTypeMsg();
                                    this.enabledOk = false;
                                } else if (ResultsManager.getDefault().getSnapshotSettings(s1fo).getAllocTrackEvery() != ResultsManager.getDefault().getSnapshotSettings(s2fo).getAllocTrackEvery()) {
                                    this.hintStr = Bundle.CompareSnapshotsAction_DifferentObjectsCountsMsg();
                                    this.enabledOk = false;
                                } else {
                                    this.hintStr = " ";
                                    this.enabledOk = CompareSnapshotsAction.areComparableSnapshots(s1fo, s2fo);
                                }
                            }

                            protected void done() {
                                SelectExternalSnapshotsPanel.this.hintLabel.setText(this.hintStr);
                                SelectExternalSnapshotsPanel.this.okButton.setEnabled(this.enabledOk);
                            }
                        }.execute();
                    }
                } else {
                    this.hintLabel.setText(Bundle.CompareSnapshotsAction_InvalidFilesMsg());
                    this.okButton.setEnabled(false);
                }
            } else {
                this.hintLabel.setText(Bundle.CompareSnapshotsAction_SelectSnapshotsString());
                this.okButton.setEnabled(false);
            }
        }
    }
}

