/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Action;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.ui.ResultsView;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.graphs.MemoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.SurvivingGenerationsGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.ThreadsGraphPanel;
import org.netbeans.lib.profiler.ui.monitor.VMTelemetryModels;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public final class TelemetryWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY = "TelemetryWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TelemetryWindow.HelpCtx");
    private static TelemetryWindow defaultInstance;
    private static final Image windowIcon;
    private final GraphTab generationsPanel;
    private final GraphTab heapPanel;
    private final GraphTab threadsStatsPanel;
    private final ResultsView telemetryView;
    private final MemoryGraphPanel heapGraph;
    private final SurvivingGenerationsGraphPanel generationsGraph;
    private final ThreadsGraphPanel threadsStatsGraph;

    public TelemetryWindow() {
        this.setName(Bundle.LAB_TelemetryWindowName());
        this.setIcon(windowIcon);
        this.getAccessibleContext().setAccessibleDescription(Bundle.TelemetryWindow_TelemetryAccessDescr());
        this.setLayout(new BorderLayout());
        this.telemetryView = new ResultsView();
        this.add((Component)this.telemetryView, "Center");
        this.heapGraph = MemoryGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.generationsGraph = SurvivingGenerationsGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.threadsStatsGraph = ThreadsGraphPanel.createBigPanel((VMTelemetryModels)NetBeansProfiler.getDefaultNB().getVMTelemetryModels());
        this.heapPanel = new GraphTab((GraphPanel)this.heapGraph);
        this.generationsPanel = new GraphTab((GraphPanel)this.generationsGraph);
        this.threadsStatsPanel = new GraphTab((GraphPanel)this.threadsStatsGraph);
        this.telemetryView.addView(Bundle.TelemetryWindow_MemoryHeapTabName(), null, Bundle.TelemetryWindow_MemoryHeapTabDescr(), this.heapPanel.getComponent(), this.heapPanel.getToolbar());
        this.telemetryView.addView(Bundle.TelemetryWindow_MemoryGCTabName(), null, Bundle.TelemetryWindow_MemoryGCTabDescr(), this.generationsPanel.getComponent(), this.generationsPanel.getToolbar());
        this.telemetryView.addView(Bundle.TelemetryWindow_ThreadsStatisticsTabName(), null, Bundle.TelemetryWindow_ThreadsStatisticsTabDescr(), this.threadsStatsPanel.getComponent(), this.threadsStatsPanel.getToolbar());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    public static TelemetryWindow getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new TelemetryWindow();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public static void closeIfOpened() {
        if (defaultInstance != null) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultInstance.isOpened()) {
                        defaultInstance.close();
                    }
                }
            });
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.threadsStatsGraph;
    }

    public void showGC() {
        this.telemetryView.selectView(this.generationsPanel.getComponent());
        this.open();
        this.requestActive();
    }

    public void showHeap() {
        this.telemetryView.selectView(this.heapPanel.getComponent());
        this.open();
        this.requestActive();
    }

    public void showThreads() {
        this.telemetryView.selectView(this.threadsStatsPanel.getComponent());
        this.open();
        this.requestActive();
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowTelemetry");
    }

    private static final class GraphTab
    implements SaveViewAction.ViewProvider,
    ExportAction.ExportProvider {
        private final GraphPanel panel;
        private final ProfilerToolbar toolBar;
        private final ExportAction exportActionButton;

        public GraphTab(GraphPanel panel) {
            this.panel = panel;
            this.toolBar = ProfilerToolbar.create((boolean)true);
            this.exportActionButton = new ExportAction(this, null);
            this.toolBar.add((Action)this.exportActionButton);
            this.toolBar.add((Action)new SaveViewAction(this));
            this.toolBar.addSeparator();
            for (Action action : panel.getActions()) {
                this.toolBar.add(action);
            }
        }

        public Component getToolbar() {
            return this.toolBar.getComponent();
        }

        public Component getComponent() {
            return this.panel;
        }

        @Override
        public BufferedImage getViewImage(boolean onlyVisibleArea) {
            return UIUtils.createScreenshot((Component)this.panel);
        }

        @Override
        public String getViewName() {
            if (this.panel instanceof MemoryGraphPanel) {
                return "memory-heap";
            }
            if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                return "memory-gc";
            }
            if (this.panel instanceof ThreadsGraphPanel) {
                return "threads-statistics";
            }
            return null;
        }

        @Override
        public boolean fitsVisibleArea() {
            return true;
        }

        @Override
        public boolean hasView() {
            return true;
        }

        private void exportCSVData(String separator, ExportDataDumper eDD) {
            VMTelemetryDataManager data = Profiler.getDefault().getVMTelemetryManager();
            String newLine = "\r\n";
            String quote = "\"";
            int nItems = data.getItemCount();
            long[] col1 = new long[nItems];
            long[] col2 = new long[nItems];
            long[] col3 = new long[nItems];
            String col1Name = Bundle.Timestamp();
            String col2Name = "";
            String col3Name = "";
            System.arraycopy(data.timeStamps, 0, col1, 0, nItems);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(data.totalMemory, 0, col2, 0, nItems);
                System.arraycopy(data.usedMemory, 0, col3, 0, nItems);
                col2Name = Bundle.Heap_Size_in_Bytes();
                col3Name = Bundle.Used_Heap_in_Bytes();
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(data.nSurvivingGenerations, 0, col2, 0, nItems);
                System.arraycopy(data.relativeGCTimeInPerMil, 0, col3, 0, nItems);
                col2Name = Bundle.Surviving_Generations();
                col3Name = Bundle.Relative_Time_Spent_in_GC();
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(data.nTotalThreads, 0, col2, 0, nItems);
                System.arraycopy(data.loadedClassesCount, 0, col3, 0, nItems);
                col2Name = Bundle.Number_of_Threads();
                col3Name = Bundle.Loaded_Classes_Count();
            }
            eDD.dumpData(new StringBuffer(quote + col1Name + quote + separator + quote + col2Name + quote + separator + quote + col3Name + quote + newLine));
            Date d = new Date();
            for (int i = 0; i < nItems; ++i) {
                d.setTime(col1[i]);
                eDD.dumpData(new StringBuffer(quote + DateFormat.getDateTimeInstance().format(d) + quote + separator + quote + col2[i] + quote + separator + quote + col3[i] + quote + newLine));
            }
            eDD.close();
        }

        private void exportHTMLData(ExportDataDumper eDD) {
            VMTelemetryDataManager data = Profiler.getDefault().getVMTelemetryManager();
            int nItems = data.getItemCount();
            long[] col1 = new long[nItems];
            long[] col2 = new long[nItems];
            long[] col3 = new long[nItems];
            String col1Name = Bundle.Timestamp();
            String col2Name = new String();
            String col3Name = new String();
            String viewName = new String();
            System.arraycopy(data.timeStamps, 0, col1, 0, nItems);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(data.totalMemory, 0, col2, 0, nItems);
                System.arraycopy(data.usedMemory, 0, col3, 0, nItems);
                viewName = Bundle.TelemetryWindow_MemoryHeapTabName();
                col2Name = Bundle.Heap_Size_in_Bytes();
                col3Name = Bundle.Used_Heap_in_Bytes();
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(data.nSurvivingGenerations, 0, col2, 0, nItems);
                System.arraycopy(data.relativeGCTimeInPerMil, 0, col3, 0, nItems);
                viewName = Bundle.TelemetryWindow_MemoryGCTabName();
                col2Name = Bundle.Surviving_Generations();
                col3Name = Bundle.Relative_Time_Spent_in_GC();
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(data.nTotalThreads, 0, col2, 0, nItems);
                System.arraycopy(data.loadedClassesCount, 0, col3, 0, nItems);
                viewName = Bundle.TelemetryWindow_ThreadsStatisticsTabName();
                col2Name = Bundle.Number_of_Threads();
                col3Name = Bundle.Loaded_Classes_Count();
            }
            StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE></HEAD><BODY><table border=\"1\"><tr>");
            result.append("<th>").append(col1Name).append("</th><th>").append(col2Name).append("</th><th>").append(col3Name).append("</th></tr>");
            eDD.dumpData(result);
            Date d = new Date();
            for (int i = 0; i < nItems; ++i) {
                d.setTime(col1[i]);
                eDD.dumpData(new StringBuffer("<tr><td>" + DateFormat.getDateTimeInstance().format(d) + "</td><td align=right>" + col2[i] + "</td><td align=right>" + col3[i] + "</td></tr>"));
            }
            eDD.dumpDataAndClose(new StringBuffer("</table></BODY></HTML>"));
        }

        private void exportXMLData(ExportDataDumper eDD) {
            VMTelemetryDataManager data = Profiler.getDefault().getVMTelemetryManager();
            int nItems = data.getItemCount();
            long[] col1 = new long[nItems];
            long[] col2 = new long[nItems];
            long[] col3 = new long[nItems];
            String col1Name = Bundle.Timestamp();
            String col2Name = new String();
            String col3Name = new String();
            String viewName = new String();
            System.arraycopy(data.timeStamps, 0, col1, 0, nItems);
            if (this.panel instanceof MemoryGraphPanel) {
                System.arraycopy(data.totalMemory, 0, col2, 0, nItems);
                System.arraycopy(data.usedMemory, 0, col3, 0, nItems);
                viewName = Bundle.TelemetryWindow_MemoryHeapTabName();
                col2Name = Bundle.Heap_Size_in_Bytes();
                col3Name = Bundle.Used_Heap_in_Bytes();
            } else if (this.panel instanceof SurvivingGenerationsGraphPanel) {
                System.arraycopy(data.nSurvivingGenerations, 0, col2, 0, nItems);
                System.arraycopy(data.relativeGCTimeInPerMil, 0, col3, 0, nItems);
                viewName = Bundle.TelemetryWindow_MemoryGCTabName();
                col2Name = Bundle.Surviving_Generations();
                col3Name = Bundle.Relative_Time_Spent_in_GC();
            } else if (this.panel instanceof ThreadsGraphPanel) {
                System.arraycopy(data.nTotalThreads, 0, col2, 0, nItems);
                System.arraycopy(data.loadedClassesCount, 0, col3, 0, nItems);
                viewName = Bundle.TelemetryWindow_ThreadsStatisticsTabName();
                col2Name = Bundle.Number_of_Threads();
                col3Name = Bundle.Loaded_Classes_Count();
            }
            String newline = System.getProperty("line.separator");
            StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\">" + newline);
            result.append("<TableData NumRows=\"").append(nItems).append("\" NumColumns=\"3\">").append(newline).append(" <TableHeader>");
            result.append(" <TableColumn>").append(col1Name).append(" </TableColumn>").append(newline).append(" <TableColumn>").append(col2Name).append(" </TableColumn>").append(newline).append(" <TableColumn>").append(col3Name).append(" </TableColumn>").append(newline);
            result.append(" </TableHeader>").append(newline).append(" <TableBody>").append(newline);
            eDD.dumpData(result);
            Date d = new Date();
            for (int i = 0; i < nItems; ++i) {
                d.setTime(col1[i]);
                result = new StringBuffer("  <TableRow>" + newline + "   <TableCell>" + DateFormat.getDateTimeInstance().format(d) + "</TableCell>" + newline);
                result.append("   <TableCell>").append(col2[i]).append("</TableCell>").append(newline);
                result.append("   <TableCell>").append(col3[i]).append("</TableCell>").append(newline).append("  </TableRow>").append(newline);
                eDD.dumpData(result);
            }
            eDD.dumpDataAndClose(new StringBuffer(" </TableBody>" + newline + "</TableData>" + newline + "</ExportedView>"));
        }

        @Override
        public void exportData(int exportedFileType, ExportDataDumper eDD) {
            if (this.panel instanceof MemoryGraphPanel || this.panel instanceof SurvivingGenerationsGraphPanel || this.panel instanceof ThreadsGraphPanel) {
                switch (exportedFileType) {
                    case 1: {
                        this.exportCSVData(",", eDD);
                        break;
                    }
                    case 2: {
                        this.exportCSVData(";", eDD);
                        break;
                    }
                    case 3: {
                        this.exportXMLData(eDD);
                        break;
                    }
                    case 4: {
                        this.exportHTMLData(eDD);
                    }
                }
            }
        }

        @Override
        public boolean hasExportableView() {
            return Profiler.getDefault().getVMTelemetryManager().getItemCount() > 0;
        }

        @Override
        public boolean hasLoadedSnapshot() {
            return false;
        }
    }
}

