/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.MonitoringGraphsPanel;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class TelemetryOverviewPanel
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY = "TelemetryOverviewPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TelemetryOverviewPanel.HelpCtx");
    private static TelemetryOverviewPanel defaultInstance;
    private static final Image windowIcon;
    private static final String ID = "profiler_to";
    private static final Dimension PREFFERED_SIZE;
    private final MonitoringGraphsPanel graphsPanel;

    public TelemetryOverviewPanel() {
        this.setName(Bundle.LAB_TelemetryOverviewPanelName());
        this.setIcon(windowIcon);
        this.setToolTipText(Bundle.TelemetryOverviewPanel_TelemetryOverviewAccessDescr());
        this.graphsPanel = new MonitoringGraphsPanel();
        JScrollPane graphsPanelScroll = new JScrollPane(this.graphsPanel, 20, 30);
        graphsPanelScroll.setBorder(BorderFactory.createEmptyBorder());
        graphsPanelScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        graphsPanelScroll.getHorizontalScrollBar().setUnitIncrement(20);
        graphsPanelScroll.getHorizontalScrollBar().setBlockIncrement(20);
        this.setLayout(new BorderLayout());
        this.add(graphsPanelScroll, "Center");
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    public static synchronized TelemetryOverviewPanel getDefault() {
        if (defaultInstance == null) {
            CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    defaultInstance = (TelemetryOverviewPanel)WindowManager.getDefault().findTopComponent(TelemetryOverviewPanel.ID);
                    if (defaultInstance == null) {
                        defaultInstance = new TelemetryOverviewPanel();
                    }
                }
            });
        }
        return defaultInstance;
    }

    public static synchronized void closeIfOpened() {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (defaultInstance != null && defaultInstance.isOpened()) {
                    defaultInstance.close();
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPersistenceType() {
        return 0;
    }

    public Dimension getPrefferedSize() {
        return PREFFERED_SIZE;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.graphsPanel;
    }

    public boolean needsDocking() {
        return WindowManager.getDefault().findMode((TopComponent)this) == null;
    }

    public void open() {
        Mode mode;
        if (this.needsDocking() && (mode = WindowManager.getDefault().findMode(Bundle.TelemetryOverviewPanel_WindowMode())) != null) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected String preferredID() {
        return ID;
    }

    static {
        windowIcon = Icons.getImage((String)"ProfilerIcons.WindowTelemetryOverview");
        PREFFERED_SIZE = new Dimension(580, 430);
    }
}

