/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SnapshotInfoPanel
extends JPanel {
    private static final HelpCtx HELP_CTX = new HelpCtx("EditUserComments.HelpCtx");
    private HTMLTextArea infoArea;
    private JScrollPane infoAreaScrollPane;
    private LoadedSnapshot loadedSnapshot;

    public SnapshotInfoPanel(LoadedSnapshot snapshot) {
        this.setLayout(new BorderLayout());
        this.infoArea = new HTMLTextArea(){

            protected void showURL(URL url) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String userComments = SnapshotInfoPanel.this.loadedSnapshot.getUserComments();
                        UserCommentsPanel panel = new UserCommentsPanel();
                        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.SnapshotInfoPanel_UserCommentsCaption(), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, HELP_CTX, null);
                        panel.setInputText(userComments);
                        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                        d.setVisible(true);
                        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                            SnapshotInfoPanel.this.setUserComments(panel.getInputText());
                        }
                    }
                });
            }

            public void scrollRectToVisible(Rectangle aRect) {
                if (this.isShowing()) {
                    super.scrollRectToVisible(aRect);
                }
            }
        };
        this.infoArea.getAccessibleContext().setAccessibleName(Bundle.SnapshotInfoPanel_InfoAreaAccessName());
        this.infoArea.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.infoAreaScrollPane = new JScrollPane((Component)this.infoArea);
        this.infoAreaScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.infoAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.infoAreaScrollPane, "Center");
        this.loadedSnapshot = snapshot;
        this.updateInfo();
    }

    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot((Component)this.infoAreaScrollPane);
        }
        return UIUtils.createScreenshot((Component)this.infoArea);
    }

    public boolean fitsVisibleArea() {
        return !this.infoAreaScrollPane.getVerticalScrollBar().isVisible();
    }

    public void setUserComments(String userComments) {
        this.loadedSnapshot.setUserComments(userComments);
        if (!this.loadedSnapshot.isSaved()) {
            this.updateInfo();
            final File snapshotFile = this.loadedSnapshot.getFile();
            if (snapshotFile != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ResultsManager.getDefault().saveSnapshot(SnapshotInfoPanel.this.loadedSnapshot, FileUtil.toFileObject((File)snapshotFile));
                    }
                });
            }
        }
    }

    public void updateInfo() {
        ProfilingSettings ps = this.loadedSnapshot.getSettings();
        StringBuffer htmlText = new StringBuffer(1000);
        String infoRes = Icons.getResource((String)"GeneralIcons.Info");
        String summaryStr = Bundle.SnapshotInfoPanel_SummaryString();
        htmlText.append("<b><img border='0' align='bottom' src='nbresloc:/").append(infoRes).append("'>&nbsp;&nbsp;").append(summaryStr).append("</b><br><hr>");
        htmlText.append("<div style='margin-left: 10px;'>");
        htmlText.append("<strong>");
        htmlText.append(Bundle.SnapshotInfoPanel_DataCollectedFromString()).append(" ");
        htmlText.append("</strong>");
        htmlText.append(StringUtils.formatFullDate((Date)new Date(this.loadedSnapshot.getSnapshot().getBeginTime())));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(Bundle.SnapshotInfoPanel_SnapshotTakenAtString()).append(" ");
        htmlText.append("</strong>");
        htmlText.append(StringUtils.formatFullDate((Date)new Date(this.loadedSnapshot.getSnapshot().getTimeTaken())));
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(Bundle.SnapshotInfoPanel_FileString()).append(" ");
        htmlText.append("</strong>");
        File f = this.loadedSnapshot.getFile();
        if (f == null) {
            htmlText.append(Bundle.SnapshotInfoPanel_NotSavedString());
        } else {
            htmlText.append(f.getAbsolutePath());
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_FileSizeString()).append(" ");
            htmlText.append("</strong>");
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setGroupingUsed(true);
            htmlText.append(format.format(f.length())).append(" B");
        }
        htmlText.append("</div>");
        String commentsRes = Icons.getResource((String)"GeneralIcons.Info");
        String commentsStr = Bundle.SnapshotInfoPanel_CommentsString();
        String commentsLink = Bundle.SnapshotInfoPanel_EditCommentsLink();
        String noCommentsStr = Bundle.SnapshotInfoPanel_NoCommentsString();
        htmlText.append("<br>");
        htmlText.append("<br>");
        htmlText.append("<b><img border='0' align='bottom' src='nbresloc:/").append(commentsRes).append("'>&nbsp;&nbsp;").append(commentsStr).append("&nbsp;&nbsp;</b><a href='#'>").append(commentsLink).append("</a><br><hr>");
        htmlText.append("<div style='margin-left: 10px;'>");
        String comments = this.loadedSnapshot.getUserComments();
        comments = comments.replace("<", "&lt;").replace(">", "&gt;");
        htmlText.append(comments.isEmpty() ? "&lt;" + noCommentsStr + "&gt;" : comments);
        htmlText.append("</div>");
        htmlText.append("<br>");
        htmlText.append("<br>");
        String settingsRes = Icons.getResource((String)"GeneralIcons.Info");
        htmlText.append("<b><img border='0' align='bottom' src='nbresloc:/").append(settingsRes).append("'>&nbsp;&nbsp;").append(Bundle.SnapshotInfoPanel_SettingsString()).append("</b><br><hr>");
        htmlText.append("<div style='margin-left: 10px;'>");
        htmlText.append("<strong>");
        htmlText.append(Bundle.SnapshotInfoPanel_SettingsNameString()).append(" ");
        htmlText.append("</strong>");
        htmlText.append(ps.getSettingsName());
        htmlText.append("<br>");
        htmlText.append("<strong>");
        htmlText.append(Bundle.SnapshotInfoPanel_ProfilingTypeString()).append(" ");
        htmlText.append("</strong>");
        switch (ps.getProfilingType()) {
            case 32: {
                htmlText.append(Bundle.SnapshotInfoPanel_CodeRegionString());
                htmlText.append("<br>");
                htmlText.append("<br>");
                htmlText.append("<strong>");
                htmlText.append(Bundle.SnapshotInfoPanel_ProfiledCodeRegionString()).append(" ");
                htmlText.append("</strong>");
                htmlText.append(this.formatRootMethod(ps.getCodeFragmentSelection()));
                htmlText.append("<br>");
                htmlText.append("<strong>");
                htmlText.append(Bundle.SnapshotInfoPanel_ExcludeSleepWaitString()).append(" ");
                htmlText.append("</strong>");
                htmlText.append(SnapshotInfoPanel.getYesNo(ps.getExcludeWaitTime()));
                htmlText.append("<br>");
                htmlText.append("<strong>");
                htmlText.append(Bundle.SnapshotInfoPanel_BufferSizeString()).append(" ");
                htmlText.append("</strong>");
                htmlText.append(ps.getCodeRegionCPUResBufSize());
                htmlText.append("<br>");
                htmlText.append("<strong>");
                htmlText.append(Bundle.SnapshotInfoPanel_LimitProfiledThreadsString()).append(" ");
                htmlText.append("</strong>");
                if (ps.getNProfiledThreadsLimit() < 0) {
                    htmlText.append(Bundle.SnapshotInfoPanel_UnlimitedString());
                } else {
                    htmlText.append("").append(ps.getNProfiledThreadsLimit());
                }
                htmlText.append("<br>");
                break;
            }
            case 64: {
                htmlText.append(Bundle.SnapshotInfoPanel_CpuSamplingString());
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendCPUText(htmlText, ps);
                break;
            }
            case 8: {
                htmlText.append(Bundle.SnapshotInfoPanel_CpuEntireString());
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendCPUText(htmlText, ps);
                break;
            }
            case 16: {
                htmlText.append(Bundle.SnapshotInfoPanel_CpuPartString());
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendCPUText(htmlText, ps);
                break;
            }
            case 128: {
                htmlText.append(Bundle.SnapshotInfoPanel_MemorySamplingString());
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendMemoryText(htmlText, ps);
                break;
            }
            case 2: {
                htmlText.append(Bundle.SnapshotInfoPanel_MemoryAllocString());
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendMemoryText(htmlText, ps);
                break;
            }
            case 4: {
                htmlText.append(Bundle.SnapshotInfoPanel_MemoryLivenessString());
                htmlText.append("<br>");
                htmlText.append("<br>");
                this.appendMemoryText(htmlText, ps);
            }
        }
        this.appendOverridenGlobalProperties(htmlText, ps);
        htmlText.append("</div>");
        htmlText.append("<br>");
        this.infoArea.setText(htmlText.toString());
        this.infoArea.setCaretPosition(0);
    }

    private static String getOnOff(boolean b) {
        return b ? Bundle.SnapshotInfoPanel_OnString() : Bundle.SnapshotInfoPanel_OffString();
    }

    private static String getYesNo(boolean b) {
        return b ? Bundle.SnapshotInfoPanel_YesString() : Bundle.SnapshotInfoPanel_NoString();
    }

    private String getCPUProfilingScheme(int type) {
        switch (type) {
            case 3: {
                return Bundle.SnapshotInfoPanel_TotalProfSchemeString();
            }
            case 2: {
                return Bundle.SnapshotInfoPanel_EagerProfSchemeString();
            }
            case 1: {
                return Bundle.SnapshotInfoPanel_LazyProfSchemeString();
            }
        }
        return Bundle.SnapshotInfoPanel_InvalidString();
    }

    private String getCPUProfilingType(int type) {
        switch (type) {
            case 0: {
                return Bundle.SnapshotInfoPanel_InstrumentationProfTypeString();
            }
            case 1: {
                return Bundle.SnapshotInfoPanel_SampledInstrProfTypeString();
            }
            case 2: {
                return Bundle.SnapshotInfoPanel_SampledProfTypeString();
            }
        }
        return Bundle.SnapshotInfoPanel_InvalidString();
    }

    private void appendCPUText(StringBuffer htmlText, ProfilingSettings ps) {
        boolean sampling;
        boolean bl = sampling = ps.getProfilingType() == 64;
        if (!sampling) {
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_RootMethodsString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(this.formatRootMethods(ps.getInstrumentationRootMethods()));
            htmlText.append("<br>");
        }
        htmlText.append("<strong>");
        htmlText.append(Bundle.SnapshotInfoPanel_CpuProfilingTypeString()).append(" ");
        htmlText.append("</strong>");
        htmlText.append(this.getCPUProfilingType(ps.getCPUProfilingType()));
        htmlText.append("<br>");
        if (sampling) {
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_SamplingPeriodString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(ps.getSamplingInterval());
            htmlText.append(" ms<br>");
        } else {
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_CpuTimerString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(SnapshotInfoPanel.getOnOff(ps.getThreadCPUTimerOn()));
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_ExcludeSleepWaitString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(SnapshotInfoPanel.getYesNo(ps.getExcludeWaitTime()));
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_LimitProfiledThreadsString()).append(" ");
            htmlText.append("</strong>");
            if (ps.getNProfiledThreadsLimit() < 0) {
                htmlText.append(Bundle.SnapshotInfoPanel_UnlimitedString());
            } else {
                htmlText.append("").append(ps.getNProfiledThreadsLimit());
            }
            htmlText.append("<br>");
        }
        htmlText.append("<strong>");
        htmlText.append(Bundle.SnapshotInfoPanel_InstrumentationFilterString()).append(" ");
        htmlText.append("</strong>");
        htmlText.append(ps.getSelectedInstrumentationFilter().toString());
        htmlText.append("<br>");
        if (!sampling) {
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_InstrumentationSchemeString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(this.getCPUProfilingScheme(ps.getInstrScheme()));
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_InstrumentMethodInvokeString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(SnapshotInfoPanel.getYesNo(ps.getInstrumentMethodInvoke()));
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_InstrumentNewThreadsString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(SnapshotInfoPanel.getYesNo(ps.getInstrumentSpawnedThreads()));
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_InstrumentGettersSettersString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(SnapshotInfoPanel.getYesNo(ps.getInstrumentGetterSetterMethods()));
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_InstrumentEmptyMethodsString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(SnapshotInfoPanel.getYesNo(ps.getInstrumentEmptyMethods()));
            htmlText.append("<br>");
        }
    }

    private void appendMemoryText(StringBuffer htmlText, ProfilingSettings ps) {
        if (ps.getProfilingType() != 128) {
            if (ps.getAllocTrackEvery() == 1) {
                htmlText.append("<strong>");
                htmlText.append(Bundle.SnapshotInfoPanel_TrackingAllInstancesString()).append(" ");
                htmlText.append("</strong>");
            } else {
                htmlText.append("<strong>");
                htmlText.append(Bundle.SnapshotInfoPanel_TrackEveryString()).append(" ");
                htmlText.append("</strong>");
                htmlText.append(Bundle.SnapshotInfoPanel_InstancesCountString("" + ps.getAllocTrackEvery()));
            }
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_RecordStackTracesString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(SnapshotInfoPanel.getYesNo(ps.getAllocStackTraceLimit() != 0));
            htmlText.append("<br>");
            if (ps.getAllocStackTraceLimit() != 0) {
                htmlText.append("<strong>");
                htmlText.append(Bundle.SnapshotInfoPanel_LimitStackDepthString()).append(" ");
                htmlText.append("</strong>");
                if (ps.getAllocStackTraceLimit() < 0) {
                    htmlText.append(Bundle.SnapshotInfoPanel_UnlimitedString());
                } else {
                    htmlText.append(ps.getAllocStackTraceLimit());
                }
                htmlText.append("<br>");
            }
        }
        htmlText.append("<strong>");
        htmlText.append(Bundle.SnapshotInfoPanel_RunGcString()).append(" ");
        htmlText.append("</strong>");
        htmlText.append(SnapshotInfoPanel.getYesNo(ps.getRunGCOnGetResultsInMemoryProfiling()));
        htmlText.append("<br>");
    }

    private void appendOverridenGlobalProperties(StringBuffer htmlText, ProfilingSettings ps) {
        if (ps.getOverrideGlobalSettings()) {
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_OverridenGlobalPropertiesString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append("<br>");
            htmlText.append("<div style='margin-left: 10px;'>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_WorkingDirectoryString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(ps.getWorkingDir());
            htmlText.append("<br>");
            String platformName = ps.getJavaPlatformName();
            if (platformName == null) {
                platformName = Bundle.SnapshotInfoPanel_ProjectPlatformNameString();
            }
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_JavaPlatformString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(platformName);
            htmlText.append("<br>");
            htmlText.append("<strong>");
            htmlText.append(Bundle.SnapshotInfoPanel_JvmArgumentsString()).append(" ");
            htmlText.append("</strong>");
            htmlText.append(ps.getJVMArgs());
            htmlText.append("</div>");
            htmlText.append("<br>");
        }
    }

    private String formatRootMethod(ClientUtils.SourceCodeSelection method) {
        String ret;
        if (method.definedViaMethodName()) {
            ret = MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(method).toFormatted();
            ret = ret.replace("<", "&lt;");
            ret = ret.replace(">", "&gt;");
        } else {
            ret = Bundle.SnapshotInfoPanel_LinesDefString(method.getClassName(), "" + method.getStartLine(), "" + method.getEndLine());
        }
        return ret;
    }

    private String formatRootMethods(ClientUtils.SourceCodeSelection[] methods) {
        if (methods == null || methods.length == 0) {
            return Bundle.SnapshotInfoPanel_NoMethodsString();
        }
        if (methods.length == 1) {
            return this.formatRootMethod(methods[0]);
        }
        StringBuilder ret = new StringBuilder();
        ret.append(Bundle.SnapshotInfoPanel_MethodsCountString("" + methods.length));
        ret.append("<br>");
        ArrayList<String> rootNames = new ArrayList<String>();
        for (int i = 0; i < methods.length; ++i) {
            String frm = this.formatRootMethod(methods[i]);
            rootNames.add(frm);
        }
        Collections.sort(rootNames);
        for (String rootName : rootNames) {
            ret.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            ret.append(rootName);
            ret.append("<br>");
        }
        return ret.toString();
    }

    private static class UserCommentsPanel
    extends JPanel {
        private JTextArea textArea;

        UserCommentsPanel() {
            this.initComponents();
        }

        String getInputText() {
            return this.textArea.getText();
        }

        void setInputText(String text) {
            this.textArea.setText(text);
            this.textArea.selectAll();
        }

        private void initComponents() {
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.setLayout(new BorderLayout(0, 5));
            JLabel textLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)textLabel, (String)Bundle.SnapshotInfoPanel_UserCommentsLbl());
            this.textArea = new JTextArea();
            textLabel.setLabelFor(this.textArea);
            this.textArea.requestFocus();
            JScrollPane textAreaScroll = new JScrollPane(this.textArea);
            textAreaScroll.setPreferredSize(new Dimension(350, 150));
            this.add((Component)textAreaScroll, "Center");
            this.add((Component)textLabel, "North");
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
        }
    }
}

