/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIManager;
import org.openide.windows.TopComponent;

public class ProfilerTopComponent
extends TopComponent {
    public static final String RECENT_FILE_KEY = "nb.recent.file.path";
    private Component lastFocusOwner;
    private final PropertyChangeListener focusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Component c = evt.getNewValue() instanceof Component ? (Component)evt.getNewValue() : null;
            this.processFocusedComponent(c);
        }

        private void processFocusedComponent(Component c) {
            Component cc = c;
            while (c != null) {
                if (c == ProfilerTopComponent.this) {
                    ProfilerTopComponent.this.lastFocusOwner = cc;
                    return;
                }
                c = c.getParent();
            }
        }
    };

    public void componentActivated() {
        super.componentActivated();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else {
            Component defaultFocusOwner = this.defaultFocusOwner();
            if (defaultFocusOwner != null) {
                defaultFocusOwner.requestFocus();
            }
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusListener);
    }

    public void componentDeactivated() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.focusListener);
        super.componentDeactivated();
    }

    protected Component defaultFocusOwner() {
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void paintComponent(Graphics g) {
        Color background = UIManager.getColor("ProfilerPanels.background");
        if (background != null) {
            g.setColor(background);
            Insets i = this.getInsets();
            g.fillRect(i.left, i.top, this.getWidth() - i.left - i.right, this.getHeight() - i.top - i.bottom);
        } else {
            super.paintComponent(g);
        }
    }
}

