/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.memory.DiffAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.DiffLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.DiffSampledResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class MemoryDiffPanel
extends JPanel
implements SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private Component findActionPresenter;
    private Component findNextPresenter;
    private Component findPreviousPresenter;
    private MemoryResultsPanel memoryPanel;
    private Lookup.Provider project;

    public MemoryDiffPanel(Lookup context, MemoryResultsSnapshot snapshot, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder, Lookup.Provider project) {
        String s2File;
        DiffSampledResultsPanel amemoryPanel;
        this.project = project;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        DiffActionsHandler memoryActionsHandler = new DiffActionsHandler();
        if (snapshot instanceof SampledMemoryResultsDiff) {
            this.memoryPanel = new DiffSampledResultsPanel((SampledMemoryResultsSnapshot)((SampledMemoryResultsDiff)snapshot), (MemoryResUserActionsHandler)memoryActionsHandler);
            amemoryPanel = (DiffSampledResultsPanel)this.memoryPanel;
            amemoryPanel.setSorting(sortingColumn, sortingOrder);
            amemoryPanel.prepareResults();
        } else if (snapshot instanceof AllocMemoryResultsDiff) {
            this.memoryPanel = new DiffAllocResultsPanel((AllocMemoryResultsSnapshot)((AllocMemoryResultsDiff)snapshot), (MemoryResUserActionsHandler)memoryActionsHandler);
            amemoryPanel = (DiffAllocResultsPanel)this.memoryPanel;
            amemoryPanel.setSorting(sortingColumn, sortingOrder);
            amemoryPanel.prepareResults();
        } else if (snapshot instanceof LivenessMemoryResultsDiff) {
            this.memoryPanel = new DiffLivenessResultsPanel((LivenessMemoryResultsSnapshot)((LivenessMemoryResultsDiff)snapshot), (MemoryResUserActionsHandler)memoryActionsHandler, 1);
            SnapshotLivenessResultsPanel lmemoryPanel = (SnapshotLivenessResultsPanel)this.memoryPanel;
            lmemoryPanel.setSorting(sortingColumn, sortingOrder);
            lmemoryPanel.prepareResults();
        }
        this.add((Component)this.memoryPanel, "Center");
        ProfilerToolbar toolBar = ProfilerToolbar.create((boolean)true);
        toolBar.add((Action)new ExportAction(this, null));
        toolBar.add((Action)new SaveViewAction(this));
        toolBar.addSeparator();
        ContextAwareAction a = (ContextAwareAction)SystemAction.get(FindAction.class);
        this.findActionPresenter = toolBar.add(a.createContextAwareInstance(context));
        this.findPreviousPresenter = toolBar.add((Action)new FindPreviousAction(this));
        this.findNextPresenter = toolBar.add((Action)new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)this.findActionPresenter;
            ab.setIcon(Icons.getIcon((String)"GeneralIcons.Find"));
            ab.setText("");
            ab.setToolTipText(Bundle.MemorySnapshotPanel_FindActionTooltip());
        }
        this.findActionPresenter.setEnabled(true);
        this.findPreviousPresenter.setEnabled(true);
        this.findNextPresenter.setEnabled(true);
        toolBar.addFiller();
        final WeakReference[] loadedSnapshots = new WeakReference[2];
        final String s1File = snapshot1.getFile() == null ? null : snapshot1.getFile().getAbsolutePath();
        String string = s2File = snapshot2.getFile() == null ? null : snapshot2.getFile().getAbsolutePath();
        if (s1File == null) {
            loadedSnapshots[0] = new WeakReference<LoadedSnapshot>(snapshot1);
        }
        if (s2File == null) {
            loadedSnapshots[1] = new WeakReference<LoadedSnapshot>(snapshot2);
        }
        final ResultsManager rm = ResultsManager.getDefault();
        String SNAPSHOT_1_MASK = "file:/1";
        String SNAPSHOT_2_MASK = "file:/2";
        String SNAPSHOT_1_LINK = "<a href='file:/1'>" + rm.getSnapshotDisplayName(snapshot1) + "</a>";
        String SNAPSHOT_2_LINK = "<a href='file:/2'>" + rm.getSnapshotDisplayName(snapshot2) + "</a>";
        HTMLLabel descriptionLabel = new HTMLLabel(Bundle.MemoryDiffPanel_SnapshotsComparisonString(SNAPSHOT_1_LINK, SNAPSHOT_2_LINK)){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            protected void showURL(URL url) {
                File f;
                LoadedSnapshot ls = null;
                if ("file:/1".equals(url.toString())) {
                    if (s1File != null) {
                        f = new File(s1File);
                        if (f.exists()) {
                            ls = rm.loadSnapshot(FileUtil.toFileObject((File)f));
                        }
                    } else {
                        ls = (LoadedSnapshot)loadedSnapshots[0].get();
                    }
                } else if ("file:/2".equals(url.toString())) {
                    if (s2File != null) {
                        f = new File(s2File);
                        if (f.exists()) {
                            ls = rm.loadSnapshot(FileUtil.toFileObject((File)f));
                        }
                    } else {
                        ls = (LoadedSnapshot)loadedSnapshots[1].get();
                    }
                }
                if (ls != null) {
                    SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls);
                    srw.open();
                    srw.requestActive();
                } else {
                    ProfilerDialogs.displayWarning((String)Bundle.MemoryDiffPanel_SnapshotNotAvailableMsg());
                }
            }
        };
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        toolBar.add((Component)descriptionLabel);
        this.add((Component)toolBar.getComponent(), "North");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryDiffPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryDiffPanel.this.performFindNext();
            }
        });
    }

    public String getTitle() {
        return Bundle.MemoryDiffPanel_PanelTitle();
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        return this.memoryPanel.getCurrentViewScreenshot(onlyVisibleArea);
    }

    @Override
    public String getViewName() {
        return "memory_diff";
    }

    @Override
    public boolean fitsVisibleArea() {
        return this.memoryPanel.fitsVisibleArea();
    }

    @Override
    public boolean hasView() {
        return true;
    }

    @Override
    public void performFind() {
        String findString = FindDialog.getFindString();
        if (findString == null) {
            return;
        }
        this.memoryPanel.setFindString(findString);
        if (!this.memoryPanel.findFirst()) {
            ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindNext() {
        if (!this.memoryPanel.isFindStringDefined()) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
        }
        if (!this.memoryPanel.findNext()) {
            ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindPrevious() {
        if (!this.memoryPanel.isFindStringDefined()) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.memoryPanel.setFindString(findString);
        }
        if (!this.memoryPanel.findPrevious()) {
            ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void requestFocus() {
        this.memoryPanel.requestFocus();
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        if (this.memoryPanel instanceof DiffSampledResultsPanel) {
            ((DiffSampledResultsPanel)this.memoryPanel).exportData(exportedFileType, eDD, Bundle.MemoryDiffPanel_PanelTitle());
        } else if (this.memoryPanel instanceof DiffAllocResultsPanel) {
            ((DiffAllocResultsPanel)this.memoryPanel).exportData(exportedFileType, eDD, Bundle.MemoryDiffPanel_PanelTitle());
        } else {
            ((DiffLivenessResultsPanel)this.memoryPanel).exportData(exportedFileType, eDD, Bundle.MemoryDiffPanel_PanelTitle());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return false;
    }

    @Override
    public boolean hasExportableView() {
        return true;
    }

    private class DiffActionsHandler
    implements MemoryResUserActionsHandler {
        private DiffActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (methodName == null && methodSig == null && (VMUtils.isVMPrimitiveType((String)className) || VMUtils.isPrimitiveType((String)className))) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(className) && "traceVMObjectAlloc".equals(methodName)) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                GoToSource.openSource((Lookup.Provider)MemoryDiffPanel.this.project, (String)className, (String)methodName, (String)methodSig);
            }
        }

        public void showStacksForClass(int selectedClassId, int sortingColumn, boolean sortingOrder) {
        }
    }
}

