/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateAdapter;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.ClassHistoryDataManager;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.LiveResultsWindowContributor;
import org.netbeans.lib.profiler.ui.ResultsView;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CodeRegionLivePanel;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.LiveFlatProfilePanel;
import org.netbeans.lib.profiler.ui.graphs.AllocationsHistoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.LivenessHistoryGraphPanel;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryActionsHandler;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryModels;
import org.netbeans.lib.profiler.ui.memory.LiveAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.LiveLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.LiveSampledResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.utilities.Delegate;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class LiveResultsWindow
extends ProfilerTopComponent
implements SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.LiveResultsWindow");
    private static final String HELP_CTX_KEY = "LiveResultsWindow.HelpCtx";
    private static final String HELP_CTX_KEY_CPU = "CpuLiveResultsWindow.HelpCtx";
    private static final String HELP_CTX_KEY_MEM = "MemoryLiveResultsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX_DEFAULT;
    private static HelpCtx HELP_CTX;
    private static LiveResultsWindow defaultLiveInstance;
    private static final AtomicBoolean resultsDumpForced;
    private CPUResUserActionsHandler cpuActionsHandler;
    private EmptyLiveResultsPanel noResultsPanel;
    private JButton runGCButton;
    private JButton updateNowButton;
    private JPanel currentDisplayComponent;
    private JPanel memoryTabPanel;
    private ResultsView resultsView;
    private JToggleButton autoToggle;
    private JToolBar.Separator graphButtonsSeparator;
    private List<JButton> chartActions = new ArrayList<JButton>();
    private JPanel historyPanel;
    private ClassHistoryDataManager classHistoryManager;
    private ClassHistoryModels classHistoryModels;
    private AllocationsHistoryGraphPanel allocationsHistoryPanel;
    private LivenessHistoryGraphPanel livenessHistoryPanel;
    private ProfilerToolbar toolBar;
    private LiveResultsPanel currentDisplay;
    private MemoryResUserActionsHandler memoryActionsHandler;
    private HistoryActionsHandler historyActionsHandler;
    private boolean autoRefresh = true;
    private volatile boolean profilerRunning = false;
    private volatile boolean resultsAvailable = false;
    private volatile boolean resultsAvailableinTA = false;
    private Listener listener;
    private final AtomicLong autoRefreshRequested = new AtomicLong(0L);

    public LiveResultsWindow() {
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                LiveResultsWindow.this.initUI();
                LiveResultsWindow.this.listener = (Listener)Lookup.getDefault().lookup(Listener.class);
                LiveResultsWindow.this.listener.setDelegate(LiveResultsWindow.this);
            }
        });
    }

    private void initUI() {
        this.setName(Bundle.LAB_ResultsWindowName());
        this.setIcon(Icons.getImage((String)"ProfilerIcons.WindowLiveResults"));
        this.getAccessibleContext().setAccessibleDescription(Bundle.LiveResultsWindow_LiveResultsAccessDescr());
        this.setLayout(new BorderLayout());
        this.memoryActionsHandler = new MemoryActionsHandler();
        this.historyActionsHandler = new HistoryActionsHandler();
        this.cpuActionsHandler = new CPUActionsHandler();
        this.classHistoryManager = new ClassHistoryDataManager();
        this.classHistoryModels = new ClassHistoryModels(this.classHistoryManager);
        this.toolBar = this.createToolBar();
        this.add(this.toolBar.getComponent(), "North");
        this.noResultsPanel = new EmptyLiveResultsPanel();
        this.noResultsPanel.setLayout(new BorderLayout());
        this.noResultsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel noResultsLabel = new JLabel(Bundle.LiveResultsWindow_NoProfilingResultsLabelText());
        noResultsLabel.setFont(noResultsLabel.getFont().deriveFont(14));
        noResultsLabel.setIcon(Icons.getIcon((String)"ProfilerIcons.Monitoring32"));
        noResultsLabel.setIconTextGap(10);
        noResultsLabel.setEnabled(false);
        this.noResultsPanel.add((Component)noResultsLabel, "North");
        this.currentDisplay = null;
        this.currentDisplayComponent = this.noResultsPanel;
        this.add(this.noResultsPanel, "Center");
        this.memoryTabPanel = new JPanel(new BorderLayout());
        this.memoryTabPanel.setOpaque(false);
        this.graphButtonsSeparator = new JToolBar.Separator();
        this.toolBar.add((Component)this.graphButtonsSeparator);
        final int chartButtonsOffset = this.toolBar.getComponentCount();
        this.graphButtonsSeparator.setVisible(false);
        this.resultsView = new ResultsView();
        this.memoryTabPanel.add((Component)this.resultsView, "Center");
        this.resultsView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LiveResultsWindow.this.currentDisplayComponent == LiveResultsWindow.this.memoryTabPanel) {
                    if (LiveResultsWindow.this.resultsView.getSelectedView() == LiveResultsWindow.this.historyPanel) {
                        for (JButton b : LiveResultsWindow.this.chartActions) {
                            LiveResultsWindow.this.toolBar.add((Component)b, chartButtonsOffset);
                        }
                        LiveResultsWindow.this.graphButtonsSeparator.setVisible(true);
                    } else {
                        for (JButton b : LiveResultsWindow.this.chartActions) {
                            LiveResultsWindow.this.toolBar.remove((Component)b);
                        }
                        LiveResultsWindow.this.graphButtonsSeparator.setVisible(false);
                    }
                    LiveResultsWindow.this.toolBar.getComponent().revalidate();
                    LiveResultsWindow.this.toolBar.getComponent().repaint();
                }
            }
        });
        this.historyPanel = new JPanel(new BorderLayout());
        this.hideContributors();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)new ProfilingStateAdapter(){

            public void instrumentationChanged(int oldInstrType, int currentInstrType) {
                LiveResultsWindow.this.requestProfilingDataUpdate(false);
            }

            public void profilingStateChanged(ProfilingStateEvent e) {
                LiveResultsWindow.this.updateActions(e.getNewState());
                switch (e.getNewState()) {
                    case 1: {
                        LiveResultsWindow.this.handleShutdown();
                        break;
                    }
                    case 4: {
                        LiveResultsWindow.this.handleStartup();
                    }
                }
            }
        });
    }

    public static LiveResultsWindow getDefault() {
        if (!LiveResultsWindow.hasDefault()) {
            defaultLiveInstance = Singleton.INSTANCE;
        }
        return defaultLiveInstance;
    }

    public static void setPaused(boolean value) {
    }

    public static void closeIfOpened() {
        if (LiveResultsWindow.hasDefault()) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (defaultLiveInstance.isShowing()) {
                        defaultLiveInstance.close();
                    }
                }
            });
        }
    }

    public static boolean hasDefault() {
        return defaultLiveInstance != null;
    }

    public void setAutoRefresh(boolean value) {
        if (this.autoRefresh != value) {
            this.autoRefresh = value;
            this.autoToggle.setSelected(value);
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPersistenceType() {
        return 2;
    }

    public int getSortingColumn() {
        if (this.currentDisplay == null) {
            return -1;
        }
        return this.currentDisplay.getSortingColumn();
    }

    public boolean getSortingOrder() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.getSortingOrder();
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.resultsView.getSelectedView() == this.historyPanel) {
            return UIUtils.createScreenshot((Component)this.historyPanel);
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewImage(onlyVisibleArea);
    }

    @Override
    public String getViewName() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.resultsView.getSelectedView() == this.historyPanel) {
            return "memory-history-" + this.classHistoryManager.getTrackedClassName();
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewName();
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.currentDisplayComponent;
    }

    @Override
    public boolean fitsVisibleArea() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.resultsView.getSelectedView() == this.historyPanel) {
            return true;
        }
        return this.currentDisplay != null && this.currentDisplay.fitsVisibleArea();
    }

    public void handleShutdown() {
        this.profilerRunning = false;
        if (this.isShowing()) {
            this.hideContributors();
            this.requestProfilingDataUpdate(false);
        }
    }

    public void handleStartup() {
        this.profilerRunning = true;
    }

    public void handleCleanupBeforeProfiling() {
        this.classHistoryManager.resetClass();
    }

    @Override
    public boolean hasView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.resultsView.getSelectedView() == this.historyPanel) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    public void ideClosing() {
        this.hideContributors();
    }

    public boolean refreshLiveResults() {
        if (this.isAutoRefresh() && this.isShowing()) {
            this.requestProfilingDataUpdate(false);
            return true;
        }
        ProfilerClient client = Profiler.getDefault().getTargetAppRunner().getProfilerClient();
        if (NetBeansProfiler.getDefaultNB().processesProfilingPoints() || client.getCurrentInstrType() == 2) {
            this.callForceObtainedResultsDump(client, false);
        }
        return false;
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        Component selectedView = this.resultsView.getSelectedView();
        if (this.currentDisplayComponent == this.memoryTabPanel) {
            if (selectedView instanceof LiveSampledResultsPanel) {
                ((LiveSampledResultsPanel)this.currentDisplay).exportData(exportedFileType, eDD, Bundle.LAB_ResultsWindowName());
            } else if (selectedView instanceof LiveAllocResultsPanel) {
                ((LiveAllocResultsPanel)this.currentDisplay).exportData(exportedFileType, eDD, Bundle.LAB_ResultsWindowName());
            } else if (selectedView instanceof LiveLivenessResultsPanel) {
                ((LiveLivenessResultsPanel)this.currentDisplay).exportData(exportedFileType, eDD, Bundle.LAB_ResultsWindowName());
            }
        } else if (this.currentDisplayComponent instanceof LiveFlatProfilePanel) {
            ((LiveFlatProfilePanel)this.currentDisplay).exportData(exportedFileType, eDD, Bundle.LAB_ResultsWindowName());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return false;
    }

    @Override
    public boolean hasExportableView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.resultsView.getSelectedView() == this.currentDisplay) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.hideContributors();
    }

    protected void componentOpened() {
        super.componentOpened();
    }

    protected void componentShowing() {
        super.componentShowing();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiveResultsWindow.this.updateResultsDisplay();
            }
        });
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    void reset() {
        this.resultsAvailable = false;
        if (this.currentDisplay != null) {
            this.currentDisplay.reset();
            this.resetResultsDisplay();
        }
        this.resetContributors();
    }

    private boolean callForceObtainedResultsDump(ProfilerClient client) {
        return this.callForceObtainedResultsDump(client, true);
    }

    private boolean callForceObtainedResultsDump(ProfilerClient client, boolean refreshDisplay) {
        int instrType = client.getCurrentInstrType();
        if (!this.resultsAvailableinTA && instrType != 2) {
            return false;
        }
        if (refreshDisplay) {
            resultsDumpForced.set(true);
        }
        try {
            if (instrType == 7) {
                this.resultsAvailable();
            } else if (instrType != 1) {
                client.forceObtainedResultsDump(true);
            }
            return true;
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            return false;
        }
    }

    private boolean isProfiling() {
        TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
        return runner.getProfilerClient().getCurrentInstrType() != 0;
    }

    private ProfilerToolbar createToolBar() {
        ProfilerToolbar tb = ProfilerToolbar.create((boolean)true);
        this.autoToggle = new JToggleButton(Icons.getIcon((String)"GeneralIcons.UpdateAuto"));
        this.autoToggle.setSelected(true);
        this.autoToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveResultsWindow.this.autoRefresh = LiveResultsWindow.this.autoToggle.isSelected();
            }
        });
        this.autoToggle.setToolTipText(Bundle.LiveResultsWindow_UpdateResultsAutomaticallyTooltip());
        this.autoToggle.getAccessibleContext().setAccessibleName(Bundle.LiveResultsWindow_UpdateResultsAutomaticallyTooltip());
        this.updateNowButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow"));
        this.updateNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.updateNowButton.setToolTipText(Bundle.LiveResultsWindow_UpdateResultsNowTooltip());
        this.updateNowButton.getAccessibleContext().setAccessibleName(Bundle.LiveResultsWindow_UpdateResultsNowTooltip());
        this.runGCButton = new JButton(Icons.getIcon((String)"ProfilerIcons.RunGC"));
        this.runGCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Profiler.getDefault().getTargetAppRunner().runGC();
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    ProfilerDialogs.displayError((String)ex.getMessage());
                    ProfilerLogger.log((Exception)((Object)ex));
                }
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.runGCButton.setToolTipText(Bundle.LiveResultsWindow_RunGCTooltip());
        this.runGCButton.getAccessibleContext().setAccessibleName(Bundle.LiveResultsWindow_RunGCTooltip());
        tb.add((Component)this.autoToggle);
        tb.add((Component)this.updateNowButton);
        tb.add((Component)this.runGCButton);
        tb.add((Action)((Object)ResetResultsAction.getInstance()));
        tb.addSeparator();
        tb.add(TakeSnapshotAction.getInstance().getToolbarPresenter());
        tb.addSeparator();
        tb.add((Action)new ExportAction(this, null));
        tb.add((Action)new SaveViewAction(this));
        return tb;
    }

    private LiveResultsPanel preparePanelForInstrType(int instrumentationType) {
        HELP_CTX = HELP_CTX_DEFAULT;
        CodeRegionLivePanel aPanel = null;
        TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
        switch (instrumentationType) {
            case 7: {
                LiveSampledResultsPanel samplingPanel = new LiveSampledResultsPanel(runner, this.memoryActionsHandler);
                this.currentDisplayComponent = this.memoryTabPanel;
                if (this.resultsView.getViewsCount() > 0) {
                    this.resultsView.removeViews();
                }
                this.resultsView.addView(Bundle.LiveResultsWindow_LiveResultsTabName(), null, null, (Component)samplingPanel, null);
                aPanel = samplingPanel;
                HELP_CTX = new HelpCtx(HELP_CTX_KEY_MEM);
                break;
            }
            case 5: {
                LiveAllocResultsPanel allocPanel = new LiveAllocResultsPanel(runner, this.memoryActionsHandler, (ClassHistoryActionsHandler)this.historyActionsHandler, this.classHistoryManager);
                this.currentDisplayComponent = this.memoryTabPanel;
                if (this.resultsView.getViewsCount() > 0) {
                    this.resultsView.removeViews();
                }
                this.resultsView.addView(Bundle.LiveResultsWindow_LiveResultsTabName(), null, null, (Component)allocPanel, null);
                this.resultsView.addView(Bundle.LiveResultsWindow_HistoryTabName(), null, null, (Component)this.historyPanel, null);
                this.resultsView.setViewEnabled((Component)this.historyPanel, false);
                aPanel = allocPanel;
                HELP_CTX = new HelpCtx(HELP_CTX_KEY_MEM);
                break;
            }
            case 6: {
                LiveLivenessResultsPanel livenessPanel = new LiveLivenessResultsPanel(runner, this.memoryActionsHandler, (ClassHistoryActionsHandler)this.historyActionsHandler, this.classHistoryManager);
                this.currentDisplayComponent = this.memoryTabPanel;
                if (this.resultsView.getViewsCount() > 0) {
                    this.resultsView.removeViews();
                }
                this.resultsView.addView(Bundle.LiveResultsWindow_LiveResultsTabName(), null, null, (Component)livenessPanel, null);
                this.resultsView.addView(Bundle.LiveResultsWindow_HistoryTabName(), null, null, (Component)this.historyPanel, null);
                this.resultsView.setViewEnabled((Component)this.historyPanel, false);
                aPanel = livenessPanel;
                HELP_CTX = new HelpCtx(HELP_CTX_KEY_MEM);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Lookup.Provider project = NetBeansProfiler.getDefaultNB().getProfiledProject();
                boolean sampling = instrumentationType == 2;
                LiveFlatProfilePanel cpuPanel = new LiveFlatProfilePanel(runner, this.cpuActionsHandler, sampling);
                for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
                    c.addToCpuResults(cpuPanel, this.toolBar, runner.getProfilerClient(), project);
                }
                this.currentDisplayComponent = cpuPanel;
                aPanel = cpuPanel;
                HELP_CTX = new HelpCtx(HELP_CTX_KEY_CPU);
                break;
            }
            case 1: {
                CodeRegionLivePanel regionPanel = new CodeRegionLivePanel(runner.getProfilerClient());
                this.currentDisplayComponent = regionPanel;
                aPanel = regionPanel;
                break;
            }
            case 0: {
                throw new IllegalStateException();
            }
        }
        return aPanel;
    }

    private void requestProfilingDataUpdate(final boolean force) {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!LiveResultsWindow.this.isAutoRefresh() && !force) {
                    return;
                }
                if (!LiveResultsWindow.this.isProfiling() || !LiveResultsWindow.this.isShowing()) {
                    return;
                }
                ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.this.autoRefreshRequested.incrementAndGet();
                        LiveResultsWindow.this.callForceObtainedResultsDump(Profiler.getDefault().getTargetAppRunner().getProfilerClient());
                    }
                });
            }
        });
    }

    private void resultsAvailable() {
        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LiveResultsWindow.this.resultsAvailable = true;
                if (resultsDumpForced.getAndSet(false) && LiveResultsWindow.this.autoRefreshRequested.getAndDecrement() > 0L) {
                    LiveResultsWindow.this.updateResultsDisplay();
                } else {
                    LiveResultsWindow.this.autoRefreshRequested.compareAndSet(-1L, 0L);
                }
            }
        });
    }

    private void resetResultsDisplay() {
        if (this.currentDisplayComponent != null && this.currentDisplayComponent != this.noResultsPanel) {
            this.remove(this.currentDisplayComponent);
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            this.add(this.noResultsPanel, "Center");
            for (JButton b : this.chartActions) {
                this.toolBar.remove((Component)b);
            }
            this.graphButtonsSeparator.setVisible(false);
            this.revalidate();
            this.repaint();
            this.hideContributors();
        }
        HELP_CTX = HELP_CTX_DEFAULT;
    }

    private void updateActions(int newState) {
        this.runGCButton.setEnabled(newState == 4);
        this.updateNowButton.setEnabled(newState == 4);
    }

    private void refresh() {
        if (LOGGER.isLoggable(Level.FINE) && this.currentDisplayComponent != null) {
            LOGGER.log(Level.FINE, "refreshing contributors for drilldown: {0}", this.currentDisplayComponent.getClass().getName());
        }
        this.refreshContributors();
        if (this.profilerRunning && this.currentDisplayComponent instanceof LiveFlatProfilePanel) {
            LOGGER.fine("Showing contributors");
            if (this.isVisible()) {
                this.showContributors();
            }
        } else {
            LOGGER.fine("Hiding contributors");
            this.hideContributors();
        }
    }

    private void updateResultsDisplay() {
        if (!this.isShowing()) {
            return;
        }
        if (!this.resultsAvailable) {
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            return;
        }
        TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
        int instrType = runner.getProfilerClient().getCurrentInstrType();
        if (instrType != 0) {
            boolean instrSupported;
            boolean bl = instrSupported = this.currentDisplayComponent != null && this.currentDisplay != null && this.currentDisplay.supports(instrType);
            if (!instrSupported) {
                if (this.currentDisplayComponent != null) {
                    this.remove(this.currentDisplayComponent);
                }
                if (this.currentDisplay != null) {
                    this.currentDisplay.handleRemove();
                }
                this.currentDisplay = this.preparePanelForInstrType(instrType);
                this.add(this.currentDisplayComponent, "Center");
                this.revalidate();
                this.repaint();
                CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.this.currentDisplayComponent.requestFocusInWindow();
                    }
                });
            }
            if (this.currentDisplay != null) {
                this.currentDisplay.updateLiveResults();
            }
        }
        this.refresh();
    }

    private void hideContributors() {
        for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            c.hide();
        }
    }

    private void showContributors() {
        for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            c.show();
        }
    }

    private void refreshContributors() {
        for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            c.refresh();
        }
    }

    private void resetContributors() {
        for (LiveResultsWindowContributor c : Lookup.getDefault().lookupAll(LiveResultsWindowContributor.class)) {
            c.reset();
        }
    }

    static {
        HELP_CTX = HELP_CTX_DEFAULT = new HelpCtx(HELP_CTX_KEY);
        resultsDumpForced = new AtomicBoolean(false);
    }

    private static class Singleton {
        private static final LiveResultsWindow INSTANCE = new LiveResultsWindow();

        private Singleton() {
        }
    }

    private final class HistoryActionsHandler
    implements ClassHistoryActionsHandler {
        private HistoryActionsHandler() {
        }

        public void showClassHistory(int classID, final String className) {
            int currentlyTrackedClass = LiveResultsWindow.this.classHistoryManager.getTrackedClassID();
            String currentlyTrackedClassName = LiveResultsWindow.this.classHistoryManager.getTrackedClassName();
            if (currentlyTrackedClass != -1 && (classID == currentlyTrackedClass ? !ProfilerDialogs.displayConfirmationDNSA((String)Bundle.History_LoggingResetMsg(currentlyTrackedClassName), (String)Bundle.History_LoggingConfirmationCaption(), null, (String)"History.historylogging.reset", (boolean)true) : !ProfilerDialogs.displayConfirmationDNSA((String)Bundle.History_LoggingStopMsg(currentlyTrackedClassName), (String)Bundle.History_LoggingConfirmationCaption(), null, (String)"History.historylogging.stop", (boolean)true))) {
                return;
            }
            LiveResultsWindow.this.classHistoryManager.setupClass(classID, className);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LiveResultsWindow.this.chartActions.clear();
                    Action[] actions = null;
                    TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
                    if (runner.getProfilerClient().getCurrentInstrType() == 5) {
                        if (LiveResultsWindow.this.allocationsHistoryPanel == null) {
                            LiveResultsWindow.this.allocationsHistoryPanel = AllocationsHistoryGraphPanel.createPanel((ClassHistoryModels)LiveResultsWindow.this.classHistoryModels);
                        }
                        LiveResultsWindow.this.historyPanel.removeAll();
                        LiveResultsWindow.this.historyPanel.add((Component)LiveResultsWindow.this.allocationsHistoryPanel, "Center");
                        actions = LiveResultsWindow.this.allocationsHistoryPanel.getActions();
                    } else if (runner.getProfilerClient().getCurrentInstrType() == 6) {
                        if (LiveResultsWindow.this.livenessHistoryPanel == null) {
                            LiveResultsWindow.this.livenessHistoryPanel = LivenessHistoryGraphPanel.createPanel((ClassHistoryModels)LiveResultsWindow.this.classHistoryModels);
                        }
                        LiveResultsWindow.this.historyPanel.removeAll();
                        LiveResultsWindow.this.historyPanel.add((Component)LiveResultsWindow.this.livenessHistoryPanel, "Center");
                        actions = LiveResultsWindow.this.livenessHistoryPanel.getActions();
                    }
                    if (actions != null) {
                        for (void var6_6 : actions) {
                            LiveResultsWindow.this.chartActions.add(new JButton((Action)var6_6));
                        }
                    }
                    Collections.reverse(LiveResultsWindow.this.chartActions);
                    LiveResultsWindow.this.resultsView.setViewEnabled((Component)LiveResultsWindow.this.historyPanel, true);
                    LiveResultsWindow.this.resultsView.setViewName((Component)LiveResultsWindow.this.historyPanel, Bundle.LiveResultsWindow_ClassHistoryTabName(className));
                    LiveResultsWindow.this.resultsView.selectView((Component)LiveResultsWindow.this.historyPanel);
                }
            });
        }
    }

    private static final class MemoryActionsHandler
    implements MemoryResUserActionsHandler {
        private MemoryActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (methodName == null && methodSig == null && (VMUtils.isVMPrimitiveType((String)className) || VMUtils.isPrimitiveType((String)className))) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(className) && "traceVMObjectAlloc".equals(methodName)) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                GoToSource.openSource((Lookup.Provider)NetBeansProfiler.getDefaultNB().getProfiledProject(), (String)className, (String)methodName, (String)methodSig);
            }
        }

        public void showStacksForClass(final int selectedClassId, final int sortingColumn, final boolean sortingOrder) {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    final LoadedSnapshot ls = ResultsManager.getDefault().takeSnapshot();
                    if (ls != null) {
                        CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls, sortingColumn, sortingOrder);
                                if (srw != null) {
                                    srw.displayStacksForClass(selectedClassId, sortingColumn, sortingOrder);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(final String className, final String methodName, final String methodSig) {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    final Lookup.Provider project = NetBeansProfiler.getDefaultNB().getProfiledProject();
                    final ProfilingSettings[] projectSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)project).getProfilingSettings();
                    final ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings settings : projectSettings) {
                        if (!ProfilingSettings.isCPUSettings((int)settings.getProfilingType())) continue;
                        cpuSettings.add(settings);
                    }
                    final ProfilingSettings[] lastProfilingSettings = new ProfilingSettings[1];
                    String lastProfilingSettingsName = Profiler.getDefault().getLastProfilingSettings().getSettingsName();
                    for (ProfilingSettings settings : cpuSettings) {
                        if (!settings.getSettingsName().equals(lastProfilingSettingsName)) continue;
                        lastProfilingSettings[0] = settings;
                        break;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final ProfilingSettings settingsToModify = IDEUtils.selectSettings(16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), lastProfilingSettings[0]);
                            if (settingsToModify == null) {
                                return;
                            }
                            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    settingsToModify.addRootMethod(className, methodName, methodSig);
                                    if (cpuSettings.contains(settingsToModify)) {
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])projectSettings, (ProfilingSettings)settingsToModify, (Lookup.Provider)project);
                                    } else {
                                        ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                                        System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                                        newProjectSettings[projectSettings.length] = settingsToModify;
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])newProjectSettings, (ProfilingSettings)settingsToModify, (Lookup.Provider)project);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }

        public void showReverseCallGraph(CPUResultsSnapshot snapshot, int threadId, int methodId, int view, int sortingColumn, boolean sortingOrder) {
            throw new IllegalStateException(Bundle.LiveResultsWindow_ErrorDisplayingCallGraphMsg());
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            GoToSource.openSource((Lookup.Provider)NetBeansProfiler.getDefaultNB().getProfiledProject(), (String)className, (String)methodName, (String)methodSig);
        }

        public void viewChanged(int viewType) {
            if (LiveResultsWindow.this.currentDisplay != null) {
                ((FlatProfilePanel)LiveResultsWindow.this.currentDisplay).prepareResults();
            }
        }
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener,
    MemoryCCTProvider.Listener {
        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, final boolean empty) {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!empty) {
                        LiveResultsWindow.getDefault().resultsAvailable();
                    } else {
                        resultsDumpForced.set(false);
                    }
                }
            });
        }

        public void cctReset() {
            CommonUtils.runInEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LiveResultsWindow.getDefault().resultsAvailable = false;
                }
            });
        }
    }

    public static final class EmptyLiveResultsPanel
    extends JPanel
    implements LiveResultsPanel {
        public EmptyLiveResultsPanel() {
            this.setOpaque(false);
        }

        public int getSortingColumn() {
            return -1;
        }

        public boolean getSortingOrder() {
            return true;
        }

        public BufferedImage getViewImage(boolean b) {
            throw new UnsupportedOperationException();
        }

        public String getViewName() {
            return "Empty live results";
        }

        public boolean fitsVisibleArea() {
            return false;
        }

        public void handleRemove() {
        }

        public void handleShutdown() {
        }

        public boolean hasView() {
            return false;
        }

        public void reset() {
        }

        public boolean supports(int instrumentationType) {
            return true;
        }

        public void updateLiveResults() {
        }
    }

    public static class Listener
    extends Delegate<LiveResultsWindow>
    implements ResultsListener {
        @Override
        public void resultsAvailable() {
            LiveResultsWindow win = (LiveResultsWindow)this.getDelegate();
            win.resultsAvailableinTA = true;
            TargetAppRunner runner = Profiler.getDefault().getTargetAppRunner();
            int instrType = runner.getProfilerClient().getCurrentInstrType();
            if (instrType == 7) {
                win.resultsAvailable();
            }
        }

        @Override
        public void resultsReset() {
            LiveResultsWindow.getDefault().resultsAvailableinTA = false;
            if (this.getDelegate() != null) {
                ((LiveResultsWindow)this.getDelegate()).reset();
            }
        }
    }
}

