/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.WindowManager;

public final class ExportAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(ExportAction.class.getName());
    private static final Icon ICON = Icons.getIcon((String)"GeneralIcons.Export");
    private static final String FILE_EXTENSION_CSV = "csv";
    private static final String FILE_EXTENSION_XML = "xml";
    private static final String FILE_EXTENSION_HTML = "html";
    private static final String FILE_EXTENSION_NPS = "nps";
    public static final int MODE_CSV = 1;
    public static final int MODE_EXCEL = 2;
    public static final int MODE_XML = 3;
    public static final int MODE_HTML = 4;
    public static final int MODE_NPS = 5;
    private static File exportDir;
    private JFileChooser fileChooser;
    private ExportProvider exportProvider;
    private int exportedFileType;
    private LoadedSnapshot snapshot;

    public ExportAction(ExportProvider exportProvider, LoadedSnapshot loadedSnapshot) {
        this.putValue("Name", Bundle.ExportAction_ExportActionName());
        this.putValue("ShortDescription", Bundle.ExportAction_ExportActionDescr());
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
        this.exportProvider = exportProvider;
        if (loadedSnapshot != null) {
            this.snapshot = loadedSnapshot;
        }
    }

    private void setFilters() {
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
        if (this.exportProvider.hasExportableView()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogXMLFilter();
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".html");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogHTMLFilter();
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".csv");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogExcelFilter();
                }
            });
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".csv");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogCSVFilter();
                }
            });
        }
        if (this.exportProvider.hasLoadedSnapshot()) {
            this.fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".nps");
                }

                @Override
                public String getDescription() {
                    return Bundle.ExportAction_ExportDialogNPSFilter();
                }
            });
            FileFilter[] currentFilters = this.fileChooser.getChoosableFileFilters();
            for (int i = 0; i < currentFilters.length; ++i) {
                if (!currentFilters[i].getDescription().equals(Bundle.ExportAction_ExportDialogNPSFilter())) continue;
                this.fileChooser.setFileFilter(currentFilters[i]);
            }
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(Bundle.ExportAction_ExportDialogTitle());
            this.fileChooser.setApproveButtonText(Bundle.ExportAction_ExportDialogButton());
        }
        this.fileChooser.resetChoosableFileFilters();
        this.setFilters();
        return this.fileChooser;
    }

    private boolean checkFileExists(File source, File target) {
        if (target.exists()) {
            if (source != null && source.equals(target)) {
                ProfilerDialogs.displayError((String)Bundle.ExportAction_ExportToItselfMsg());
                return false;
            }
            if (!ProfilerDialogs.displayConfirmation((String)Bundle.ExportAction_OverwriteFileMsg(target.getName()), (String)Bundle.ExportAction_OverwriteFileCaption())) {
                return false;
            }
        }
        return true;
    }

    private SelectedFile selectExportTargetFile(ExportProvider exportProvider) {
        String targetName;
        File targetDir;
        String targetExt;
        int result;
        String defaultName = exportProvider.getViewName();
        JFileChooser chooser = this.getFileChooser();
        if (exportDir != null) {
            chooser.setCurrentDirectory(exportDir);
        }
        if ((result = chooser.showSaveDialog((Component)WindowManager.getDefault().getRegistry().getActivated())) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (chooser.getFileFilter().getDescription().equals(Bundle.ExportAction_ExportDialogXMLFilter())) {
            targetExt = FILE_EXTENSION_XML;
            this.exportedFileType = 3;
        } else if (chooser.getFileFilter().getDescription().equals(Bundle.ExportAction_ExportDialogHTMLFilter())) {
            targetExt = FILE_EXTENSION_HTML;
            this.exportedFileType = 4;
        } else if (chooser.getFileFilter().getDescription().equals(Bundle.ExportAction_ExportDialogExcelFilter())) {
            targetExt = FILE_EXTENSION_CSV;
            this.exportedFileType = 2;
        } else if (chooser.getFileFilter().getDescription().equals(Bundle.ExportAction_ExportDialogNPSFilter())) {
            targetExt = FILE_EXTENSION_NPS;
            this.exportedFileType = 5;
        } else {
            targetExt = FILE_EXTENSION_CSV;
            this.exportedFileType = 1;
        }
        if (file.isDirectory()) {
            exportDir = file;
            targetDir = file;
            targetName = defaultName;
        } else {
            targetDir = this.fileChooser.getCurrentDirectory();
            String fName = file.getName();
            if (fName.endsWith("." + targetExt)) {
                int idx = fName.lastIndexOf(46);
                targetName = fName.substring(0, idx);
            } else {
                targetName = fName;
            }
        }
        return new SelectedFile(targetDir, targetName, targetExt);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        File file;
        SelectedFile saveFile;
        if (!this.exportProvider.hasExportableView() && !this.exportProvider.hasLoadedSnapshot()) {
            ProfilerDialogs.displayError((String)Bundle.ExportAction_NoViewMsg());
            return;
        }
        final LiveResultsWindow lrw = this.exportProvider instanceof LiveResultsWindow ? (LiveResultsWindow)this.exportProvider : null;
        final AppStatusHandler statusHandler = Profiler.getDefault().getTargetAppRunner().getAppStatusHandler();
        if (lrw != null) {
            statusHandler.pauseLiveUpdates();
        }
        if ((saveFile = this.selectExportTargetFile(this.exportProvider)) == null) {
            if (lrw != null) {
                statusHandler.resumeLiveUpdates();
            }
            return;
        }
        if (!this.checkFileExists(this.snapshot == null ? null : this.snapshot.getFile(), file = saveFile.getSelectedFile())) {
            if (lrw != null) {
                statusHandler.resumeLiveUpdates();
            }
            return;
        }
        if (this.exportedFileType == 5) {
            new NBSwingWorker(true){
                private final ProgressHandle ph;
                {
                    super(x0);
                    this.ph = ProgressHandleFactory.createHandle((String)Bundle.ExportAction_SavingSnapshot());
                }

                protected void doInBackground() {
                    try {
                        this.ph.setInitialDelay(500);
                        this.ph.start();
                        if (!file.getAbsolutePath().toLowerCase().endsWith(".nps")) {
                            ProfilerDialogs.displayError((String)Bundle.ExportAction_InvalidLocationForFileMsg());
                            return;
                        }
                        FileObject fo = FileUtil.createData((File)file);
                        if (fo == null) {
                            ProfilerDialogs.displayError((String)Bundle.ExportAction_InvalidLocationForFileMsg());
                            return;
                        }
                        ResultsManager.getDefault().saveSnapshot(ExportAction.this.snapshot, fo);
                    }
                    catch (IOException e1) {
                        ProfilerDialogs.displayError((String)Bundle.ExportAction_CannotWriteFileMsg(e1.getLocalizedMessage()));
                        LOGGER.log(Level.WARNING, e1.toString());
                    }
                }

                protected void done() {
                    this.ph.finish();
                    if (lrw != null) {
                        statusHandler.resumeLiveUpdates();
                    }
                }
            }.execute();
        } else {
            new NBSwingWorker(true){
                private final ProgressHandle ph;
                {
                    super(x0);
                    this.ph = ProgressHandleFactory.createHandle((String)Bundle.ExportAction_ExportingViewMsg());
                }

                protected void doInBackground() {
                    this.ph.setInitialDelay(500);
                    this.ph.start();
                    try {
                        FileOutputStream fo = new FileOutputStream(file);
                        ExportDataDumper eDD = new ExportDataDumper(fo);
                        ExportAction.this.exportProvider.exportData(ExportAction.this.exportedFileType, eDD);
                        if (eDD.getCaughtException() != null) {
                            ProfilerDialogs.displayError((String)(eDD.getNumExceptions() + Bundle.ExportAction_IOException_Exporting_Msg()));
                        }
                    }
                    catch (OutOfMemoryError e) {
                        ProfilerDialogs.displayError((String)(Bundle.ExportAction_OomeExportingMsg() + e.getMessage()));
                    }
                    catch (IOException e1) {
                        ProfilerDialogs.displayError((String)Bundle.ExportAction_CannotWriteFileMsg(e1.getLocalizedMessage()));
                        LOGGER.log(Level.WARNING, e1.toString());
                    }
                }

                protected void done() {
                    this.ph.finish();
                    if (lrw != null) {
                        statusHandler.resumeLiveUpdates();
                    }
                }
            }.execute();
        }
    }

    private static class SelectedFile {
        File folder;
        String fileExt;
        String fileName;

        SelectedFile(File folder, String fileName, String fileExt) {
            this.folder = folder;
            this.fileName = fileName;
            this.fileExt = fileExt;
        }

        File getSelectedFile() {
            String folderPath = this.folder.getAbsolutePath();
            if (folderPath.endsWith(File.separator)) {
                folderPath = folderPath.substring(0, folderPath.length() - 1);
            }
            return new File(folderPath + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    public static interface ExportProvider {
        public void exportData(int var1, ExportDataDumper var2);

        public String getViewName();

        public boolean hasExportableView();

        public boolean hasLoadedSnapshot();
    }
}

