/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.CombinedPanel;
import org.netbeans.lib.profiler.ui.cpu.ReverseCallGraphPanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.SubtreeCallGraphPanel;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.actions.FindAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public final class CPUSnapshotPanel
extends SnapshotPanel
implements ActionListener,
ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Icon CLASSES_ICON = Icons.getIcon((String)"LanguageIcons.Class");
    private static final Icon METHODS_ICON = Icons.getIcon((String)"LanguageIcons.Methods");
    private static final Icon PACKAGES_ICON = Icons.getIcon((String)"LanguageIcons.Package");
    private static final Icon THREADS_ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final Icon CALL_TREE_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabCallTree");
    private static final Icon HOTSPOTS_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabHotSpots");
    private static final Icon COMBINED_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabCombined");
    private static final Icon INFO_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabInfo");
    private static final Icon BACK_TRACES_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabBackTraces");
    private static final Icon SUBTREE_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabSubtree");
    private static final Icon SLAVE_DOWN_ICON = Icons.getIcon((String)"GeneralIcons.SlaveDown");
    private static final Icon SLAVE_UP_ICON = Icons.getIcon((String)"GeneralIcons.SlaveUp");
    private static final double SPLIT_HALF = 0.5;
    private CCTDisplay cctPanel;
    private CCTDisplay combinedCCT;
    private CPUResultsSnapshot snapshot;
    private CombinedPanel combined;
    private CombinedViewTracker combinedViewTracker;
    private Component findActionPresenter;
    private Component findNextPresenter;
    private Component findPreviousPresenter;
    private JComboBox aggregationCombo;
    private JComboBox threadsCombo;
    private JToggleButton slaveToggleButtonDown;
    private JToggleButton slaveToggleButtonUp;
    private LoadedSnapshot loadedSnapshot;
    private ReverseCallGraphPanel backtraceView;
    private SaveSnapshotAction saveAction;
    private SaveViewAction saveViewAction;
    private SnapshotFlatProfilePanel combinedFlat;
    private SnapshotFlatProfilePanel flatPanel;
    private SnapshotInfoPanel infoPanel;
    private SubtreeCallGraphPanel subtreeView;
    private int[] threadIds;
    private boolean internalChange = false;
    private boolean internalFilterChange = false;
    private boolean internalSelChange = false;
    private boolean slaveModeDown = true;
    private boolean slaveModeUp = true;
    private int currentAggregationMode;
    private Boolean sampling;

    public CPUSnapshotPanel(Lookup context, LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        this.loadedSnapshot = ls;
        this.snapshot = (CPUResultsSnapshot)ls.getSnapshot();
        CPUActionsHandler actionsHandler = new CPUActionsHandler();
        CPUSnapshotSelectionHandler combinedActionsHandlerCCT = new CPUSnapshotSelectionHandler(true);
        CPUSnapshotSelectionHandler combinedActionsHandlerFlat = new CPUSnapshotSelectionHandler(false);
        this.sampling = ls.getSettings().getCPUProfilingType() == 2;
        this.flatPanel = new SnapshotFlatProfilePanel((CPUResUserActionsHandler)actionsHandler, this.sampling);
        this.cctPanel = new CustomCCTDisplay((CPUResUserActionsHandler)actionsHandler, this.sampling);
        this.infoPanel = new SnapshotInfoPanel(ls);
        this.combinedFlat = new SnapshotFlatProfilePanel((CPUResUserActionsHandler)actionsHandler, (CPUSelectionHandler)combinedActionsHandlerFlat, this.sampling);
        this.combinedCCT = new CustomCCTDisplay((CPUResUserActionsHandler)actionsHandler, combinedActionsHandlerCCT, this.sampling);
        this.flatPanel.setSorting(sortingColumn, sortingOrder);
        this.cctPanel.setSorting(sortingColumn, sortingOrder);
        this.combinedFlat.setSorting(sortingColumn, sortingOrder);
        this.combinedCCT.setSorting(sortingColumn, sortingOrder);
        if (this.cctPanel.getPopupFindItem() != null) {
            this.cctPanel.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_HotSpotsString()));
            this.cctPanel.getPopupFindItem().setVisible(true);
        }
        if (this.flatPanel.getPopupFindItem() != null) {
            this.flatPanel.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_CallTreeString()));
            this.flatPanel.getPopupFindItem().setVisible(true);
        }
        if (this.combinedFlat.getPopupFindItem() != null) {
            this.combinedFlat.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_CallTreeString()));
            this.combinedFlat.getPopupFindItem().setVisible(true);
        }
        if (this.combinedCCT.getPopupFindItem() != null) {
            this.combinedCCT.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_HotSpotsString()));
            this.combinedCCT.getPopupFindItem().setVisible(true);
        }
        this.flatPanel.setDataToDisplay(this.snapshot, -1, 0);
        this.cctPanel.setDataToDisplay(this.snapshot, 0);
        this.combinedFlat.setDataToDisplay(this.snapshot, -1, 0);
        this.combinedCCT.setDataToDisplay(this.snapshot, 0);
        this.flatPanel.prepareResults();
        this.cctPanel.prepareResults();
        this.combinedCCT.prepareResults();
        this.combinedFlat.prepareResults();
        this.infoPanel.updateInfo();
        this.flatPanel.addFilterListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CPUSnapshotPanel.this.internalFilterChange) {
                    CPUSnapshotPanel.this.internalFilterChange = true;
                    CPUSnapshotPanel.this.combinedFlat.setFilterValues(CPUSnapshotPanel.this.flatPanel.getFilterValue(), CPUSnapshotPanel.this.flatPanel.getFilterType());
                    CPUSnapshotPanel.this.internalFilterChange = false;
                }
            }
        });
        this.combinedFlat.addFilterListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CPUSnapshotPanel.this.internalFilterChange) {
                    CPUSnapshotPanel.this.internalFilterChange = true;
                    CPUSnapshotPanel.this.flatPanel.setFilterValues(CPUSnapshotPanel.this.combinedFlat.getFilterValue(), CPUSnapshotPanel.this.combinedFlat.getFilterType());
                    CPUSnapshotPanel.this.internalFilterChange = false;
                }
            }
        });
        this.combined = new CombinedPanel(0, (Component)this.combinedCCT, (Component)this.combinedFlat){

            public void requestFocus() {
                if (CPUSnapshotPanel.this.combinedCCT != null) {
                    CPUSnapshotPanel.this.combinedCCT.requestFocus();
                }
            }
        };
        this.combined.setResizeWeight(0.5);
        this.combined.setBorder(BorderFactory.createEmptyBorder());
        this.combined.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CPUSnapshotPanel.this.combined.setDividerLocation(0.5);
            }
        });
        this.addView(Bundle.CPUSnapshotPanel_CallTreeString(), CALL_TREE_TAB_ICON, Bundle.CPUSnapshotPanel_CallTreeTabDescr(), (Component)this.cctPanel, null);
        this.addView(Bundle.CPUSnapshotPanel_HotSpotsString(), HOTSPOTS_TAB_ICON, Bundle.CPUSnapshotPanel_HotSpotTabDescr(), (Component)this.flatPanel, null);
        this.addView(Bundle.CPUSnapshotPanel_CombinedString(), COMBINED_TAB_ICON, Bundle.CPUSnapshotPanel_CombinedTabDescr(), (Component)this.combined, null);
        this.addView(Bundle.CPUSnapshotPanel_InfoString(), INFO_TAB_ICON, Bundle.CPUSnapshotPanel_InfoTabDescr(), this.infoPanel, null);
        this.addChangeListener(this);
        ProfilerToolbar toolBar = ProfilerToolbar.create((boolean)true);
        this.saveAction = new SaveSnapshotAction(this.loadedSnapshot);
        toolBar.add((Action)this.saveAction);
        toolBar.add((Action)new ExportAction(this, this.loadedSnapshot));
        this.saveViewAction = new SaveViewAction(this);
        toolBar.add((Action)this.saveViewAction);
        toolBar.addSeparator();
        this.aggregationCombo = new JComboBox(new Object[]{Bundle.CPUSnapshotPanel_MethodsString(), Bundle.CPUSnapshotPanel_ClassesString(), Bundle.CPUSnapshotPanel_PackagesString()}){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width + 20, this.getPreferredSize().height);
            }
        };
        this.aggregationCombo.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_AggregationComboAccessName());
        this.aggregationCombo.getAccessibleContext().setAccessibleDescription(Bundle.CPUSnapshotPanel_AggregationComboAccessDescr());
        this.currentAggregationMode = 0;
        String[] tn = this.snapshot.getThreadNames();
        Object[] threadNames = new Object[tn.length + 1];
        threadNames[0] = new Object(){

            public String toString() {
                return Bundle.CPUSnapshotPanel_AllThreadsItem();
            }
        };
        for (int i = 0; i < tn.length; ++i) {
            final String tname = tn[i];
            threadNames[i + 1] = new Object(){

                public String toString() {
                    return tname;
                }
            };
        }
        this.threadIds = this.snapshot.getThreadIds();
        this.threadsCombo = new JComboBox(threadNames){

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                d.width = 1;
                return d;
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension d = super.getPreferredSize();
                d.width += 50;
                return d;
            }
        };
        this.threadsCombo.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_ThreadsComboAccessName());
        this.threadsCombo.getAccessibleContext().setAccessibleDescription(Bundle.CPUSnapshotPanel_ThreadsComboAccessDescr());
        this.aggregationCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer dlcr = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (Bundle.CPUSnapshotPanel_MethodsString().equals(value)) {
                    dlcr.setIcon(METHODS_ICON);
                } else if (Bundle.CPUSnapshotPanel_ClassesString().equals(value)) {
                    dlcr.setIcon(CLASSES_ICON);
                } else if (Bundle.CPUSnapshotPanel_PackagesString().equals(value)) {
                    dlcr.setIcon(PACKAGES_ICON);
                }
                return dlcr;
            }
        });
        this.threadsCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer dlcr = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (Bundle.CPUSnapshotPanel_AllThreadsItem().equals(value.toString())) {
                    dlcr.setIcon(null);
                } else {
                    dlcr.setIcon(THREADS_ICON);
                }
                return dlcr;
            }
        });
        JLabel lab = new JLabel(Bundle.CPUSnapshotPanel_ViewLabelString());
        lab.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        lab.setLabelFor(this.aggregationCombo);
        int mnemCharIndex = 0;
        lab.setDisplayedMnemonic(lab.getText().charAt(mnemCharIndex));
        lab.setDisplayedMnemonicIndex(mnemCharIndex);
        toolBar.add((Component)lab);
        toolBar.add((Component)this.aggregationCombo);
        this.aggregationCombo.addActionListener(this);
        toolBar.addSpace(6);
        this.slaveToggleButtonDown = new JToggleButton(SLAVE_DOWN_ICON);
        this.slaveToggleButtonDown.setSelected(this.slaveModeDown);
        this.slaveToggleButtonDown.addActionListener(this);
        this.slaveToggleButtonDown.setToolTipText(Bundle.CPUSnapshotPanel_ToggleDownToolTip());
        this.slaveToggleButtonDown.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_ToggleDownToolTip());
        toolBar.add((Component)this.slaveToggleButtonDown);
        this.slaveToggleButtonUp = new JToggleButton(SLAVE_UP_ICON);
        this.slaveToggleButtonUp.setSelected(this.slaveModeUp);
        this.slaveToggleButtonUp.addActionListener(this);
        this.slaveToggleButtonUp.setToolTipText(Bundle.CPUSnapshotPanel_ToggleUpToolTip());
        this.slaveToggleButtonUp.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_ToggleUpToolTip());
        toolBar.add((Component)this.slaveToggleButtonUp);
        toolBar.add((Component)this.threadsCombo);
        this.threadsCombo.addActionListener(this);
        toolBar.addSeparator();
        ContextAwareAction a = (ContextAwareAction)SystemAction.get(FindAction.class);
        this.findActionPresenter = toolBar.add(a.createContextAwareInstance(context));
        this.findPreviousPresenter = toolBar.add((Action)new FindPreviousAction(this));
        this.findNextPresenter = toolBar.add((Action)new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)this.findActionPresenter;
            ab.setIcon(Icons.getIcon((String)"GeneralIcons.Find"));
            ab.setText("");
            ab.setToolTipText(Bundle.CPUSnapshotPanel_FindActionTooltip());
        }
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        toolBar.addSeparator();
        toolBar.add((Action)new CompareSnapshotsAction(ls));
        this.updateToolbar();
        this.setMainToolbar(toolBar.getComponent());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPUSnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPUSnapshotPanel.this.performFindNext();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        Component selectedView = this.getSelectedView();
        if (!(selectedView instanceof ScreenshotProvider)) {
            return null;
        }
        return ((ScreenshotProvider)selectedView).getCurrentViewScreenshot(onlyVisibleArea);
    }

    @Override
    public String getViewName() {
        Component selectedView = this.getSelectedView();
        if (!(selectedView instanceof ScreenshotProvider)) {
            return null;
        }
        String viewName = ((ScreenshotProvider)selectedView).getDefaultViewName();
        return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-" + viewName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.internalChange) {
            return;
        }
        Object src = e.getSource();
        if (src == this.aggregationCombo) {
            Object sel = this.aggregationCombo.getSelectedItem();
            if (Bundle.CPUSnapshotPanel_MethodsString().equals(sel)) {
                this.changeView(0);
            } else if (Bundle.CPUSnapshotPanel_ClassesString().equals(sel)) {
                this.changeView(1);
            } else if (Bundle.CPUSnapshotPanel_PackagesString().equals(sel)) {
                this.changeView(2);
            }
        } else if (src == this.threadsCombo) {
            assert (this.getSelectedView() == this.flatPanel);
            int tid = -1;
            if (this.threadsCombo.getSelectedIndex() > 0) {
                tid = this.threadIds[this.threadsCombo.getSelectedIndex() - 1];
            }
            if (this.flatPanel.getCurrentThreadId() != tid) {
                this.flatPanel.setDataToDisplay(this.snapshot, tid, this.flatPanel.getCurrentView());
                this.flatPanel.prepareResults();
            }
        } else if (src == this.slaveToggleButtonDown) {
            this.slaveModeDown = this.slaveToggleButtonDown.isSelected();
        } else if (src == this.slaveToggleButtonUp) {
            this.slaveModeUp = this.slaveToggleButtonUp.isSelected();
        }
    }

    public void changeView(int view) {
        if (this.currentAggregationMode == view) {
            return;
        }
        this.currentAggregationMode = view;
        this.flatPanel.clearSelection();
        this.flatPanel.changeView(view);
        this.cctPanel.clearSelection();
        this.cctPanel.changeView(view);
        this.combinedCCT.clearSelection();
        this.combinedCCT.changeView(view);
        this.combinedFlat.clearSelection();
        this.combinedFlat.changeView(view);
        this.viewChanged(view);
    }

    @Override
    public boolean fitsVisibleArea() {
        Component selectedView = this.getSelectedView();
        if (!(selectedView instanceof ScreenshotProvider)) {
            return false;
        }
        return ((ScreenshotProvider)selectedView).fitsVisibleArea();
    }

    @Override
    public boolean hasView() {
        Component selectedView = this.getSelectedView();
        return selectedView != null && selectedView instanceof ScreenshotProvider && selectedView != this.infoPanel;
    }

    @Override
    public void performFind() {
        if (this.getSelectedView() != this.infoPanel) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.setFindString(findString);
            this.performFindFirst();
        }
    }

    public void performFindFirst() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean found = false;
        Component selectedView = this.getSelectedView();
        if (selectedView == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findFirst();
        } else if (selectedView == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findFirst();
        } else if (selectedView == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedFlat.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedCCT.findFirst();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedFlat.findFirst();
            }
        } else if (selectedView == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.backtraceView.findFirst();
        } else if (selectedView == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findFirst();
        }
        if (!found) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindNext() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean found = false;
        Component selectedView = this.getSelectedView();
        if (selectedView == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findNext();
        } else if (selectedView == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findNext();
        } else if (selectedView == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedCCT.findNext();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedFlat.findNext();
            }
        } else if (selectedView == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.backtraceView.findNext();
        } else if (selectedView == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findNext();
        }
        if (!found) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindPrevious() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean found = false;
        Component selectedView = this.getSelectedView();
        if (selectedView == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findPrevious();
        } else if (selectedView == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findPrevious();
        } else if (selectedView == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedCCT.findPrevious();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedFlat.findPrevious();
            }
        } else if (selectedView == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.backtraceView.findPrevious();
        } else if (selectedView == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findPrevious();
        }
        if (!found) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    public void requestFocus() {
        if (this.cctPanel != null) {
            this.cctPanel.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateToolbar();
        Component selectedView = this.getSelectedView();
        if (selectedView != null) {
            selectedView.requestFocus();
        }
    }

    @Override
    public void updateSavedState() {
        this.infoPanel.updateInfo();
        this.saveAction.updateState();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot snapshot) {
        return "snapshot-" + snapshot.getTimeTaken();
    }

    private void setFindString(String findString) {
        this.cctPanel.setFindString(findString);
        this.flatPanel.setFindString(findString);
        this.combinedFlat.setFindString(findString);
        this.combinedCCT.setFindString(findString);
        if (this.backtraceView != null) {
            this.backtraceView.setFindString(findString);
        }
        if (this.subtreeView != null) {
            this.subtreeView.setFindString(findString);
        }
    }

    private void closeReverseCallsGraphs() {
        if (this.backtraceView != null) {
            this.removeView((Component)this.backtraceView);
            this.backtraceView = null;
        }
    }

    private void updateToolbar() {
        Component selectedView = this.getSelectedView();
        this.threadsCombo.setVisible(selectedView == this.flatPanel);
        this.slaveToggleButtonDown.setVisible(selectedView == this.combined);
        this.slaveToggleButtonUp.setVisible(selectedView == this.combined);
        this.aggregationCombo.setEnabled(selectedView != this.backtraceView && selectedView != this.infoPanel && selectedView != this.subtreeView);
        boolean findEnabled = selectedView != this.infoPanel;
        this.saveViewAction.setEnabled(findEnabled);
        this.findActionPresenter.setEnabled(findEnabled);
        this.findPreviousPresenter.setEnabled(findEnabled);
        this.findNextPresenter.setEnabled(findEnabled);
    }

    private void viewChanged(int viewType) {
        this.viewTypeHasChanged();
        this.internalChange = true;
        switch (viewType) {
            case 2: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_PackagesString());
                break;
            }
            case 1: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_ClassesString());
                break;
            }
            default: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_MethodsString());
            }
        }
        this.internalChange = false;
    }

    private void viewTypeHasChanged() {
        this.cctPanel.prepareResults();
        this.flatPanel.prepareResults();
        this.combinedCCT.prepareResults();
        this.combinedFlat.prepareResults();
        this.revalidate();
        this.repaint();
    }

    private void enhancePopupMenu(JPopupMenu popup, CCTDisplay customCCTDisplay) {
        Collection col = Lookup.getDefault().lookupAll(CCTPopupEnhancer.class);
        for (CCTPopupEnhancer en : col) {
            en.enhancePopup(popup, this.loadedSnapshot, customCCTDisplay);
        }
    }

    private void enableDisablePopup(PrestimeCPUCCTNode node) {
        Collection col = Lookup.getDefault().lookupAll(CCTPopupEnhancer.class);
        for (CCTPopupEnhancer en : col) {
            en.enableDisablePopup(this.loadedSnapshot, node);
        }
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        Component selectedView = this.getSelectedView();
        if (selectedView instanceof CCTDisplay) {
            this.cctPanel.exportData(exportedFileType, eDD, false, Bundle.CPUSnapshotPanel_CallTreeString());
        } else if (selectedView instanceof SnapshotFlatProfilePanel) {
            this.flatPanel.exportData(exportedFileType, eDD, false, Bundle.CPUSnapshotPanel_HotSpotsString());
        } else if (selectedView instanceof SubtreeCallGraphPanel) {
            this.subtreeView.exportData(exportedFileType, eDD, this.subtreeView.getShortTitle());
        } else if (selectedView instanceof ReverseCallGraphPanel) {
            this.backtraceView.exportData(exportedFileType, eDD, this.backtraceView.getShortTitle());
        } else if (selectedView == this.combined) {
            this.combined.exportData(exportedFileType, eDD, Bundle.CPUSnapshotPanel_CombinedString());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return true;
    }

    @Override
    public boolean hasExportableView() {
        Component selectedView = this.getSelectedView();
        return selectedView != null && selectedView != this.infoPanel;
    }

    @Override
    public void setState(SnapshotPanel.State state) {
        if (!(state instanceof State)) {
            return;
        }
        State newState = (State)state;
        int selectedTab = newState.getSelectedTab();
        if (selectedTab == -1) {
            return;
        }
        boolean[] filterVisible = newState.getVisibleFilters();
        this.cctPanel.setFilterVisible(filterVisible[0]);
        this.combinedCCT.setFilterVisible(filterVisible[1]);
        this.flatPanel.setFilterVisible(filterVisible[2]);
        this.combinedFlat.setFilterVisible(filterVisible[3]);
        boolean[][] columnVisibilities = newState.getVisibleColumns();
        this.cctPanel.setColumnsVisibility(columnVisibilities[0]);
        this.combinedCCT.setColumnsVisibility(columnVisibilities[1]);
        this.flatPanel.setColumnsVisibility(columnVisibilities[2]);
        this.combinedFlat.setColumnsVisibility(columnVisibilities[3]);
        int[] sortingColumns = newState.getSortingColumns();
        boolean[] sortingOrder = newState.getSortingOrders();
        this.cctPanel.setSorting(sortingColumns[0], sortingOrder[0], true);
        this.combinedCCT.setSorting(sortingColumns[1], sortingOrder[1], true);
        this.flatPanel.setSorting(sortingColumns[2], sortingOrder[2], true);
        this.combinedFlat.setSorting(sortingColumns[3], sortingOrder[3], true);
        String[] filterValues = newState.getFilterValues();
        int[] filterTypes = newState.getFilterTypes();
        this.cctPanel.setFilterValues(filterValues[0], filterTypes[0]);
        this.combinedCCT.setFilterValues(filterValues[1], filterTypes[1]);
        this.flatPanel.setFilterValues(filterValues[2], filterTypes[2]);
        this.combinedFlat.setFilterValues(filterValues[3], filterTypes[3]);
        this.selectView(selectedTab);
    }

    @Override
    public State getState() {
        int cctFilterType;
        String cctFilterValue;
        boolean cctSorting;
        int cctColumn;
        int selectedTab = this.getSelectedViewIndex();
        if (selectedTab > 3) {
            selectedTab = 0;
        }
        if (selectedTab == -1) {
            return null;
        }
        boolean cctPanelFilter = this.cctPanel.isFilterVisible();
        boolean combinedCCTFilter = this.combinedCCT.isFilterVisible();
        boolean flatPanelFilter = this.flatPanel.isFilterVisible();
        boolean combinedFlatFilter = this.combinedFlat.isFilterVisible();
        boolean[] cctPanelVisibilities = this.cctPanel.getColumnsVisibility();
        boolean[] combinedCCTVisibilities = this.combinedCCT.getColumnsVisibility();
        boolean[] flatPanelVisibilities = this.flatPanel.getColumnsVisibility();
        boolean[] combinedFlatVisibilities = this.combinedFlat.getColumnsVisibility();
        int cctPanelColumn = cctColumn = this.getSelectedView() == this.cctPanel ? this.cctPanel.getSortingColumn() : this.combinedCCT.getSortingColumn();
        int combinedCCTColumn = cctColumn;
        int flatPanelColumn = this.flatPanel.getSortingColumn();
        int combinedFlatColumn = this.combinedFlat.getSortingColumn();
        boolean cctPanelSorting = cctSorting = this.getSelectedView() == this.cctPanel ? this.cctPanel.getSortingOrder() : this.combinedCCT.getSortingOrder();
        boolean combinedCCTSorting = cctSorting;
        boolean flatPanelSorting = this.flatPanel.getSortingOrder();
        boolean combinedFlatSorting = this.combinedFlat.getSortingOrder();
        String cctPanelFilterValue = cctFilterValue = this.getSelectedView() == this.cctPanel ? this.cctPanel.getFilterValue() : this.combinedCCT.getFilterValue();
        String combinedCCTFilterValue = cctFilterValue;
        String flatPanelFilterValue = this.flatPanel.getFilterValue();
        String combinedFlatFilterValue = this.combinedFlat.getFilterValue();
        int cctPanelFilterType = cctFilterType = this.getSelectedView() == this.cctPanel ? this.cctPanel.getFilterType() : this.combinedCCT.getFilterType();
        int combinedCCTFilterType = cctFilterType;
        int flatPanelFilterType = this.flatPanel.getFilterType();
        int combinedFlatFilterType = this.combinedFlat.getFilterType();
        return new State(selectedTab, new boolean[]{cctPanelFilter, combinedCCTFilter, flatPanelFilter, combinedFlatFilter}, new boolean[][]{cctPanelVisibilities, combinedCCTVisibilities, flatPanelVisibilities, combinedFlatVisibilities}, new int[]{cctPanelColumn, combinedCCTColumn, flatPanelColumn, combinedFlatColumn}, new boolean[]{cctPanelSorting, combinedCCTSorting, flatPanelSorting, combinedFlatSorting}, new String[]{cctPanelFilterValue, combinedCCTFilterValue, flatPanelFilterValue, combinedFlatFilterValue}, new int[]{cctPanelFilterType, combinedCCTFilterType, flatPanelFilterType, combinedFlatFilterType});
    }

    public static class State
    extends SnapshotPanel.State {
        private int selectedTab;
        private boolean[] visibleFilters;
        private boolean[][] visibleColumns;
        private int[] sortingColumns;
        private boolean[] sortingOrders;
        private String[] filterValues;
        private int[] filterTypes;

        State(int selectedTab, boolean[] visibleFilters, boolean[][] visibleColumns, int[] sortingColumns, boolean[] sortingOrders, String[] filterValues, int[] filterTypes) {
            this.selectedTab = selectedTab;
            this.visibleFilters = visibleFilters;
            this.visibleColumns = visibleColumns;
            this.sortingColumns = sortingColumns;
            this.sortingOrders = sortingOrders;
            this.filterValues = filterValues;
            this.filterTypes = filterTypes;
        }

        int getSelectedTab() {
            return this.selectedTab;
        }

        boolean[] getVisibleFilters() {
            return this.visibleFilters;
        }

        boolean[][] getVisibleColumns() {
            return this.visibleColumns;
        }

        int[] getSortingColumns() {
            return this.sortingColumns;
        }

        boolean[] getSortingOrders() {
            return this.sortingOrders;
        }

        String[] getFilterValues() {
            return this.filterValues;
        }

        int[] getFilterTypes() {
            return this.filterTypes;
        }
    }

    public static interface CCTPopupEnhancer {
        public void enhancePopup(JPopupMenu var1, LoadedSnapshot var2, CCTDisplay var3);

        public void enableDisablePopup(LoadedSnapshot var1, PrestimeCPUCCTNode var2);
    }

    private class CustomCCTDisplay
    extends CCTDisplay {
        private CustomCCTDisplay(CPUResUserActionsHandler actionsHandler, Boolean sampling) {
            super(actionsHandler, sampling);
        }

        private CustomCCTDisplay(CPUResUserActionsHandler actionsHandler, CPUSelectionHandler selectionHandler, Boolean sampling) {
            super(actionsHandler, selectionHandler, sampling);
        }

        protected JPopupMenu createPopupMenu() {
            JPopupMenu popup = super.createPopupMenu();
            CPUSnapshotPanel.this.enhancePopupMenu(popup, this);
            return popup;
        }

        protected void enableDisablePopup(PrestimeCPUCCTNode node) {
            super.enableDisablePopup(node);
            CPUSnapshotPanel.this.enableDisablePopup(node);
        }
    }

    private static class CombinedViewTracker
    extends FocusAdapter {
        private Object lastFocusOwner;

        private CombinedViewTracker() {
        }

        public Object getLastFocusOwner() {
            return this.lastFocusOwner;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.lastFocusOwner = e.getSource();
        }
    }

    private final class CPUSnapshotSelectionHandler
    implements CPUSelectionHandler {
        private boolean cct;

        private CPUSnapshotSelectionHandler(boolean cct) {
            this.cct = cct;
        }

        public void methodSelected(int threadId, int methodId, int view) {
            if (CPUSnapshotPanel.this.internalSelChange) {
                return;
            }
            if (methodId == -1) {
                return;
            }
            if (this.cct) {
                if (threadId >= -1 && CPUSnapshotPanel.this.combinedFlat.getCurrentThreadId() != threadId) {
                    CPUSnapshotPanel.this.combinedFlat.setDataToDisplay(CPUSnapshotPanel.this.combinedFlat.getSnapshot(), threadId, view);
                    CPUSnapshotPanel.this.combinedFlat.prepareResults();
                }
                if (CPUSnapshotPanel.this.slaveModeDown) {
                    if (CPUSnapshotPanel.this.combinedCCT.getPopupFindItem() != null) {
                        CPUSnapshotPanel.this.combinedCCT.getPopupFindItem().setEnabled(false);
                    }
                    CPUSnapshotPanel.this.internalSelChange = true;
                    CPUSnapshotPanel.this.combinedFlat.selectMethod(methodId);
                    CPUSnapshotPanel.this.internalSelChange = false;
                } else if (CPUSnapshotPanel.this.combinedCCT.getPopupFindItem() != null) {
                    CPUSnapshotPanel.this.combinedCCT.getPopupFindItem().setEnabled(true);
                }
            } else if (CPUSnapshotPanel.this.slaveModeUp) {
                if (CPUSnapshotPanel.this.combinedFlat.getPopupFindItem() != null) {
                    CPUSnapshotPanel.this.combinedFlat.getPopupFindItem().setEnabled(false);
                }
                int curView = CPUSnapshotPanel.this.combinedFlat.getCurrentView();
                String[] names = CPUSnapshotPanel.this.snapshot.getMethodClassNameAndSig(methodId, curView);
                CPUSnapshotPanel.this.combinedCCT.setFindString(MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(names[0], names[1], names[2]).toFormatted());
                CPUSnapshotPanel.this.internalSelChange = true;
                CPUSnapshotPanel.this.combinedCCT.silentlyFindFirst();
                CPUSnapshotPanel.this.internalSelChange = false;
            } else if (CPUSnapshotPanel.this.combinedFlat.getPopupFindItem() != null) {
                CPUSnapshotPanel.this.combinedFlat.getPopupFindItem().setEnabled(true);
            }
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(final String className, final String methodName, final String methodSig) {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    final Lookup.Provider project = CPUSnapshotPanel.this.loadedSnapshot.getProject();
                    final ProfilingSettings[] projectSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)project).getProfilingSettings();
                    final ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings settings : projectSettings) {
                        if (!ProfilingSettings.isCPUSettings((int)settings.getProfilingType())) continue;
                        cpuSettings.add(settings);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final ProfilingSettings settings = IDEUtils.selectSettings(16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), null);
                            if (settings == null) {
                                return;
                            }
                            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    settings.addRootMethod(className, methodName, methodSig);
                                    if (cpuSettings.contains(settings)) {
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])projectSettings, (ProfilingSettings)settings, (Lookup.Provider)project);
                                    } else {
                                        ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                                        System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                                        newProjectSettings[projectSettings.length] = settings;
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])newProjectSettings, (ProfilingSettings)settings, (Lookup.Provider)project);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }

        public void find(Object source, String findString) {
            if (source == CPUSnapshotPanel.this.cctPanel) {
                CPUSnapshotPanel.this.setFindString(findString);
                CPUSnapshotPanel.this.selectView((Component)CPUSnapshotPanel.this.flatPanel);
                CPUSnapshotPanel.this.flatPanel.selectMethod(findString);
            } else if (source == CPUSnapshotPanel.this.flatPanel) {
                CPUSnapshotPanel.this.setFindString(findString);
                CPUSnapshotPanel.this.selectView((Component)CPUSnapshotPanel.this.cctPanel);
                CPUSnapshotPanel.this.performFindFirst();
            } else if (source == CPUSnapshotPanel.this.combinedFlat) {
                CPUSnapshotPanel.this.setFindString(findString);
                CPUSnapshotPanel.this.performFindFirst();
            } else if (source == CPUSnapshotPanel.this.combinedCCT) {
                CPUSnapshotPanel.this.setFindString(findString);
                CPUSnapshotPanel.this.combinedFlat.selectMethod(findString);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot s, int threadId, int methodId, int view, int sortingColumn, boolean sortingOrder) {
            if (CPUSnapshotPanel.this.backtraceView != null) {
                CPUSnapshotPanel.this.removeView((Component)CPUSnapshotPanel.this.backtraceView);
            }
            CPUSnapshotPanel.this.backtraceView = new ReverseCallGraphPanel((CPUResUserActionsHandler)this, CPUSnapshotPanel.this.sampling);
            CPUSnapshotPanel.this.backtraceView.setDataToDisplay(s, threadId, view);
            CPUSnapshotPanel.this.backtraceView.setSelectedMethodId(methodId);
            CPUSnapshotPanel.this.backtraceView.setSorting(sortingColumn, sortingOrder);
            CPUSnapshotPanel.this.backtraceView.prepareResults();
            CPUSnapshotPanel.this.backtraceView.setFindString(CPUSnapshotPanel.this.cctPanel.getFindString());
            CPUSnapshotPanel.this.addView(CPUSnapshotPanel.this.backtraceView.getShortTitle(), BACK_TRACES_TAB_ICON, CPUSnapshotPanel.this.backtraceView.getTitle(), (Component)CPUSnapshotPanel.this.backtraceView, null);
            CPUSnapshotPanel.this.selectView((Component)CPUSnapshotPanel.this.backtraceView);
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            GoToSource.openSource((Lookup.Provider)CPUSnapshotPanel.this.loadedSnapshot.getProject(), (String)className, (String)methodName, (String)methodSig);
        }

        public void showSubtreeCallGraph(CPUResultsSnapshot s, CCTNode node, int view, int sortingColumn, boolean sortingOrder) {
            if (!(node instanceof PrestimeCPUCCTNode)) {
                return;
            }
            if (CPUSnapshotPanel.this.subtreeView != null) {
                CPUSnapshotPanel.this.removeView((Component)CPUSnapshotPanel.this.subtreeView);
            }
            CPUSnapshotPanel.this.subtreeView = new SubtreeCallGraphPanel((CPUResUserActionsHandler)this, CPUSnapshotPanel.this.sampling);
            CPUSnapshotPanel.this.subtreeView.setDataToDisplay(s, (PrestimeCPUCCTNode)node, view);
            CPUSnapshotPanel.this.subtreeView.setSorting(sortingColumn, sortingOrder);
            CPUSnapshotPanel.this.subtreeView.prepareResults();
            CPUSnapshotPanel.this.subtreeView.setFindString(CPUSnapshotPanel.this.cctPanel.getFindString());
            CPUSnapshotPanel.this.addView(CPUSnapshotPanel.this.subtreeView.getShortTitle(), SUBTREE_TAB_ICON, CPUSnapshotPanel.this.subtreeView.getTitle(), (Component)CPUSnapshotPanel.this.subtreeView, null);
            CPUSnapshotPanel.this.selectView((Component)CPUSnapshotPanel.this.subtreeView);
        }
    }
}

