/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsDiff;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.DiffCCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.DiffFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.SubtreeCallGraphPanel;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public final class CPUDiffPanel
extends SnapshotPanel
implements ActionListener,
ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Icon CLASSES_ICON = Icons.getIcon((String)"LanguageIcons.Class");
    private static final Icon METHODS_ICON = Icons.getIcon((String)"LanguageIcons.Methods");
    private static final Icon PACKAGES_ICON = Icons.getIcon((String)"LanguageIcons.Package");
    private static final Icon THREADS_ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final Icon CALL_TREE_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabCallTree");
    private static final Icon HOTSPOTS_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabHotSpots");
    private static final Icon SUBTREE_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabSubtree");
    private CCTDisplay cctPanel;
    private CPUResultsDiff snapshot;
    private JComboBox aggregationCombo;
    private LoadedSnapshot loadedSnapshot;
    private SnapshotFlatProfilePanel flatPanel;
    private SubtreeCallGraphPanel subtreeView;
    private boolean internalChange = false;
    private int currentAggregationMode;
    private Boolean sampling;

    public CPUDiffPanel(Lookup context, LoadedSnapshot ls, LoadedSnapshot snapshot1, LoadedSnapshot snapshot2, int sortingColumn, boolean sortingOrder) {
        String s2File;
        this.loadedSnapshot = ls;
        this.snapshot = (CPUResultsDiff)ls.getSnapshot();
        CPUActionsHandler actionsHandler = new CPUActionsHandler();
        boolean sampling1 = snapshot1.getSettings().getCPUProfilingType() == 2;
        boolean sampling2 = snapshot2.getSettings().getCPUProfilingType() == 2;
        this.sampling = sampling1 != sampling2 ? null : Boolean.valueOf(sampling1);
        this.flatPanel = new DiffFlatProfilePanel((CPUResUserActionsHandler)actionsHandler, this.sampling);
        this.cctPanel = new DiffCCTDisplay((CPUResUserActionsHandler)actionsHandler, this.sampling);
        this.flatPanel.setSorting(sortingColumn, sortingOrder);
        this.cctPanel.setSorting(sortingColumn, sortingOrder);
        if (this.cctPanel.getPopupFindItem() != null) {
            this.cctPanel.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_HotSpotsString()));
            this.cctPanel.getPopupFindItem().setVisible(true);
        }
        if (this.flatPanel.getPopupFindItem() != null) {
            this.flatPanel.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_CallTreeString()));
            this.flatPanel.getPopupFindItem().setVisible(true);
        }
        this.flatPanel.setDataToDisplay((CPUResultsSnapshot)this.snapshot, -1, 0);
        this.cctPanel.setDataToDisplay((CPUResultsSnapshot)this.snapshot, 0);
        this.flatPanel.prepareResults();
        this.cctPanel.prepareResults();
        this.addView(Bundle.CPUSnapshotPanel_CallTreeString(), CALL_TREE_TAB_ICON, Bundle.CPUSnapshotPanel_CallTreeTabDescr(), (Component)this.cctPanel, null);
        this.addView(Bundle.CPUSnapshotPanel_HotSpotsString(), HOTSPOTS_TAB_ICON, Bundle.CPUSnapshotPanel_HotSpotTabDescr(), (Component)this.flatPanel, null);
        this.addChangeListener(this);
        ProfilerToolbar toolBar = ProfilerToolbar.create((boolean)true);
        toolBar.add((Action)new ExportAction(this, this.loadedSnapshot));
        toolBar.add((Action)new SaveViewAction(this));
        toolBar.addSeparator();
        this.aggregationCombo = new JComboBox(new Object[]{Bundle.CPUSnapshotPanel_MethodsString(), Bundle.CPUSnapshotPanel_ClassesString(), Bundle.CPUSnapshotPanel_PackagesString()}){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width + 20, this.getPreferredSize().height);
            }
        };
        this.aggregationCombo.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_AggregationComboAccessName());
        this.aggregationCombo.getAccessibleContext().setAccessibleDescription(Bundle.CPUSnapshotPanel_AggregationComboAccessDescr());
        this.currentAggregationMode = 0;
        String[] tn = this.snapshot.getThreadNames();
        Object[] threadNames = new Object[tn.length + 1];
        threadNames[0] = new Object(){

            public String toString() {
                return Bundle.CPUSnapshotPanel_AllThreadsItem();
            }
        };
        for (int i = 0; i < tn.length; ++i) {
            final String tname = tn[i];
            threadNames[i + 1] = new Object(){

                public String toString() {
                    return tname;
                }
            };
        }
        this.aggregationCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer dlcr = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (Bundle.CPUSnapshotPanel_MethodsString().equals(value)) {
                    dlcr.setIcon(METHODS_ICON);
                } else if (Bundle.CPUSnapshotPanel_ClassesString().equals(value)) {
                    dlcr.setIcon(CLASSES_ICON);
                } else if (Bundle.CPUSnapshotPanel_PackagesString().equals(value)) {
                    dlcr.setIcon(PACKAGES_ICON);
                }
                return dlcr;
            }
        });
        JLabel lab = new JLabel(Bundle.CPUSnapshotPanel_ViewLabelString());
        lab.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        lab.setLabelFor(this.aggregationCombo);
        int mnemCharIndex = 0;
        lab.setDisplayedMnemonic(lab.getText().charAt(mnemCharIndex));
        lab.setDisplayedMnemonicIndex(mnemCharIndex);
        toolBar.add((Component)lab);
        toolBar.add((Component)this.aggregationCombo);
        this.aggregationCombo.addActionListener(this);
        toolBar.addSpace(6);
        toolBar.addSeparator();
        ContextAwareAction a = (ContextAwareAction)SystemAction.get(FindAction.class);
        Component findActionPresenter = toolBar.add(a.createContextAwareInstance(context));
        toolBar.add((Action)new FindPreviousAction(this));
        toolBar.add((Action)new FindNextAction(this));
        if (findActionPresenter instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)findActionPresenter;
            ab.setIcon(Icons.getIcon((String)"GeneralIcons.Find"));
            ab.setText("");
            ab.setToolTipText(Bundle.CPUSnapshotPanel_FindActionTooltip());
        }
        toolBar.addFiller();
        final WeakReference[] loadedSnapshots = new WeakReference[2];
        final String s1File = snapshot1.getFile() == null ? null : snapshot1.getFile().getAbsolutePath();
        String string = s2File = snapshot2.getFile() == null ? null : snapshot2.getFile().getAbsolutePath();
        if (s1File == null) {
            loadedSnapshots[0] = new WeakReference<LoadedSnapshot>(snapshot1);
        }
        if (s2File == null) {
            loadedSnapshots[1] = new WeakReference<LoadedSnapshot>(snapshot2);
        }
        final ResultsManager rm = ResultsManager.getDefault();
        String SNAPSHOT_1_MASK = "file:/1";
        String SNAPSHOT_2_MASK = "file:/2";
        String SNAPSHOT_1_LINK = "<a href='file:/1'>" + rm.getSnapshotDisplayName(snapshot1) + "</a>";
        String SNAPSHOT_2_LINK = "<a href='file:/2'>" + rm.getSnapshotDisplayName(snapshot2) + "</a>";
        HTMLLabel descriptionLabel = new HTMLLabel(Bundle.MemoryDiffPanel_SnapshotsComparisonString(SNAPSHOT_1_LINK, SNAPSHOT_2_LINK)){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            protected void showURL(URL url) {
                File f;
                LoadedSnapshot ls = null;
                if ("file:/1".equals(url.toString())) {
                    if (s1File != null) {
                        f = new File(s1File);
                        if (f.exists()) {
                            ls = rm.loadSnapshot(FileUtil.toFileObject((File)f));
                        }
                    } else {
                        ls = (LoadedSnapshot)loadedSnapshots[0].get();
                    }
                } else if ("file:/2".equals(url.toString())) {
                    if (s2File != null) {
                        f = new File(s2File);
                        if (f.exists()) {
                            ls = rm.loadSnapshot(FileUtil.toFileObject((File)f));
                        }
                    } else {
                        ls = (LoadedSnapshot)loadedSnapshots[1].get();
                    }
                }
                if (ls != null) {
                    SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls);
                    srw.open();
                    srw.requestActive();
                } else {
                    ProfilerDialogs.displayWarning((String)Bundle.MemoryDiffPanel_SnapshotNotAvailableMsg());
                }
            }
        };
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        toolBar.add((Component)descriptionLabel);
        this.updateToolbar();
        this.setMainToolbar(toolBar.getComponent());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPUDiffPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPUDiffPanel.this.performFindNext();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        Component selectedView = this.getSelectedView();
        if (!(selectedView instanceof ScreenshotProvider)) {
            return null;
        }
        return ((ScreenshotProvider)selectedView).getCurrentViewScreenshot(onlyVisibleArea);
    }

    @Override
    public String getViewName() {
        Component selectedView = this.getSelectedView();
        if (!(selectedView instanceof ScreenshotProvider)) {
            return null;
        }
        String viewName = ((ScreenshotProvider)selectedView).getDefaultViewName();
        return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-" + viewName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.internalChange) {
            return;
        }
        Object src = e.getSource();
        if (src == this.aggregationCombo) {
            Object sel = this.aggregationCombo.getSelectedItem();
            if (Bundle.CPUSnapshotPanel_MethodsString().equals(sel)) {
                this.changeView(0);
            } else if (Bundle.CPUSnapshotPanel_ClassesString().equals(sel)) {
                this.changeView(1);
            } else if (Bundle.CPUSnapshotPanel_PackagesString().equals(sel)) {
                this.changeView(2);
            }
        }
    }

    public void changeView(int view) {
        if (this.currentAggregationMode == view) {
            return;
        }
        this.currentAggregationMode = view;
        this.flatPanel.clearSelection();
        this.flatPanel.changeView(view);
        this.cctPanel.clearSelection();
        this.cctPanel.changeView(view);
        this.viewChanged(view);
    }

    @Override
    public boolean fitsVisibleArea() {
        Component selectedView = this.getSelectedView();
        if (!(selectedView instanceof ScreenshotProvider)) {
            return false;
        }
        return ((ScreenshotProvider)selectedView).fitsVisibleArea();
    }

    @Override
    public boolean hasView() {
        Component selectedView = this.getSelectedView();
        return selectedView != null && selectedView instanceof ScreenshotProvider;
    }

    @Override
    public void performFind() {
        String findString = FindDialog.getFindString();
        if (findString == null) {
            return;
        }
        this.setFindString(findString);
        this.performFindFirst();
    }

    public void performFindFirst() {
        boolean found = false;
        Component selectedView = this.getSelectedView();
        if (selectedView == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findFirst();
        } else if (selectedView == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findFirst();
        } else if (selectedView == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findFirst();
        }
        if (!found) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindNext() {
        boolean found = false;
        Component selectedView = this.getSelectedView();
        if (selectedView == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findNext();
        } else if (selectedView == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findNext();
        } else if (selectedView == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findNext();
        }
        if (!found) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindPrevious() {
        boolean found = false;
        Component selectedView = this.getSelectedView();
        if (selectedView == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findPrevious();
        } else if (selectedView == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findPrevious();
        } else if (selectedView == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findPrevious();
        }
        if (!found) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    public void requestFocus() {
        if (this.cctPanel != null) {
            this.cctPanel.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateToolbar();
        Component selectedView = this.getSelectedView();
        if (selectedView != null) {
            selectedView.requestFocus();
        }
    }

    @Override
    public void updateSavedState() {
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot snapshot) {
        return "snapshot-" + snapshot.getTimeTaken();
    }

    private void setFindString(String findString) {
        this.cctPanel.setFindString(findString);
        this.flatPanel.setFindString(findString);
        if (this.subtreeView != null) {
            this.subtreeView.setFindString(findString);
        }
    }

    private void updateToolbar() {
        Component selectedView = this.getSelectedView();
        this.aggregationCombo.setEnabled(selectedView != this.subtreeView);
    }

    private void viewChanged(int viewType) {
        this.viewTypeHasChanged();
        this.internalChange = true;
        switch (viewType) {
            case 2: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_PackagesString());
                break;
            }
            case 1: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_ClassesString());
                break;
            }
            default: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_MethodsString());
            }
        }
        this.internalChange = false;
    }

    private void viewTypeHasChanged() {
        this.cctPanel.prepareResults();
        this.flatPanel.prepareResults();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        Component selectedView = this.getSelectedView();
        if (selectedView instanceof CCTDisplay) {
            this.cctPanel.exportData(exportedFileType, eDD, false, Bundle.CPUSnapshotPanel_CallTreeString());
        } else if (selectedView instanceof SnapshotFlatProfilePanel) {
            this.flatPanel.exportData(exportedFileType, eDD, false, Bundle.CPUSnapshotPanel_HotSpotsString());
        } else if (selectedView instanceof SubtreeCallGraphPanel) {
            this.subtreeView.exportData(exportedFileType, eDD, this.subtreeView.getShortTitle());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return false;
    }

    @Override
    public boolean hasExportableView() {
        Component selectedView = this.getSelectedView();
        return selectedView != null;
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(final String className, final String methodName, final String methodSig) {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    final Lookup.Provider project = CPUDiffPanel.this.loadedSnapshot.getProject();
                    final ProfilingSettings[] projectSettings = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)project).getProfilingSettings();
                    final ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings settings : projectSettings) {
                        if (!ProfilingSettings.isCPUSettings((int)settings.getProfilingType())) continue;
                        cpuSettings.add(settings);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final ProfilingSettings settings = IDEUtils.selectSettings(16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), null);
                            if (settings == null) {
                                return;
                            }
                            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    settings.addRootMethod(className, methodName, methodSig);
                                    if (cpuSettings.contains(settings)) {
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])projectSettings, (ProfilingSettings)settings, (Lookup.Provider)project);
                                    } else {
                                        ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                                        System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                                        newProjectSettings[projectSettings.length] = settings;
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])newProjectSettings, (ProfilingSettings)settings, (Lookup.Provider)project);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }

        public void find(Object source, String findString) {
            if (source == CPUDiffPanel.this.cctPanel) {
                CPUDiffPanel.this.setFindString(findString);
                CPUDiffPanel.this.selectView((Component)CPUDiffPanel.this.flatPanel);
                CPUDiffPanel.this.flatPanel.selectMethod(findString);
            } else if (source == CPUDiffPanel.this.flatPanel) {
                CPUDiffPanel.this.setFindString(findString);
                CPUDiffPanel.this.selectView((Component)CPUDiffPanel.this.cctPanel);
                CPUDiffPanel.this.performFindFirst();
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot s, int threadId, int methodId, int view, int sortingColumn, boolean sortingOrder) {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            GoToSource.openSource((Lookup.Provider)CPUDiffPanel.this.loadedSnapshot.getProject(), (String)className, (String)methodName, (String)methodSig);
        }

        public void showSubtreeCallGraph(CPUResultsSnapshot s, CCTNode node, int view, int sortingColumn, boolean sortingOrder) {
            if (!(node instanceof PrestimeCPUCCTNode)) {
                return;
            }
            if (CPUDiffPanel.this.subtreeView != null) {
                CPUDiffPanel.this.removeView((Component)CPUDiffPanel.this.subtreeView);
            }
            CPUDiffPanel.this.subtreeView = new SubtreeCallGraphPanel((CPUResUserActionsHandler)this, CPUDiffPanel.this.sampling);
            CPUDiffPanel.this.subtreeView.setDataToDisplay(s, (PrestimeCPUCCTNode)node, view);
            CPUDiffPanel.this.subtreeView.setSorting(sortingColumn, sortingOrder);
            CPUDiffPanel.this.subtreeView.prepareResults();
            CPUDiffPanel.this.subtreeView.setFindString(CPUDiffPanel.this.cctPanel.getFindString());
            CPUDiffPanel.this.addView(CPUDiffPanel.this.subtreeView.getShortTitle(), SUBTREE_TAB_ICON, CPUDiffPanel.this.subtreeView.getTitle(), (Component)CPUDiffPanel.this.subtreeView, null);
            CPUDiffPanel.this.selectView((Component)CPUDiffPanel.this.subtreeView);
        }
    }
}

