/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.CustomizerCompile;
import org.netbeans.modules.web.project.ui.customizer.CustomizerFrameworks;
import org.netbeans.modules.web.project.ui.customizer.CustomizerJavadoc;
import org.netbeans.modules.web.project.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.web.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.project.ui.customizer.CustomizerRun;
import org.netbeans.modules.web.project.ui.customizer.CustomizerSources;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWSClientHost;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWSServiceHost;
import org.netbeans.modules.web.project.ui.customizer.CustomizerWar;
import org.netbeans.modules.web.project.ui.customizer.NoWebServiceClientsPanel;
import org.netbeans.modules.web.project.ui.customizer.NoWebServicesPanel;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class WebCompositePanelProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String SOURCES = "Sources";
    static final String LIBRARIES = "Libraries";
    private static final String FRAMEWORKS = "Frameworks";
    private static final String BUILD = "Build";
    private static final String WAR = "War";
    private static final String JAVADOC = "Javadoc";
    public static final String RUN = "Run";
    private static final String WEBSERVICESCATEGORY = "WebServicesCategory";
    private static final String WEBSERVICES = "WebServices";
    private static final String WEBSERVICECLIENTS = "WebServiceClients";
    private String name;

    private WebCompositePanelProvider(String name) {
        this.name = name;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ResourceBundle bundle = NbBundle.getBundle(CustomizerProviderImpl.class);
        ProjectCustomizer.Category toReturn = null;
        if (SOURCES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)SOURCES, (String)bundle.getString("LBL_Config_Sources"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (FRAMEWORKS.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)FRAMEWORKS, (String)bundle.getString("LBL_Config_Frameworks"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (LIBRARIES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)LIBRARIES, (String)bundle.getString("LBL_Config_Libraries"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (BUILD.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)BUILD, (String)bundle.getString("LBL_Config_Build"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (WAR.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)WAR, (String)bundle.getString("LBL_Config_War"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (JAVADOC.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)JAVADOC, (String)bundle.getString("LBL_Config_Javadoc"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (RUN.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)RUN, (String)bundle.getString("LBL_Config_Run"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (WEBSERVICESCATEGORY.equals(this.name) && WebCompositePanelProvider.showWebServicesCategory((WebProjectProperties)context.lookup(WebProjectProperties.class))) {
            ProjectCustomizer.Category services = ProjectCustomizer.Category.create((String)WEBSERVICES, (String)bundle.getString("LBL_Config_WebServices"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            ProjectCustomizer.Category clients = ProjectCustomizer.Category.create((String)WEBSERVICECLIENTS, (String)bundle.getString("LBL_Config_WebServiceClients"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            toReturn = ProjectCustomizer.Category.create((String)WEBSERVICESCATEGORY, (String)bundle.getString("LBL_Config_WebServiceCategory"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{services, clients});
        }
        return toReturn;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        String nm = category.getName();
        WebProjectProperties uiProps = (WebProjectProperties)context.lookup(WebProjectProperties.class);
        if (SOURCES.equals(nm)) {
            return new CustomizerSources(uiProps);
        }
        if (FRAMEWORKS.equals(nm)) {
            return new CustomizerFrameworks(category, uiProps);
        }
        if (LIBRARIES.equals(nm)) {
            CustomizerProviderImpl.SubCategoryProvider prov = (CustomizerProviderImpl.SubCategoryProvider)context.lookup(CustomizerProviderImpl.SubCategoryProvider.class);
            assert (prov != null) : "Assuming CustomizerProviderImpl.SubCategoryProvider in customizer context";
            return new CustomizerLibraries(uiProps, prov);
        }
        if (BUILD.equals(nm)) {
            return new CustomizerCompile(uiProps);
        }
        if (WAR.equals(nm)) {
            return new CustomizerWar(category, uiProps);
        }
        if (JAVADOC.equals(nm)) {
            return new CustomizerJavadoc(uiProps);
        }
        if (RUN.equals(nm)) {
            return new CustomizerRun(category, uiProps);
        }
        if (WEBSERVICES.equals(nm) || WEBSERVICECLIENTS.equals(nm)) {
            ProjectWebModule wm = (ProjectWebModule)uiProps.getProject().getLookup().lookup(ProjectWebModule.class);
            FileObject docBase = wm.getDocumentBase();
            if (WEBSERVICES.equals(nm)) {
                WebServicesSupport servicesSupport;
                List servicesSettings = null;
                if (docBase != null && (servicesSupport = WebServicesSupport.getWebServicesSupport((FileObject)docBase)) != null) {
                    servicesSettings = servicesSupport.getServices();
                }
                if (servicesSettings != null && servicesSettings.size() > 0) {
                    return new CustomizerWSServiceHost(uiProps, servicesSettings);
                }
                return new NoWebServicesPanel();
            }
            if (WEBSERVICECLIENTS.equals(nm)) {
                WebServicesClientSupport clientSupport;
                List serviceClientsSettings = null;
                if (docBase != null && (clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)docBase)) != null) {
                    serviceClientsSettings = clientSupport.getServiceClients();
                }
                if (serviceClientsSettings != null && serviceClientsSettings.size() > 0) {
                    return new CustomizerWSClientHost(uiProps, serviceClientsSettings);
                }
                return new NoWebServiceClientsPanel();
            }
        }
        return new JPanel();
    }

    public static WebCompositePanelProvider createSources() {
        return new WebCompositePanelProvider(SOURCES);
    }

    public static WebCompositePanelProvider createFrameworks() {
        return new WebCompositePanelProvider(FRAMEWORKS);
    }

    public static WebCompositePanelProvider createLibraries() {
        return new WebCompositePanelProvider(LIBRARIES);
    }

    public static WebCompositePanelProvider createBuild() {
        return new WebCompositePanelProvider(BUILD);
    }

    public static WebCompositePanelProvider createWar() {
        return new WebCompositePanelProvider(WAR);
    }

    public static WebCompositePanelProvider createJavadoc() {
        return new WebCompositePanelProvider(JAVADOC);
    }

    public static WebCompositePanelProvider createRun() {
        return new WebCompositePanelProvider(RUN);
    }

    public static WebCompositePanelProvider createWebServicesCategory() {
        return new WebCompositePanelProvider(WEBSERVICESCATEGORY);
    }

    private static boolean showWebServicesCategory(WebProjectProperties uiProperties) {
        WebProject project = uiProperties.getProject();
        if (!project.isJavaEE5(project)) {
            WebServicesSupport servicesSupport = WebServicesSupport.getWebServicesSupport((FileObject)project.getProjectDirectory());
            WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)project.getProjectDirectory());
            return servicesSupport != null || clientSupport != null;
        }
        return false;
    }
}

