/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.project.ui.customizer.SourceRootsUi;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizer;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerSources
extends JPanel
implements HelpCtx.Provider {
    private String originalEncoding;
    private WebProjectProperties uiProperties;
    private boolean notified;
    private File projectFld;
    private JButton addSourceRoot;
    private JButton addTestRoot;
    private JButton downSourceRoot;
    private JButton downTestRoot;
    private JComboBox encoding;
    private JButton includeExcludeButton;
    private JButton jButtonBrowse;
    private JComboBox jComboBoxSourceLevel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabelSourceLevel;
    private JLabel jLabelWebPages;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextFieldWebPages;
    private JTextField projectLocation;
    private JButton removeSourceRoot;
    private JButton removeTestRoot;
    private JTable sourceRoots;
    private JPanel sourceRootsPanel;
    private JTable testRoots;
    private JPanel testRootsPanel;
    private JButton upSourceRoot;
    private JButton upTestRoot;
    private JButton webInfBrowseButton;
    private JLabel webInfLabel;
    private JTextField webInfTextField;

    public CustomizerSources(WebProjectProperties uiProperties) {
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(this.sourceRoots.getBackground());
        this.jScrollPane2.getViewport().setBackground(this.testRoots.getBackground());
        this.sourceRoots.setModel(uiProperties.SOURCE_ROOTS_MODEL);
        this.testRoots.setModel(uiProperties.TEST_ROOTS_MODEL);
        this.sourceRoots.getTableHeader().setReorderingAllowed(false);
        this.testRoots.getTableHeader().setReorderingAllowed(false);
        FileObject projectFolder = uiProperties.getProject().getProjectDirectory();
        File pf = FileUtil.toFile((FileObject)projectFolder);
        this.projectLocation.setText(pf == null ? "" : pf.getPath());
        this.projectFld = pf;
        this.jTextFieldWebPages.setDocument(uiProperties.WEB_DOCBASE_DIR_MODEL);
        this.webInfTextField.setDocument(uiProperties.WEBINF_DIR_MODEL);
        SourceRootsUi.EditMediator emSR = SourceRootsUi.registerEditMediator((Project)uiProperties.getProject(), (SourceRoots)uiProperties.getProject().getSourceRoots(), (JTable)this.sourceRoots, (JButton)this.addSourceRoot, (JButton)this.removeSourceRoot, (JButton)this.upSourceRoot, (JButton)this.downSourceRoot, null, (boolean)true);
        SourceRootsUi.EditMediator emTSR = SourceRootsUi.registerEditMediator((Project)uiProperties.getProject(), (SourceRoots)uiProperties.getProject().getTestSourceRoots(), (JTable)this.testRoots, (JButton)this.addTestRoot, (JButton)this.removeTestRoot, (JButton)this.upTestRoot, (JButton)this.downTestRoot, null, (boolean)true);
        emSR.setRelatedEditMediator(emTSR);
        emTSR.setRelatedEditMediator(emSR);
        this.jComboBoxSourceLevel.setModel(uiProperties.JAVAC_SOURCE_MODEL);
        this.jComboBoxSourceLevel.setRenderer(uiProperties.JAVAC_SOURCE_RENDERER);
        uiProperties.JAVAC_SOURCE_MODEL.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                CustomizerSources.this.enableSourceLevel();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                CustomizerSources.this.enableSourceLevel();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                CustomizerSources.this.enableSourceLevel();
            }
        });
        this.enableSourceLevel();
        this.originalEncoding = uiProperties.getProject().evaluator().getProperty("source.encoding");
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encoding.setModel(ProjectCustomizer.encodingModel((String)this.originalEncoding));
        this.encoding.setRenderer(ProjectCustomizer.encodingRenderer());
        String lafid = UIManager.getLookAndFeel().getID();
        if (!"Aqua".equals(lafid)) {
            this.encoding.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.encoding.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JComboBox combo = (JComboBox)e.getSource();
                    combo.setPopupVisible(false);
                }
            });
        }
        this.encoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CustomizerSources.this.handleEncodingChange();
            }
        });
        Util.initTwoColumnTableVisualProperties((Component)this, (JTable)this.sourceRoots);
        Util.initTwoColumnTableVisualProperties((Component)this, (JTable)this.testRoots);
        this.uiProperties = uiProperties;
        uiProperties.addOptionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor cellEditor = CustomizerSources.this.sourceRoots.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.stopCellEditing();
                }
                if ((cellEditor = CustomizerSources.this.testRoots.getCellEditor()) != null) {
                    cellEditor.stopCellEditing();
                }
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerSources.class);
    }

    private void enableSourceLevel() {
        this.jComboBoxSourceLevel.setEnabled(this.jComboBoxSourceLevel.getItemCount() > 0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectLocation = new JTextField();
        this.jLabelWebPages = new JLabel();
        this.jTextFieldWebPages = new JTextField();
        this.jButtonBrowse = new JButton();
        this.webInfLabel = new JLabel();
        this.webInfTextField = new JTextField();
        this.webInfBrowseButton = new JButton();
        this.sourceRootsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.sourceRoots = new JTable();
        this.addSourceRoot = new JButton();
        this.removeSourceRoot = new JButton();
        this.upSourceRoot = new JButton();
        this.downSourceRoot = new JButton();
        this.testRootsPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.testRoots = new JTable();
        this.addTestRoot = new JButton();
        this.removeTestRoot = new JButton();
        this.upTestRoot = new JButton();
        this.downTestRoot = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabelSourceLevel = new JLabel();
        this.jComboBoxSourceLevel = new JComboBox();
        this.jLabel5 = new JLabel();
        this.encoding = new JComboBox();
        this.includeExcludeButton = new JButton();
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_ProjectFolder").charAt(0));
        this.jLabel1.setLabelFor(this.projectLocation);
        this.jLabel1.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_ProjectFolder"));
        this.projectLocation.setEditable(false);
        this.jLabelWebPages.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_WebPages").charAt(0));
        this.jLabelWebPages.setLabelFor(this.jTextFieldWebPages);
        this.jLabelWebPages.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_WebPagesFolder"));
        this.jButtonBrowse.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_WebPagesBrowse").charAt(0));
        this.jButtonBrowse.setText(NbBundle.getMessage(CustomizerSources.class, (String)"LBL_Browse_JButton"));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSources.this.jButtonBrowseActionPerformed(evt);
            }
        });
        this.webInfLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/customizer/Bundle").getString("MNE_WebInf").charAt(0));
        this.webInfLabel.setLabelFor(this.webInfTextField);
        this.webInfLabel.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_WebInfFolder"));
        this.webInfBrowseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/project/ui/customizer/Bundle").getString("MNE_WebInfBrowse").charAt(0));
        this.webInfBrowseButton.setText(NbBundle.getMessage(CustomizerSources.class, (String)"LBL_WebInf_Browse_JButton"));
        this.webInfBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSources.this.webInfBrowseButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_SourceRoots").charAt(0));
        this.jLabel2.setLabelFor(this.sourceRoots);
        this.jLabel2.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_SourceRoots"));
        this.sourceRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.sourceRoots.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.sourceRoots);
        this.sourceRoots.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_sourceRoots"));
        this.addSourceRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_AddSourceRoot").charAt(0));
        this.addSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_AddSourceRoot"));
        this.removeSourceRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_RemoveSourceRoot").charAt(0));
        this.removeSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_RemoveSourceRoot"));
        this.upSourceRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_UpSourceRoot").charAt(0));
        this.upSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_UpSourceRoot"));
        this.downSourceRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_DownSourceRoot").charAt(0));
        this.downSourceRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_DownSourceRoot"));
        GroupLayout sourceRootsPanelLayout = new GroupLayout(this.sourceRootsPanel);
        this.sourceRootsPanel.setLayout(sourceRootsPanelLayout);
        sourceRootsPanelLayout.setHorizontalGroup(sourceRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -1, 666, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, sourceRootsPanelLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 531, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(sourceRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.addSourceRoot, -1, -1, Short.MAX_VALUE).addComponent(this.removeSourceRoot, -1, -1, Short.MAX_VALUE).addComponent(this.upSourceRoot, -1, -1, Short.MAX_VALUE).addComponent(this.downSourceRoot, -1, -1, Short.MAX_VALUE))));
        sourceRootsPanelLayout.setVerticalGroup(sourceRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sourceRootsPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(sourceRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sourceRootsPanelLayout.createSequentialGroup().addComponent(this.addSourceRoot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeSourceRoot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upSourceRoot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downSourceRoot).addContainerGap()).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE))));
        this.addSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_addSourceRoot"));
        this.removeSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_removeSourceRoot"));
        this.upSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_upSourceRoot"));
        this.downSourceRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_downSourceRoot"));
        this.jLabel3.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_TestRoots").charAt(0));
        this.jLabel3.setLabelFor(this.testRoots);
        this.jLabel3.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_TestRoots"));
        this.testRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.testRoots.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView(this.testRoots);
        this.testRoots.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_testRoots"));
        this.addTestRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_AddTestRoot").charAt(0));
        this.addTestRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_AddTestRoot"));
        this.removeTestRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_RemoveTestRoot").charAt(0));
        this.removeTestRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_RemoveTestRoot"));
        this.upTestRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_UpTestRoot").charAt(0));
        this.upTestRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_UpTestRoot"));
        this.downTestRoot.setMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_DownTestRoot").charAt(0));
        this.downTestRoot.setText(NbBundle.getMessage(CustomizerSources.class, (String)"CTL_DownTestRoot"));
        this.jLabelSourceLevel.setDisplayedMnemonic(NbBundle.getMessage(CustomizerSources.class, (String)"MNE_SourceLevel").charAt(0));
        this.jLabelSourceLevel.setLabelFor(this.jComboBoxSourceLevel);
        this.jLabelSourceLevel.setText(NbBundle.getMessage(CustomizerSources.class, (String)"TXT_SourceLevel"));
        this.jLabel5.setLabelFor(this.encoding);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(CustomizerSources.class, (String)"TXT_Encoding"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelSourceLevel).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.encoding, 0, 302, Short.MAX_VALUE).addComponent(this.jComboBoxSourceLevel, 0, 302, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSourceLevel).addComponent(this.jComboBoxSourceLevel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.encoding, -2, -1, -2))));
        this.jComboBoxSourceLevel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSources.class, (String)"AN_SourceLevel"));
        this.jComboBoxSourceLevel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_SourceLevel"));
        this.encoding.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_Encoding"));
        Mnemonics.setLocalizedText((AbstractButton)this.includeExcludeButton, (String)NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.includeExcludeButton"));
        this.includeExcludeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSources.this.includeExcludeButtonActionPerformed(evt);
            }
        });
        GroupLayout testRootsPanelLayout = new GroupLayout(this.testRootsPanel);
        this.testRootsPanel.setLayout(testRootsPanelLayout);
        testRootsPanelLayout.setHorizontalGroup(testRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, 666, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, testRootsPanelLayout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 531, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(testRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.addTestRoot, -1, -1, Short.MAX_VALUE).addComponent(this.removeTestRoot, -1, -1, Short.MAX_VALUE).addComponent(this.upTestRoot, -1, -1, Short.MAX_VALUE).addComponent(this.downTestRoot, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, testRootsPanelLayout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.includeExcludeButton)));
        testRootsPanelLayout.setVerticalGroup(testRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testRootsPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(testRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(testRootsPanelLayout.createSequentialGroup().addComponent(this.addTestRoot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeTestRoot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upTestRoot).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downTestRoot)).addComponent(this.jScrollPane2, -1, 143, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(testRootsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includeExcludeButton).addComponent(this.jPanel1, -2, -1, -2)).addGap(0, 0, 0)));
        this.addTestRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_addTestRoot"));
        this.removeTestRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_removeTestRoot"));
        this.upTestRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_upTestRoot"));
        this.downTestRoot.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_downTestRoot"));
        this.includeExcludeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_InclExclButton"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.webInfLabel).addComponent(this.jLabelWebPages).addComponent(this.jLabel1)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.webInfTextField, -1, 421, Short.MAX_VALUE).addComponent(this.jTextFieldWebPages, -1, 421, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.webInfBrowseButton).addComponent(this.jButtonBrowse)).addGap(0, 0, 0)).addComponent(this.projectLocation, -1, 526, Short.MAX_VALUE))).addComponent(this.testRootsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.sourceRootsPanel, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.projectLocation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelWebPages).addComponent(this.jTextFieldWebPages, -2, -1, -2).addComponent(this.jButtonBrowse)).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.webInfLabel).addComponent(this.webInfBrowseButton).addComponent(this.webInfTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sourceRootsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.testRootsPanel, -1, -1, Short.MAX_VALUE)));
        this.projectLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_projectLocation"));
        this.jTextFieldWebPages.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_webPagesFolder"));
        this.jButtonBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_webPagesFolderBrowse"));
        this.webInfTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_webInfFolder"));
        this.webInfBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"AD_CustomizerSources_webInfFolderBrowse"));
    }

    private void webInfBrowseButtonActionPerformed(ActionEvent evt) {
        this.updateFolder(this.webInfTextField);
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        this.updateFolder(this.jTextFieldWebPages);
    }

    private void includeExcludeButtonActionPerformed(ActionEvent evt) {
        IncludeExcludeVisualizer v = new IncludeExcludeVisualizer();
        this.uiProperties.loadIncludesExcludes(v);
        DialogDescriptor dd = new DialogDescriptor((Object)v.getVisualizerPanel(), NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.title.includeExclude"));
        dd.setOptionType(2);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            this.uiProperties.storeIncludesExcludes(v);
        }
    }

    private void updateFolder(JTextField textField) {
        File folder;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        File fileName = new File(textField.getText());
        File file = folder = fileName.isAbsolute() ? fileName : new File(this.projectFld, fileName.getPath());
        if (folder.exists()) {
            chooser.setSelectedFile(folder);
        } else {
            chooser.setSelectedFile(this.projectFld);
        }
        if (0 == chooser.showOpenDialog(this)) {
            File selected = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            String newFolder = CollocationQuery.areCollocated((File)this.projectFld, (File)selected) ? PropertyUtils.relativizeFile((File)this.projectFld, (File)selected) : selected.getPath();
            textField.setText(newFolder);
        }
    }

    private void handleEncodingChange() {
        Charset enc = (Charset)this.encoding.getSelectedItem();
        String encName = enc != null ? enc.name() : this.originalEncoding;
        if (!this.notified && encName != null && !encName.equals(this.originalEncoding)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSources.class, (String)"MSG_EncodingWarning"), 2));
            this.notified = true;
        }
        this.uiProperties.putAdditionalProperty("source.encoding", encName);
    }
}

