/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ui.customizer.CustomizerProvider2;
import org.netbeans.modules.java.api.common.project.ui.customizer.ProjectSharability;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CustomizerProviderImpl
implements CustomizerProvider2,
ProjectSharability {
    private final WebProject project;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private ProjectCustomizer.Category[] categories;
    private static final int OPTION_OK = 0;
    public static final String CUSTOMIZER_FOLDER_PATH = "Projects/org-netbeans-modules-web-project/Customizer";
    private static Map<Project, Dialog> project2Dialog = new HashMap<Project, Dialog>();

    public CustomizerProviderImpl(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper) {
        this.project = (WebProject)project;
        this.updateHelper = updateHelper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(String preselectedCategory, String preselectedSubCategory) {
        Dialog dialog = project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.setVisible(true);
            return;
        }
        WebProjectProperties uiProperties = new WebProjectProperties(this.project, this.updateHelper, this.evaluator, this.refHelper);
        Lookup context = Lookups.fixed((Object[])new Object[]{this.project, uiProperties, new SubCategoryProvider(preselectedCategory, preselectedSubCategory)});
        OptionListener listener = new OptionListener(this.project, uiProperties);
        StoreListener storeListener = new StoreListener(uiProperties);
        dialog = ProjectCustomizer.createCustomizerDialog((String)CUSTOMIZER_FOLDER_PATH, (Lookup)context, (String)preselectedCategory, (ActionListener)listener, (ActionListener)storeListener, null);
        dialog.addWindowListener(listener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.setVisible(true);
    }

    public boolean isSharable() {
        return this.project.getAntProjectHelper().isSharableProject();
    }

    public void makeSharable() {
        WebProjectProperties uiProperties = new WebProjectProperties(this.project, this.updateHelper, this.evaluator, this.refHelper);
        if (this.project.getAntProjectHelper().isSharableProject()) {
            assert (false) : "Project " + this.project + " is already sharable.";
            return;
        }
        final String[] serverLibraryName = new String[1];
        boolean res = CustomizerLibraries.makeSharable(uiProperties, serverLibraryName);
        if (res) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditableProperties ep = CustomizerProviderImpl.this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
                        String value = ep.getProperty("javac.classpath");
                        if (value.length() > 0) {
                            value = value + ":";
                        }
                        value = value + "${libs." + serverLibraryName[0] + "." + "classpath" + "}";
                        ep.setProperty("javac.classpath", value);
                        ProjectManager.getDefault().saveProject((Project)CustomizerProviderImpl.this.project);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return;
                    }
                }
            });
        }
    }

    static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String category, String subcategory) {
            this.category = category;
            this.subcategory = subcategory;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    private static class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private WebProjectProperties uiProperties;

        OptionListener(Project project, WebProjectProperties uiProperties) {
            this.project = project;
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ActionListener actionListener : this.uiProperties.getOptionListeners()) {
                actionListener.actionPerformed(e);
            }
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            project2Dialog.remove(this.project);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }

    private static class StoreListener
    implements ActionListener {
        private WebProjectProperties uiProperties;

        StoreListener(WebProjectProperties uiProperties) {
            this.uiProperties = uiProperties;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.uiProperties.save();
        }
    }
}

