/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class WebProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private WebProject project;
    private String libraryPath;
    private File libraryFile;
    private boolean libraryWithinProject;
    private String absolutesRelPath;

    public WebProjectOperations(WebProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        WebProjectOperations.addFile(projectDirectory, "nbproject", files);
        WebProjectOperations.addFile(projectDirectory, this.project.getBuildXmlName(), files);
        WebProjectOperations.addFile(projectDirectory, "catalog.xml", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        FileObject libFolder;
        File f;
        FileObject resourceFO;
        File resourceDir;
        FileObject persistenceXmlDir;
        FileObject confDir;
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        FileObject docRoot = this.project.getAPIWebModule().getDocumentBase();
        if (docRoot != null) {
            files.add(docRoot);
        }
        if ((confDir = this.project.getWebModule().getConfDir()) != null) {
            files.add(confDir);
        }
        if (!((persistenceXmlDir = this.project.getWebModule().getPersistenceXmlDir()) == null || confDir != null && FileUtil.toFile((FileObject)persistenceXmlDir).equals(FileUtil.toFile((FileObject)confDir)))) {
            files.add(persistenceXmlDir);
        }
        if ((resourceDir = this.project.getWebModule().getResourceDirectory()) != null && (resourceFO = FileUtil.toFileObject((File)resourceDir)) != null) {
            files.add(resourceFO);
        }
        SourceRoots src = this.project.getSourceRoots();
        FileObject[] srcRoots = src.getRoots();
        for (int cntr = 0; cntr < srcRoots.length; ++cntr) {
            if (srcRoots[cntr] == null) continue;
            files.add(srcRoots[cntr]);
        }
        PropertyEvaluator evaluator = this.project.evaluator();
        String prop = evaluator.getProperty("source.root");
        if (prop != null) {
            FileObject projectDirectory = this.project.getProjectDirectory();
            FileObject srcDir = this.project.getAntProjectHelper().resolveFileObject(prop);
            if (srcDir != null && projectDirectory != srcDir && !files.contains(srcDir)) {
                files.add(srcDir);
            }
        }
        SourceRoots test = this.project.getTestSourceRoots();
        FileObject[] testRoots = test.getRoots();
        for (int cntr = 0; cntr < testRoots.length; ++cntr) {
            if (testRoots[cntr] == null) continue;
            files.add(testRoots[cntr]);
        }
        AntProjectHelper helper = this.project.getAntProjectHelper();
        if (helper.getLibrariesLocation() != null && (f = helper.resolveFile(helper.getLibrariesLocation())) != null && f.exists() && (libFolder = FileUtil.toFileObject((File)f).getParent()) != null && FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)libFolder)) {
            files.add(libFolder);
        }
        return files;
    }

    public void notifyDeleting() throws IOException {
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        if (buildXML != null) {
            ActionUtils.runTarget((FileObject)buildXML, (String[])new String[]{"clean"}, (Properties)new Properties()).waitFinished();
        }
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        this.rememberLibraryLocation();
    }

    public void notifyCopied(Project original, File originalPath, final String newName) {
        if (original == null) {
            return;
        }
        final String oldProjectName = this.project.getName();
        this.project.getReferenceHelper().fixReferences(originalPath);
        WebProjectOperations origOperations = (WebProjectOperations)original.getLookup().lookup(WebProjectOperations.class);
        this.fixLibraryLocation(origOperations);
        this.project.setName(newName);
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                ProjectWebModule wm;
                AntProjectHelper helper = WebProjectOperations.this.project.getAntProjectHelper();
                EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                String warName = projectProps.get((Object)"war.name");
                String warEarName = projectProps.get((Object)"war.ear.name");
                String oldName = warName.substring(0, warName.length() - 4);
                if (warName.endsWith(".war") && oldName.equals(oldProjectName)) {
                    projectProps.put("war.name", PropertyUtils.getUsablePropertyName((String)newName) + ".war");
                }
                if (warEarName.endsWith(".war") && oldName.equals(oldProjectName)) {
                    projectProps.put("war.ear.name", PropertyUtils.getUsablePropertyName((String)newName) + ".war");
                }
                if ((wm = (ProjectWebModule)WebProjectOperations.this.project.getLookup().lookup(ProjectWebModule.class)) != null) {
                    wm.setContextPath("/" + newName);
                }
                helper.putProperties("nbproject/project.properties", projectProps);
            }
        });
    }

    public void notifyMoving() throws IOException {
        this.rememberLibraryLocation();
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, final String newName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        final String oldProjectName = this.project.getName();
        this.project.setName(newName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        WebProjectOperations origOperations = (WebProjectOperations)original.getLookup().lookup(WebProjectOperations.class);
        this.fixLibraryLocation(origOperations);
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                String serverId;
                ProjectWebModule wm;
                String oldCP;
                AntProjectHelper helper = WebProjectOperations.this.project.getAntProjectHelper();
                EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                EditableProperties privateProps = helper.getProperties("nbproject/private/private.properties");
                String warName = projectProps.get((Object)"war.name");
                String warEarName = projectProps.get((Object)"war.ear.name");
                String oldName = warName.substring(0, warName.length() - 4);
                if (warName.endsWith(".war") && oldName.equals(oldProjectName)) {
                    projectProps.put("war.name", PropertyUtils.getUsablePropertyName((String)newName) + ".war");
                }
                if (warEarName.endsWith(".war") && oldName.equals(oldProjectName)) {
                    projectProps.put("war.ear.name", PropertyUtils.getUsablePropertyName((String)newName) + ".war");
                }
                if ((oldCP = (wm = (ProjectWebModule)WebProjectOperations.this.project.getLookup().lookup(ProjectWebModule.class)).getContextPath(serverId = privateProps.getProperty("j2ee.server.instance"))) != null && oldName.equals(oldCP.substring(1))) {
                    wm.setContextPath(serverId, "/" + newName);
                }
                helper.putProperties("nbproject/project.properties", projectProps);
            }
        });
    }

    private void fixLibraryLocation(WebProjectOperations original) throws IllegalArgumentException {
        String libPath = original.libraryPath;
        if (libPath != null) {
            if (!new File(libPath).isAbsolute()) {
                if (!original.libraryWithinProject) {
                    File file = original.libraryFile;
                    if (file == null) {
                        return;
                    }
                    String relativized = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (File)file);
                    if (relativized != null) {
                        this.project.getAntProjectHelper().setLibrariesLocation(relativized);
                    } else {
                        this.project.getAntProjectHelper().setLibrariesLocation(file.getAbsolutePath());
                    }
                }
            } else if (original.libraryWithinProject && original.absolutesRelPath != null) {
                this.project.getAntProjectHelper().setLibrariesLocation(PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)original.absolutesRelPath).getAbsolutePath());
            }
        }
    }

    private void rememberLibraryLocation() {
        this.libraryWithinProject = false;
        this.absolutesRelPath = null;
        this.libraryPath = this.project.getAntProjectHelper().getLibrariesLocation();
        if (this.libraryPath != null) {
            File prjRoot = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.libraryFile = PropertyUtils.resolveFile((File)prjRoot, (String)this.libraryPath);
            if (FileOwnerQuery.getOwner((URI)this.libraryFile.toURI()) == this.project && this.libraryFile.getAbsolutePath().startsWith(prjRoot.getAbsolutePath())) {
                this.libraryWithinProject = true;
                FileObject fo = FileUtil.toFileObject((File)this.libraryFile);
                if (new File(this.libraryPath).isAbsolute() && fo != null) {
                    this.absolutesRelPath = FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fo);
                }
            }
        }
    }
}

