/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;
import org.netbeans.modules.javaee.specs.support.api.JpaProvider;
import org.netbeans.modules.javaee.specs.support.api.JpaSupport;
import org.netbeans.modules.web.project.WebProject;

public class WebPersistenceProviderSupplier
implements PersistenceProviderSupplier {
    private final WebProject project;

    public WebPersistenceProviderSupplier(WebProject project) {
        this.project = project;
    }

    public List<Provider> getSupportedProviders() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
        if (platform == null) {
            return Collections.emptyList();
        }
        ArrayList<Provider> result = new ArrayList<Provider>();
        HashSet<Provider> candidates = new HashSet<Provider>();
        candidates.add(ProviderUtil.HIBERNATE_PROVIDER);
        candidates.add(ProviderUtil.HIBERNATE_PROVIDER2_0);
        candidates.add(ProviderUtil.TOPLINK_PROVIDER1_0);
        candidates.add(ProviderUtil.KODO_PROVIDER);
        candidates.add(ProviderUtil.DATANUCLEUS_PROVIDER);
        candidates.add(ProviderUtil.OPENJPA_PROVIDER);
        candidates.add(ProviderUtil.OPENJPA_PROVIDER1_0);
        candidates.add(ProviderUtil.ECLIPSELINK_PROVIDER);
        this.addPersistenceProviders(candidates, platform, result);
        return result;
    }

    private void addPersistenceProviders(Set<Provider> providers, J2eePlatform platform, List<Provider> result) {
        JpaSupport jpaSupport = JpaSupport.getInstance((J2eePlatform)platform);
        HashMap<String, JpaProvider> map = new HashMap<String, JpaProvider>();
        for (JpaProvider jpaProvider : jpaSupport.getProviders()) {
            map.put(jpaProvider.getClassName(), jpaProvider);
        }
        for (Provider provider : providers) {
            String version;
            JpaProvider jpa = (JpaProvider)map.get(provider.getProviderClass());
            if (jpa == null || (version = ProviderUtil.getVersion((Provider)provider)) != null && (!version.equals("2.0") || !jpa.isJpa2Supported()) && (!version.equals("1.0") || !jpa.isJpa1Supported())) continue;
            if (jpa.isDefault()) {
                result.add(0, provider);
                continue;
            }
            result.add(provider);
        }
    }

    public boolean supportsDefaultProvider() {
        J2eeProjectCapabilities capabilities = J2eeProjectCapabilities.forProject((Project)this.project);
        return capabilities != null && capabilities.hasDefaultPersistenceProvider();
    }
}

