/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.utils;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.api.parser.SourceUtils;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class FindPossibleMethods {
    public static Set<MethodNode> findPossibleMethods(FileObject relevantFiles, String fqn, String methodName) {
        HashSet<MethodNode> methods = new HashSet<MethodNode>();
        for (FileObject fo : GroovyProjectUtil.getGroovyFilesInProject(relevantFiles)) {
            try {
                FindPossibleTask task = new FindPossibleTask(fqn, methodName);
                SourceUtils.runUserActionTask((FileObject)fo, (UserTask)task);
                methods.addAll(task.getResult());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return methods;
    }

    private static class MethodCollector
    extends ClassCodeVisitorSupport {
        private final ModuleNode moduleNode;
        private final String fqn;
        private final String methodName;
        private final Set<MethodNode> methods;

        public MethodCollector(ModuleNode moduleNode, String fqn, String methodName) {
            this.moduleNode = moduleNode;
            this.methodName = methodName;
            this.fqn = fqn;
            this.methods = new HashSet<MethodNode>();
        }

        protected SourceUnit getSourceUnit() {
            return this.moduleNode.getContext();
        }

        public Set<MethodNode> collectMethods() {
            for (ClassNode classNode : this.moduleNode.getClasses()) {
                this.visitClass(classNode);
            }
            return this.methods;
        }

        public void visitMethod(MethodNode method) {
            if (this.methodName.equals(method.getName())) {
                this.methods.add(method);
            }
            super.visitMethod(method);
        }
    }

    private static class FindPossibleTask
    extends UserTask {
        private final String fqn;
        private final String methodName;
        private final Set<MethodNode> methods;

        public FindPossibleTask(String fqn, String methodName) {
            this.fqn = fqn;
            this.methodName = methodName;
            this.methods = new HashSet<MethodNode>();
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult result = ASTUtils.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode moduleNode = result.getRootElement().getModuleNode();
            this.methods.addAll(new MethodCollector(moduleNode, this.fqn, this.methodName).collectMethods());
        }

        public Set<MethodNode> getResult() {
            return this.methods;
        }
    }
}

