/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.api.parser.SourceUtils;
import org.netbeans.modules.groovy.refactoring.findusages.FindUsagesElement;
import org.netbeans.modules.groovy.refactoring.findusages.impl.AbstractFindUsagesVisitor;
import org.netbeans.modules.groovy.refactoring.findusages.model.ClassRefactoringElement;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class AbstractFindUsages {
    protected final RefactoringElement element;
    protected final List<FindUsagesElement> usages;

    protected AbstractFindUsages(RefactoringElement element) {
        this.element = element;
        this.usages = new ArrayList<FindUsagesElement>();
    }

    protected abstract List<AbstractFindUsagesVisitor> getVisitors(ModuleNode var1, String var2);

    protected List<AbstractFindUsagesVisitor> singleVisitor(AbstractFindUsagesVisitor visitor) {
        return Collections.singletonList(visitor);
    }

    public final void findUsages(FileObject fo) {
        try {
            SourceUtils.runUserActionTask((FileObject)fo, (UserTask)new AddFindUsagesElementsTask(fo));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public final void clear() {
        this.usages.clear();
    }

    public final List<FindUsagesElement> getResults() {
        return this.usages;
    }

    protected final class AddFindUsagesElementsTask
    extends UserTask {
        private final FileObject fo;
        private final String defClass;

        public AddFindUsagesElementsTask(FileObject fo) {
            this.fo = fo;
            this.defClass = AbstractFindUsages.this.element.getOwnerName();
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult result = ASTUtils.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode moduleNode = result.getRootElement().getModuleNode();
            BaseDocument doc = GroovyProjectUtil.getDocument((ParserResult)result, this.fo);
            for (AbstractFindUsagesVisitor visitor : AbstractFindUsages.this.getVisitors(moduleNode, this.defClass)) {
                for (ASTNode node : visitor.findUsages()) {
                    if (node.getLineNumber() == -1 || node.getColumnNumber() == -1) continue;
                    AbstractFindUsages.this.usages.add(new FindUsagesElement(new ClassRefactoringElement(this.fo, node), doc));
                }
            }
            Collections.sort(AbstractFindUsages.this.usages);
        }
    }
}

