/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.cncppunit.codegeneration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.simpleunit.utils.CodeGenerationUtils;
import org.netbeans.modules.cnd.utils.FSPath;

public class CppUnitCodeGenerator {
    private CppUnitCodeGenerator() {
    }

    public static Map<String, Object> generateTemplateParamsForFunctions(String testClassName, FSPath testFilePath, List<CsmFunction> functions) {
        HashMap<String, Object> templateParams = new HashMap<String, Object>();
        if (functions != null) {
            StringBuilder testFunctions = new StringBuilder("");
            StringBuilder testInits = new StringBuilder("");
            StringBuilder testDecls = new StringBuilder("");
            StringBuilder testIncludes = new StringBuilder("");
            ArrayList<String> testFunctionsNames = new ArrayList<String>();
            ArrayList<String> addedTestIncludes = new ArrayList<String>();
            for (CsmFunction fun : functions) {
                CsmIncludeResolver inclResolver = CsmIncludeResolver.getDefault();
                String include = inclResolver.getLocalIncludeDerectiveByFilePath(testFilePath, (CsmObject)fun);
                if (!include.isEmpty()) {
                    if (!addedTestIncludes.contains(include)) {
                        testIncludes.append(include);
                        testIncludes.append("\n");
                    }
                    addedTestIncludes.add(include);
                } else {
                    testFunctions.append(CodeGenerationUtils.generateFunctionDeclaration((CsmFunction)fun));
                    testFunctions.append("\n\n");
                }
                String funName = ((Object)fun.getName()).toString();
                String testFunctionName = "test" + Character.toUpperCase(funName.charAt(0)) + funName.substring(1);
                if (testFunctionsNames.contains(testFunctionName)) {
                    int i = 2;
                    while (testFunctionsNames.contains(testFunctionName + i)) {
                        ++i;
                    }
                    testFunctionName = testFunctionName + i;
                }
                testFunctionsNames.add(testFunctionName);
                testFunctions.append("void ").append(testClassName).append("::").append(testFunctionName).append("() {\n");
                Collection params = fun.getParameters();
                int i = 0;
                for (CsmParameter param : params) {
                    testFunctions.append("    ");
                    testFunctions.append(CodeGenerationUtils.generateParameterDeclaration((CsmParameter)param, (int)i));
                    testFunctions.append("\n");
                    ++i;
                }
                testFunctions.append(CodeGenerationUtils.generateFunctionCall((CsmFunction)fun));
                testFunctions.append("    if(true /*check result*/) {\n");
                testFunctions.append("        CPPUNIT_ASSERT(false);\n");
                testFunctions.append("    }\n");
                testFunctions.append("}\n\n");
                testDecls.append("    void " + testFunctionName + "();\n");
                testInits.append("    CPPUNIT_TEST(" + testFunctionName + ");\n");
            }
            templateParams.put("testFunctions", testFunctions.toString());
            templateParams.put("testDecls", testDecls.toString());
            templateParams.put("testInits", testInits.toString());
            templateParams.put("testIncludes", testIncludes.toString());
        }
        return templateParams;
    }
}

