/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.cncppunit;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.testrunner.spi.TestHandlerFactory;
import org.netbeans.modules.cnd.testrunner.spi.TestRecognizerHandler;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;

public class CnCppUnitTestHandlerFactory
implements TestHandlerFactory {
    private static String C_UNIT = "C Unit Test";
    private static String CPP_UNIT = "Cpp Unit Test";

    public List<TestRecognizerHandler> createHandlers() {
        ArrayList<TestRecognizerHandler> result = new ArrayList<TestRecognizerHandler>();
        result.add(new CppUnitHandler());
        result.add(new CUnitSuiteStartingHandler());
        result.add(new CUnitSuiteFinishedHandler());
        result.add(new CUnitTestFinishedHandler());
        result.add(new CUnitTestFailedHandler());
        return result;
    }

    public boolean printSummary() {
        return true;
    }

    static String[] getStackTrace(String message, String stackTrace) {
        ArrayList<String> stackTraceList = new ArrayList<String>();
        stackTraceList.add(message);
        return stackTraceList.toArray(new String[stackTraceList.size()]);
    }

    static class CppUnitHandler
    extends TestRecognizerHandler {
        private final List<TestRecognizerHandler> handlers = new ArrayList<TestRecognizerHandler>();
        private String currentSuiteName;
        private boolean currentSuiteFinished = false;

        public CppUnitHandler() {
            super("(((.*)::(.+) : .*)|(Run: )|(OK \\())");
            this.handlers.add(new CppUnitTestFinishedHandler());
            this.handlers.add(new CppUnitTestFailedHandler());
            this.handlers.add(new CppUnitSuiteFinishedHandler());
        }

        public void updateUI(Manager manager, TestSession session) {
            String line = this.matcher.group(0);
            for (TestRecognizerHandler handler : this.handlers) {
                if (!handler.matches(line)) continue;
                handler.updateUI(manager, session);
                break;
            }
        }

        class CppUnitSuiteFinishedHandler
        extends TestRecognizerHandler {
            public CppUnitSuiteFinishedHandler() {
                super("((Run: )|(OK \\())");
            }

            public void updateUI(Manager manager, TestSession session) {
                manager.displayReport(session, session.getReport(0L));
                manager.sessionFinished(session);
                CppUnitHandler.this.currentSuiteFinished = true;
            }
        }

        class CppUnitTestFailedHandler
        extends TestRecognizerHandler {
            public CppUnitTestFailedHandler() {
                super("(.*)::(.+) : (.*)");
            }

            public void updateUI(Manager manager, TestSession session) {
                String suiteName = this.matcher.group(1);
                TestSuite currentSuite = session.getCurrentSuite();
                if (currentSuite == null) {
                    manager.testStarted(session);
                    session.addSuite(new TestSuite(suiteName));
                    manager.displaySuiteRunning(session, suiteName);
                } else if (!currentSuite.getName().equals(suiteName)) {
                    if (currentSuite.getName().equals(CppUnitHandler.this.currentSuiteName) && !CppUnitHandler.this.currentSuiteFinished) {
                        manager.displayReport(session, session.getReport(0L));
                        CppUnitHandler.this.currentSuiteFinished = true;
                    }
                    session.addSuite(new TestSuite(suiteName));
                    manager.displaySuiteRunning(session, suiteName);
                }
                CppUnitHandler.this.currentSuiteName = suiteName;
                Testcase testcase = new Testcase(this.matcher.group(2), CPP_UNIT, session);
                testcase.setTimeMillis(0L);
                testcase.setClassName(suiteName);
                testcase.setTrouble(new Trouble(true));
                String message = this.matcher.group(3);
                testcase.getTrouble().setStackTrace(CnCppUnitTestHandlerFactory.getStackTrace(message, ""));
                session.addTestCase(testcase);
            }
        }

        class CppUnitTestFinishedHandler
        extends TestRecognizerHandler {
            public CppUnitTestFinishedHandler() {
                super("(.*)::(.+) : OK");
            }

            public void updateUI(Manager manager, TestSession session) {
                String suiteName = this.matcher.group(1);
                TestSuite currentSuite = session.getCurrentSuite();
                if (currentSuite == null) {
                    manager.testStarted(session);
                    session.addSuite(new TestSuite(suiteName));
                    manager.displaySuiteRunning(session, suiteName);
                    CppUnitHandler.this.currentSuiteFinished = false;
                } else if (!currentSuite.getName().equals(suiteName)) {
                    if (currentSuite.getName().equals(CppUnitHandler.this.currentSuiteName) && !CppUnitHandler.this.currentSuiteFinished) {
                        manager.displayReport(session, session.getReport(0L));
                    }
                    session.addSuite(new TestSuite(suiteName));
                    manager.displaySuiteRunning(session, suiteName);
                    CppUnitHandler.this.currentSuiteFinished = false;
                }
                CppUnitHandler.this.currentSuiteName = suiteName;
                Testcase testcase = new Testcase(this.matcher.group(2), CPP_UNIT, session);
                if (session.getCurrentTestCase() == null || !session.getCurrentTestCase().getName().equals(testcase.getName()) || session.getCurrentTestCase().getTrouble() == null) {
                    testcase.setTimeMillis(0L);
                    testcase.setClassName(suiteName);
                    session.addTestCase(testcase);
                }
            }
        }
    }

    static class CUnitSuiteFinishedHandler
    extends TestRecognizerHandler {
        public CUnitSuiteFinishedHandler() {
            super("(--)?Run Summary: ");
        }

        public void updateUI(Manager manager, TestSession session) {
            manager.displayReport(session, session.getReport(0L));
            manager.sessionFinished(session);
        }
    }

    static class CUnitTestFailedHandler
    extends TestRecognizerHandler {
        public CUnitTestFailedHandler() {
            super("Test: (.*) \\.\\.\\.( )?FAILED");
        }

        public void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(1), C_UNIT, session);
            testcase.setTimeMillis(0L);
            testcase.setClassName(session.getCurrentSuite().getName());
            testcase.setTrouble(new Trouble(true));
            session.addTestCase(testcase);
        }
    }

    static class CUnitTestFinishedHandler
    extends TestRecognizerHandler {
        public CUnitTestFinishedHandler() {
            super("Test: (.*) \\.\\.\\.( )?passed");
        }

        public void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(1), C_UNIT, session);
            if (session.getCurrentTestCase() == null || !session.getCurrentTestCase().getName().equals(testcase.getName()) || session.getCurrentTestCase().getTrouble() == null) {
                testcase.setTimeMillis(0L);
                testcase.setClassName(session.getCurrentSuite().getName());
                session.addTestCase(testcase);
            }
        }
    }

    static class CUnitSuiteStartingHandler
    extends TestRecognizerHandler {
        private boolean firstSuite = true;

        public CUnitSuiteStartingHandler() {
            super("Suite: (.+)");
        }

        public void updateUI(Manager manager, TestSession session) {
            if (this.firstSuite) {
                this.firstSuite = false;
                manager.testStarted(session);
            }
            String suiteName = this.matcher.group(1);
            session.addSuite(new TestSuite(suiteName));
            manager.displaySuiteRunning(session, suiteName);
        }
    }
}

