/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tools.ide.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final int PORT_CHECK_TIMEOUT = 2000;
    private static byte[] TEST_QUERY = new byte[]{22, 3, 0, 0, 83, 1, 0, 0, 79, 3, 0, 63, 71, -41, -9, -70, 44, -18, -22, -78, 96, 126, -13, 0, -3, -126, 123, -71, -43, -106, -56, 119, -101, -26, -60, -37, 60, 61, -37, 111, -17, 16, 110, 0, 0, 40, 0, 22, 0, 19, 0, 10, 0, 102, 0, 5, 0, 4, 0, 101, 0, 100, 0, 99, 0, 98, 0, 97, 0, 96, 0, 21, 0, 18, 0, 9, 0, 20, 0, 17, 0, 8, 0, 6, 0, 3, 1, 0, 71, 69, 84, 32, 47, 99, 111, 109, 95, 115, 117, 110, 95, 119, 101, 98, 95, 117, 105, 32, 72, 84, 84, 80, 47, 49, 46, 48, 10, 10};
    private static Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        return Utils.isSecurePort(hostname, port, 0);
    }

    private static boolean isSecurePort(String hostname, int port, int depth) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket;
        block13: {
            socket = new Socket();
            try {
                Logger.getLogger("glassfish-socket-connect-diagnostic").log(Level.FINE, "Using socket.connect", new Exception());
                socket.connect(new InetSocketAddress(hostname, port), 2000);
                socket.setSoTimeout(2000);
            }
            catch (SocketException ex) {
                String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block13;
                String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                System.setProperty("socksNonProxyHosts", socksNonProxyHosts + localhost);
                if (depth < 1) {
                    socket.close();
                    return Utils.isSecurePort(hostname, port, 1);
                }
                socket.close();
                ConnectException ce = new ConnectException();
                ce.initCause(ex);
                throw ce;
            }
        }
        OutputStream ostream = socket.getOutputStream();
        ostream.write(TEST_QUERY);
        InputStream istream = socket.getInputStream();
        byte[] input = new byte[8192];
        istream.read(input);
        String response = new String(input).toLowerCase(Locale.ENGLISH);
        boolean isSecure = true;
        if (response.length() == 0) {
            socket.close();
            throw new ConnectException();
        }
        if (response.startsWith("http/1.1 302 moved temporarily")) {
            isSecure = true;
        } else if (response.startsWith("http/1.")) {
            isSecure = false;
        } else if (response.indexOf("<html") != -1) {
            isSecure = false;
        } else if (response.indexOf("</html") != -1) {
            isSecure = false;
        } else if (response.indexOf("connection: ") != -1) {
            isSecure = false;
        }
        socket.close();
        return isSecure;
    }

    public static String lineSeparator() {
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator == null) {
            lineSeparator = "\n";
        }
        return lineSeparator;
    }

    public static String sanitizeName(String name) {
        if (null == name || name.matches("[\\p{L}\\p{N}_][\\p{L}\\p{N}\\-_./;#:]*")) {
            return name;
        }
        return "_" + name.replaceAll("[^\\p{L}\\p{N}\\-_./;#:]", "_");
    }

    public static String quote(String path) {
        return path.indexOf(32) == -1 ? path : "\"" + path + "\"";
    }

    public static List<File> classPathToFileList(String cp, File root) {
        ArrayList<File> result = new ArrayList<File>();
        if (cp != null && cp.length() > 0) {
            String[] jars;
            for (String jar : jars = cp.split(File.pathSeparator)) {
                File jarFile = new File(jar);
                if (!jarFile.isAbsolute() && root != null) {
                    jarFile = new File(root, jar);
                }
                if (!jarFile.exists()) continue;
                result.add(jarFile);
            }
        }
        return result;
    }

    public static String doSub(String value, Map<String, String> varMap) {
        try {
            Matcher matcher = pattern.matcher(value);
            boolean result = matcher.find();
            if (result) {
                StringBuffer sb = new StringBuffer(value.length() * 2);
                do {
                    String key;
                    String replacement;
                    if ((replacement = varMap.get(key = matcher.group(1))) == null) {
                        replacement = System.getProperty(key);
                        replacement = replacement != null ? Utils.escapePath(replacement) : "\\$\\{" + key + "\\}";
                    }
                    matcher.appendReplacement(sb, replacement);
                } while (result = matcher.find());
                matcher.appendTail(sb);
                value = sb.toString();
            }
        }
        catch (Exception ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
        }
        return value;
    }

    public static String escapePath(String path) {
        return path.replace("\\", "\\\\").replace("$", "\\$");
    }

    public static String[] splitOptionsString(String optionString) {
        return optionString.trim().split("\\s+(?=-)");
    }
}

